//
// fastcode compo
//
//   verification/scoring program
// 
// LTP4. skal@planet-d.net
//////////////////////////////////////////////////////////////////

int Score = 0;
int Output_Char = 0;
int Wrong_Char = 0;
int Right_Char = 0;
int Grid_Penalty = 0;
#define CHAR_SCORE         10
#define GRID_OUT_PENALTY  500
#define FALSE_SQUARE_PENALTY  5
#define LEFT_SQUARE         2

#define GW  16
#define GH  16
#define NB_CHARS 4      // <7
#define MAX_CLUSTER 4

//////////////////////////////////////////////////////////////////

#include <stdio.h>

typedef unsigned char       BYTE;
typedef short int           SHORT;
typedef unsigned short int  USHORT;

#define SHOW_ME_YOUR_SOUL

static BYTE Grid[GH][GW];
int Nb_Blocks;

#define MAX_CHARS (2+NB_CHARS)
#define REMOVE_ME 1
static BYTE Grid_Chars[] = { ' ', 'O', 'a', 'b', 'c', 'd', 'e', 'f' };
#define BLK 8
#define LINE_COL 1
#define NB_COLS  (MAX_CHARS+1)
static BYTE Vid_Colors[] = { 
  0x00,0x00,0x00, // bckgrnd
  0xff,0xff,0xff, // lines
  0x80,0x80,0x80, // remove-me
  0xff,0x00,0x00, // chars...
  0x00,0x00,0xff,
  0x00,0xff,0x00,
  0x80,0x80,0x00,
  0x00,0x80,0x80,
  0xff,0x80,0x00
};
static BYTE Char_Colors[] = { 0, 2, 3, 4, 5, 6, 7, 8 };


char *Grid0[16] = {
 "adbdcdbdddcbdbab",
 "bccbddbccaadcdaa",
 "dabdacdbbdacaccd",
 "cdababcacbdcadca",
 "baadabbabadbaddb",
 "addbdaadcdaddcba",
 "adcacdabcabcaadc",
 "acadcbddbbcdcccd",
 "bdbaadaaabdcaaba",
 "adadbccbdacddcdb",
 "dbaaddbcbdbbbcaa",
 "dccbdcbaacaaacad",
 "cbdacbcadcbdddcc",
 "dbaadbacdcaaacab",
 "dbcdcdbadbbbdaca",
 "dcddccdcccacdcdb"
};

void Use_Grid(char *G[GH]);

static int Vid_Ok = 0;
static int Use_Vid = 0;
void Print_Grid(BYTE Grid[GH][GW]);

void Loop();
int Get_Input();

void Error(char *s);

#define Width   (1+(BLK+1)*GW+15) // must be multiple of 8. Hence the '+15'...
#define Height  (1+(BLK+1)*GH+15)
#include "video.h"

//////////////////////////////////////////////////////////////////

void Error(char *s) {
  fprintf( stderr, "Error: %s", s);
  exit(1);
}

//////////////////////////////////////////////////////////////////

void Print_Grid(BYTE Grid[GH][GW])
{
  int i, j;
  fprintf( stderr, "+----------------+\n" );
  for(j=0; j<GH; ++j) {
    fprintf( stderr, "|" );
    for(i=0; i<GW; ++i) {
      fprintf( stderr, "%c", Grid_Chars[Grid[j][i]] );
    }
    fprintf( stderr, "|\n" );
  }
  fprintf( stderr, "+----------------+\n" );
}

//////////////////////////////////////////////////////////////////

void Show_Grid()
{
  int i, j, k;
  BYTE *Dst;
  if (!Use_Vid) return;
  if (Vid_Ok==0) {
    if (Video_On(256)) Error( "can't open video mode\n" );
    Video_Store_Colors(NB_COLS, Vid_Colors);
    Vid_Ok = 1;
  }

  Video_Lock();
  Dst = Vid_Mem;
  memset( Dst, LINE_COL, 1+(BLK+1)*GW);
  Dst += Stride;
  for(j=0; j<GH; ++j) {
    BYTE *Ptr = Dst;
    *Ptr++ = LINE_COL;
    for(i=0; i<GW; ++i) {
      BYTE Col = Char_Colors[Grid[j][i]];
      for(k=0; k<BLK; ++k) *Ptr++ = Col;
      *Ptr++ = LINE_COL;
    }
    for(k=1; k<BLK; ++k) {
      Dst += Stride;
      memcpy(Dst, Dst-Stride, Stride);
    }
    Dst += Stride;
    memset( Dst, LINE_COL, 1+(BLK+1)*GW);
    Dst += Stride;
  }
  Video_Unlock();
//  while(!Get_Key());
  usleep(200000);
}

//////////////////////////////////////////////////////////////////

void Remove(int i, int j)
{
#ifdef SHOW_ME_YOUR_SOUL
  Grid[j][i] = REMOVE_ME;
  Show_Grid();
#endif
  Grid[j][i] = 0;
}

void Make_Fall() {
  int i, j, k;
  Nb_Blocks = 0;
  for(i=0; i<GW; ++i) {
    k = GH-1;
    for(j=GH-1; j>=0; --j) {
      if (Grid[j][i]!=0) {
        Grid[k--][i] = Grid[j][i];
        Nb_Blocks++;
      }
    }
    for( ; k>=0; --k) Grid[k][i] = 0;
  }
}

//////////////////////////////////////////////////////////////////

#define SWAP(a,b) { if (I[a]!=I[b]) { int n=R[a]; R[a]=R[b]; R[b]=n; I[b]=I[a]; } }

int Remove_Clusters()
{
  int nb, i, R[GW*GH], I[GW*GH];
  BYTE *G = Grid[0];

  for( i=0; i<GW*GH; ++i ) I[i] = R[i] = i;
  for( i=0; i<GW*GH; ++i ) {
    if (G[i]==0) continue;
    if ( ((i%GW)!=GW-1) && (G[i+1]==G[i]) ) SWAP(i,i+1);
    if ( ((i/GW)!=GH-1) && (G[i+GW]==G[i])) SWAP(i,i+GW);
  }
  for( nb=i=0; i<GW*GH; ++i ) {
    int n, j;
    if (R[i]==-1) continue;
    n = 0;
    j = i;
    do { n++; i = R[i]; } while (i!=j);
    if (n>=MAX_CLUSTER) {
      nb += n;
      i=j;
      do { n=R[i]; R[i]=-1; G[i]=0; i=n; } while (i!=j);
    }
  }      
  return nb;
}

//////////////////////////////////////////////////////////////////

int Remove_Blocks() {
  int n=0, nb=0;
  do {
    Make_Fall();
    n = Remove_Clusters();
    nb += n;
  } while(n!=0);
  return nb;
}

void Loop() {

  Grid_Penalty = 0;
  Output_Char = 0;
  Wrong_Char = 0;
  Right_Char = 0;

  do {
    int i, n;
    i = Get_Input();
    if (i==2) {
      n = Remove_Blocks();
      Show_Grid();
    }
    else // if (i==16)
       return;  // finished
  }
  while( Nb_Blocks>0 );
}

//////////////////////////////////////////////////////////////////

void Use_Grid(char *G[GH])
{
  int i, j, k;
  for(j=0; j<GH; ++j) {
    for(i=0; i<GW; ++i) {
      char c=G[j][i];
      for(k=sizeof(Grid_Chars)-1; k>=0; --k)
        if (c==Grid_Chars[k])
          break;
      if (k<0)
        Error("Unknown character given in grid.\n");
      Grid[j][i] = k;
    }
  }
}

//////////////////////////////////////////////////////////////////

int Read_Hex(char c) {
  int j;
  if (c>='0' && c<='9') j = c-'0';
  else if (c>='a' && c<='f') j = 0x0a + c-'a';
  else if (c>='A' && c<='F') j = 0x0a + c-'A';
  else Error( "Invalid Hex in Read_Hex()\n" );
  return j;
}

int Read_Line(char Buf[17]) {
  int i;
  int c;
Redo:
  i = 0;
  while( (c=fgetc(stdin))!=EOF && c!='\n' && i<16)
    Buf[i++] = c;
  Buf[i] = 0;
  if (i==0) {
    if (c!=EOF)
    {
      fprintf( stderr, "unexpected EOF in Read_Line()\n" );
      goto Redo;
    }
    else return 0;
  }
  if (i!=2 && i!=16)
    Error( "Wrong input in Read_Line()\n" );
  return i;
}

void Line_To_Grid(char Buf[17], BYTE *Grid)
{
  int i;
  for(i=0; i<GW; ++i) {
    char c = Buf[i];
    if (c!=' ' && (c<'a'||c>'d') ) {
      printf("Invalid grid character '%c'\n", Buf[i]);
      exit(1);
    }
    if (c==' ') Grid[i]=0;
    else Grid[i] = c-'a'+2;
  }
}

void Read_Stop_Grid(char Buf[17])
{
  BYTE Cmp[GH][GW];
  int j, n, m;

  Grid_Penalty  = GRID_OUT_PENALTY;

  Line_To_Grid(Buf, Cmp[0]);
  for(j=1; j<16; ++j) {
    int i = Read_Line(Buf);
    Line_To_Grid(Buf, Cmp[j]);
  }

  for(j=0; j<GW*GH; ++j) {
    if (Grid[0][j]!=Cmp[0][j])
      Wrong_Char++;
    else if (Grid[0][j]!=0)
      Right_Char++;
  }
  printf( "Stop-Grid:\n" );
  Print_Grid(Cmp);
  printf( " ...should be:\n" );
  Print_Grid(Grid);
}

int Get_Input()
{
  int i, j, n;
  char Buf[17];
  n = Read_Line(Buf);
  if (n==16) {
    Read_Stop_Grid(Buf);
    return 16;
  }
  else if (n!=0)
  {
    Output_Char++;
    j = Read_Hex(Buf[0]);
    i = Read_Hex(Buf[1]);
    printf( "Removed: (%d,%d)   [%c]\n", i, j, Grid_Chars[Grid[j][i]]);
#ifdef SHOW_ME_YOUR_SOUL
    Grid[j][i] = REMOVE_ME;
    Show_Grid();
#endif
    Grid[j][i] = 0;
  }
  else {
    Right_Char = Nb_Blocks;
  }
  return n;
}

//////////////////////////////////////////////////////////////////

void Help()
{
  printf( "Options:\n" );
  printf( "-h :    help\n" );
  printf( "-vid :  show grid on display\n" );

  exit(0);
}

void Parse_Args(int argc, char *argv[])
{
  int i;

  Use_Vid = 0;
  for(i=1; i<argc; ++i) {
    if (argv[i][0]=='-') {
      if (!strcmp(argv[i], "-vid"))
        Use_Vid = 1;
      else if (!strcmp(argv[i], "-h"))
        Help();
    }
  }
}

int main(int argc, char *argv[])
{
  Parse_Args(argc, argv);

  Use_Grid(Grid0);

  printf( "Starting grid, with the missing line:\n" );
  Print_Grid(Grid);
  Show_Grid();

  Loop();

  printf( "-> output char: %d\n", Output_Char);
  printf( "-> Number of right characters: %d\n", Right_Char);
  printf( "-> Number of wrong characters: %d\n", Wrong_Char);
  printf( "-> grid penalty: %d\n", Grid_Penalty);

  Score = 0;
  Score += Output_Char*CHAR_SCORE;
  Score += Wrong_Char*FALSE_SQUARE_PENALTY;
  Score += Right_Char*LEFT_SQUARE;
  Score += Grid_Penalty;
  printf( "Score=%d\n", Score);

  if (Vid_Ok) Video_Off( );
  return 0;
}

//////////////////////////////////////////////////////////////////
