/* Spock RealtimeBattle robot */

#include <iostream.h>
#include <stdio.h>
#include <strings.h>

// Message types

char *msg_type[] = {
     "ExitRobot",
     "Initialize",
     "Energy",
     "RobotInfo",
     "GameStarts",
     "Info",
     "Warning",
     "Collision",
     "RotationReached",
     "Radar",
     "RobotsLeft",
     ""};

#define EXITROBOT  0
#define INITIALIZE 1
#define ENERGY     2
#define ROBOTINFO  3
#define GAMESTARTS 4
#define INFO       5
#define WARNING    6
#define COLLISION  7
#define ROTREACHED 8 
#define RADAR      9
#define ROBOTSLEFT 10

// Object types

#define NONE      -1
#define ROBOT      0
#define SHOT       1
#define WALL       2
#define COOKIE     3
#define MINE       4

// Other defs

#define MIN_SHOT   0.5
#define MAX_SHOT   30.0
#define PI         3.14159
#define SAMPLES    9

// Status vars

double energy;   // Robot energy
double speed;    // Robot speed
double radar;    // Radar angle
double cannon;   // Cannon angle
double opponent; // Opponent energy
int    mode;     // Robot mode
int    rot_rob;  // Is the robot rotating?
int    rot_rad;  // Is the radar rotating?
int    rot_can;  // Is the cannon rotating?
int    swp_rad;  // Is the radar sweeping?
int    swp_radr; // To the right?
int    swp_can;  // Is the cannon sweeping?
int    swp_canr; // To the right?
double rad_dis [SAMPLES]; // Distance to the object detected with the radar
int    rad_what[SAMPLES]; // What has been detected?
int    rad_fresh;// Radar data is fresh...
int    co_what;  // Collision with what?
double co_angle; // Where?
int    robots;   // Remaining robots

// Robot modes

#define SLEEP      0
#define STATIC     1
#define COLLIDED   2

// Message identification routine

int msgtype()
{int  i;
 char msg[64];

 cin >> msg;
 for (i=0; msg_type[i][0] != '\0'; i++) if(!strcmp(msg_type[i],msg)) break;
 return i;}

void main()
{int i;
 double j; 
 char *str; 

 cout << "RobotOption " << 3 << " " << 0 << endl; // We will use blocking e/s
 cout << "RobotOption " << 1 << " " << 2 << endl; // Notify when rotations end
 mode = SLEEP; 

 while(i = msgtype()) {
 switch(i) {
    case INITIALIZE:
	cin >> i;
	if (i == 1) { cout << "Name Spock" << endl;
	 	      cout << "Colour 3f3fff 3f3fff" << endl;}
	break;
    case GAMESTARTS:
	energy   = 100;
	opponent = 100;
	speed   = 0;
	cannon  = 0;
	rot_rob = 0;
	rot_rad = 0;
	rot_can = 0;
	swp_rad = 0;
	swp_radr = 0;
	swp_can = 0;
	swp_canr = 0;
	mode    = STATIC;
	cout << "Print Summoning Wild Bits rythm" << endl;
        cout << "Accelerate 10.0" << endl;
	break;
    case ROBOTINFO:
        cin >> opponent >> i;
	break;
    case RADAR:
        for(i=SAMPLES-1;i--;) {
	  rad_what[i+1] = rad_what[i];
	  rad_dis [i+1] = rad_dis [i];}
	rad_fresh = 1;
	cin >> rad_dis[0] >> rad_what[0] >> radar;
	break;
    case INFO:
	cin >> speed >> speed >> cannon;
	break;
    case ENERGY:
	cin >> energy;
	break;
    case ROTREACHED:
	cin >> i;
	if (i > 3) { i -= 4; if (swp_rad) ++swp_radr %= 2; else rot_rad = 0; } 
	if (i > 1) { i -= 2; if (swp_can) ++swp_canr %= 2; else rot_can = 0; }
	if (i)               rot_rob = 0;
	break;
    case COLLISION:
	mode = COLLIDED;
	cin >> co_what >> co_angle;
	break;
    case ROBOTSLEFT:
	cin >> robots;
	break;
    case WARNING:
	cin >> i;
	cout << "Print Warning " << i << endl;
	break;}

 switch(mode) {
    case SLEEP:
	break;
    case COLLIDED:
	// Seems to work by now...
        for (i = 0; i < SAMPLES; i++) if (rad_what[i] == ROBOT) break;
        if (co_what == SHOT) cout << "Accelerate 10.0" << endl;
	if ((co_what == ROBOT) || ((co_what == SHOT) && (i = SAMPLES))) {
	   for (;co_angle < 0;    co_angle += 2*PI);
	   for (;co_angle > 2*PI; co_angle -= 2*PI);
	   if      (co_angle < PI) swp_radr = 1;
	   else if (co_angle > PI) swp_radr = 0;
	   for (i = 0; i < SAMPLES; i++) rad_what[i] = NONE;
	   rad_fresh =  1;}
        mode = STATIC;
    case STATIC:
	// Works pretty well at a short distance
	if (rad_fresh) {
	   rad_fresh = 0;
	   for (i=0; i < SAMPLES; i++) if (rad_what[i] == ROBOT) break;
	   j = ((double)i * PI)/(2.0 * (double)SAMPLES);
	   if ((rad_what[0] == ROBOT) || (rad_what[0] == COOKIE))
	     { cout << "Accelerate 10.0" << endl; j = 0;} 
	   else cout << "Brake 1.0" << endl;
	   if(!(rad_what[0] == ROBOT)) {
	      if ((i < SAMPLES) && !swp_canr && ((i == SAMPLES-1) || (i > rad_dis[i]-2.5))) {
		swp_canr = 1;
		swp_radr = !swp_radr;}}
	   else swp_canr = 0;
	   if (!swp_radr) j *= -1.0;
	   cout << "Rotate 1 " << j << endl;}
	if (rad_what[0]  == ROBOT)
	  if (energy > 8.0) cout << "Shoot " << MIN_SHOT+(MAX_SHOT/(rad_dis[0]*rad_dis[0]*robots)) << endl;
	  else cout << "Shoot " << MIN_SHOT << endl;
	else if ((rad_what[1] == ROBOT) || (rad_what[0] == MINE)) 
	   cout << "Shoot " << MIN_SHOT << endl;
	break;
	}
}}
