/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio.device;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.komplex.audio.AudioDataConverter;
import org.komplex.audio.AudioException;
import org.komplex.audio.BaseDevice;

public class JavaSoundDevice
extends BaseDevice
implements Runnable {
    static final int JSBUFSIZE = 5120;
    static final int BUFSIZE = 1024;
    Thread thread;
    AudioDataConverter ac;
    SourceDataLine line;
    private static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public void stop() {
        this.thread = null;
    }

    void close() {
        if (this.line != null) {
            if (this.thread != null) {
                this.line.drain();
            }
            this.line.stop();
            this.line.close();
            this.line = null;
        }
    }

    void open() throws AudioException {
        AudioFormat audioFormat;
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine != null ? class$javax$sound$sampled$SourceDataLine : (class$javax$sound$sampled$SourceDataLine = JavaSoundDevice.class$("javax.sound.sampled.SourceDataLine")), audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.getSampleRate(), this.getBits(), this.getChannels(), this.getSampleSize(), 5120.0f, false));
        if (!AudioSystem.isLineSupported(info)) {
            throw new AudioException("unsupported: " + info.toString());
        }
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat);
            return;
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new AudioException("Unable to open the line: " + lineUnavailableException);
        }
    }

    public String toString() {
        return "JavaSound Audio Out";
    }

    public int read() {
        return 255;
    }

    public float getGain() {
        return this.getGainControl().getValue();
    }

    public float getGainMin() {
        return this.getGainControl().getMinimum();
    }

    public void setGain(float f) {
        this.getGainControl().setValue(f);
    }

    public void start() throws AudioException {
        this.thread = new Thread(this);
        this.thread.setName(this.toString());
        this.thread.start();
        this.thread.setPriority(10);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public FloatControl getGainControl() {
        return (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
    }

    public void run() {
        int[] nArray = new int[1024];
        byte[] byArray = new byte[nArray.length * this.getSampleSize()];
        this.line.start();
        System.out.println("start");
        try {
            while (this.thread != null) {
                System.currentTimeMillis();
                int n = nArray.length;
                if (this.source != null) {
                    n = this.source.read(nArray, 0, nArray.length);
                    if (n == -1) break;
                    this.ac.convert(nArray, 0, byArray, 0, n);
                }
                int n2 = 0;
                int n3 = n * this.getSampleSize();
                while (n3 > 0) {
                    int n4 = this.line.write(byArray, n2, n3);
                    n2 += n4;
                    n3 -= n4;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("playback error: " + exception);
            exception.printStackTrace();
        }
        this.close();
    }

    public void init(int n) throws AudioException {
        super.init(n);
        this.open();
        this.ac = AudioDataConverter.getConverter(this.getFormat());
        if (this.line == null) {
            throw new AudioException("cannot open line output");
        }
    }

    public float getGainMax() {
        return this.getGainControl().getMaximum();
    }
}

