unit helvetti;
interface
uses routines,playmods,map;

const vidseg = $a000;
      zc = 256;
      xc = 160;
      yc = 100;

      sinsize = 360;

      gap = 100;
      skip = 4;

var picseg,virseg : word;
    picscr,virscr : pointer;
    loop : word;
    x,y,z : integer;
    stab,ctab : array[0..sinsize] of real;
    pal : array[0..255,1..3] of byte;
    palOK : boolean;
    frames : word;
    loppu : boolean;
    trackstatus : miscdata;
    status : miscdata;

procedure do_helvetti(nosound:boolean);

implementation

procedure do_helvetti(nosound:boolean);

procedure fadein;
var r,g,b:byte;
    cols:byte;
begin
  cols:=0;
  for loop:=0 to 255 do begin
    port[$3c7]:=loop;
    r:=port[$3c9];
    g:=port[$3c9];
    b:=port[$3c9];
    if r<pal[loop,1] then inc(r);
    if g<pal[loop,2] then inc(g);
    if b<pal[loop,3] then inc(b);
    if (r<>pal[loop,1])or(g<>pal[loop,2])or(b<>pal[loop,3]) then inc(cols);
    port[$3c8]:=loop;
    port[$3c9]:=r;
    port[$3c9]:=g;
    port[$3c9]:=b;
  end;
  if cols=0 then palOK:=true;
end;

begin
  cls(vidseg);
  randomize;
  getmem(virscr,320*200);
  virseg:=seg(virscr^);
  cls(virseg);
  getmem(picscr,320*200);
  picseg:=seg(picscr^);
  loadmap(picseg,'helvetti.map');

  for loop:=0 to sinsize do ctab[loop]:=cos(loop*pi/(sinsize div 2));
  for loop:=0 to sinsize do stab[loop]:=sin(loop*pi/(sinsize div 2));

  palOK:=false;
  loppu:=false;

  cls(vidseg);
  loadPAL('pal1.pal');
  flip(picseg,virseg);
  frames:=0;
  repeat
    retrace;
{    if not palOK then fadein; }
    flip(virseg,vidseg);
    if nosound then begin
      inc(frames);
      if frames=gap then loppu:=true;
    end else begin
      get_module_status(trackstatus);
      if trackstatus[0]=$24 then loppu:=true;
    end;
  until (keypressed)or(loppu);
  mode(3);
  freemem(virscr,320*200);
  freemem(picscr,320*200);
end;

end.

