uses routines,map;

const vidseg = $a000;
      points = 18;
      cam = 256;
      xsize = 32;
      ysize = 32;
      xrange = 56;
      yrange = 56;
      zwr = 8;

var virseg,flareseg,logoseg,bgseg : word;
    virscr,flarescr,logoscr,bgscr : pointer;
    loop : word;
    stab,ctab : array[0..255] of real;
    sd : real;
    phi,sphi : byte;
    point : array[1..points,1..3] of integer;
    trans : array[1..points,1..3] of integer;
    palloZ,palloX,palloY : integer;
    subbi : word;
    lphi : byte;
    zphi : byte;
    randx,randy : integer;

procedure rotate;
const phi_inc = 1;

var x,y,z : integer;
    sini,kosi : real;

begin
  for loop:=1 to points do begin
    x := point[loop,1];
    y := point[loop,2];
    z := point[loop,3];
    sini := stab[phi];
    kosi := ctab[phi];
{
                                                         
                    cy*cz          cy*sz          -sy    
     [X]*[Y]*[Z] =  sx*sy*cz-cx*sz sx*sy*sz+cx*cz  sx*cy 
                    cx*sy*cz+sx*sz cx*sy*sz-sx*cz  cx*cy 
                                                         
                                                           
                1  0  0      cy 0 -sy     cy     0  -sy    
     [X]*[Y] =  0  cx sx  *  0  1  0   =  sx*sy  cx  sx*cy 
                0 -sx cx     sy 0  cy     cx*sy -sx  cx*cy 
                                                           
}

    trans[loop,1]:=round((kosi*x)+(sini*sini*y)+(kosi*sini*z));
    trans[loop,2]:=round((kosi*y)+(-sini*z));
    trans[loop,3]:=round((-sini*x)+(sini*kosi*y)+(kosi*kosi*z));
{
    trans[loop,1]:=round((kosi*kosi*x)+((sini*sini*kosi*y)-(kosi*sini*y))+
                         ((kosi*sini*kosi*z)+(sini*sini*z)));
    trans[loop,2]:=round((kosi*sini*x)+((sini*sini*sini*y)+(kosi*kosi*y))+
                         ((kosi*sini*sini*z)-(sini*kosi*z)));
    trans[loop,3]:=round((-sini*x)+(sini*kosi*y)+(kosi*kosi*z));
}
  end;
  if phi<255-phi_inc then inc(phi,phi_inc) else phi:=0;
end;

procedure sprite(x,y:integer; col:integer); assembler;
var sy,sx:integer;
asm
  push ds
  mov cx,[x]
  mov dx,[y]
  sub dx,16
  sub cx,16
  mov [sy],dx
  mov [sx],cx
  mov ax,[virseg]
  mov es,ax
  mov ax,[flareseg]
  mov ds,ax
  mov ax,dx
  shl ax,6
  mov di,ax
  shl ax,2
  add di,ax
  add di,cx
  xor si,si
  xor dx,dx
@inner:
  cmp [sy],199
  jg @noPixel
  cmp [sy],0
  jl @noPixel
  cmp [sx],319
  jg @noPixel
  cmp [sx],0
  jl @noPixel
  xor bx,bx
  xor ax,ax
  mov bl,[ds:si]
  mov al,[es:di]
{  sub bx,[col] }
  add ax,bx
  cmp ax,256
  jl @skip
  mov ax,255
@skip:
  mov [es:di],al
@noPixel:
  inc si
  inc dx
  inc [sx]
  cmp dx,32
  jnz @skip3
  xor dx,dx
  mov ax,[x]
  sub ax,8
  mov [sx],ax
  inc [sy]
  add di,320-32
@skip3:
  inc di
  cmp si,32*32
  jnz @inner
  pop ds
@done:
end;

procedure piirraPallot(x,y,z:integer);
var sx,sy:integer;
    px,py,pz:integer;
    temp:integer;
    col:integer;
    p:byte;

begin
  for p:=1 to points do begin
    px:=trans[p,1];
    py:=trans[p,2];
    pz:=trans[p,3];
    if z-pz <> 0 then begin
{      col:=128+pz; }
      sx:=round(cam*px / (z-pz) + x);
      sy:=round(cam*py / (z-pz) + y);
      sprite(sx,sy,col);
    end;
  end;
end;

procedure smoothen; assembler;
    asm
      mov es,[logoseg]
      xor ax,ax
      xor bx,bx
      xor di,di
      mov si,68*36
      @outer:

          mov al,[es:di+1]
          mov bl,[es:di-1]
          add ax,bx
{          mov bl,[es:di+2]
          add ax,bx
          mov bl,[es:di-2]
          add ax,bx       }

          shr ax,1
          cmp ax,[subbi]
          jl @jump1
          sub ax,[subbi]
          @jump1:
          mov [es:di],al
          @jump2:
          inc di

      dec si
      jne @outer
    end;

procedure wavez;
begin
  sphi:=round(sd*lphi) shr 2;
  zphi:=sphi shl 1;
  for loop:=1 to points do begin
    point[loop,3]:=round(stab[zphi]*zwr);
    sphi:=round(sphi+sd);
    zphi:=sphi shl 1;
    if sphi>255 then sphi:=0;
    if zphi>255 then zphi:=0;
  end;
end;

begin
  randomize;
  getmem(virscr,64000);
  virseg:=seg(virscr^);
  getmem(flarescr,32*32);
  flareseg:=seg(flarescr^);
  getmem(bgscr,64000);
  bgseg:=seg(bgscr^);
  loadMAPe(flareseg,'flare.map',32*32);
  loadMAP(bgseg,'godspeed.map');
  for loop:=0 to 255 do ctab[loop]:=cos(loop*pi/128);
  for loop:=0 to 255 do stab[loop]:=sin(loop*pi/128);
  sd := 255 / points;
  sphi:=0;
  zphi:=0;
  for loop:=1 to points do begin
    point[loop,1]:=round(ctab[sphi]*xrange);
    point[loop,2]:=round(stab[sphi]*yrange);
    point[loop,3]:=0;
    sphi:=round(sphi+sd);
  end;
  mode($13);
  cls(vidseg);
  loadpal('pal1.pal');
  phi:=0;
  palloZ:=256;
  PalloX:=160;
  PalloY:=100;
  cls(virseg);
  subbi:=2;
  lphi:=0;
  repeat
    wavez;
    rotate;
    flip(bgseg,virseg);
    piirraPallot(palloX,palloY,palloZ);
    inc(lphi);
    palloZ:=256+round(stab[lphi]*64);
    retrace;
    flip(virseg,vidseg);
  until keypressed;
  mode(3);
  freemem(virscr,64000);
  freemem(bgscr,64000);
  freemem(flarescr,32*32);
end.