/*
 * Decompiled with CFR 0.152.
 */
package gl4java.utils.textures;

import com.sixlegs.image.png.PngImage;
import gl4java.GLFunc;
import gl4java.GLUFunc;
import gl4java.utils.textures.IOTextureLoader;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.io.InputStream;

public class PngTextureLoader
extends IOTextureLoader {
    protected boolean grayToAlpha = false;

    public PngTextureLoader(GLFunc gLFunc, GLUFunc gLUFunc) {
        super(gLFunc, gLUFunc);
    }

    protected boolean readTexture(InputStream inputStream) {
        try {
            PngImage pngImage = new PngImage(inputStream);
            this.imageWidth = pngImage.getWidth();
            this.imageHeight = pngImage.getHeight();
            int[] nArray = new int[this.imageWidth * this.imageHeight];
            PixelGrabber pixelGrabber = new PixelGrabber((ImageProducer)pngImage, 0, 0, this.imageWidth, this.imageHeight, nArray, 0, this.imageWidth);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("interrupted waiting for pixel!");
                this.error = true;
                return false;
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
                this.error = true;
                return false;
            }
            switch (pngImage.getColorType()) {
                case 0: {
                    this.glFormat = this.grayToAlpha ? 6406 : 6409;
                    break;
                }
                case 4: {
                    this.glFormat = 6410;
                    break;
                }
                case 2: {
                    this.glFormat = 6407;
                    break;
                }
                case 6: {
                    this.glFormat = 6408;
                    break;
                }
                case 3: {
                    this.glFormat = 6407;
                    break;
                }
                default: {
                    this.error = true;
                    System.err.println("unsupported png color type: " + pngImage.getColorType());
                    return false;
                }
            }
            int n = this.getComponents();
            this.pixel = new byte[this.imageWidth * this.imageHeight * n];
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n2 = 0;
            int n3 = this.imageHeight - 1;
            while (n3 >= 0) {
                int n4 = 0;
                while (n4 < this.imageWidth) {
                    int n5 = nArray[n3 * this.imageWidth + n4];
                    switch (this.glFormat) {
                        case 6408: {
                            this.pixel[n2] = (byte)(n5 >> 16);
                            this.pixel[n2 + 1] = (byte)(n5 >> 8);
                            this.pixel[n2 + 2] = (byte)n5;
                            this.pixel[n2 + 3] = (byte)(n5 >> 24);
                            n2 += 4;
                            break;
                        }
                        case 6407: {
                            this.pixel[n2] = (byte)(n5 >> 16);
                            this.pixel[n2 + 1] = (byte)(n5 >> 8);
                            this.pixel[n2 + 2] = (byte)n5;
                            n2 += 3;
                            break;
                        }
                        case 6400: 
                        case 6409: {
                            this.pixel[n2] = (byte)n5;
                            ++n2;
                            break;
                        }
                        case 6410: {
                            this.pixel[n2] = (byte)n5;
                            this.pixel[n2 + 1] = (byte)(n5 >> 24);
                            n2 += 2;
                            break;
                        }
                    }
                    ++n4;
                }
                --n3;
            }
            this.setTextureSize();
            return true;
        }
        catch (Exception exception) {
            System.out.println("An exception occured, while loading a PngTexture");
            System.out.println(exception);
            this.error = true;
            return false;
        }
    }

    public void setGrayToAlpha(boolean bl) {
        this.grayToAlpha = bl;
    }
}

