/*
 * Decompiled with CFR 0.152.
 */
package gl4java.utils.textures;

import gl4java.GLFunc;
import gl4java.GLUFunc;
import gl4java.utils.textures.TextureLoader;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;
import java.net.URL;

public class AWTTextureLoader
extends TextureLoader {
    Component comp;

    public AWTTextureLoader(Component component, GLFunc gLFunc, GLUFunc gLUFunc) {
        super(gLFunc, gLUFunc);
        this.comp = component;
    }

    private boolean readTexture(Component component, Image image) {
        try {
            Object object;
            try {
                object = new MediaTracker(component);
                ((MediaTracker)object).addImage(image, 0);
                ((MediaTracker)object).waitForID(0);
            }
            catch (Exception exception) {}
            this.imageWidth = image.getWidth(component);
            this.imageHeight = image.getHeight(component);
            object = new int[this.imageWidth * this.imageHeight];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.imageWidth, this.imageHeight, (int[])object, 0, this.imageWidth);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("interrupted waiting for pixel!");
                this.error = true;
                return false;
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
                this.error = true;
                return false;
            }
            this.glFormat = 6407;
            this.setTextureSize();
            this.pixel = new byte[this.imageWidth * this.imageHeight * this.getComponents()];
            int n = 0;
            int n2 = this.imageHeight - 1;
            while (n2 >= 0) {
                int n3 = 0;
                while (n3 < this.imageWidth) {
                    Object object2 = object[n2 * this.imageWidth + n3];
                    this.pixel[n++] = new Integer((int)(object2 >> 16 & 0xFF)).byteValue();
                    this.pixel[n++] = new Integer((int)(object2 >> 8 & 0xFF)).byteValue();
                    this.pixel[n++] = new Integer((int)(object2 & 0xFF)).byteValue();
                    if (this.glFormat == 6408) {
                        this.pixel[n++] = new Integer((int)(object2 >> 24 & 0xFF)).byteValue();
                    }
                    ++n3;
                }
                --n2;
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("An exception occured, while loading a AWTTexture");
            System.out.println(exception);
            this.error = true;
            return false;
        }
    }

    public boolean readTexture(String string) {
        Image image = this.comp.getToolkit().getImage(string);
        return this.readTexture(this.comp, image);
    }

    public boolean readTexture(URL uRL, String string) {
        try {
            URL uRL2 = new URL(uRL, string);
            Image image = this.comp.getToolkit().getImage(uRL2);
            return this.readTexture(this.comp, image);
        }
        catch (Exception exception) {
            System.out.println("AWTTextureLoader.readTexture <" + uRL + " / " + string + "> failed !\n" + exception);
            return false;
        }
    }
}

