/*
 * Decompiled with CFR 0.152.
 */
package gl4java.swing;

import gl4java.GLContext;
import gl4java.GLEnum;
import gl4java.GLFunc;
import gl4java.GLUEnum;
import gl4java.GLUFunc;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JPanel;

public class GLJPanel
extends JPanel
implements GLEnum,
GLUEnum,
ComponentListener,
WindowListener,
MouseListener {
    protected GLContext glj = null;
    public GLFunc gl = null;
    public GLUFunc glu = null;
    protected boolean mustResize = false;
    protected boolean cvsInitialized = false;
    protected boolean needCvsDispose = false;
    protected int stencilBits = 0;
    protected int accumSize = 0;
    protected boolean stereoView = false;
    protected boolean rgba = true;
    protected GLContext sharedGLContext;
    protected BufferedImage offImage = null;
    protected byte[] offImagePixels = null;
    protected Dimension offScrnSize = null;
    protected boolean customOffScrnSize = false;
    protected boolean offScrnSizeChanged = false;
    protected Window topLevelWindow = null;
    Graphics gr = null;
    DataBufferInt dbInt = null;
    protected long _f_dur_self = 0L;
    protected long _f_dur_self_sum = 0L;
    protected long _f_dur_tst_sum = 0L;
    protected long _f_dur_total = 0L;
    protected long _f_dur_total_sum = 0L;
    protected int _f_dur_times = 0;

    static {
        if (!GLContext.loadNativeLibraries(null, null, null)) {
            System.out.println("GLJPanel could not load def. native libs.");
        }
    }

    public GLJPanel() {
        this(null, null, new FlowLayout(), true);
    }

    public GLJPanel(LayoutManager layoutManager) {
        this(null, null, layoutManager, true);
    }

    public GLJPanel(LayoutManager layoutManager, boolean bl) {
        this(null, null, layoutManager, bl);
    }

    public GLJPanel(String string, String string2, LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.gl = GLContext.createGLFunc(string);
        if (this.gl == null) {
            System.out.println("GLFunc implementation " + string + " not created");
        }
        if ((this.glu = GLContext.createGLUFunc(string2)) == null) {
            System.out.println("GLUFunc implementation " + string2 + " not created");
        }
        this.addComponentListener(this);
        this.setOpaque(false);
    }

    public GLJPanel(boolean bl) {
        this(null, null, new FlowLayout(), bl);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (GLContext.gljClassDebug) {
            System.out.println("GLJPanel::componentResized(" + componentEvent.getComponent() + ")");
        }
        if (this.glj != null && this.glj.gljIsInit() && componentEvent.getComponent() == this) {
            this.mustResize = true;
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void cvsDispose() {
        block2: {
            this.cvsInitialized = false;
            if (this.glj == null || !this.glj.gljIsInit()) break block2;
            try {
                this.glj.gljFree();
                this.doCleanup();
                this.glj.setEnabled(false);
                this.glj.gljDestroy();
                this.needCvsDispose = false;
            }
            catch (Exception exception) {
                this.needCvsDispose = true;
            }
        }
    }

    public final int cvsGetHeight() {
        return this.getSize().height;
    }

    public final int cvsGetWidth() {
        return this.getSize().width;
    }

    public boolean cvsIsInit() {
        return this.cvsInitialized;
    }

    public void display() {
    }

    public void doCleanup() {
    }

    public final GLContext getGLContext() {
        return this.glj;
    }

    public Dimension getOffScreenSize() {
        return this.offScrnSize;
    }

    public Dimension getSize() {
        if (this.customOffScrnSize) {
            return this.offScrnSize;
        }
        return super.getSize();
    }

    public final Window getTopLevelWindow() {
        return this.topLevelWindow;
    }

    public void init() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public final synchronized void paintComponent(Graphics graphics) {
        if (this.glj == null || this.mustResize && !this.customOffScrnSize || this.offScrnSizeChanged) {
            if (this.mustResize) {
                this.cvsDispose();
                this.mustResize = false;
            }
            this.preInit();
            this.glj = GLContext.createOffScreenCtx(this, this.gl, this.glu, this.stereoView, this.rgba, this.stencilBits, this.accumSize, this.sharedGLContext, this.offScrnSize);
            if (this.glj != null) {
                this.stencilBits = this.glj.getStencilBitNumber();
                this.accumSize = this.glj.getAccumSize();
                this.stereoView = this.glj.isStereoView();
                this.rgba = this.glj.isRGBA();
            }
            if (this.offImage != null) {
                this.offImage.flush();
            }
            this.offImage = null;
            this.offScrnSizeChanged = false;
            this.init();
            Container container = this.getParent();
            Container container2 = null;
            while (container != null) {
                container2 = container;
                container = container.getParent();
            }
            if (container2 instanceof Window) {
                this.topLevelWindow = (Window)container2;
                this.topLevelWindow.addComponentListener(this);
                this.topLevelWindow.addMouseListener(this);
            } else {
                this.topLevelWindow = null;
                System.out.println("toplevel is not a Window: " + container2);
            }
            if (this.topLevelWindow != null) {
                this.topLevelWindow.addWindowListener(this);
            } else {
                System.out.println("no parent found for " + this.getName());
                System.out.flush();
            }
            if (this.glj != null && this.glj.gljIsInit()) {
                this.cvsInitialized = true;
            }
        }
        this.gr = graphics;
        this.sDisplay();
    }

    public void preInit() {
    }

    public void reshape(int n, int n2) {
        if (GLContext.gljClassDebug) {
            System.out.println("GLJPanel::reshape bounds(" + this.getBounds() + ")");
        }
        this.gl.glViewport(0, 0, n, n2);
    }

    public final synchronized void sDisplay() {
        boolean bl = true;
        long l = System.currentTimeMillis();
        if (!this.cvsIsInit()) {
            return;
        }
        if (!this.glj.gljMakeCurrent()) {
            System.out.println("GLJPanel: problem in use() method");
            return;
        }
        if (bl) {
            this.display();
            this._f_dur_self = System.currentTimeMillis() - l;
            if (GLContext.gljClassDebug) {
                this._f_dur_self_sum += this._f_dur_self;
                this.glj.gljCheckGL();
            }
            int n = this.rgba ? 6408 : 6407;
            int n2 = this.rgba ? 4 : 3;
            int n3 = this.rgba ? 2 : 1;
            Dimension dimension = null;
            dimension = this.customOffScrnSize ? this.offScrnSize : this.getSize();
            int n4 = dimension.width;
            int n5 = dimension.height;
            long l2 = System.currentTimeMillis();
            if (this.offImage == null || this.offImage.getHeight() != n5 || this.offImage.getWidth() != n4) {
                if (this.offImage != null) {
                    this.offImage.flush();
                }
                this.offImage = new BufferedImage(n4, n5, n3);
                this.offImagePixels = new byte[n4 * n5 * n2];
                this.dbInt = (DataBufferInt)this.offImage.getRaster().getDataBuffer();
                if (GLContext.gljClassDebug) {
                    System.out.print("set offImage to size: " + dimension + "(hw size: " + n4 + "x" + n5 + "), type: ");
                    switch (n) {
                        case 6407: {
                            System.out.println("RGB");
                            break;
                        }
                        case 6408: {
                            System.out.println("RGBA");
                            break;
                        }
                        case 32992: {
                            System.out.println("BGR");
                            break;
                        }
                        case 32993: {
                            System.out.println("BGRA");
                            break;
                        }
                    }
                }
            }
            GLContext.gljReadPixelGL2AWT(0, 0, n4, n5, n, 5121, this.glj.isDoubleBuffer() ? 1029 : 1028, this.offImagePixels, this.dbInt.getData());
            if (GLContext.gljClassDebug) {
                this._f_dur_tst_sum += System.currentTimeMillis() - l2;
            }
            if (GLContext.gljClassDebug) {
                this.glj.gljCheckGL();
            }
            this.glj.gljFree();
            if (!this.customOffScrnSize) {
                this.gr.drawImage(this.offImage, 0, 0, this);
            } else {
                dimension = super.getSize();
                this.gr.drawImage(this.offImage, 0, 0, dimension.width, dimension.height, this);
            }
            this._f_dur_total = System.currentTimeMillis() - l;
            if (GLContext.gljClassDebug) {
                this._f_dur_total_sum += this._f_dur_total;
                if (++this._f_dur_times == 100) {
                    System.out.println("self p 100: " + (double)(this._f_dur_self_sum / 100L) / 1000.0 + " s");
                    System.out.println("tst p 100: " + (double)(this._f_dur_tst_sum / 100L) / 1000.0 + " s");
                    System.out.println("gl-bitblit p 100: " + (double)((this._f_dur_total_sum - this._f_dur_self_sum) / 100L) / 1000.0 + " s");
                    System.out.println("total p 100: " + (double)(this._f_dur_total_sum / 100L) / 1000.0 + " s");
                    this._f_dur_self_sum = 0L;
                    this._f_dur_tst_sum = 0L;
                    this._f_dur_total_sum = 0L;
                    this._f_dur_times = 0;
                }
            }
        }
    }

    public void setOffScreenSize(Dimension dimension) {
        if (dimension != null && !dimension.equals(this.offScrnSize) || dimension != this.offScrnSize) {
            this.offScrnSizeChanged = true;
            this.offScrnSize = dimension;
            this.customOffScrnSize = this.offScrnSize != null;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.needCvsDispose) {
            this.cvsDispose();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getComponent().equals(this.topLevelWindow)) {
            this.cvsDispose();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

