/*
 * Decompiled with CFR 0.152.
 */
package gl4java.awt;

import gl4java.GLContext;
import gl4java.awt.GLCanvas;

public class GLAnimCanvas
extends GLCanvas
implements Runnable {
    protected double FramesPerSec = 20.0;
    protected long mSecPerFrame = 0L;
    protected long dFpsMilli = 0L;
    protected Thread killme = null;
    protected boolean threadSuspended = false;
    protected boolean useRepaint = true;
    protected boolean useFpsSleep = true;
    protected boolean shallWeRender = true;
    private long _fDelay = 0L;
    private long _fDelay_Frames = 10L;
    private boolean _fDelaySync = true;
    private boolean _fDelayRun = false;
    private double fps = 0.0;
    private long fps_duration = 0L;
    private long fps_start = 0L;
    private long fps_frames = 0L;
    private boolean fps_isCounting = true;
    private boolean verboseFps = false;

    static {
        if (!GLContext.loadNativeLibraries(null, null, null)) {
            System.out.println("GLAnimCanvas could not load def. native libs.");
        }
    }

    public GLAnimCanvas(int n, int n2) {
        super(n, n2);
        this.setAnimateFps(this.FramesPerSec);
    }

    public GLAnimCanvas(int n, int n2, String string, String string2) {
        super(n, n2, string, string2);
        this.setAnimateFps(this.FramesPerSec);
    }

    public void ReInit() {
    }

    public void display() {
        if (!this.cvsIsInit() || !this.glj.gljMakeCurrent(true)) {
            System.out.println("problem in use() method");
            return;
        }
        this.glj.gljSwap();
        this.glj.gljCheckGL();
        this.glj.gljFree();
    }

    public double getFps() {
        return this.fps;
    }

    public long getFpsDuration() {
        return this.fps_duration;
    }

    public long getFpsFrames() {
        return this.fps_frames;
    }

    public double getMaxFps() {
        return 1.0 / (double)this._f_dur * 1000.0;
    }

    public boolean getUseFpsSleep() {
        return this.useFpsSleep;
    }

    public boolean getUseRepaint() {
        return this.useRepaint;
    }

    public void init() {
        this.glj.gljCheckGL();
        this.ReInit();
        this.start();
    }

    public boolean isAlive() {
        if (this.killme == null) {
            return false;
        }
        return this.killme.isAlive();
    }

    public boolean isSuspended() {
        if (this.killme == null) {
            return true;
        }
        return this.threadSuspended;
    }

    public void resetFpsCounter() {
        this.fps = 0.0;
        this.fps_duration = 0L;
        this.fps_frames = 0L;
        this.fps_isCounting = true;
        this.fps_start = System.currentTimeMillis();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.killme == thread) {
            GLAnimCanvas gLAnimCanvas;
            if (this.cvsIsInit()) {
                if (this.shallWeRender) {
                    if (this.useRepaint) {
                        this.repaint();
                    } else {
                        this.sDisplay();
                    }
                } else {
                    gLAnimCanvas = this;
                    synchronized (gLAnimCanvas) {
                        this.threadSuspended = true;
                    }
                }
                if (this.fps_isCounting) {
                    ++this.fps_frames;
                }
            }
            try {
                if (this.useFpsSleep) {
                    if (this.useRepaint) {
                        this.dFpsMilli = this.mSecPerFrame < this._f_dur ? this._f_dur : this.mSecPerFrame;
                    } else {
                        this.dFpsMilli = this.mSecPerFrame - this._f_dur;
                        if (this.dFpsMilli <= 0L) {
                            this.dFpsMilli = 1L;
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(this.dFpsMilli, 0);
                }
                if (!this.threadSuspended) continue;
                this.stopFpsCounter();
                gLAnimCanvas = this;
                synchronized (gLAnimCanvas) {
                    while (this.threadSuspended) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setAnimateFps(double d) {
        this.FramesPerSec = d;
        this.mSecPerFrame = (long)(1.0 / this.FramesPerSec * 1000.0);
        if (this.verboseFps) {
            System.out.println("\nset fps    := " + String.valueOf(d) + " -> " + String.valueOf(this.mSecPerFrame) + " [ms/frame]");
        }
        this.resetFpsCounter();
    }

    public void setAnimateFps(double d, int n) {
        this.setAnimateFps(d);
    }

    public void setSuspended(boolean bl) {
        this.setSuspended(bl, false);
    }

    public synchronized void setSuspended(boolean bl, boolean bl2) {
        if (bl) {
            this.shallWeRender = false;
        } else if (!this.isAlive()) {
            this.start();
        } else {
            this.shallWeRender = true;
            this.resetFpsCounter();
            if (bl2) {
                this.ReInit();
            }
            this.threadSuspended = false;
            this.notify();
        }
    }

    public void setUseFpsSleep(boolean bl) {
        this.useFpsSleep = bl;
    }

    public void setUseRepaint(boolean bl) {
        this.useRepaint = bl;
    }

    public void setVerboseFps(boolean bl) {
        this.verboseFps = bl;
    }

    public void start() {
        if (this.killme == null) {
            this.killme = new Thread(this);
            this.killme.start();
            this.resetFpsCounter();
        }
    }

    public synchronized void stop() {
        this.killme = null;
        this.threadSuspended = false;
        this.notify();
    }

    public void stopFpsCounter() {
        if (this.fps_isCounting) {
            long l = System.currentTimeMillis();
            this.fps_duration = l - this.fps_start;
            double d = (double)this.fps_duration / 1000.0;
            if (d == 0.0) {
                d = 1.0;
            }
            this.fps = (double)this.fps_frames / d;
            this.fps_isCounting = false;
        }
        if (this.verboseFps) {
            System.out.println("\nfps    = " + String.valueOf(this.fps));
            System.out.println("time   = " + String.valueOf(this.fps_duration) + " ms");
            System.out.println("frames = " + String.valueOf(this.fps_frames));
            if (this.fps_frames == 0L) {
                this.fps_frames = 1L;
            }
            System.out.println("time/f = " + String.valueOf(this.fps_duration / this.fps_frames) + " ms");
        }
    }
}

