/*
 * Decompiled with CFR 0.152.
 */
package gl4java.applet;

import gl4java.GLContext;
import gl4java.GLFunc;
import gl4java.GLUFunc;
import gl4java.awt.GLAnimCanvas;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class SimpleGLAnimApplet1
extends Applet
implements MouseListener,
WindowListener,
ActionListener,
ItemListener {
    public GLAnimCanvas canvas = null;
    public Button buttonInfo = null;
    public Button buttonFps = null;
    public TextField textFps = null;
    public Checkbox checkUseRepaint = null;
    public Checkbox checkUseFpsSleep = null;
    public Button buttonReStart = null;
    Frame fInfo = null;

    public void actionPerformed(ActionEvent actionEvent) {
        block3: {
            Object object = actionEvent.getSource();
            if (object != this.textFps) break block3;
            try {
                double d = Double.valueOf(this.textFps.getText());
                if (this.canvas != null) {
                    this.canvas.setAnimateFps(d);
                    this.canvas.setSuspended(false, true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("wrong fps format, use float ..");
            }
        }
    }

    public void destroy() {
        if (this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
        this.canvas.stop();
        this.canvas.cvsDispose();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 3));
        this.buttonInfo = new Button("GL4Java");
        this.buttonInfo.addMouseListener(this);
        panel.add(this.buttonInfo);
        this.checkUseRepaint = new Checkbox("repaint", true);
        this.checkUseRepaint.addItemListener(this);
        panel.add(this.checkUseRepaint);
        this.checkUseFpsSleep = new Checkbox("fps-sleep", true);
        this.checkUseFpsSleep.addItemListener(this);
        panel.add(this.checkUseFpsSleep);
        this.buttonReStart = new Button("start/stop");
        this.buttonReStart.addMouseListener(this);
        panel.add(this.buttonReStart);
        this.buttonFps = new Button("fps: ");
        this.buttonFps.addMouseListener(this);
        panel.add(this.buttonFps);
        this.textFps = new TextField("0000000000");
        this.textFps.addActionListener(this);
        panel.add(this.textFps);
        this.add("South", panel);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable.equals(this.checkUseRepaint) && this.canvas != null) {
            this.canvas.setUseRepaint(this.checkUseRepaint.getState());
            System.out.println("canvas uses repaint: " + this.checkUseRepaint.getState());
        }
        if (itemSelectable.equals(this.checkUseFpsSleep) && this.canvas != null) {
            this.canvas.setUseFpsSleep(this.checkUseFpsSleep.getState());
            System.out.println("canvas uses fps-sleep: " + this.checkUseFpsSleep.getState());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (this.canvas != null && component.equals(this.buttonFps)) {
            double d = 0.0;
            this.canvas.stopFpsCounter();
            d = this.canvas.getFps();
            int n = (int)(d * 100.0);
            d = (double)n / 100.0;
            this.textFps.setText(String.valueOf(d));
            this.canvas.resetFpsCounter();
        } else if (component.equals(this.buttonInfo)) {
            if (this.fInfo == null && this.canvas != null && this.canvas.getGLContext() != null) {
                this.fInfo = this.showGLInfo();
            }
        } else if (component.equals(this.buttonReStart)) {
            this.canvas.setSuspended(this.canvas.isSuspended() ^ true, mouseEvent.getClickCount() > 1);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public Frame showGLInfo() {
        if (this.canvas == null) {
            return null;
        }
        GLContext gLContext = this.canvas.getGLContext();
        if (gLContext == null) {
            return null;
        }
        GLFunc gLFunc = gLContext.getGLFunc();
        if (gLFunc == null) {
            return null;
        }
        GLUFunc gLUFunc = gLContext.getGLUFunc();
        if (gLFunc == null) {
            return null;
        }
        this.canvas.setSuspended(true, false);
        Frame frame = new Frame("GL4Java Version");
        TextArea textArea = new TextArea(25, 80);
        textArea.setEditable(false);
        frame.add(textArea);
        ((Component)frame).setSize(600, 400);
        String string = "null string";
        if (!gLContext.gljMakeCurrent()) {
            string = "problem in use() method\n";
        } else {
            string = this.canvas.getGLContext().gljGetVersions();
            if (string == null) {
                string = "could not get versions";
            }
            System.out.println(string);
            gLContext.gljFree();
        }
        textArea.append(string);
        frame.addWindowListener(this);
        this.canvas.setSuspended(false, false);
        frame.pack();
        ((Component)frame).setVisible(true);
        return frame;
    }

    public void start() {
        this.checkUseFpsSleep.setState(this.canvas.getUseFpsSleep());
        this.checkUseRepaint.setState(this.canvas.getUseRepaint());
        this.canvas.start();
    }

    public void stop() {
        this.canvas.stop();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this.fInfo && this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (window == this.fInfo && this.fInfo != null) {
            this.fInfo.dispose();
            this.fInfo = null;
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

