/*
 * Decompiled with CFR 0.152.
 */
package gl4java;

import gl4java.GL4JavaInitException;
import gl4java.GLFunc;
import gl4java.GLUFunc;
import gl4java.jau.awt.WinHandleAccess;
import gl4java.system.GljMSJDirect;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.peer.LightweightPeer;
import java.io.Serializable;
import java.lang.reflect.Method;

public class GLContext
implements Runnable {
    protected boolean isInitialized = false;
    protected static boolean libsLoaded = false;
    public static final String defGljMSWinLib = "GL4JavaGljMSJDirect";
    public static final String defGljLib = "GL4JavaJauGljJNI";
    public static final String defGLFuncClass = "GLFuncJauJNI";
    public static final String defGLFuncLib = "GL4JavaJauGLJNI";
    public static final String defGLUFuncClass = "GLUFuncJauJNI";
    public static final String defGLUFuncLib = "GL4JavaJauGLUJNI";
    public static final String version = "2.4.1.0";
    public static boolean gljClassDebug = false;
    public static boolean gljNativeDebug = false;
    protected int glContext = 0;
    protected GLContext sharedGLContext;
    protected int sharedGLContextNative = 0;
    protected int pixmapHandle = 0;
    protected int windowHandle = 0;
    protected int displayHandle = 0;
    private int createwinx;
    private int createwiny;
    private int createwinw;
    private int createwinh;
    private boolean threadRunning = false;
    private boolean destroyWindow = false;
    protected Container containerWindow = null;
    protected Dimension offScrnSize = null;
    int pData = 0;
    protected boolean glEnabled = true;
    protected boolean offScreenRenderer = false;
    protected boolean doubleBuffer = true;
    protected int stencilBits = 0;
    protected int accumSize = 0;
    protected boolean stereoView = false;
    protected boolean rgba = true;
    protected boolean createOwnWindow = false;
    protected boolean mustResize = false;
    protected Dimension size = null;
    protected Component _comp = null;
    protected Component _compHeavy = null;
    public static final int OsWindoof = -1;
    public static final int OsUnknown = 0;
    public static final int OsX11 = 1;
    public static final int OsMac = 2;
    private static int osType = 0;
    private static boolean isNetscapeJvm = false;
    private static boolean isMicrosoftJvm = false;
    private static boolean useMSJDirect = false;
    private static String jvmVendor = null;
    private static String jvmVersion = null;
    private static int jvmVersionMajor = 1;
    private static int jvmVersionMinor = 1;
    private static String osName = null;
    private GLFunc gl = null;
    private GLUFunc glu = null;

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc) {
        this(component, gLFunc, gLUFunc, false, false, true, false, true, 0, 0, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2) {
        this(component, gLFunc, gLUFunc, false, false, bl, bl2, true, 0, 0, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3) {
        this(component, gLFunc, gLUFunc, false, false, bl, bl2, bl3, 0, 0, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, int n) {
        this(component, gLFunc, gLUFunc, false, false, bl, bl2, bl3, n, 0, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        this(component, gLFunc, gLUFunc, false, false, bl, bl2, bl3, n, n2, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        this(component, gLFunc, gLUFunc, bl, false, bl2, bl3, bl4, n, 0, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2) {
        this(component, gLFunc, gLUFunc, bl, false, bl2, bl3, bl4, n, n2, null, null);
    }

    public GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, GLContext gLContext) {
        this(component, gLFunc, gLUFunc, bl, false, bl2, bl3, bl4, n, n2, gLContext, null);
    }

    protected GLContext(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, int n2, GLContext gLContext, Dimension dimension) {
        this._comp = component;
        this.gl = gLFunc;
        this.glu = gLUFunc;
        this.createOwnWindow = bl;
        this.offScreenRenderer = bl2;
        this.doubleBuffer = bl3;
        this.stereoView = bl4;
        this.rgba = bl5;
        this.stencilBits = n;
        this.accumSize = n2;
        this.offScrnSize = dimension;
        this.sharedGLContext = gLContext;
        if (this.sharedGLContext != null) {
            this.sharedGLContextNative = (int)this.sharedGLContext.getNativeGLContext();
        }
        while (component != null && component.getPeer() instanceof LightweightPeer) {
            component = component.getParent();
        }
        this._compHeavy = component;
        Graphics graphics = null;
        if (this._compHeavy != null) {
            if (!this._comp.isVisible()) {
                this.setVisible(true);
            }
            if ((graphics = this._compHeavy.getGraphics()) == null) {
                System.out.println("got empty Graphics");
            }
        } else {
            System.out.println("got empty Component");
        }
        if (this._comp != null && graphics != null) {
            int n3 = 0;
            do {
                this.createGLContext(graphics);
                if (this.gljIsInit()) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            } while (!this.gljIsInit() && ++n3 < 5);
        }
        if (gljClassDebug) {
            if (this.gljIsInit()) {
                System.out.println(">>> GLContext() succeded");
            } else {
                System.out.println(">>> GLContext() failed");
            }
        }
    }

    public final void createGLContext(Graphics graphics) {
        String string = "sun.awt.";
        WinHandleAccess winHandleAccess = null;
        try {
            Serializable serializable;
            if (gljClassDebug) {
                System.out.println(">>> createGLContext");
            }
            if (this.pData == 0) {
                if (useMSJDirect) {
                    if (gljClassDebug) {
                        System.out.println("using MSJDirect ...");
                    }
                    winHandleAccess = (WinHandleAccess)Class.forName(String.valueOf(string) + "windows.MSWin32HandleAccess").newInstance();
                    serializable = this._comp;
                    while (!(serializable instanceof Window) && !(serializable instanceof Applet)) {
                        serializable = ((Component)serializable).getParent();
                    }
                    this.containerWindow = (Container)serializable;
                    graphics = ((Component)serializable).getGraphics();
                    if (graphics == null) {
                        System.out.println("GL4Java-MSJVM: got empty Graphics");
                    }
                    this.pData = winHandleAccess.getWinHandle((Component)serializable, graphics);
                    if (this.pData != 0) {
                        Object object;
                        Cloneable cloneable;
                        Point point;
                        try {
                            point = this._comp.getLocationOnScreen();
                        }
                        catch (Exception exception) {
                            point = this._comp.getLocation();
                            cloneable = this.containerWindow.getLocation();
                            point.x += ((Point)cloneable).x;
                            point.y += ((Point)cloneable).y;
                            object = this.containerWindow.getInsets();
                            point.x += ((Insets)object).left;
                            point.y += ((Insets)object).top;
                        }
                        cloneable = this._comp.getBounds();
                        this.createwinx = point.x;
                        this.createwiny = point.y;
                        this.createwinw = cloneable.width;
                        this.createwinh = cloneable.height;
                        this.windowHandle = 0;
                        this.threadRunning = true;
                        this.destroyWindow = false;
                        object = new Thread(this);
                        ((Thread)object).start();
                        while (this.windowHandle == 0 && this.threadRunning) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else if (osType == -1) {
                    winHandleAccess = (WinHandleAccess)Class.forName(String.valueOf(string) + "windows.Win32HandleAccess").newInstance();
                    this.windowHandle = this.pData = winHandleAccess.getWinHandle(this._compHeavy, graphics);
                } else if (osType == 2) {
                    winHandleAccess = (WinHandleAccess)Class.forName(String.valueOf(string) + "macintosh.MacHandleAccess").newInstance();
                    this.windowHandle = this.pData = winHandleAccess.getWinHandle(this._compHeavy, graphics);
                } else {
                    winHandleAccess = (WinHandleAccess)Class.forName(String.valueOf(string) + "motif.X11HandleAccess").newInstance();
                    this.windowHandle = this.pData = winHandleAccess.getWinHandle(this._compHeavy, graphics);
                }
            }
            if (this.offScrnSize != null) {
                this.createwinw = this.offScrnSize.width;
                this.createwinh = this.offScrnSize.height;
            } else {
                serializable = this._comp.getBounds();
                this.createwinw = ((Rectangle)serializable).width;
                this.createwinh = ((Rectangle)serializable).height;
            }
            try {
                this.gljInit();
            }
            catch (GL4JavaInitException gL4JavaInitException) {
                System.out.println("can't create a GL context\n");
            }
        }
        catch (Exception exception) {
            System.out.println("An exception is thrown, while creating a GL context\n");
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public static final GLFunc createGLFunc(String string) {
        String string2 = "gl4java.";
        GLFunc gLFunc = null;
        Object var3_3 = null;
        if (string == null) {
            string = defGLFuncClass;
        }
        String string3 = String.valueOf(string2) + string;
        try {
            var3_3 = Class.forName(string3).newInstance();
        }
        catch (Exception exception) {
            System.out.println("could not create instance of: " + string3);
        }
        if (var3_3 != null && var3_3 instanceof GLFunc) {
            gLFunc = var3_3;
        } else {
            System.out.println("Not a GLFunc implementation: " + string3);
        }
        return gLFunc;
    }

    public static final GLUFunc createGLUFunc(String string) {
        String string2 = "gl4java.";
        GLUFunc gLUFunc = null;
        Object var3_3 = null;
        if (string == null) {
            string = defGLUFuncClass;
        }
        String string3 = String.valueOf(string2) + string;
        try {
            var3_3 = Class.forName(string3).newInstance();
        }
        catch (Exception exception) {
            System.out.println("could not create instance of: " + string3);
        }
        if (var3_3 != null && var3_3 instanceof GLUFunc) {
            gLUFunc = var3_3;
        } else {
            System.out.println("Not a GLUFunc implementation: " + string3);
        }
        return gLUFunc;
    }

    public static final GLContext createOffScreenCtx(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, int n, int n2, GLContext gLContext) {
        return new GLContext(component, gLFunc, gLUFunc, false, true, false, bl, bl2, n, n2, gLContext, null);
    }

    public static final GLContext createOffScreenCtx(Component component, GLFunc gLFunc, GLUFunc gLUFunc, boolean bl, boolean bl2, int n, int n2, GLContext gLContext, Dimension dimension) {
        return new GLContext(component, gLFunc, gLUFunc, false, true, false, bl, bl2, n, n2, gLContext, dimension);
    }

    public final int getAccumSize() {
        return this.accumSize;
    }

    public final GLFunc getGLFunc() {
        return this.gl;
    }

    public final GLUFunc getGLUFunc() {
        return this.glu;
    }

    public static String getJVMVendor() {
        return jvmVendor;
    }

    public final long getNativeGLContext() {
        return this.glContext;
    }

    public final int getNativeOSType() {
        return osType;
    }

    public final long getNativeWindoHandle() {
        return this.windowHandle;
    }

    public final GLContext getSharedGLContext() {
        return this.sharedGLContext;
    }

    public final int getStencilBitNumber() {
        return this.stencilBits;
    }

    public final boolean gljCheckGL() {
        int n = this.gl.glGetError();
        if (n != 0) {
            String string = this.glu.gluErrorString(n);
            try {
                throw new Exception();
            }
            catch (Exception exception) {
                System.out.println("GL ERROR : " + string);
                System.out.println("GL ERROR : " + n + " == 0x" + Integer.toHexString(n));
                exception.printStackTrace();
                System.out.println();
                System.out.flush();
                return false;
            }
        }
        return true;
    }

    public static final boolean gljCheckGLTypes() {
        return GLContext.gljCheckGLTypesNative();
    }

    private static final native boolean gljCheckGLTypesNative();

    public final native void gljCpyOffScrnImg2Buffer(int var1, int var2, int var3, byte[] var4);

    public final native void gljCpyOffScrnImg2Buffer(int var1, int var2, int var3, int[] var4);

    public final synchronized boolean gljDestroy() {
        boolean bl = true;
        if (!this.gljDestroyNative()) {
            bl = false;
        }
        this.windowHandle = 0;
        this.glContext = 0;
        this.pixmapHandle = 0;
        if (useMSJDirect) {
            this.destroyWindow = false;
            GljMSJDirect.destroyOGLWindowNative(this.pData);
            this.windowHandle = 0;
            GljMSJDirect.OGLWindowMsgPump();
        }
        this.pData = 0;
        return bl;
    }

    private final native boolean gljDestroyNative();

    public final boolean gljFree() {
        if (!this.isInitialized) {
            return false;
        }
        return GLContext.gljFreeNative(this.displayHandle, this.windowHandle, this.glContext);
    }

    private static final native boolean gljFreeNative(int var0, int var1, int var2);

    public static final String gljGetClassVendor() {
        return "Jausoft - Sven Goethel Software Development";
    }

    public static final String gljGetClassVersion() {
        return version;
    }

    public static final String gljGetNativeLibVendor() {
        return GLContext.gljGetNativeLibVendorNative();
    }

    private static final native String gljGetNativeLibVendorNative();

    public static final String gljGetNativeLibVersion() {
        return GLContext.gljGetNativeLibVersionNative();
    }

    private static final native String gljGetNativeLibVersionNative();

    public final String gljGetVersions() {
        if (!libsLoaded || this.gl == null || this.glu == null || !this.gljIsInit()) {
            return null;
        }
        String string = "GL4Java - LGPL-Version\n-------------------------------------------------\n-------------------------------------------------\nJava-Class         : GL4Java.GLContext           \n          : Version: " + GLContext.gljGetClassVersion() + "\n" + "            Vendor : " + GLContext.gljGetClassVendor() + "\n" + "Native-Library     : GL4Java.GLContext           \n" + "            Version: " + GLContext.gljGetNativeLibVersion() + "\n" + "            Vendor : " + GLContext.gljGetNativeLibVendor() + "\n" + "-------------------------------------------------\n" + "Java-Class         : GL4Java.GLFunc impl.        \n" + "          : Version: " + this.gl.getClassVersion() + "\n" + "            Vendor : " + this.gl.getClassVendor() + "\n" + "Native-Library     : GL4Java.GLFunc impl.        \n" + "            Version: " + this.gl.getNativeVersion() + "\n" + "            Vendor : " + this.gl.getNativeVendor() + "\n" + "-------------------------------------------------\n" + "Java-Class         : GL4Java.GLUFunc impl.       \n" + "          : Version: " + this.glu.getClassVersion() + "\n" + "            Vendor : " + this.glu.getClassVendor() + "\n" + "Native-Library     : GL4Java.GLUFunc impl.       \n" + "            Version: " + this.glu.getNativeVersion() + "\n" + "            Vendor : " + this.glu.getNativeVendor() + "\n" + "-------------------------------------------------\n" + "\n";
        String string2 = this.gl.glGetString(7936);
        String string3 = this.gl.glGetString(7937);
        String string4 = this.gl.glGetString(7938);
        String string5 = this.gl.glGetString(7939);
        String string6 = this.glu.gluGetString(100800);
        String string7 = this.glu.gluGetString(100801);
        String string8 = "OpenGL - Versions                              \n-----------------------------------------------\nGL  VENDOR: " + string2 + "\n" + "GL  RENDERER: " + string3 + "\n" + "GL  VERSION: " + string4 + "\n" + "GL  EXTENSIONS: " + string5 + "\n" + "GLU VERSION: " + string6 + "\n" + "GLU EXTENSIONS: " + string7 + "\n" + "\n";
        String string9 = "OpenGL - Function Test                         \n-----------------------------------------------\n";
        int n = 0;
        while (n < GLFunc.GL_PROC_NAMES.length) {
            String string10 = GLFunc.GL_PROC_NAMES[n];
            if (string10 == null) break;
            string9 = GLContext.gljTestGLProc(string10, gljNativeDebug) ? String.valueOf(string9) + "OK  : " + string10 + "\n" : String.valueOf(string9) + "NOPE: " + string10 + "\n";
            ++n;
        }
        return String.valueOf(string) + "\n" + string8 + "\n" + string9;
    }

    protected final synchronized void gljInit() throws GL4JavaInitException {
        if (!libsLoaded) {
            return;
        }
        if (this.pData == 0 && !this.offScreenRenderer) {
            System.out.println("could not open a GL widget -- Win CONTEXT");
            throw new GL4JavaInitException();
        }
        if (gljClassDebug) {
            System.out.println(">>> gljInit");
        }
        if (!this.openOpenGLNative()) {
            if (useMSJDirect) {
                this.destroyWindow = true;
                while (this.threadRunning) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                this.pData = 0;
                this.windowHandle = 0;
            }
            System.out.println("could not open a GL widget -- GL CONTEXT");
            throw new GL4JavaInitException();
        }
        this.isInitialized = true;
    }

    public final boolean gljIsInit() {
        return this.isInitialized;
    }

    public final boolean gljMakeCurrent() {
        if (!this.isInitialized || !this.glEnabled) {
            return false;
        }
        return GLContext.gljMakeCurrentNative(this.displayHandle, this.windowHandle, this.glContext);
    }

    public final boolean gljMakeCurrent(boolean bl) {
        if (!this.isInitialized || !this.glEnabled) {
            return false;
        }
        return GLContext.gljMakeCurrentNative(this.displayHandle, this.windowHandle, this.glContext);
    }

    private static final native boolean gljMakeCurrentNative(int var0, int var1, int var2);

    public static final native void gljReadPixelGL2AWT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, byte[] var7);

    public static final native void gljReadPixelGL2AWT(int var0, int var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int[] var8);

    public final void gljResize(int n, int n2) {
        if (!this.isInitialized || !this.glEnabled) {
            return;
        }
        if (this.offScreenRenderer) {
            return;
        }
        if (useMSJDirect) {
            try {
                Point point = this._comp.getLocationOnScreen();
                GljMSJDirect.moveOGLWindowNative(this.windowHandle, point.x, point.y, n, n2);
            }
            catch (Exception exception) {}
        } else {
            this.gljResizeNative(this.createOwnWindow, this.displayHandle, this.windowHandle, n, n2);
        }
    }

    private final native void gljResizeNative(boolean var1, int var2, int var3, int var4, int var5);

    public final Frame gljShowVersions() {
        Frame frame = new Frame("GL4Java Version");
        TextArea textArea = new TextArea(25, 80);
        textArea.setEditable(false);
        frame.add(textArea);
        ((Component)frame).setSize(600, 400);
        frame.pack();
        ((Component)frame).setVisible(true);
        String string = "null string";
        if (!this.gljMakeCurrent(true)) {
            string = "problem in use() method\n";
        } else {
            string = this.gljGetVersions();
            if (string == null) {
                string = "could not get versions";
            }
            System.out.println(string);
            this.gljFree();
        }
        textArea.append(string);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        return frame;
    }

    public final boolean gljSwap() {
        if (!this.isInitialized) {
            return false;
        }
        return GLContext.gljSwapNative(this.displayHandle, this.windowHandle, this.glContext, this.doubleBuffer);
    }

    private static final native boolean gljSwapNative(int var0, int var1, int var2, boolean var3);

    public static final native boolean gljTestGLProc(String var0, boolean var1);

    public final boolean isDoubleBuffer() {
        return this.doubleBuffer;
    }

    public boolean isEnabled() {
        return this.glEnabled;
    }

    public static boolean isMicrosoftJVM() {
        return isMicrosoftJvm;
    }

    public static boolean isNetscapeJVM() {
        return isNetscapeJvm;
    }

    public final boolean isOwnWindowCreated() {
        return this.createOwnWindow;
    }

    public final boolean isRGBA() {
        return this.rgba;
    }

    public final boolean isStereoView() {
        return this.stereoView;
    }

    public static boolean loadNativeLibraries(String string, String string2, String string3) {
        Object object;
        Class[] classArray;
        if (libsLoaded) {
            return true;
        }
        String[] stringArray = null;
        jvmVendor = System.getProperty("java.vendor");
        jvmVersion = System.getProperty("java.version");
        int n = 0;
        int n2 = jvmVersion.indexOf(".", n);
        String string4 = jvmVersion.substring(n, n2);
        try {
            jvmVersionMajor = Integer.valueOf(string4);
        }
        catch (Exception exception) {
            System.out.println("Not a number: " + string4 + " (" + jvmVersion + ")");
        }
        n = n2 + 1;
        n2 = jvmVersion.indexOf(".", n);
        string4 = jvmVersion.substring(n, n2);
        try {
            jvmVersionMinor = Integer.valueOf(string4);
        }
        catch (Exception exception) {
            System.out.println("Not a number: " + string4 + " (" + jvmVersion + ")");
        }
        if (gljClassDebug) {
            System.out.println("jvm vendor: " + jvmVendor);
            System.out.println("jvm version: " + jvmVersion + " ( " + "major: " + jvmVersionMajor + ", minor: " + jvmVersionMinor + " )");
        }
        isNetscapeJvm = jvmVendor != null && jvmVendor.indexOf("Netscape") >= 0;
        isMicrosoftJvm = jvmVendor != null && jvmVendor.indexOf("Microsoft") >= 0;
        osName = System.getProperty("os.name");
        osType = osName.startsWith("Wind") ? -1 : (osName.startsWith("Mac OS") ? 2 : 1);
        String string5 = "";
        if (jvmVersionMajor >= 2 || jvmVersionMajor == 1 && jvmVersionMinor >= 2) {
            string5 = "12";
        }
        if (string == null) {
            string = defGljLib + string5;
        }
        if (string2 == null) {
            string2 = defGLFuncLib + string5;
        }
        if (string3 == null) {
            string3 = defGLUFuncLib + string5;
        }
        if (osType == -1 && isMicrosoftJvm) {
            stringArray = new String[]{string, string2, string3, defGljMSWinLib};
            useMSJDirect = true;
        } else {
            stringArray = new String[]{string, string2, string3};
            useMSJDirect = false;
        }
        if (isNetscapeJvm) {
            System.out.println("Netscape JVM try to get Privileges");
            try {
                Class<?> clazz = Class.forName("netscape.security.PrivilegeManager");
                classArray = new Class[]{Class.forName("java.lang.String")};
                object = clazz.getMethod("enablePrivilege", classArray);
                Object[] objectArray = new Object[]{new String("UniversalLinkAccess")};
                ((Method)object).invoke(clazz, objectArray);
                System.out.println("Netscape-Privilege: enabled UniversalLinkAccess priv.");
            }
            catch (Exception exception) {
                System.out.println("Not enabled Netscape-Privilege: UniversalLinkAccess priv.");
            }
        }
        int n3 = 0;
        classArray = null;
        object = new boolean[stringArray.length];
        n3 = 0;
        while (n3 < stringArray.length) {
            object[n3] = false;
            ++n3;
        }
        n3 = 0;
        while (n3 < stringArray.length) {
            do {
                try {
                    System.loadLibrary(stringArray[n3]);
                    object[n3] = true;
                    if (!gljClassDebug) continue;
                    System.out.println("loaded native library: " + stringArray[n3]);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    System.out.println("Sorry, can't find the library: " + stringArray[n3] + "\n" + unsatisfiedLinkError);
                    stringArray[n3] = null;
                }
            } while (object[n3] == false && stringArray[n3] != null);
            ++n3;
        }
        n3 = 0;
        while (n3 < stringArray.length) {
            if (!object[n3]) break;
            ++n3;
        }
        if (n3 == stringArray.length) {
            libsLoaded = true;
        }
        return libsLoaded;
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = defGLFuncClass;
        String string5 = defGLUFuncClass;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        boolean bl3 = true;
        if (stringArray.length == 0) {
            System.out.println("usage: java gl4java.GLContext <options>, where options can be: ");
            System.out.println("\t-gljlib <glj-libname> \t choose a custom the gl4java-glj-lib native library (default: GL4JavaJauGljJNI)");
            System.out.println("\t-gllib <gl-libname> \t choose a custom the gl4java-gl-lib native library (default: GL4JavaJauGLJNI)");
            System.out.println("\t-glulib <glu-libname> \t choose a custom the gl4java-glu-lib native library (default: GL4JavaJauGLUJNI");
            System.out.println("\t-glclass <gl-class> \t choose a custom the gl4java-gl-class java GLFunc implementation (default: GLFuncJauJNI)");
            System.out.println("\t-gluclass <glu-class> \t choose a custom the gl4java-glu-class java GLUFunc implementation (default: GLUFuncJauJNI)");
            System.out.println("\t-info \t creates a GLContext and prints all avaiable information of GL/GLU and GL4Java");
            System.out.println("\t-infotxt \t like -info, but exits straight after -info !");
            System.exit(0);
        }
        while (stringArray.length > n) {
            if (stringArray[n].equals("-gljlib")) {
                if (stringArray.length > ++n) {
                    string = stringArray[n];
                }
            } else if (stringArray[n].equals("-gllib")) {
                if (stringArray.length > ++n) {
                    string2 = stringArray[n];
                }
            } else if (stringArray[n].equals("-glulib")) {
                if (stringArray.length > ++n) {
                    string3 = stringArray[n];
                }
            } else if (stringArray[n].equals("-glclass")) {
                if (stringArray.length > ++n) {
                    string4 = stringArray[n];
                }
            } else if (stringArray[n].equals("-gluclass")) {
                if (stringArray.length > ++n) {
                    string5 = stringArray[n];
                }
            } else if (stringArray[n].equals("-info")) {
                bl = true;
            } else if (stringArray[n].equals("-infotxt")) {
                bl = true;
                bl2 = true;
            } else {
                System.out.println("illegal arg " + n + ": " + stringArray[n]);
                bl3 = false;
            }
            ++n;
        }
        gljNativeDebug = true;
        gljClassDebug = true;
        GLFunc gLFunc = null;
        GLUFunc gLUFunc = null;
        if (GLContext.loadNativeLibraries(string, string2, string3)) {
            System.out.println("native Libraries loaded succesfull");
        } else {
            System.out.println("native library NOT loaded complete");
            bl3 = false;
        }
        gLFunc = GLContext.createGLFunc(string4);
        if (gLFunc != null) {
            System.out.println("GLFunc implementation " + string4 + " created succesfull");
        } else {
            System.out.println("GLFunc implementation " + string4 + " not created");
            bl3 = false;
        }
        gLUFunc = GLContext.createGLUFunc(string5);
        if (gLUFunc != null) {
            System.out.println("GLUFunc implementation " + string5 + " created succesfull");
        } else {
            System.out.println("GLUFunc implementation " + string5 + " not created");
            bl3 = false;
        }
        if (bl && bl3) {
            Frame frame = new Frame("GL4Java Info");
            ((Component)frame).setSize(10, 10);
            frame.pack();
            ((Component)frame).setVisible(true);
            GLContext gLContext = new GLContext(frame, gLFunc, gLUFunc);
            Frame frame2 = gLContext.gljShowVersions();
            frame2.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            gLContext.gljDestroy();
            if (bl2) {
                System.exit(0);
            }
        }
    }

    protected final native boolean openOpenGLNative();

    public void run() {
        if (!useMSJDirect) {
            System.err.println("GL4Java-MSJVM-Run: INTERNAL ERROR");
            System.exit(0);
        }
        this.pData = GljMSJDirect.createOGLWindowNative(this.pData, this.createwinx, this.createwiny, this.createwinw, this.createwinh);
        if (this.pData != 0) {
            this.windowHandle = this.pData;
            while (!this.destroyWindow) {
                GljMSJDirect.OGLWindowMsgPump();
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            this.destroyWindow = false;
            GljMSJDirect.destroyOGLWindowNative(this.windowHandle);
            this.windowHandle = 0;
            this.pData = 0;
            GljMSJDirect.OGLWindowMsgPump();
        }
        this.threadRunning = false;
    }

    public void setEnabled(boolean bl) {
        this.glEnabled = bl;
        if (!bl && this.isInitialized) {
            this.gljFree();
        }
    }

    public final void setGLFunc(GLFunc gLFunc) {
        this.gl = gLFunc;
    }

    public final void setGLUFunc(GLUFunc gLUFunc) {
        this.glu = gLUFunc;
    }

    public void setVisible(boolean bl) {
        int n = 0;
        this._comp.setVisible(bl);
        while (this._comp.isVisible() != bl && n < 5) {
            this._comp.setVisible(bl);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                System.out.println("GLContext:setVisible: Error - " + exception);
            }
            ++n;
        }
        if (n >= 5) {
            System.out.println("GLContext:setVisible: Error, could not set to " + bl);
        }
    }
}

