/*
 Ŀ
  FILE        : init.c                   VERSION : 1.3     DATE : 12/07/1998 
  DESCRIPTION : Initialize Functions                                         
                                                                             
 Ĵ
  Copyright (C) 1998 by Yannick Suter aka AsC/Nowadays                       
 
*/

#include "libs/header.h"
#include "libs/level.dat"

void initPAUSE()
{
    int x, indx = 196, indy = 250;

    for(x=0;x<5;x++){
        ppause[x].c = 0;
        ppause[x].ttx = indx;
        ppause[x].tty = indy;
        ppause[x].ddx = 0;
        ppause[x].dint = 1;
        indx += 22;
        indy += 6;
    }
}

void initMENU()
{
    mmenu.cmenu = 0;
    mmenu.numMENU = 4;
    mmenu.numLEV = anzLEVELS;
    mmenu.numP1 = 2;
    mmenu.p1numb = 0;
}

void initMENU2()
{
    mmenu.cmenu = 1;
    mmenu.numMENU = 4;
}

void initPSX()
{
    SetVideoMode(MODE_PAL);
    GsInitGraph(SCREEN_WIDTH, SCREEN_HEIGHT, 4, 0, 0);
    GsDefDispBuff(0, 0, 0, SCREEN_HEIGHT);

    InitialisePad();
}

void init_OT()
{
    int x;
    for(x=0;x<2;x++){
        worldOT[x].length = OT_LENGTH;
        worldOT[x].org = OTTags[x];
    }
}

void init_game(int level_ind)
{
    int x;
    char temp[16] = {0,-8,0,0,0,0,0,0,0,0,0,-8,0,-8,0,-8};

    memcpy(&coorect_x[0][0],&temp[0],16);

    for(x=0;x<jumpmax_steps;x++){
        jump_h[x] = sin(PI*(x/(float)(jumpmax_steps)))*(float)(jumpmax_height);
    }

    numLEVEL = levelDATA[level_ind][0];
    numPINGU = levelDATA[level_ind][1];
    numBIRD  = levelDATA[level_ind][2];
    numWOLKE = levelDATA[level_ind][3];

    GLOBAL_x = 30;
}

void initNME_pingu(int level_ind)
{
  int x;

  for(x=0;x<numPINGU;x++){
    pin[x].level = pingu[level_ind][x][0];
    pin[x].actLEVEL = pin[x].level;
    pin[x].state = 0;
    pin[x].knok = 0;
    pin[x].dir = pingu[level_ind][x][1];
    pin[x].x = pingu[level_ind][x][2];
    pin[x].y = level[pin[x].level].foffs_y - 16;
    pin[x].frame = 0;
  }
}

void initNME_bird(int level_ind)
{
  int x;

  for(x=0;x<numBIRD;x++) initNME_birdx(x,level_ind);
}

void initNME_birdx(int x,int level_ind)
{
    bird[x].level = bird_init[level_ind][x][0];
    bird[x].state = 0;
    bird[x].dir   = bird_init[level_ind][x][1];

    if(bird[x].dir) bird[x].x = 240;
    else bird[x].x = 0;

    bird[x].knok = 0;

    bird[x].y = level[bird[x].level].foffs_y - 24;
    bird[x].frame = 0;
    bird[x].delay = 0;
}


void initLEVEL(int level_ind){
    int x;

    for(x=0;x<numLEVEL;x++){
       level[x].levelNR = mount[level_ind][x][0];
       level[x].offs_x = 0;
       level[x].offs_y = (numLEVEL - x - 1)*48;
       level[x].foffs_x = 0;
       level[x].foffs_y = level[x].offs_y + 40;

       memcpy(&level[x].art[0][0],&mount[level_ind][x][1],64);
       memcpy(&level[x].status[0][0],&mount[level_ind][x][1],64);
    }
}

void initHARRY(int ind,int gx,int numbL)
{
    harry[ind].actLEVEL = 0;
    harry[ind].init = 20;
    harry[ind].numLIVES = numbL;
    
    harry[ind].x = gx;
    harry[ind].y = level[harry[ind].actLEVEL].foffs_y - 28;

    harry[ind].knok = 0;

    harry[ind].jump = 0;
    harry[ind].jumpind = 0;
    harry[ind].hit = 0;
    harry[ind].walk = 0;
}

void initHARRY2(int ind,int gx,int lev)
{
    harry[ind].actLEVEL = lev;
    harry[ind].init = 20;
    
    harry[ind].x = gx;
    harry[ind].y = ((numLEVEL - harry[ind].actLEVEL - 1)*48) + 12;;

    harry[ind].knok = 0;

    harry[ind].jump = 0;
    harry[ind].jumpind = 0;
    harry[ind].hit = 0;
    harry[ind].walk = 0;
}

void initWOLKEN(int level_ind)
{
  int x;
  for(x=0;x<numWOLKE;x++){
    d_wolke[x].level = wolke_init[level_ind][x][3];
    d_wolke[x].dir = wolke_init[level_ind][x][0];

    switch(d_wolke[x].dir){
        case 0: { d_wolke[x].x = wolke_init[level_ind][x][1]; break;}
        case 1: { d_wolke[x].x = wolke_init[level_ind][x][2]-35; break;}
    }

    d_wolke[x].y = level[wolke_init[level_ind][x][3]].foffs_y;

    d_wolke[x].min_x = wolke_init[level_ind][x][1];;
    d_wolke[x].max_x = wolke_init[level_ind][x][2];;
  }
}


void loadIMAGE(GsSPRITE *sprite,long TIMLOC)
{
  RECT rect;
  GsIMAGE img;

  GsGetTimInfo((u_long *)(TIMLOC+4),&img);
  rect.x = img.px; rect.y = img.py; rect.w = img.pw; rect.h = img.ph;
  LoadImage(&rect,img.pixel);

  if ((img.pmode>>3)&0x01) {
    rect.x = img.cx; rect.y = img.cy; rect.w = img.cw; rect.h = img.ch;
    LoadImage(&rect,img.clut);
  }

  switch (img.pmode) {
    case 0x08:     //4 bit with CLUT
      sprite->attribute = 0x00000000;
      sprite->w = img.pw*4;
      sprite->tpage = GetTPage(0,0,img.px,img.py);
      break;
    case 0x09:     //8 bit with CLUT
      sprite->attribute = 0x01000000;

      if(img.pw*2>=64) sprite->w = 64;
      else sprite->w = img.pw*2;
      sprite->tpage = GetTPage(1,0,img.px,img.py);
      break;
    default:       //16 bit
      sprite->attribute = 0x02000000;
      sprite->w = img.pw;
      sprite->tpage = GetTPage(2,0,img.px,img.py);
      break;
  }

  sprite->x = 0; sprite->y = 0;
  sprite->h = img.ph;
  sprite->u = 0; sprite->v = 0;
  sprite->cx = img.cx; sprite->cy = img.cy;
  sprite->r = 128; sprite->g = 128; sprite->b = 128;
  sprite->mx = sprite->w/2; sprite->my = sprite->h/2;
  sprite->scalex = 4096; sprite->scaley = 4096;
  sprite->rotate = 0;
}

void setupSPRITE()
{
    loadIMAGE(&harry_sp,aniADD);
    harry_sp.w = 21;
    harry_sp.h = 28;
    harry_sp.x = harry[0].x;
    harry_sp.y = harry[0].y;
    harry_sp.mx = harry_sp.w >> 1;

    loadIMAGE(&block_sp,blkADD);
    block_sp.w = 8;
    block_sp.h = 8;

    loadIMAGE(&block2_sp,blk2ADD);
    block2_sp.v = 32;
    block2_sp.w = 8;
    block2_sp.h = 48;

    loadIMAGE(&ice,iceLOC);
    ice.u = 32;
    ice.v = 0;
    ice.w = 8;
    ice.h = 10;

    loadIMAGE(&nme,nmeLOC);
    nme.w = 16;
    nme.h = 16;

    loadIMAGE(&lives,livLOC);
    lives.u = 32;
    lives.v = 10;
    lives.w = 8;
    lives.h = 8;

    loadIMAGE(tile,tile0LOC);
    tile->h = 40;
    tile->w = 256;

    loadIMAGE(&star_pic,starLOC);
    star_pic.h = 16;
    star_pic.w = 16;

    loadIMAGE(&wolke,wolkeLOC);
    wolke.h = 8;
    wolke.w = 35;

    loadIMAGE(&bird_pic,birdLOC);
    bird_pic.h = 16;
    bird_pic.w = 16;

    loadIMAGE(&pause_pic,pauseLOC);
    pause_pic.h = 21;
    pause_pic.w = 20;

    loadIMAGE(&finger,fingLOC);
    loadIMAGE(&menu_pkt,pauseLOC);
    menu_pkt.u = 0;
    menu_pkt.v = 21;
    menu_pkt.w = 100;
    menu_pkt.h = 20;

    loadIMAGE(&FONT_SPRITE,fontLOC);
    FONT_SPRITE.w = 8;
    FONT_SPRITE.h = 8;

    loadIMAGE(&nds,ndsLOC);
    nds.x = 160;
    nds.y = 120;
    nds.mx = 128;
    nds.my = 13;
    nds.w = 255;
    nds.h = 26;
    nds.u = 0;
    nds.v = 220;

    loadIMAGE(&bb2,logoLOC);
    bb2.w = 212;
    bb2.h = 108;
    bb2.x = 60;
    bb2.y = 5;
    bb2.u = 0;
    bb2.v = 148;
}
