*=$1001
        .byte $0b,$12,$0a,$00,$9e
        .text "4109"
        .byte 0,0,0

lda #255      ; gfx mode
sta 36869
lda #8        ; scr cols
sta 36879
lda #15       ; volume
sta 36878

ldx #0                 ; clrscr
cll lda #2
    sta 38400,x
    sta 38400+256,x
    lda #32+128
    sta 7680,x
    sta 7680+256,x
    dex
    bne cll

;;;;;;;;;;;;;;;;;;;; drawmask

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        lda #15
        sta 36878

        sei
;       lda #$7f        ; dis&akn nmi&irq
;       sta $913d
;       sta $913e

        lda #<irq       ; set irq
        sta $314
        lda #>irq
        sta $315

        lda #0          ; reset lowtimer
        sta 162

        lda #$c0
        sta $912e       ; enable tym
        cli

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


        jsr mask
        jsr waitr
        jsr waitr

        lda #63         ; vaakasuunnassa
        sta sgrko+1
        jsr waitr

        lda #4          ; toinen liikkeelle
        sta pladd+1
        jsr waitr
        jsr waitr

        lda #0
        sta ukkoko+1
        jsr waitr
        jsr waitr
        jsr waitr

        lda #1
        sta ukkoko+1
        ldx #<(7680+23)
        lda #>(7680+23)
        ldy #5
        jsr dm
        ldx #<(7680+220+10+23)
        lda #>(7680+220+10+23)
        ldy #6
        jsr dm
        jsr waitr

        ; sitten joku varjo-ukko hyppimaan

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        sei
        lda #<60095
        sta $314
        lda #>60095
        sta $315
        cli

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; load next part

ldn  lda #240
     sta 36869
     sta 36878

      ldx #0
      stx 36877       ; the tunnel part doesn't use this channel
ldl0  lda loader,x
      jsr 65490
      inx
      cpx #15-3
      bne ldl0
ldl1  lda loader,x
      sta 631-15+3,x
      inx
      cpx #19-3
      bne ldl1
      lda #4
      sta 198
rts

loader  .byte 147,17,17
        .byte 76,79+32,34
        .text "2*"
        .byte 34
        .text ",8"
        .byte 19

        .byte 13,82,85+32,13

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pluup   ldx #0
pfak    ldy #0

pl0     lda tab0,y
        eor tab1,x
        sta 7168,x

        lda tab0+256,y
        eor tab1+256,x
        sta 7168+256,x

        inx
        iny
        bne pl0

        txa
        beq waitr

pl1     lda tab0+256,y
        eor tab1,x
        sta 7168,x

        lda tab0,y
        eor tab1+256,x
        sta 7168+256,x

        iny
        inx
        bne pl1

waitr   lda #$ff
        bne pluup

        lda #$ff
        sta waitr+1
        rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;         ;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;   IRQ   ;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;         ;;;;;;

irq     lda $9124

;irqctr  ldx #0
;        dex
;        stx irqctr+1
;        bne sgrko

;        stx waitr+1

;;;;;;;;;;;;;;;;; sgrollaa kuviota

sgrko   ldx #0
        beq plou

irqsg   clc
        rol tab1+(56*8),x
        rol tab1+(48*8),x
        rol tab1+(40*8),x
        rol tab1+(32*8),x
        rol tab1+(24*8),x
        rol tab1+(16*8),x
        rol tab1+( 8*8),x
        rol tab1+( 0*8),x
        lda tab1+(56*8),x
        adc #0
        sta tab1+(56*8),x

        dex
        bpl irqsg

plou    lda #0
        bpl plu2
        eor #$ff
plu2    and #127
        lsr
        sta pfak+1

        clc
        lda plou+1
pladd   adc #0
        sta plou+1

;;;;;;;;;;;;;;;;;;;;;;;;;; ukkohyppely

ukkoko  ldx #1
        bne ukkoei

        lda #7
        bit 162
        bne ukkoei

        lda #<38446
        sta ukkito+1
        lda #>38446
        sta ukkito+2

ukl     ldy #15
ukki    lda ukko0,x
ukkito  sta 38446,y
        inx
        dey
        bpl ukki

        lda ukkito+1
        clc
        adc #22
        sta ukkito+1
        lda ukkito+2
        adc #0
        sta ukkito+2

        cpx #0
        bne ukl

                lda ukki+2
                eor #$1
                sta ukki+2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;; playvveri

ukkoei  lda #3
        bit 162
        bne drmstat

;         lda #0           ; 16 = outofdrum, backtonormal
;         sta drmstat+1
notecnt   lda #0
          and #63
          sta 36877
          tax
          and #31
          sta waitr+1
          lda notes,x
          sta 36876
          bpl nc22
          sta 36874
          sta 36875
nc22      lda #8
          sta 36879
          txa
          bit imm3
          bne noteg
              ldy #18
              and #7
              bne nc00
                ldy #9         ; da vakiorumpu
nc00          sty drmstat+1
              lda #25
              sta 36879
noteg     inc notecnt+1
;         jmp drmstat

drmstat ldx #0
        lda drum8,x
        cmp #16
        bne drm9

        lda #0
        sta drmstat+1

drm9    bmi drmout      ; vol 128bit: "on myos muuta dataa"
        tay
        lda drum7-9,x
        sta 36877
        lda drum5-9,x
        sta 36874
        tya
drmout  and #127
        sta 36878
        inc drmstat+1

        jmp 60095

notes .byte 195,195,195,195,204,0,209,0,215,217,215,217,195,0,0,0
      .byte 187,187,187,187,201,0,203,0,209,215,209,215,195,203,201,203
      .byte 195,195,195,195,203,0,209,0,215,217,215,217,195,225,221,225
      .byte 221,0,0,0,209,0,201,0,187,0,0,0,201,0,209,0

drum7   .byte 200,180,170,160,150,140,145,135, 129
        .byte 240,200,240,200,230,  147,240,  135, 1
imm3    .byte 3
drum5   .byte 170,160,150,140,130,1,  1,  1,  1
        .byte 220,220,200,130,140,130,140,  1, 140

drum8   .byte 15,13,11,9,7,6,5,4,16 ; vakiojoo

        .byte 128+15,128+14,128+15,128+13,128+11,128+9,128+12,128+9,16
        .byte 128+15,128+13,128+11,128+9, 128+7, 128+14,128+5, 128+5,16

;;;;;;;;;;;;;;;;;;;;;;;;;; drawmask

mask    lda #<7680
        sta 251
        lda #>7680
        sta 252

        ldx #23
ml1     ldy #0          ; draw a row
        pha
ml0     sta (251),y
        clc
        adc #8
        and #63
        iny
        cpy #22
        bne ml0

        clc             ; addr+=22
        lda 251
        adc #22
        sta 251
        lda 252
        adc #0
        sta 252

        pla             ; startchar+=1
        clc
        adc #1

        dex
        bne ml1
        rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; dRAWMASK

dm      sty dmp0+1
        stx 251
        stx 253

dm9     sta 252
        clc
        adc #120
        sta 254

        ldy #9
        lda #78+128
        sta (251),y
        dey

        lda #100+128
dml9    sta (251),y
        dey
        bne dml9

        lda #77+128
        sta (251),y

        tya
        ldy #22
        clc

dml1    pha

        ;;;;;;

        tax
        lda #103+128
        sta (251),y
        iny
        txa

dml0    sta (251),y
        tax
dmp0    lda #16+4
        sta (253),y
        txa

        iny
        adc #8
        cmp #64
        clc
        bmi dml0

        tax
        lda #101+128
        sta (251),y
        txa

        ;;;;;;

        tya
        adc #22-9
        tay

        pla
        adc #1
        cmp #8
        clc
        bmi dml1

        ;;;;;;

        lda #78+128
        sta (251),y
        iny

        lda #99+128
dml8    sta (251),y
        iny
        cpy #207
        bne dml8

        lda #77+128
        sta (251),y
        rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

*=7168-(512*3)

ukko0 .byte 7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7
.byte 7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7
.byte 7,7,7,7,7,7,0,0,0,0,7,7,7,7,7,7
.byte 7,7,7,7,7,0,6,0,0,6,0,7,7,7,7,7
.byte 7,7,7,7,7,0,0,0,0,0,0,7,7,7,7,7
.byte 7,7,7,7,7,7,0,0,0,0,7,7,7,7,7,7
.byte 7,7,7,7,7,7,7,0,0,7,7,7,7,7,7,7
.byte 7,7,0,0,0,0,0,0,0,0,0,0,0,0,7,7
.byte 7,7,7,7,7,7,7,0,0,7,7,7,7,7,7,7
.byte 7,7,7,7,7,7,7,0,0,7,7,7,7,7,7,7
.byte 7,7,7,7,7,7,7,0,0,7,7,7,7,7,7,7
.byte 7,7,7,7,7,7,0,0,0,0,7,7,7,7,7,7
.byte 7,7,7,7,7,7,0,0,0,0,7,7,7,7,7,7
.byte 7,7,7,7,7,0,0,7,7,0,0,7,7,7,7,7
.byte 7,7,7,7,7,0,0,7,7,0,0,7,7,7,7,7
.byte 7,7,7,7,7,0,0,7,7,0,0,7,7,7,7,7

ukko1 .byte 7,7,7,7,7,7,0,0,0,0,7,7,7,7,7,7
.byte 7,0,0,7,7,0,6,0,0,6,0,7,7,0,0,7
.byte 7,7,0,0,7,0,0,0,0,0,0,7,0,0,7,7
.byte 7,7,7,0,0,7,0,0,0,0,7,0,0,7,7,7
.byte 7,7,7,7,0,0,7,0,0,7,0,0,7,7,7,7
.byte 7,7,7,7,7,0,0,0,0,0,0,7,7,7,7,7
.byte 7,7,7,7,7,7,0,0,0,0,7,7,7,7,7,7
.byte 7,7,7,7,7,7,7,0,0,7,7,7,7,7,7,7
.byte 7,7,7,7,7,7,7,0,0,7,7,7,7,7,7,7
.byte 7,7,7,7,7,7,0,0,0,0,7,7,7,7,7,7
.byte 7,7,7,7,7,0,0,7,7,0,0,7,7,7,7,7
.byte 7,7,7,7,0,0,7,7,7,7,0,0,7,7,7,7
.byte 7,7,7,0,0,7,7,7,7,7,7,0,0,7,7,7
.byte 7,7,0,0,7,7,7,7,7,7,7,7,0,0,7,7
.byte 7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7
.byte 7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7

*=7168-(512*2)

tab0 .byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1
.byte 1, 3, 3, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 3, 3, 3
.byte 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
.byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 7, 15, 31, 62, 124, 124
.byte 248, 240, 240, 224, 225, 195, 195, 131, 135, 135, 135, 135, 135
.byte 135, 135, 135, 135, 135, 135, 135, 131, 195, 195, 225, 224, 240
.byte 240, 248, 124, 124, 62, 31, 15, 7, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0
.byte 0, 0, 0, 0, 0, 0, 0, 0, 3, 15, 63, 255, 254, 248, 224, 192, 1, 3
.byte 15, 31, 63, 126, 252, 248, 240, 224, 193, 193, 195, 135, 135, 135
.byte 135, 135, 135, 135, 135, 135, 135, 195, 193, 193, 224, 240, 248
.byte 252, 126, 63, 31, 15, 3, 1, 192, 224, 248, 254, 255, 63, 15, 3
.byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255, 255, 255, 128, 0, 0
.byte 0, 63, 255, 255, 255, 224, 0, 0, 0, 31, 63, 255, 255, 240, 224
.byte 192, 128, 131, 135, 135, 135, 135, 131, 128, 192, 224, 240, 255
.byte 255, 63, 31, 0, 0, 0, 224, 255, 255, 255, 63, 0, 0, 0, 128, 255
.byte 255, 255, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 255, 255, 255
.byte 1, 0, 0, 0, 252, 255, 255, 255, 7, 0, 0, 0, 248, 252, 255, 255
.byte 15, 7, 3, 1, 193, 225, 225, 225, 225, 193, 1, 3, 7, 15, 255
.byte 255, 252, 248, 0, 0, 0, 7, 255, 255, 255, 252, 0, 0, 0, 1, 255, 255
.byte 255, 254, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 240, 252, 255, 127
.byte 31, 7, 3, 128, 192, 240, 248, 252, 126, 63, 31, 15, 7, 131, 131
.byte 195, 225, 225, 225, 225, 225, 225, 225, 225, 225, 225, 195, 131
.byte 131, 7, 15, 31, 63, 126, 252, 248, 240, 192, 128, 3, 7, 31, 127
.byte 255, 252, 240, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
.byte 0, 128, 192, 224, 240, 248, 124, 62, 62, 31, 15, 15, 7, 135, 195
.byte 195, 193, 225, 225, 225, 225, 225, 225, 225, 225, 225, 225, 225
.byte 225, 193, 195, 195, 135, 7, 15, 15, 31, 62, 62, 124, 248, 240
.byte 224, 192, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
.byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 192, 192
.byte 192, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224
.byte 224, 224, 192, 192, 192, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
.byte 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

*=7168-(512*1)

tab1 .byte 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
.byte 255, 255, 255, 254, 252, 252, 248, 248, 241, 241, 243, 227
.byte 227, 231, 231, 199, 199, 199, 199, 199, 199, 199, 199, 199
.byte 199, 231, 231, 227, 227, 243, 241, 241, 248, 248, 252, 252
.byte 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
.byte 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254
.byte 248, 240, 225, 195, 135, 15, 31, 62, 124, 124, 248, 240, 240
.byte 224, 225, 195, 195, 131, 135, 135, 135, 135, 135, 135, 135
.byte 135, 135, 135, 135, 135, 131, 195, 195, 225, 224, 240, 240
.byte 248, 124, 124, 62, 31, 15, 135, 195, 225, 240, 248, 254
.byte 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 240
.byte 192, 3, 15, 63, 255, 254, 248, 224, 192, 1, 3, 15, 31, 63
.byte 126, 252, 248, 240, 224, 193, 193, 195, 135, 135, 135, 135
.byte 135, 135, 135, 135, 135, 135, 195, 193, 193, 224, 240, 248
.byte 252, 12 6, 63, 31, 15, 3, 1, 192, 224, 248, 254, 255, 63
.byte 15, 3, 192, 240, 254, 255, 255, 255, 255, 255, 224, 0, 0
.byte 127, 255, 255, 255, 128, 0, 0, 0, 63, 255, 255, 255, 224, 0
.byte 0, 0, 31, 63, 255, 255, 240, 224, 192, 128, 131, 135, 135
.byte 135, 135, 131, 128, 192, 224, 240, 255, 255, 63, 31, 0, 0
.byte 0, 224, 255, 255, 255, 63, 0, 0, 0, 128, 255, 255, 255
.byte 127, 0, 0, 224, 255, 255, 255, 255, 7, 0, 0, 254, 255, 255
.byte 255, 1, 0, 0, 0, 2 52, 255, 255, 255, 7, 0, 0, 0, 248
.byte 252, 255, 255, 15, 7, 3, 1, 193, 225, 225, 225, 225, 193, 1
.byte 3, 7, 15, 255, 255, 252, 248, 0, 0, 0, 7, 255, 255, 255
.byte 252, 0, 0, 0, 1, 255, 255, 255, 254, 0, 0, 7, 255, 255
.byte 255, 255, 255, 127, 15, 3, 192, 240, 252, 255, 127, 31, 7
.byte 3, 128, 192, 240, 248, 252, 126, 63, 31, 15, 7, 131, 131
.byte 195, 225, 225, 225, 225, 225, 225, 225, 225, 225, 225, 195
.byte 131, 131, 7, 15, 31, 63, 126, 252, 248, 240, 192, 128, 3, 7
.byte 31, 127, 255, 252, 240, 192, 3, 15, 127, 255, 255, 255
.byte 255, 255, 255, 255, 255, 255, 255, 127, 31, 15, 135, 195
.byte 225, 240, 248, 124, 62, 62, 31, 15, 15, 7, 135, 195, 195
.byte 193, 225, 225, 225, 225, 225, 225, 225, 225, 225, 225, 225
.byte 225, 193, 195, 195, 135, 7, 15, 15, 31, 62, 62, 124, 248
.byte 240, 225, 195, 135, 15, 31, 127, 255, 255, 255, 255, 255
.byte 255, 255, 25 5, 255, 255, 255, 255, 255, 255, 255, 255, 255
.byte 255, 255, 255, 255, 255, 127, 63, 63, 31, 31, 143, 143, 207
.byte 199, 199, 231, 231, 227, 227, 227, 227, 227, 227, 227, 227
.byte 227, 227, 231, 231, 199, 199, 207, 143, 143, 31, 31, 63
.byte 63, 127, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
.byte 255, 255, 255, 255, 255

