{$X+}
unit m3d6;
{Multi object,ROck texture for bump,additions..}

interface

USES crt,gfx3,peuv,polygons;



procedure setup(s:string);
Procedure LNM(s:string); {Load new mesh}
procedure shut;
procedure rotatepoints2(x,y,z:integer);
procedure showpolys(add,w:word);
procedure killpolys(w:word);
procedure phongpal(gtk:string;w:word);
procedure setupmap(w:word); {For bump }
procedure shutmap;
procedure showbump(w1,w2:word);
procedure asmsh(out,w1,w2:word); {assembly bumping}
procedure showtext(w1,w2:word);
procedure settmap(s:string;w:word);
procedure shadethetext(w1,w2:word);
procedure setuppal;
procedure phongit(w1,w2:word);
procedure setuprefpal;
procedure showFpolys(w:word);

var    lx,ly,lz,olx,oly,olz:integer;
    light,ambient:integer;
    Xoff,Yoff,Zoff:Integer;               { Used for movement of the object }
    con:byte;
    cx,cy,cz:integer;

    d:real;
    ad1,ad2,ad3:byte;     {These will be added to color values}
    {default=0}

implementation


{      divfac=64/light ;}

type     { point=record
               x,y,z:real;                { The data on every point we rotate
             END;}
          fpoint=record
              x,y,z:integer;
           end;
     Virtual = Array [1..64000] of byte;  { The size of our Virtual Screen }
     VirtPtr = ^Virtual;                  { Pointer to the virtual screen }
     tdobj=array[1..maxpoints] of fpoint;
     tdobj2=array[1..maxpoints] of LONGINT;
     looker=Array [0..360,1..2] of integer;

VAR Lines : ^tdobj  { The base object rotated } ;
    Translated : ^tdobj; { The rotated object }
    pict:pointer;
    lookup : ^looker; { Our sin and cos lookup table }
    Virscr : VirtPtr;                     { Our first Virtual screen }
    l1,n:integer;
    fr:longint;
    polyz:array[0..maxfaces] of integer;
    pind:array[1..3,0..maxfaces] of byte;
    show:boolean;
    au,av:array[1..maxfaces] of byte; {mapping coords}
    


    co:array[1..3] of byte;
    Nx,ny,nz,tnx,tny,tnz:^tdobj2;



Procedure SetUpVirtual;
   { This sets up the memory needed for the virtual screen }
BEGIN
  getmem(translated,sizeof(translated^));
  getmem (lookup,sizeof(lookup^));
  getmem(lines,sizeof(lines^));
  new(nx);
  new(ny);
  new(nz);
  new(tnx);
  new(tny);
  new(tnz);
END;

Procedure Shut;
   { This frees the memory used by the virtual screen }
BEGIN
  kaput;
  freemem (lookup,sizeof(lookup^));
  freemem(lines,sizeof(lines^));
  dispose(nx);
  dispose(ny);
  dispose(nz);
  dispose(tnx);
  dispose(tny);
  dispose(tnz);
{  dispose(faces^);
  dispose(points^);}
END;

procedure setuppal;
var l1,l2:integer;
begin
  l2:=0;
  for l1:=1 to 127 do pal(l1+128,63,63,63);
  for l1:=1 to 63 do pal(l1+128,l1 div 2,0,l1);
  for l1:=1 to 16 do pal(l1+191,l1*2+32,l1*4,63);

 ambient :=10;
end;

procedure setuprefpal;
var l1,l2:integer;
     r,g,b:byte;
begin
  l2:=0;
  for l1:=1 to 127 do pal(l1+128,63,63,63);
  for l1:=1 to 128 do begin
     getpal(l1,r,g,b);
     if r<54 then inc(r,7);
     pal(l1+128,r,g,b);
 end;
 for l1:=1 to 16 do pal(l1+191,63,l1*4,l1*4);
 ambient :=-10;
 con:=64;
end;



procedure phongpal(gtk:string;w:word);
type c=record
        r,g,b:byte;
     end;
var pa:array[1..128] of c;
     l1,l2:integer;
     co:byte;
begin
  for l1:=1 to 255 do begin
    pa[l1].r:=0;
    pa[l1].g:=0;
    pa[l1].b:=0;
  end;
{     lpcx(gtk,w); AN einai dynaton. ginetai mono tou ' '!}
lpcx('pmap3.pcx',w);


{  flip(w,sega000);}
  for l1:=1 to con do begin
    co:=getpixel(l1,97,w);
    putpixel(l1,97,0,w);
    getpal(co,pa[l1].r,pa[l1].g,pa[l1].b);
  end;
{  for l1:=158 to 160 do begin
    pa[l1].r:=50;
    pa[l1].g:=50;
    pa[l1].b:=50;
  end;}
  for l1:=1 to 128 do
    pal(l1+128,pa[l1].r,pa[l1].g,pa[l1].b);
  ambient:=10;
end;


Procedure SetUpPoints;{general setup}
  { This sets the basic offsets of the object, creates the lookup table and
    moves the object from a constant to a variable }
VAR loop1,l1,l2:integer;
    hcos:array[1..90] of integer;
BEGIN
  olx:=0;
  oly:=0;
  olz:=1000;
  For loop1:=0 to 360 do BEGIN
    lookup^ [loop1,1]:= round(sin(rad (loop1))*256);
    lookup^ [loop1,2]:= round(cos(rad (loop1))*256);
  END;
  For loop1:=1 to npoints do BEGIN
    Lines^ [loop1].x:=points^[loop1,1];
    Lines^ [loop1].y:=points^[loop1,2];
    Lines^ [loop1].z:=points^[loop1,3];
  END;
  {fill with fixed cos/..}

END;

{}

{}
Procedure Rotate1(X,Y,Z:Integer);
{rotates olx,oly,olz and places the result to lx,ly,lz}
VAR loop1:integer;
    temp:fpoint;
BEGIN

    temp.x:=olx;
    temp.y:=(lookup^[x,1]*ly - lookup^[x,2]*lz);
    temp.z:=(lookup^[x,2]*ly + lookup^[x,1]*lz);
    lx:=temp.x;
    ly:=temp.y;
    lz:=temp.z;

    If y>0 then BEGIN
      temp.x:=(lookup^[y,2]*lx - lookup^[y,1]*ly);
      temp.y:=(lookup^[y,1]*lx + lookup^[y,2]*ly);
      temp.z:=olz;
      lx:=temp.x;
      ly:=temp.y;
      lz:=temp.z;
    END;

    If z>0 then BEGIN
      temp.x:=(lookup^[z,2]*lx + lookup^[z,1]*lz);
      temp.y:=oly;
      temp.z:=(-lookup^[z,1]*lx + lookup^[z,2]*lz);
      lx:=temp.x;
      ly:=temp.y;
      lz:=temp.z;
    END;
END;




{Procedure RotatePoints (X,Y,Z:Integer);
VAR loop1:integer;
    temp:fpoint;
    lok1,lok2:longint;
BEGIN
  For loop1:=1 to npoints do BEGIN
    temp.x:=(lines^[loop1].x*256) div 256;
    lok1:=((lookup^[x,1]));
    lok2:=((lookup^[x,2]));
    temp.y:=lok1*(lines^[loop1].y) - lok2*(lines^[loop1].z);
    temp.z:=lok2*lines^[loop1].y + lok1*lines^[loop1].z;
    temp.y:=temp.y div 256;
    temp.z:=temp.z div 256;
    translated^[loop1]:=temp;
    If y>0 then BEGIN
      lok1:=(lookup^[y,1]);
      lok2:=(lookup^[y,2]);
      temp.x:=lok2*translated^[loop1].x - lok1*translated^[loop1].y;
      temp.y:=lok1*translated^[loop1].x + lok2*translated^[loop1].y;
      temp.z:=translated^[loop1].z;

      temp.x:=temp.x div 256;
      temp.y:=temp.y div 256;
      translated^[loop1]:=temp;
    END;

    If z>0 then BEGIN
      lok1:=(lookup^[z,1]);
      lok2:=(lookup^[z,2]);
      temp.x:=lok2*translated^[loop1].x + lok1*translated^[loop1].z;
      temp.y:=translated^[loop1].y;
      temp.z:=-lok1*translated^[loop1].x + lok2*translated^[loop1].z;
      temp.x:=temp.x div 256;
      temp.z:=temp.z  div 256;
      translated^[loop1]:=temp;
    END;
  END;
END;}

Procedure RotatePoints (X,Y,Z:Integer);
{Fixed Point rotation!}
  { This rotates object lines by X,Y and Z; then places the result in
    TRANSLATED }
VAR loop1:integer;
    temp:fpoint;
    tu,tv:byte;
    lok1,lok2:longint;
{    look1,look2:real;}
BEGIN
  For loop1:=1 to npoints do BEGIN
    temp.x:=round(lines^[loop1].x);
    lok1:=(lookup^[x,1]);
    lok2:=(lookup^[x,2]);
    temp.y:=lok1*(lines^[loop1].y) - lok2*(lines^[loop1].z);
    temp.z:=lok2*lines^[loop1].y + lok1*lines^[loop1].z;
    temp.y:=temp.y div 256;
    temp.z:=temp.z div 256;

    tu:=au[loop1];
    tv:=av[loop1];

    translated^[loop1]:=temp;
    If y>0 then BEGIN
      lok1:=(lookup^[y,1]);
      lok2:=(lookup^[y,2]);
      temp.x:=lok2*translated^[loop1].x - lok1*translated^[loop1].y;
      temp.y:=lok1*translated^[loop1].x + lok2*translated^[loop1].y;
      temp.z:=translated^[loop1].z;

      temp.x:=temp.x div 256;
      temp.y:=temp.y div 256;
      translated^[loop1]:=temp;
    END;

    If z>0 then BEGIN
      lok1:=(lookup^[z,1]);
      lok2:=(lookup^[z,2]);
      temp.x:=lok2*translated^[loop1].x + lok1*translated^[loop1].z;
      temp.y:=translated^[loop1].y;
      temp.z:=-lok1*translated^[loop1].x + lok2*translated^[loop1].z;
      temp.x:=temp.x div 256;
      temp.z:=temp.z  div 256;
      translated^[loop1]:=temp;
    END;
  END;
END;



Procedure Rotatenormals (X,Y,Z:Integer);
  { This rotates normals(nx,ny,nz) and places the result in tnx,tny,tnz }
VAR loop1:integer;
{    temp:fpoint;}
    sin,cos:integer;
    tx,ty,tz:longint;
BEGIN
  For loop1:=1 to npoints do BEGIN
    sin:=((lookup^[x,1]));
    cos:=((lookup^[x,2]));
    tx:=nx^[loop1];
    ty:=(sin*ny^[loop1] - cos*nz^[loop1]);
    tz:=(cos*ny^[loop1] + sin*nz^[loop1]);
    tnx^[loop1]:=tx;
{    tny^[loop1]:=ty div 256;}
    if ty<0 then ty:=-(-(ty) shr 8) else ty:=ty shr 8;
    tny^[loop1]:=ty;
    if tz<0 then tz:=-(-(tz) shr 8) else tz:=tz shr 8;
{    tnz^[loop1]:=tz div 256;}
    tnz^[loop1]:=tz;


    If y>0 then BEGIN
      sin:=((lookup^[y,1]));
      cos:=((lookup^[y,2]));
      tx:=(cos*tnx^[loop1] - sin*tny^[loop1]);
      ty:=(sin*tnx^[loop1] + cos*tny^[loop1]);
      tz:=tnz^[loop1];
  {   tnx^[loop1]:=tx div 3256;}
    if tx<0 then tx:=-(-(tx) shr 8) else tx:=tx shr 8;
    tnx^[loop1]:=tx;
{        tny^[loop1]:=ty div 256;}
    if ty<0 then ty:=-(-(ty) shr 8) else ty:=ty shr 8;
    tny^[loop1]:=ty;
     tnz^[loop1]:=tz;
    END;

    If z>0 then BEGIN
      sin:=((lookup^[z,1]));
      cos:=((lookup^[z,2]));
      tx:=(cos*tnx^[loop1] + sin*tnz^[loop1]);
      ty:=tny^[loop1];
      tz:=(-sin*tnx^[loop1] + cos*tnz^[loop1]);
  {   tnx^[loop1]:=tx div 256;}
     if tx<0 then tx:=-(-(tx) shr 8) else tx:=tx shr 8;
    tnx^[loop1]:=tx;
    tny^[loop1]:=ty;
    {tnz^[loop1]:=tz div 256;}
         if tz<0 then tz:=-(-(tz) shr 8) else tz:=tz shr 8;
    tnz^[loop1]:=tz;
    END;
  END;
END;

Procedure RotatePoints2 (X,Y,Z:Integer);
{Fixed Point rotation!}
  { This rotates object lines by X,Y and Z; then places the result in
    TRANSLATED }
VAR loop1:integer;
{    temp:fpoint;}
    tx,ty,tz:integer;
    lok1,lok2:integer;
    dx,dy,dz:integer;
{    look1,look2:real;}
BEGIN
  dx:=(x+90+cx) mod 360;
  dy:=(y+cy) mod 360;
  dz:=(z+cz) mod 360;
  rotatenormals(dx,dy,dz);

    For loop1:=1 to npoints do BEGIN
    tx:=(lines^[loop1].x*256) div 256;
    lok1:=((lookup^[x,1]));
    lok2:=((lookup^[x,2]));
    ty:=lok1*(lines^[loop1].y) - lok2*(lines^[loop1].z);
    tz:=lok2*lines^[loop1].y + lok1*lines^[loop1].z;
    {o xristos kai h panagia... idiothtes apolutvn!}
{    if ty<0 then ty:=-(-(ty) shr 8) else ty:=ty shr 8;
        if tz<0 then tz:=-(-(tz) shr 8) else tz:=tz shr 8;}
    asm
    sar ty,8
    sar tz,8
    end;

    translated^[loop1].x:=tx;
    translated^[loop1].y:=ty;
    translated^[loop1].z:=tz;

    If y>0 then BEGIN
      lok1:=(lookup^[y,1]);
      lok2:=(lookup^[y,2]);
      tx:=lok2*translated^[loop1].x - lok1*translated^[loop1].y;
      ty:=lok1*translated^[loop1].x + lok2*translated^[loop1].y;
      tz:=translated^[loop1].z;

{      if tx<0 then tx:=-(-(tx) shr 8) else tx:=tx shr 8;
      if ty<0 then ty:=-(-(ty) shr 8) else ty:=ty shr 8;}
    asm
    sar tx,8
    sar ty,8
    end;

    translated^[loop1].x:=tx;
    translated^[loop1].y:=ty;
    translated^[loop1].z:=tz;
    END;

    If z>0 then BEGIN
      lok1:=(lookup^[z,1]);
      lok2:=(lookup^[z,2]);
      tx:=lok2*translated^[loop1].x + lok1*translated^[loop1].z;
      ty:=translated^[loop1].y;
      tz:=-lok1*translated^[loop1].x + lok2*translated^[loop1].z;
{      if tx<0 then tx:=-(-(tx) shr 8) else tx:=tx shr 8;
      if tz<0 then tz:=-(-(tz) shr 8) else tz:=tz shr 8;}
    asm
      sar tx,8
      sar tz,8
    end;
      translated^[loop1].x:=tx;
      translated^[loop1].y:=ty;
      translated^[loop1].z:=tz;
    END;
  END;
END;


{}


procedure swap(i,j:integer);
var polytmp:array[1..3] of integer;
    nt:fpoint;
begin
  polytmp[1]:=faces^[i,1];
  polytmp[2]:=faces^[i,2];
  polytmp[3]:=faces^[i,3];
{  nt:=fnormals[i];}
  faces^[i,1]:=faces^[j,1];
  faces^[i,2]:=faces^[j,2];
  faces^[i,3]:=faces^[j,3];
{  fnormals[i]:=fnormals[j];}

  faces^[j,1]:=polytmp[1];
  faces^[j,2]:=polytmp[2];
  faces^[j,3]:=polytmp[3];
{  fnormals[j]:=nt;}
end;


procedure quicksort(lo,hi:integer);

procedure sort(l,r:integer);
var i,j,x,y:integer;
begin
  i:=l; j:=r; x:=polyz[(l+r) shr 1];
  repeat
    while polyz[i]<x do inc(i);
     while x<polyz[j] do dec(j);
    if i<=j then begin
      swap(j,i);
{      y:=pind[i];
      pind[i]:=pind[j];
      pind[j]:=y;}
      inc(i); dec(j);
    end;
  until i>j;
  if l<j then sort(l,j);
  if i<r then sort(i,r);
end;

begin
  sort(lo,hi);
end;

procedure shellsort(n:integer);
var gap,i,j,k,x:integer;
begin
  gap:=n div 2;
  while (gap>0) do
  begin
    for i:= gap+1 to n do begin
      j:=i-gap;
      while j>0  do begin
        k:=j+gap;
        if polyz[j]<=polyz[k] then
         j:=0
        else
         begin
           swap(j,k);
           j:=j-gap;
         end;
       end;
      end;
     gap:=gap div 2;
     end;
end;


procedure GetNormal(x1,y1,z1,x2,y2,z2:integer; var x,y,z:integer);
begin
        x := y1*z2-y2*z1;
        y := x2*z1-x1*z2;
        z := x1*y2-x2*y1;
end;


procedure precalc; {precalculate normals}
var l1,l2:integer;
   x,y,z:array [1..3]of longint;
       summax,summay,summaz,nf:longint;
           Fnormals:array[1..maxfaces]of fpoint;
begin
  for l1:=1 to nfaces do begin
      {Proetoimasia metablhton}
  x[1]:=(translated^[faces^[l1,1]].x);
  y[1]:=(translated^[faces^[l1,1]].y);
  z[1]:=(translated^[faces^[l1,1]].z);

  x[2]:=(translated^[faces^[l1,2]].x);
  y[2]:=(translated^[faces^[l1,2]].y);
  z[2]:=(translated^[faces^[l1,2]].z);

  x[3]:=(translated^[faces^[l1,3]].x);
  y[3]:=(translated^[faces^[l1,3]].y);
  z[3]:=(translated^[faces^[l1,3]].z);
  getnormal(x[2]-x[1],y[2]-y[1],z[2]-z[1],x[3]-x[2],y[3]-y[2],z[3]-z[2]
  ,fnormals[l1].x,fnormals[l1].y,fnormals[l1].z);
  end;
  for l1:=1 to npoints do begin
     summax:=0;
     summay:=0;
     summaz:=0;
     nf:=0;
     for l2:=1 to nfaces do begin {elenxe ola ta faces^^                      }
       if (faces^[l2,1]=l1) or(faces^[l2,2]=l1) or (faces^[l2,3]=l1) then begin
         summax:=summax+fnormals[l2].x;
         summay:=summay+fnormals[l2].y;
         summaz:=summaz+fnormals[l2].z;
         inc (nf);
       end;
     end;
     if nf>0 then begin {mesos oros olvn tvn apo pano..}
        nx^[l1]:=summax  div nf;
        ny^[l1]:=summay  div nf;
        nz^[l1]:=summaz  div nf;
    end;
  end;
end;





procedure Diffuse(i:integer);  {This one does all the shading..Using ANGLES!}
var d:single;
    c,l1,tmp:integer;
    cnx,cny,cnz:longint;
    x,y,z:array [1..3]of longint;
    va,costh,dn,dl,yp:longint; {va is the angle}

begin
  {Proetoimasia metablhton}
  x[1]:=(translated^[faces^[i,1]].x);
  y[1]:=(translated^[faces^[i,1]].y);
  z[1]:=(translated^[faces^[i,1]].z);

  x[2]:=(translated^[faces^[i,2]].x);
  y[2]:=(translated^[faces^[i,2]].y);
  z[2]:=(translated^[faces^[i,2]].z);

  x[3]:=(translated^[faces^[i,3]].x);
  y[3]:=(translated^[faces^[i,3]].y);
  z[3]:=(translated^[faces^[i,3]].z);
  {with this method find if the vector has it's back turned to us}
   if(x[1]-x[2])*(y[3]-y[2])-(x[3]-x[2])*(y[1]-y[2])>0 then show:=false;
if show then begin {avoid uselless calculations}
{Calcs for color 1}
  cnx:=tnx^[faces^[i,1]];
  cny:=tny^[faces^[i,1]];
  cnz:=tnz^[faces^[i,1]];
{    fixedpoint}
        va:=(lx-x[1])*cnx+(ly-x[1])*cny +(lz-x[1])*cnz;
     yp:=(cnx*cnx+cny*cny+cnz*cnz);
     if yp>0 then  dn:=round(sqrt(yp)*256);
     yp:=(sqr(lx-x[1])+sqr(ly-y[1])+sqr(lz+z[1]));
     if yp>0 then  dl:=round(sqrt(yp)*256);
     if (dn<>0) and (dl<>0) then begin
       costh:=round(va/((dn/256)*(dl/256))*256);
       tmp:=round((costh/256)*con)+ambient;
     end;
{     else tmp:=1;}
      if tmp<1 then tmp:=1;
      if tmp>con then tmp:=con;
      co[1]:=tmp;


  cnx:=tnx^[faces^[i,2]];
  cny:=tny^[faces^[i,2]];
  cnz:=tnz^[faces^[i,2]];
{    fixedpoint}
        va:=(lx-x[2])*cnx+(ly-x[2])*cny +(lz-x[2])*cnz;
     yp:=(sqr(cnx)+sqr(cny)+sqr(cnz));
     if yp>0 then  dn:=round(sqrt(yp)*256);
     yp:=(sqr(lx-x[2])+sqr(ly-y[2])+sqr(lz+z[2]));
     if yp>0 then  dl:=round(sqrt(yp)*256);
     if (dn<>0) and (dl<>0) then begin
       costh:=round(va/((dn/256)*(dl/256))*256);
       tmp:=round((costh/256)*con)+ambient;
     end;
{     else tmp:=0;}
      if tmp<1 then tmp:=1;
      if tmp>con then tmp:=con;
      co[2]:=tmp;


  cnx:=tnx^[faces^[i,3]];
  cny:=tny^[faces^[i,3]];
  cnz:=tnz^[faces^[i,3]];
{    fixedpoint}
        va:=(lx-x[3])*cnx+(ly-x[3])*cny +(lz-x[3])*cnz;
     yp:=(sqr(cnx)+sqr(cny)+sqr(cnz));
     if yp>0 then  dn:=round(sqrt(yp)*256);
     yp:=(sqr(lx-x[1])+sqr(ly-y[1])+sqr(lz+z[1]));
     if yp>0 then  dl:=round(sqrt(yp)*256);
     if (dn<>0) and (dl<>0) then begin
       costh:=round(va/((dn/256)*(dl/256))*256);
       tmp:=round((costh/256)*con)+ambient;
     end ;
{     else tmp:=0;}
      if tmp<1 then tmp:=1;
      if tmp>con then tmp:=con;
      co[3]:=tmp;

{     co[2]:=co[1];
     co[3]:=co[1];}
   end;
end;
  {Now find whether to show it or not}



procedure showpolys(add,w:word);
var l1,l2:integer;
     x,y,xx,yy:array[1..3] of integer;
     temp:integer;
     n:integer;


begin
    for n:=1 to nfaces do begin
        polyz[n]:=(translated^[faces^[n,1]].z+
                  translated^[faces^[n,2]].z+
                  translated^[faces^[n,3]].z);
    end;
  shellsort(nfaces);
   for l2:=1 to nfaces do begin
   show:=true;
      for l1:=1 to 3 do begin
{        if l2>394 then begin
          readln;
        end;}
        if faces^[l2,l1]<=0 then faces^[l2,l1]:=faces^[l2-1,l1]{translated^[faces^[l2-1,l1]].z+zoff}
        else
        temp:=((translated^[faces^[l2,l1]].z+CZ)+zoff);
      if temp<0 then begin
{        x[l1] :=longdiv(round(translated^[faces^^[l2,l1]].X *256*D) ,temp)+xoff;}
          x[l1] :=round((translated^[faces^[l2,l1]].X+CX) *d )shl 8 div temp+xoff;
          y[l1] :=round((translated^[faces^[l2,l1]].Y+CY) *d )shl 8 div temp+yoff;
{        if temp>-100 then show:=false;}
        end;
      end;
        diffuse(l2);
    if show then begin
          gouraudcppoly (x[1],y[1],x[2],y[2],x[3],y[3],co[1]+add+ad1,co[2]+add+ad2,co[3]+add+ad3,w);
{          flip(vaddr,vga);
        readln;}
      end;
   end;
end;


procedure showFpolys(w:word);
{JUST WITH AD1 AD2 AD3 COLORS..}
var l1,l2:integer;
     x,y,xx,yy:array[1..3] of integer;
     temp:integer;
     n:integer;


begin
    for n:=1 to nfaces do begin
        polyz[n]:=(translated^[faces^[n,1]].z+
                  translated^[faces^[n,2]].z+
                  translated^[faces^[n,3]].z);
    end;
  shellsort(nfaces);
   for l2:=1 to nfaces do begin
   show:=true;
      for l1:=1 to 3 do begin
{        if l2>394 then begin
          readln;
        end;}
        if faces^[l2,l1]<=0 then faces^[l2,l1]:=faces^[l2-1,l1]{translated^[faces^[l2-1,l1]].z+zoff}
        else
        temp:=((translated^[faces^[l2,l1]].z+CZ)+zoff);
      if temp<0 then begin
{        x[l1] :=longdiv(round(translated^[faces^^[l2,l1]].X *256*D) ,temp)+xoff;}
          x[l1] :=round((translated^[faces^[l2,l1]].X+CX) *d )shl 8 div temp+xoff;
          y[l1] :=round((translated^[faces^[l2,l1]].Y+CY) *d )shl 8 div temp+yoff;
{        if temp>-100 then show:=false;}
        end;
      end;
    if show then begin
          gouraudcppoly (x[1],y[1],x[2],y[2],x[3],y[3],ad1,ad2,ad3,w);
{          flip(vaddr,vga);
        readln;}
      end;
   end;
end;


procedure killpolys(w:word);
begin
   cls32(w,0);
{   asmfade(virscr);}
end;



{}
Procedure setup(s:string); {s:file name of object file}
  { This is the main display procedure. Firstly it brings the object towards
    the viewer by increasing the Zoff, then passes control to the user }
VAR deg,loop1:integer;
    ch:char;
BEGIN
  con:=78;
  config;
  getmem(translated,sizeof(translated^));
  getmem (lookup,sizeof(lookup^));
  getmem(lines,sizeof(lines^));
  new(nx);
  new(ny);
  new(nz);
  new(tnx);
  new(tny);
  new(tnz);
{  config;}
  readeuv(s);
  setuppoints;
  rotatepoints(0,0,0);
  precalc;
  rotatenormals(1,1,1);
{  rotate1(1,1,1);}
lx:=0;
ly:=0;
lz:=1000;
end;


Procedure LNM(s:string); {load new mesh}
  { This is used for animations}
VAR deg,loop1:integer;
    ch:char;
BEGIN
  readeuv(s);
  setuppoints;
  rotatepoints(0,0,0);
  precalc;
  rotatenormals(1,1,1);
end;



Procedure getmapcords;
VAR loop1:integer;
const
uvrel:array[1..269,1..2] of real=
((0.3608,0.4206),
(0.3413,0.3902),
(0.3489,0.4162),
(0.3581,0.3807),
(0.2927,0.4185),
(0.9699,0.4358),
(0.3010,0.4306),
(0.9452,0.3918),
(0.9778,0.3969),
(0.9197,0.4135),
(0.9326,0.4150),
(0.9225,0.4344),
(0.9374,0.4340),
(0.9544,0.4552),
(0.9762,0.4507),
(0.3013,0.4616),
(0.0306,0.4518),
(0.2480,0.4536),
(0.3088,0.4546),
(0.3616,0.4608),
(0.3283,0.4545),
(0.3463,0.4545),
(0.3522,0.4544),
(0.3507,0.4306),
(0.1185,0.3962),
(0.1830,0.3896),
(0.0846,0.4143),
(0.0866,0.4333),
(0.1116,0.4501),
(0.1270,0.4511),
(0.1566,0.4529),
(0.1736,0.4539),
(0.1844,0.4538),
(0.2011,0.4538),
(0.2093,0.4537),
(0.2018,0.4299),
(0.1679,0.4299),
(0.1106,0.4351),
(0.1641,0.4179),
(0.1962,0.4155),
(0.1712,0.4609),
(0.0987,0.4545),
(0.0616,0.4337),
(0.0611,0.4128),
(0.1028,0.3912),
(0.2162,0.4199),
(0.2286,0.4601),
(0.2853,0.4469),
(0.3207,0.4555),
(0.2973,0.4605),
(0.2398,0.4602),
(0.2935,0.4204),
(0.2205,0.4334),
(0.2270,0.4546),
(0.2692,0.4203),
(0.2924,0.4204),
(0.2187,0.4199),
(0.2192,0.4208),
(0.2187,0.4274),
(0.2272,0.4552),
(0.2574,0.4605),
(0.2516,0.4604),
(0.2114,0.3824),
(0.2615,0.3810),
(0.2007,0.3806),
(0.2116,0.3823),
(0.2827,0.3805),
(0.1989,0.3801),
(0.2372,0.4084),
(0.2815,0.4181),
(0.2935,0.4201),
(0.2829,0.3809),
(0.2155,0.3927),
(0.2008,0.3821),
(0.2172,0.4177),
(0.1990,0.3804),
(0.2178,0.4297),
(0.2270,0.4550),
(0.8651,0.0494),
(0.8620,0.0432),
(0.8645,0.0476),
(0.8664,0.0515),
(0.8659,0.0515),
(0.7820,0.0245),
(0.8169,0.001),
(0.8518,0.0312),
(0.8775,0.0618),
(0.8776,0.0620),
(0.8771,0.0942),
(0.8765,0.0606),
(0.6692,0.3293),
(0.4115,0.3488),
(0.5761,0.1063),
(0.8436,0.2366),
(0.8675,0.1864),
(0.8733,0.0574),
(0.8749,0.1540),
(0.8588,0.0393),
(0.8687,0.0539),
(0.8666,0.0521),
(0.1664,0.1051),
(0.0717,0.0233),
(0.3119,0.3477),
(0.0285,0.2354),
(0.1361,0.3281),
(0.9689,0.1853),
(0.9452,0.1528),
(0.9345,0.0930),
(0.9312,0.0609),
(0.9316,0.0606),
(0.9340,0.0594),
(0.9418,0.0562),
(0.9526,0.0527),
(0.9572,0.0509),
(0.9576,0.0503),
(0.9615,0.0464),
(0.9666,0.0420),
(0.9603,0.0482),
(0.9587,0.0503),
(0.9729,0.0381),
(0.9860,0.0300),
(0.0349,0.002),
(0.4909,0.3791),
(0.4146,0.3537),
(0.4145,0.3542),
(0.4150,0.3548),
(0.3155,0.3317),
(0.3908,0.3325),
(0.3328,0.3479),
(0.3846,0.3484),
(0.3543,0.3482),
(0.3547,0.3473),
(0.3850,0.3391),
(0.3972,0.3517),
(0.4208,0.3618),
(0.4172,0.3590),
(0.4162,0.3673),
(0.4189,0.3692),
(0.3817,0.3758),
(0.3781,0.3769),
(0.2836,0.3787),
(0.1965,0.3777),
(0.1868,0.3779),
(0.1948,0.3777),
(0.1977,0.3781),
(0.2102,0.3746),
(0.3108,0.3496),
(0.3053,0.3524),
(0.2989,0.3537),
(0.3243,0.3490),
(0.3846,0.3486),
(0.3564,0.3483),
(0.2192,0.3447),
(0.1569,0.3441),
(0.2564,0.3718),
(0.1950,0.3643),
(0.1612,0.3473),
(0.1572,0.3443),
(0.1964,0.3417),
(0.2957,0.3443),
(0.3065,0.3423),
(0.2109,0.3642),
(0.3052,0.3321),
(0.3051,0.3356),
(0.2007,0.3412),
(0.2503,0.3377),
(0.2682,0.3733),
(0.2280,0.3768),
(0.2831,0.3347),
(0.2996,0.3705),
(0.2808,0.4088),
(0.2461,0.4123),
(0.3124,0.4062),
(0.3217,0.3686),
(0.3404,0.4050),
(0.3510,0.3684),
(0.3712,0.4055),
(0.3924,0.3696),
(0.4060,0.4076),
(0.4199,0.3722),
(0.4315,0.4108),
(0.4244,0.3751),
(0.4362,0.4140),
(0.4171,0.3777),
(0.4070,0.4165),
(0.3702,0.3803),
(0.2966,0.4181),
(0.1967,0.3800),
(0.2188,0.4158),
(0.2900,0.4443),
(0.2587,0.4478),
(0.3224,0.4419),
(0.3562,0.4413),
(0.3894,0.4427),
(0.4191,0.4456),
(0.4436,0.4494),
(0.4503,0.4529),
(0.3928,0.4552),
(0.2324,0.4516),
(0.2996,0.4797),
(0.2744,0.4825),
(0.3267,0.4778),
(0.3554,0.4774),
(0.3828,0.4786),
(0.4059,0.4810),
(0.4213,0.4841),
(0.4163,0.4870),
(0.3671,0.4889),
(0.2859,0.4893),
(0.2192,0.4545),
(0.2559,0.4857),
(0.2526,0.4881),
(0.3096,0.5151),
(0.2904,0.5173),
(0.3313,0.5137),
(0.3544,0.5135),
(0.3759,0.5145),
(0.3925,0.5165),
(0.4003,0.5189),
(0.3899,0.5211),
(0.3538,0.5225),
(0.3057,0.5228),
(0.2798,0.5217),
(0.2782,0.5198),
(0.3200,0.5506),
(0.3063,0.5521),
(0.3362,0.5497),
(0.3534,0.5496),
(0.3687,0.5504),
(0.3789,0.5519),
(0.3810,0.5537),
(0.3698,0.5553),
(0.3458,0.5562),
(0.3180,0.5562),
(0.3012,0.5554),
(0.2986,0.5539),
(0.3293,0.3312),
(0.3783,0.3317),
(0.2111,0.3814),
(0.1816,0.3449),
(0.1565,0.3441),
(0.3002,0.3323),
(0.3157,0.5557),
(0.3031,0.5543),
(0.3093,0.5522),
(0.3262,0.5504),
(0.3463,0.5558),
(0.3719,0.5544),
(0.3767,0.5524),
(0.3656,0.5505),
(0.3468,0.5497),
(0.2859,1.0029),
(0.2943,1.0029),
(0.3231,1.0033),
(0.2953,1.0031),
(0.3243,1.0033),
(0.3523,1.0036),
(0.3602,1.0037),
(0.3509,1.0037),
(0.3327,1.0034),
(0.3120,1.0031),
(0.3675,0.9514),
(0.3672,0.9891),
(0.3630,0.9875),
(0.3646,0.9370),
(0.3313,0.9509),
(0.3320,0.9886),
(0.3227,0.9869),
(0.3243,0.9365));

BEGIN
  {for precaution}
  For loop1:=1 to npoints do BEGIN
    {gET MAPPING COORDS}
    au[loop1]:=ROUND(UVREL[LOOP1,1]*128);
    av[loop1]:=ROUND(UVREL[LOOP1,2]*128);
  END;
END;
{map must be already loaded in w}


Procedure getbumpcords; {coords for rock}
VAR loop1:integer;
const
uvrel:array[1..390,1..2] of real= {rock}

((0.2500,0.0526),
(0.2500,0.3276),
(0.753,0.3342),
(0.750,0.4265),
(0.750,0.6307),
(0.751,0.9008),
(0.750,0.9404),
(0.755,0.9206),
(0.756,0.6109),
(0.757,0.3145),
(0.752,0.1629),
(0.754,0.1102),
(0.753,0.0773),
(0.2483,0.0526),
(0.2483,0.3276),
(0.7845,0.3342),
(0.7840,0.4265),
(0.7839,0.6307),
(0.7839,0.9008),
(0.7838,0.9404),
(0.7838,0.9206),
(0.7837,0.6109),
(0.7838,0.3145),
(0.7840,0.1629),
(0.7845,0.1102),
(0.7850,0.0773),
(0.2507,0.0526),
(0.2507,0.3276),
(0.8188,0.3342),
(0.8179,0.4265),
(0.8177,0.6307),
(0.8177,0.9008),
(0.8176,0.9404),
(0.8174,0.9206),
(0.8174,0.6109),
(0.8175,0.3145),
(0.8178,0.1629),
(0.8188,0.1102),
(0.8198,0.0773),
(0.2492,0.0526),
(0.2492,0.3276),
(0.8531,0.3342),
(0.8519,0.4265),
(0.8516,0.6307),
(0.8515,0.9008),
(0.8514,0.9404),
(0.8512,0.9206),
(0.8512,0.6109),
(0.8513,0.3145),
(0.8518,0.1629),
(0.8531,0.1102),
(0.8546,0.0773),
(0.2481,0.0526),
(0.2481,0.3276),
(0.8874,0.3342),
(0.8857,0.4265),
(0.8853,0.6307),
(0.8853,0.9008),
(0.8851,0.9404),
(0.8849,0.9206),
(0.8849,0.6109),
(0.8850,0.3145),
(0.8856,0.1629),
(0.8874,0.1102),
(0.8892,0.0773),
(0.2495,0.0526),
(0.2495,0.3276),
(0.9212,0.3342),
(0.9194,0.4265),
(0.9189,0.6307),
(0.9189,0.9008),
(0.9186,0.9404),
(0.9184,0.9206),
(0.9184,0.6109),
(0.9186,0.3145),
(0.9192,0.1629),
(0.9212,0.1102),
(0.9233,0.0773),
(0.2487,0.0526),
(0.2487,0.3276),
(0.9550,0.3342),
(0.9530,0.4265),
(0.9525,0.6307),
(0.9525,0.9008),
(0.9522,0.9404),
(0.9519,0.9206),
(0.9519,0.6109),
(0.9521,0.3145),
(0.9528,0.1629),
(0.9550,0.1102),
(0.9573,0.0773),
(0.2486,0.0526),
(0.2486,0.3276),
(0.9886,0.3342),
(0.9865,0.4265),
(0.9860,0.6307),
(0.9860,0.9008),
(0.9857,0.9404),
(0.9854,0.9206),
(0.9854,0.6109),
(0.9856,0.3145),
(0.9863,0.1629),
(0.9886,0.1102),
(0.9909,0.0773),
(0.2485,0.0526),
(0.2485,0.3276),
(0.0218,0.3342),
(0.0198,0.4265),
(0.0192,0.6307),
(0.0192,0.9008),
(0.0189,0.9404),
(0.0186,0.9206),
(0.0186,0.6109),
(0.0189,0.3145),
(0.0196,0.1629),
(0.0218,0.1102),
(0.0240,0.0773),
(0.2487,0.0526),
(0.2487,0.3276),
(0.0549,0.3342),
(0.0530,0.4265),
(0.0525,0.6307),
(0.0525,0.9008),
(0.0522,0.9404),
(0.0519,0.9206),
(0.0519,0.6109),
(0.0521,0.3145),
(0.0528,0.1629),
(0.0549,0.1102),
(0.0571,0.0773),
(0.2495,0.0526),
(0.2495,0.3276),
(0.0878,0.3342),
(0.0861,0.4265),
(0.0856,0.6307),
(0.0856,0.9008),
(0.0854,0.9404),
(0.0851,0.9206),
(0.0851,0.6109),
(0.0853,0.3145),
(0.0859,0.1629),
(0.0878,0.1102),
(0.0898,0.0773),
(0.2481,0.0526),
(0.2481,0.3276),
(0.1204,0.3342),
(0.1189,0.4265),
(0.1186,0.6307),
(0.1185,0.9008),
(0.1183,0.9404),
(0.1181,0.9206),
(0.1181,0.6109),
(0.1183,0.3145),
(0.1188,0.1629),
(0.1204,0.1102),
(0.1220,0.0773),
(0.2492,0.0526),
(0.2492,0.3276),
(0.1530,0.3342),
(0.1518,0.4265),
(0.1515,0.6307),
(0.1515,0.9008),
(0.1513,0.9404),
(0.1512,0.9206),
(0.1511,0.6109),
(0.1513,0.3145),
(0.1517,0.1629),
(0.1530,0.1102),
(0.1542,0.0773),
(0.2507,0.0526),
(0.2507,0.3276),
(0.1854,0.3342),
(0.1846,0.4265),
(0.1844,0.6307),
(0.1844,0.9008),
(0.1843,0.9404),
(0.1841,0.9206),
(0.1841,0.6109),
(0.1842,0.3145),
(0.1845,0.1629),
(0.1854,0.1102),
(0.1863,0.0773),
(0.2484,0.0526),
(0.2484,0.3276),
(0.2176,0.3342),
(0.2172,0.4265),
(0.2171,0.6307),
(0.2171,0.9008),
(0.2171,0.9404),
(0.2170,0.9206),
(0.2170,0.6109),
(0.2171,0.3145),
(0.2172,0.1629),
(0.2176,0.1102),
(0.2180,0.0773),
(0.2500,0.0526),
(0.2500,0.3276),
(0.253,0.3342),
(0.250,0.4265),
(0.250,0.6307),
(0.251,0.9008),
(0.250,0.9404),
(0.255,0.9206),
(0.256,0.6109),
(0.257,0.3145),
(0.252,0.1629),
(0.254,0.1102),
(0.253,0.0773),
(0.2515,0.0526),
(0.2515,0.3276),
(0.2823,0.3342),
(0.2827,0.4265),
(0.2828,0.6307),
(0.2828,0.9008),
(0.2828,0.9404),
(0.2829,0.9206),
(0.2829,0.6109),
(0.2828,0.3145),
(0.2827,0.1629),
(0.2823,0.1102),
(0.2819,0.0773),
(0.2492,0.0526),
(0.2492,0.3276),
(0.3145,0.3342),
(0.3153,0.4265),
(0.3155,0.6307),
(0.3155,0.9008),
(0.3156,0.9404),
(0.3158,0.9206),
(0.3158,0.6109),
(0.3157,0.3145),
(0.3154,0.1629),
(0.3145,0.1102),
(0.3136,0.0773),
(0.2507,0.0526),
(0.2507,0.3276),
(0.3469,0.3342),
(0.3481,0.4265),
(0.3484,0.6307),
(0.3484,0.9008),
(0.3486,0.9404),
(0.3487,0.9206),
(0.3488,0.6109),
(0.3486,0.3145),
(0.3482,0.1629),
(0.3469,0.1102),
(0.3457,0.0773),
(0.2518,0.0526),
(0.2518,0.3276),
(0.3795,0.3342),
(0.3810,0.4265),
(0.3813,0.6307),
(0.3814,0.9008),
(0.3816,0.9404),
(0.3818,0.9206),
(0.3818,0.6109),
(0.3816,0.3145),
(0.3811,0.1629),
(0.3795,0.1102),
(0.3779,0.0773),
(0.2504,0.0526),
(0.2504,0.3276),
(0.4121,0.3342),
(0.4138,0.4265),
(0.4143,0.6307),
(0.4143,0.9008),
(0.4145,0.9404),
(0.4148,0.9206),
(0.4148,0.6109),
(0.4146,0.3145),
(0.4140,0.1629),
(0.4121,0.1102),
(0.4101,0.0773),
(0.2512,0.0526),
(0.2512,0.3276),
(0.4450,0.3342),
(0.4469,0.4265),
(0.4474,0.6307),
(0.4474,0.9008),
(0.4477,0.9404),
(0.4480,0.9206),
(0.4480,0.6109),
(0.4478,0.3145),
(0.4471,0.1629),
(0.4450,0.1102),
(0.4428,0.0773),
(0.2514,0.0526),
(0.2514,0.3276),
(0.4781,0.3342),
(0.4801,0.4265),
(0.4807,0.6307),
(0.4807,0.9008),
(0.4810,0.9404),
(0.4813,0.9206),
(0.4813,0.6109),
(0.4810,0.3145),
(0.4803,0.1629),
(0.4781,0.1102),
(0.4759,0.0773),
(0.2513,0.0526),
(0.2513,0.3276),
(0.5113,0.3342),
(0.5134,0.4265),
(0.5139,0.6307),
(0.5139,0.9008),
(0.5142,0.9404),
(0.5145,0.9206),
(0.5145,0.6109),
(0.5143,0.3145),
(0.5136,0.1629),
(0.5113,0.1102),
(0.5090,0.0773),
(0.2512,0.0526),
(0.2512,0.3276),
(0.5449,0.3342),
(0.5469,0.4265),
(0.5474,0.6307),
(0.5474,0.9008),
(0.5477,0.9404),
(0.5480,0.9206),
(0.5480,0.6109),
(0.5478,0.3145),
(0.5471,0.1629),
(0.5449,0.1102),
(0.5426,0.0773),
(0.2504,0.0526),
(0.2504,0.3276),
(0.5787,0.3342),
(0.5805,0.4265),
(0.5810,0.6307),
(0.5810,0.9008),
(0.5813,0.9404),
(0.5815,0.9206),
(0.5815,0.6109),
(0.5813,0.3145),
(0.5807,0.1629),
(0.5787,0.1102),
(0.5766,0.0773),
(0.2518,0.0526),
(0.2518,0.3276),
(0.6125,0.3342),
(0.6142,0.4265),
(0.6146,0.6307),
(0.6146,0.9008),
(0.6148,0.9404),
(0.6150,0.9206),
(0.6150,0.6109),
(0.6149,0.3145),
(0.6143,0.1629),
(0.6125,0.1102),
(0.6107,0.0773),
(0.2507,0.0526),
(0.2507,0.3276),
(0.6468,0.3342),
(0.6480,0.4265),
(0.6483,0.6307),
(0.6484,0.9008),
(0.6485,0.9404),
(0.6487,0.9206),
(0.6487,0.6109),
(0.6486,0.3145),
(0.6481,0.1629),
(0.6468,0.1102),
(0.6453,0.0773),
(0.2492,0.0526),
(0.2492,0.3276),
(0.6811,0.3342),
(0.6820,0.4265),
(0.6822,0.6307),
(0.6822,0.9008),
(0.6823,0.9404),
(0.6825,0.9206),
(0.6825,0.6109),
(0.6824,0.3145),
(0.6821,0.1629),
(0.6811,0.1102),
(0.6801,0.0773),
(0.2516,0.0526),
(0.2516,0.3276),
(0.7154,0.3342),
(0.7159,0.4265),
(0.7160,0.6307),
(0.7160,0.9008),
(0.7161,0.9404),
(0.7161,0.9206),
(0.7162,0.6109),
(0.7161,0.3145),
(0.7159,0.1629),
(0.7154,0.1102),
(0.7149,0.0773));

BEGIN
  {for precaution}
  For loop1:=1 to npoints do BEGIN
    {gET MAPPING COORDS}
    au[loop1]:=ROUND(UVREL[LOOP1,1]*127);
    av[loop1]:=ROUND(UVREL[LOOP1,2]*127);
  END;
END;
{map must be already loaded in w}


procedure setupmap(w:word);
var i,J:word;
    c:byte;
const uf=0.8;
      vf=1.30;
{normal values 0.8 and 1.25}
begin
   GetMem(Pict,65535);
   {clear map}
   for i:=1 to 255 do
     for j:=1 to 255 do
       Mem[Seg(Pict^):Ofs(Pict^)+i+j*255]:=0;
{   lpcx(s,w);}
   flip(w,sega000);
   {now watch how i shrink it}
    for i:=1 to 255 do
     for j:=1 to 255 do begin
       c:=mem[sega000:round(i/uf)+round(j/vf)*320];
       Mem[Seg(Pict^):Ofs(Pict^)+(i)+(j*255)]:=mem[sega000:round(i/uf)+round(j/vf)*320];
     end;
  getbumpcords;
 {change this to getbumpcoords to have more correct mapping coords}
end;


procedure shutmap;
begin
  freeMem(Pict,65535);
end;



procedure showbump(w1,w2:word);
var l1,l2:integer;
     x,y,xx,yy:array[1..3] of integer;
     u,v:array[1..3] of byte;
     temp:integer;
begin
    for n:=1 to nfaces do begin
        polyz[n]:=round((translated^[faces^[n,1]].z+
                  translated^[faces^[n,2]].z+
                  translated^[faces^[n,3]].z));
{        pind[n]:=n;}
    end;
   shellsort(nfaces);

   for l2:=1 to nfaces do begin
   show:=true;
      for l1:=1 to 3 do begin
        temp:=translated^[faces^[l2,l1]].z+zoff;
        x[l1]:=translated^[faces^[l2,l1]].X shl 8 div temp+xoff;
        y[l1]:=translated^[faces^[l2,l1]].Y shl 8 div temp+yoff;
        u[l1]:=au[faces^[l2,l1]];
        v[l1]:=av[faces^[l2,l1]];

        if temp>-50 then show:=false;
      end;
      diffuse(l2);
    if show then begin
          phongclippolygon (x[1],y[1],x[2],y[2],x[3],y[3]
          ,u[1],v[1],u[2],v[2],u[3],v[3],w1,pict);
          gouraudcppoly(x[1],y[1],x[2],y[2],x[3],y[3],co[1],co[2],co[3],w2);
{          flip(vaddr,sega000);
{         readln;}
    end;
   end;
end;

procedure asmsh(out,w1,w2:word); {assembly bumping}
{added out so to be able to have reflection}
var l1,l2:word;
    c,c2,nc:byte;
    gtk:word;

begin
    asm
    mov cx,63999
    @Loop1:
      mov es,w2
      mov di,cx
      mov al,es:[di]
      cmp al,0
      je @zero
      mov c,al
        mov es,w1
        mov di,cx
        mov al,es:[di]
        mov c2,al
        {find gtk}
        mov ah,0
        shr ax,1  {this is how much}
        xor bx,bx
        mov bl,c
        add ax,bx
        mov gtk,ax
        mov nc,al
        cmp al,con
        ja @greater
          jmp @ok
        @greater:
          mov al,con
          jmp @ok
        @zero:
          mov al,0
        @ok:
        mov es,out
        mov es:[di],al
        dec cx
        jnz @loop1
     end;
end;

procedure showtext(w1,w2:word);
var l1,l2:integer;
     x,y,xx,yy:array[1..3] of integer;
     u,v:array[1..3] of byte;
     temp:integer;


begin
    for n:=1 to nfaces do begin
        polyz[n]:=round((translated^[faces^[n,1]].z+
                  translated^[faces^[n,2]].z+
                  translated^[faces^[n,3]].z));
{        pind[n]:=n;}
    end;
   quicksort(1,nfaces);

   for l2:=1 to nfaces do begin
   show:=true;
      for l1:=1 to 3 do begin
        temp:=round (translated^[faces^[l2,l1]].z+zoff+d);
        x[l1] :=(translated^[faces^[l2,l1]].X*256 div temp)+xoff;
        y[l1] :=(translated^[faces^[l2,l1]].Y *256 div temp)+yoff;
        u[l1]:=au[faces^[l2,l1]];
        v[l1]:=av[faces^[l2,l1]];

        if temp>-100 then show:=false;
      end;
      diffuse(l2);
    if show then begin
          phongclippolygon (x[1],y[1],x[2],y[2],x[3],y[3]
          ,u[1],v[1],u[2],v[2],u[3],v[3],w1,pict);
          gouraudcppoly(x[1],y[1],x[2],y[2],x[3],y[3],co[1],co[2],co[3],w2);
{          flip(vaddr,vga);
{         readln;}
    end;
   end;
end;

procedure shadethetext(w1,w2:word);
var l1,l2,gtk:word;
    c,c2:byte;
begin
  for l1:=1 to 63999 do begin
    c:=mem[w1:l1];
    if c>0 then begin
      c2:=mem[w2:l1];
      gtk:=word(c+(c2*16));
      c:=gtk mod 256;

      mem[sega000:l1]:=c;
    end
    else mem[sega000:l1]:=0;
  end;
end;

procedure make16(w:word);
var l1:word;
    r,g,b:byte;

begin
  {this will make 256 colors to be 16}
  for l1:=1 to 16 do begin
    getpal((l1*15),r,g,b);
    pal(l1,r,g,b);
  end;
  for l1:=1 to 63999 do begin
    mem[w:l1]:=mem[w:l1] div 16;
  end;
end;


Procedure settmappal(w:word);
var l1,l2:integer;
    c:byte;
op:array[1..16,1..3] of byte;
begin
{  for l1:=1 to 16 do pal(l1,l1*4,0,0);}
  for l1:=1 to 16 do begin
    getpal(l1,op[l1,1],op[l1,2],op[l1,3]);
  end;

  for l1:=8 to 15 do begin
      for l2:=1 to 16 do begin
            if op[l2,1]<63 then op[l2,1]:=op[l2,1]+1 ;
            if op[l2,2]<63 then op[l2,2]:=op[l2,2]+1 ;
            if op[l2,3]<63 then op[l2,3]:=op[l2,3]+1 ;
            c:=integer(l2+l1*16)-1;
      pal(c,op[l2,1],op[l2,2],op[l2,3]);
    end;
  end;

  for l1:=1 to 16 do begin
    getpal(l1,op[l1,1],op[l1,2],op[l1,3]);
  end;

  for l1:=8 downto 0 do begin
      for l2:=1 to 16 do begin
            if op[l2,1]>1 then op[l2,1]:=op[l2,1]-2 ;
            if op[l2,2]>1 then op[l2,2]:=op[l2,2]-2 ;
            if op[l2,3]>1 then op[l2,3]:=op[l2,3]-2 ;
      pal(l2+l1*16,op[l2,1],op[l2,2],op[l2,3]);
    end;
  end;
  for l1:=1 to 255 do
   for l2:=1 to 100 do
    putpixel(l1,l2,l1,w);
  readln;
  pal(0,0,0,0);
  ambient:=-2;
end;

procedure phongit(w1,w2:word);assembler;
var      c,c2:byte;
      ofs:word;
  asm
       mov cx,63999
       @scan:
         xor ax,ax
         mov es,w1
         mov di,cx
         mov al,es:[di]
         cmp al,0
         jz @out

         mov c,al

         mov ax,cx
         xor bx,bx
         mov bl,c
         shl bx,1      {<-------- change this to change the effect}
         add ax,bx
{         mov ofs,ax
                    replaced with the 2 following
         mov es,w2
         mov di,ofs}
         mov es,w2
         mov di,ax

         mov al,es:[di]
         mov c2,al

         mov es,w1
         mov di,cx
         xor ax,ax
         mov al,c2
         mov es:[di],al
         @out:
         loop @scan
{
  push    ds
  mov   ax,0
  cmp   ax,0
  je     @doit
@cont:
  mov     ax, 0a000h
  mov     es, ax
  mov     ax, w1
  mov     ds, ax
  db      $F3, $66, $A5
  pop     ds
  jmp     @dout
@doit:
  xor     di, di
  xor     si, si
  mov     cx, 16000
  jmp     @cont
@dout:                       }
end;



procedure settmap(s:string;w:word);
var i,J:word;
    c:byte;
const uf=0.8;
      vf=1.30;
{normal values 0.8 and 1.25}
begin
   GetMem(Pict,65535);
   {clear map}
   for i:=1 to 256 do
     for j:=1 to 256 do
       Mem[Seg(Pict^):Ofs(Pict^)+i+j*256]:=0;

   lpcx(s,w);
   pal(240,16,15,23);
   pal(224,26,25,33);

    fillbox(1,35,80,199,240,w);
    fillbox(1,55,80,199,224,w);

   readln;
   make16(w);

   {now watch how i shrink it
     for i:=1 to 255 do
     for j:=1 to 255 do begin
       c:=mem[w:round(i/uf)+round(j/vf)*320];
       Mem[Seg(Pict^):Ofs(Pict^)+(i)+(j*255)]:=mem[w:round(i/uf)+round(j/vf)*320];
     end;                    }

    for i:=1 to 256 do
     for j:=1 to 256 do
       Mem[Seg(Pict^):Ofs(Pict^)+(i)+(j*256)]:=mem[w:round(i/uf)+round(j/vf)*320];

{  for i:=1 to 256 do
    for j:=1 to 256 do
      Mem[Seg(Pict^):Ofs(Pict^)+(i)+(j*256)]:=i div 16;
}

  {Here, the 'phong-map' as I call it is created. Normally I use a different
   routine for that (Looks WAY better), but that one is too big}
  For I:=0 To 255 Do For J:=0 To 255 Do Begin
{    Mem[Seg(Pict^):Ofs(Pict^)+Word(256*I)+J]:=
        Round(Sqr(Sqr(Sin(I/20)))*Sqr(Sqr(Sin(J/20.487)))*62);}
    Mem[sega000:320*Round(I/1.25)+J]:=Mem[Seg(Pict^):Ofs(Pict^)+Word(256*I)+J];
  end;
  settmappal(w);
  getmapcords;
end;

BEGIN
  ad1:=0;
  ad2:=0;
  ad3:=0;
  cx:=0;
  cy:=0;
  cz:=0;
END.
