
objet3d& objet3d::litset(float aax,float aay,float aaz,short int dx,short int dy,short int dz)
{
	ax=aax;
	ay=aay;
	az=aaz;
	center.x=dx;
	center.y=dy;
	center.z=dz;
	return *this;
}


objet3d& objet3d::set(objet3d *p,float nsax,float nsay,float nsaz,
	 float neax,float neay,float neaz,float aax,float aay,float aaz,
	 short int dx,short int dy,short int dz,float scx,float scy,float scz,
	 float ecx,float ecy,float ecz,byte ms,byte me,byte ccs,byte cct,byte md)
{
	parent=p;
	sax=nsax;
	say=nsay;
	saz=nsaz;
	eax=neax;
	eay=neax;
	eaz=neax;
	ax=aax;
	ay=aay;
	az=aaz;
	center.x=dx;
	center.y=dy;
	center.z=dz;
	Scenter.x=scx;
	Scenter.y=scy;
	Scenter.z=scz;
	Ecenter.x=ecx;
	Ecenter.y=ecy;
	Ecenter.z=ecz;
	mstart=ms;
	mend=me;
	cs=ccs;
	ct=cct;
	mdraw=md;
	return *this;
}

objet3d& objet3d::start(float aax,float aay,float aaz,short int dx,short int dy,short int dz)
{
	sax=aax;
	say=aay;
	saz=aaz;
	Scenter.x=dx;
	Scenter.y=dy;
	Scenter.z=dz;
	return *this;
}

objet3d& objet3d::end(float aax,float aay,float aaz,short int dx,short int dy,short int dz)
{
	eax=aax;
	eay=aay;
	eaz=aaz;
	Ecenter.x=dx;
	Ecenter.y=dy;
	Ecenter.z=dz;
	return *this;
}
	
objet3d& objet3d::inta(float pos, float tot)
{

	ax=pos*(eax-sax)/tot+sax;
	ay=pos*(eay-say)/tot+say;
	az=pos*(eaz-saz)/tot+saz;
	center.x=pos*(Ecenter.x-Scenter.x)/tot+Scenter.x;
	center.y=pos*(Ecenter.y-Scenter.y)/tot+Scenter.y;
	center.z=pos*(Ecenter.z-Scenter.z)/tot+Scenter.z;
	
	return *this;
}



	
	 


objet3d& objet3d::move(short int x,short int y,short int z)
{
	center.x+=x;
	center.y+=y;
	center.z+=z;
	return *this;
}



objet3d&  objet3d::load(char *name,byte no)
{
	FILE *entree2;
	entree2=fopen(name,"rb");
	no++;
while(no)
  {
	fread(&tot_vertex,2,1,entree2);
	fread(&tot_face,2,1,entree2);

	face= new FACE [tot_face];
	vertex= new VERTEX [tot_vertex];
	image=new IVERTEX [tot_vertex];
	centroid=new CENTROID[tot_face];
	bufA=new CENTROID[tot_face];
	bufB=new CENTROID[tot_face];

	normalo=new NORMAL [tot_face];
	normali=new NORMAL [tot_face];
	normalvi=new NORMAL [tot_vertex];
	normalvo=new NORMAL [tot_vertex];
	texture=new TEXTURE [tot_vertex];
	if(!face || !vertex || !image || !normali || !normalo || !normalvi || !normalvo || !centroid || !bufA || !bufB || !texture)
	   {
		   mode3();
		   printf("Insufisant memory...");
		   exit(0);

	   }
			fread(vertex,2,tot_vertex*3L,entree2);
			fread(face,2,tot_face*3L,entree2);

	 ax=ay=az=0;
	 zmax=256;
	 ALL=0;
	 no--;
	 if(no)
		{
		delete face;
		delete vertex;
		delete image;
		delete normalo;
		delete normali;
		delete normalvi;
		delete normalvo;
		delete centroid;
		delete texture;
		delete bufA;
		delete bufB;
		}
	 
   }
  fclose(entree2);
	 return *this;
}

objet3d&  objet3d::dload(long posf,byte no)
{
    fseek(data,posf,0);                                         
	no++;
while(no)
  {
	fread(&tot_vertex,2,1,data);
	fread(&tot_face,2,1,data);

	face= new FACE [tot_face];
	vertex= new VERTEX [tot_vertex];
	image=new IVERTEX [tot_vertex];
	centroid=new CENTROID[tot_face];
	bufA=new CENTROID[tot_face];
	bufB=new CENTROID[tot_face];

	normalo=new NORMAL [tot_face];
	normali=new NORMAL [tot_face];
	normalvi=new NORMAL [tot_vertex];
	normalvo=new NORMAL [tot_vertex];
	texture=new TEXTURE [tot_vertex];
	if(!face || !vertex || !image || !normali || !normalo || !normalvi || !normalvo || !centroid || !bufA || !bufB || !texture)
	   {
		   mode3();
		   printf("Insufisant memory...");
		   exit(0);

	   }
			fread(vertex,2,tot_vertex*3L,data);
			fread(face,2,tot_face*3L,data);

	 ax=ay=az=0;
	 zmax=256;
	 ALL=0;
	 no--;
	 if(no)
		{
		delete face;
		delete vertex;
		delete image;
		delete normalo;
		delete normali;
		delete normalvi;
		delete normalvo;
		delete centroid;
		delete texture;
		delete bufA;
		delete bufB;
		}
	 
   }
	 return *this;
}



objet3d& objet3d::findnorm(void)
{
	int noface[20];
	float total=0;
	for(int i=0;i<tot_vertex;i++)
	   {
		  total=0;
		normalvo[i].x=0;
		normalvo[i].y=0;
		normalvo[i].z=0;
		  
		  for(int j=0;j<tot_face;j++)
			   {
				 if(face[j].a==i)
					{
				{
				normalvo[i].x+=normalo[j].x;
				normalvo[i].y+=normalo[j].y;
				normalvo[i].z+=normalo[j].z;
						total++;

				}       
				
					} 
				 if(face[j].b==i)
					{
			   {
				normalvo[i].x+=normalo[j].x;
				normalvo[i].y+=normalo[j].y;
				normalvo[i].z+=normalo[j].z;
						total++;

			}       
				
					} 
				 if(face[j].c==i)
					{

				{
				normalvo[i].x+=normalo[j].x;
				normalvo[i].y+=normalo[j].y;
				normalvo[i].z+=normalo[j].z;
					
						total++;
				}
					} 
				 
				 
			   }
		normalvo[i].x/=total;
		normalvo[i].y/=total;
		normalvo[i].z/=total;
		if(normalvo[i].x>254)normalvo[i].x=254;
		if(normalvo[i].x<-254)normalvo[i].x=-254;
		if(normalvo[i].y>254)normalvo[i].y=254;
		if(normalvo[i].y<-254)normalvo[i].y=-254;
		if(normalvo[i].z>254)normalvo[i].z=254;
		if(normalvo[i].z<-254)normalvo[i].z=-254;
		
		

		
		}
  delete normalo;
  delete normali;
  return *this;
			   
}
	  
				 
				 

objet3d& objet3d::delet(void)
{
 delete image;
 delete vertex;
 delete face;
 return  *this;
}

objet3d& objet3d::draw()
{
   long x1,x2,y1,y2,x3,y3,c1,c2,c3,z1,z2,z3,nx,ny,nz,lx,lz,ly;
   long facea,faceb,facec;
   int tot=0;
if(mdraw==2)
{   
   for(int zi=0;zi<tot_face;zi++)
	   {   
		   facea=face[zi].a;
		   faceb=face[zi].b;
		   facec=face[zi].c;

		   z1=image[facea].z;
		   z2=image[faceb].z;
		   z3=image[facec].z;
		   
		   x1=image[facea].x;
		   x2=image[faceb].x;
		   x3=image[facec].x;

		   
		   y1=image[facea].y;
		   y2=image[faceb].y;
		   y3=image[facec].y;
		   
		   
long   ux=(x3-x1);
long   uy=(y3-y1);
long   uz=(z3-z1);

long   vx=(x2-x1);
long   vy=(y2-y1);
long   vz=(z2-z1);

// nx=(uy*vz-vy*uz);
// ny=(uz*vx-vz*ux);
 nz=(ux*vy-vx*uy);
 
		   
		   long middle=((long int )(z1+z2+z3)/3.0);
		   if(ALL)nz=0;
		   if(nz>=0 && middle >170 && middle <11000)
		   {
		   centroid[tot].z=middle;
		   centroid[tot].noface=zi;
		   tot++;
		   }
	  }
	 
		   

sort(tot);

for(zi=0;zi<tot;zi++)
		   {
		   word hi;
		   hi=centroid[tot-(zi+1)].noface;

		   facea=face[hi].a;
		   faceb=face[hi].b;
		   facec=face[hi].c;
		   z1=image[facea].z;
		   z2=image[faceb].z;
		   z3=image[facec].z;
		   if(z1==0)z1=1;
		   if(z2==0)z2=1;
		   if(z3==0)z3=1;
		   
		   x1=160+zmax*image[facea].x/z1;
		   x2=160+zmax*image[faceb].x/z2;
		   x3=160+zmax*image[facec].x/z3;
		   
		   y1=100+zmax*image[facea].y/z1;
		   y2=100+zmax*image[faceb].y/z2;
		   y3=100+zmax*image[facec].y/z3;

			 long total;
			 
			 total=normalvi[facea].z;
			 if(total>255)total=255;
			 if(total<-255)total=-255;
			 float clo=(ct-cs)/3.1415;
			 
			 c1=ct-clo*acos(total/256.0);
			 total=normalvi[faceb].z;
			 if(total>255)total=255;
			 if(total<-255)total=-255;
			 c2=ct-clo*acos(total/256.0);
			 total=normalvi[facec].z;
			 if(total>255)total=255;
			 if(total<-255)total=-255;
			 c3=ct-clo*acos(total/256.0);
		 
			 
			 gourad(x1,y1,x2,y2,x3,y3,c1,c2,c3,buf1); 

			 
		   }
}
if(mdraw==4)
   {
   for(int zi=0;zi<tot_face;zi++)
	   {   
		   facea=face[zi].a;
		   faceb=face[zi].b;
		   facec=face[zi].c;

		   z1=image[facea].z;
		   z2=image[faceb].z;
		   z3=image[facec].z;
		   
		   x1=image[facea].x;
		   x2=image[faceb].x;
		   x3=image[facec].x;

		   
		   y1=image[facea].y;
		   y2=image[faceb].y;
		   y3=image[facec].y;
		   
long   u1=(x3-x1);
long   u2=(y3-y1);
long   v1=(x2-x1);
long   v2=(y2-y1);

 nz=(u1*v2-u2*v1);
 
		   long middle=((long int )(z1+z2+z3)/3.0);
		   if(ALL)nz=0;
		   if(nz>=0 && middle >170 && middle <11000)
		   {
		   centroid[tot].z=((long int )(z1+z2+z3)/3.0);
		   centroid[tot].noface=zi;
		   tot++;
		   }
	  }
	 
		   

sort(tot);

for( zi=0;zi<tot;zi++)
		   {
		   word hi;
	   hi=centroid[tot-(zi+1)].noface;
		   facea=face[hi].a;
		   faceb=face[hi].b;
		   facec=face[hi].c;
		   
		   z1=image[facea].z;
		   z2=image[faceb].z;
		   z3=image[facec].z;
		   if(z1==0)z1=1;
		   if(z2==0)z2=1;
		   if(z3==0)z3=1;
		   
		   x1=160+zmax*image[facea].x/(float)-z1;
		   x2=160+zmax*image[faceb].x/(float)-z2;
		   x3=160+zmax*image[facec].x/(float)-z3;
		   
		   y1=100+zmax*image[facea].y/(float)-z1;
		   y2=100+zmax*image[faceb].y/(float)-z2;
		   y3=100+zmax*image[facec].y/(float)-z3;
			 
			 map(x1,y1,x2,y2,x3,y3,buf1,texture[facea].x,texture[facea].y,
			 texture[faceb].x,texture[faceb].y,
			 texture[facec].x,texture[facec].y,TEXPTR); 
		   }
}
   


   return *this;
}


objet3d&  objet3d::prenormal(void)
{
	
	 long x2,x3,x1,y1,y2,y3,z1,z2,z3,facea,faceb,facec;
	 
	 for(int i=0;i<tot_face;i++)
		 {
			  
		   facea=face[i].a;
		   faceb=face[i].b;
		   facec=face[i].c;


		   x1=vertex[facea].x;
		   x2=vertex[faceb].x;
		   x3=vertex[facec].x;
		   
		   y1=vertex[facea].y;
		   y2=vertex[faceb].y;
		   y3=vertex[facec].y;

		   z1=vertex[facea].z;
		   z2=vertex[faceb].z;
		   z3=vertex[facec].z;
long   u1=(x3-x1);
long   u2=(y3-y1);
long   u3=(z3-z1);
  
long   v1=(x2-x1);
long   v2=(y2-y1);
long   v3=(z2-z1);
  
long nx=(u2*v3-u3*v2);
long ny=-(u1*v3-u3*v1);
long nz=(u1*v2-u2*v1);

double dist=sqrt((unsigned long)nx*nx+ny*ny+nz*nz);
double angle=(double)nz/dist;

normalo[i].x=(nx/dist)*256;
normalo[i].y=(ny/dist)*256;
normalo[i].z=(nz/dist)*256;

if(normalo[i].z>255)
   normalo[i].z=255;
if(normalo[i].y>255)
   normalo[i].y=255;
if(normalo[i].x>255)
   normalo[i].x=255;
   
if(normalo[i].z<-255)
   normalo[i].z=-255;
if(normalo[i].y<-255)
   normalo[i].y=-255;
if(normalo[i].x<-255)
   normalo[i].x=-255;
}
	return *this;
   
}

objet3d&  objet3d::rotaten(short int anx,short int any,short int anz)
{
   long t1,t2,t3,t4,t5,t6,t7,t8,t9,tmp1,tmp2,tcx,tcz,tcy,tsx,tsz,tsy,i;
   tcx=cosine[anx];
   tcz=cosine[anz];
   tcy=cosine[any];

   tsx=sine[anx];
   tsz=sine[anz];
   tsy=sine[any];

   tmp1=(tsx*tsz)>>14;
   tmp2=(tcz*tsx)>>14;

   t1=((tcz*tcy)>>14)+((tmp1*-tsy)>>14);
   t2=(tcx*tsz>>14);
   t3=((tcz*tsy)>>14)+((tmp1*tcy)>>14);

   t4=((tcy*-tsz)>>14)+((tmp2*-tsy)>>14);
   t5=(tcz*tcx)>>14;
   t6=((tsy*-tsz)>>14)+((tmp2*tcz)>>14);

   t7=(tcx*-tsy)>>14;
   t8=-tsx;
   t9=(tcy*tcx)>>14;

   for(i=0;i<tot_vertex;i++)
	  {
	  normalvi[i].x = (normalvo[i].x * t1 + normalvo[i].y * t4 + normalvo[i].z * t7)>>14;
	  normalvi[i].y = (normalvo[i].x * t2 + normalvo[i].y * t5 + normalvo[i].z * t8)>>14;
	  normalvi[i].z = (normalvo[i].x * t3 + normalvo[i].y * t6 + normalvo[i].z * t9)>>14;
	  }
	 return *this;
}

			 

			 
objet3d&  objet3d::sort(int tot)
{
   int i,j,c1=0,c0=0;
  
   long int n;

   for(i=0;i<16;i++)
   {
	  c1=c0=0;
	  for(j=0;j<tot;j++)
	 {
	 n=centroid[j].z;
	 if((n>>i)&1)
		{
		   bufB[c1]=centroid[j];
		   c1++;
		}
		   
	 else
		{
		   bufA[c0]=centroid[j];
		   c0++;
		}
		
	 }
	  memcpy((CENTROID *)centroid,(CENTROID *)bufA,c0*6);
	  memcpy((CENTROID *)centroid+c0,(CENTROID *)bufB,c1*6);
	  }
	  

	  

   return *this;
}





void make_angle(void)
{
   int i;
   float angle;
   for(i=0;i<1024;i++)
   {
   angle=i*2*3.141592654/1024;
   sine[i]=(float)sin(angle)*16384;
   cosine[i]=(float)cos(angle)*16384;
   }
}




/*******************/
/* Pragma          */
/*******************/ 

			  

void mode13(void)
{
void init13(void);
#pragma aux init13=\
	" mov ax,0013h"\
	" int 10h     "\
	modify exact [eax] nomemory;
	init13();
}

void mode3(void)
{
void init3(void);
#pragma aux init3=\
	" mov ax,003h"\
	" int 10h     "\
	modify exact [eax] nomemory;
	init3();
}

void setpal(byte *pal)
{
	 outp(0x3c8,0);
	 for(int i=0;i<768;i+=3)
		 {
			outp(0x3c9,pal[i]);
			outp(0x3c9,pal[i+1]);
			outp(0x3c9,pal[i+2]);
		  }
}




#pragma aux setpix=\
  "lea ecx,[ecx+ecx*4]"\
  "shl cx,6           "\
  "add bx,cx          "\
  "mov [ebx+0a0000h],al"\
parm [ebx ecx al]\
modify exact [ebx ecx al] nomemory;


#pragma aux waitr = \
	" mov dx,03dah    "\
"l2:                  "\
	" in al,dx        "\ 
	" and al,08h	  "\
	" jz l2	    	  "\
modify exact [eax edx];


void initmatrix(float M[4][4])
{
	for(int i=0;i<4;i++)
	   for(int j=0;j<4;j++)
		   if(i==j) 
				M[i][j]=1;
		   else
				M[i][j]=0;
}

void matmult(float A[4][4],float B[4][4])
{                       
	float temp[4][4];
	int i;
	for(int j=0;j<4;j++)
	   for(i=0;i<4;i++)
			 temp[i][j]=A[i][0]*B[0][j]+A[i][1]*B[1][j]+A[i][2]*B[2][j]+A[i][3]*B[3][j];
	
	for(i=0;i<16;i++)
		A[0][i]=temp[0][i];
}



/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
objet3d& objet3d::rotate(void)
{
float I[4][4],E[4][4],X[4][4],Y[4][4],Z[4][4],Tr[4][4];
long T[16];
int i;


float cx=cos(ax);
float cy=cos(ay);
float cz=cos(az);

float sx=sin(ax);
float sy=sin(ay);
float sz=sin(az);

initmatrix(X);
X[1][1]=cx;
X[1][2]=sx;
X[2][1]=-sx;
X[2][2]=cx;

initmatrix(Y);
Y[0][0]=cy;
Y[0][2]=-sy;
Y[2][0]=sy;
Y[2][2]=cy;

initmatrix(Z);
Z[0][0]=cz;
Z[0][1]=sz;
Z[1][0]=-sz;
Z[1][1]=cz;


if(parent)
  {
	initmatrix(O);
	matmult(O,Z);
	matmult(O,X);
	matmult(O,Y);
	
	O[3][0]+=center.x;
	O[3][1]+=center.y;
	O[3][2]+=center.z;
	matmult(O,parent->O);
	icenter.x=(center.x*parent->O[0][0]+ center.y*parent->O[1][0] + center.z*parent->O[2][0] + parent->O[3][0]);
	icenter.y=(center.x*parent->O[0][1]+ center.y*parent->O[1][1] + center.z*parent->O[2][1] + parent->O[3][1]);
	icenter.z=(center.x*parent->O[0][2]+ center.y*parent->O[1][2] + center.z*parent->O[2][2] + parent->O[3][2]);
	
	
   }
else
   {
	initmatrix(O);
//      initmatrix(Tr);
	O[3][0]-=center.x;
	O[3][1]-=center.y;
	O[3][2]-=center.z;
//      matmult(O,Tr);
	matmult(O,Z);
	matmult(O,X);
	matmult(O,Y);
	}
	
	

for(i=0;i<16;i++)
	T[i]=O[0][i]*256;
for(i=0;i<tot_vertex;i++)
{
	long x=vertex[i].x;
	long y=vertex[i].y;
	long z=vertex[i].z;
	
	image[i].x=(x*T[0]+ y*T[4] + z*T[8] + T[12])>>8;
	image[i].y=(x*T[1]+ y*T[5] + z*T[9] + T[13])>>8;
	image[i].z=(x*T[2]+ y*T[6] + z*T[10] + T[14])>>8;
  }
  

   
  return *this;
}


void line(word x,word y,word x2,word y2,byte col,byte *buf1)
{
	  long tmp;
	  int i, steep = 0, sx, sy, dx1, dy, e;

	  dx1 = abs(x2 - x);
	  sx = ((x2 - x) > 0) ? 1 : -1;
	  dy = abs(y2 - y);
	  sy = ((y2 - y) > 0) ? 1 : -1;

	  if(dy > dx1)
	  {
			steep = 1;
			x ^= y;  /* swap x and y */
			y ^= x;
			x ^= y;

			dx1 ^= dy; /* swap dx and dy */
			dy ^= dx1;
			dx1 ^= dy;

			sx ^= sy; /* swap sx and sy */
			sy ^= sx;
			sx ^= sy;
	  }

	  e = (dy - dx1)<<1;
	  for(i = 0;i < dx1;i++)
	  {
			if(steep)
			   {
				  tmp=(x<<8)+(x<<6)+y;
				  buf1[tmp]=col;


			   }
		  else
		  {
			tmp=(y<<8)+(y<<6)+x;
			buf1[tmp]=col;
		  }
			while(e >= 0)
			{
				  y += sy;
				  e -=(dx1<<1);
			}
			x += sx;
			e +=(dy<<1);
	  }
}



void init_light(int n,float x,float y, float pwr)
{
	alight[n].x=x;
	alight[n].y=y;
	alight[n].lx=x;
	alight[n].ly=y;
	
	alight[n].pwr=pwr;
}

void init_source(int n,float x,float y, float pwr)
{
	source[n].x=x;
	source[n].y=y;
	source[n].pwr=pwr;
}

float lighting(LIGHT tlight)
{
   int i;
   float tmp,dist;
   SOURCE temp;
 // search for the biggest power...
 temp.pwr=tlight.pwr;
 tmp=0;
 for(i=0;i<tot_source;i++)
	 {
		   if(temp.pwr<source[i].pwr)
			   temp=source[i];
	 }
	 
 if (temp.pwr==tlight.pwr)
		{
			return tlight.pwr;
		}
  tmp=rand()%18;      
  tlight.pwr+=tmp;
  if(tlight.x<=temp.x) tlight.x+=rand()%8;
  if(tlight.x>=temp.x) tlight.x-=rand()%8;
  if(tlight.y<=temp.y) tlight.y+=rand()%8;
  if(tlight.y>=temp.y) tlight.y-=rand()%8;
  /* purat etre enlever lorsque le la methode va etre sur */
  if(tlight.y<0)tlight.y=0;
  if(tlight.x<0)tlight.x=0;
  
  if(tlight.y>199)tlight.y=199;
  if(tlight.x>319)tlight.x=319;


  
  line(tlight.lx,tlight.ly,tlight.x,tlight.y,tlight.pwr/2,buf1);
  tlight.lx=tlight.x;
  tlight.ly=tlight.y;

if(!(rand()%10))  
   {
	   tlight.pwr+=10;
	   lighting(tlight);
   }
//  buf1[(unsigned short int)(tlight.x+tlight.y*320)]=tlight.pwr;
  lighting(tlight);
	 
 return tlight.pwr;
}


void fadebuf(byte *buf)
{
   int col;
   for(int i=320;i<63680;i++)
	   {
		  col=((int)buf[i-320]+buf[i+320]+buf[i+1]+buf[i-1]+buf[i-2]+buf[i+2])>>2;
		  if(col>255)col=255;
		  buf[i]=col;
	   }
}

void fade(struct COLORS *cp,word intensity,word start,word end,byte *palbuf)
{
// range parameter values: red,green,blue  0 to 63  (6bit)
//                         intensity       0 to 64
//                         start,end       0 to 255
	byte inc;
//      waitr();
	word i=start*3;
	outp(0x03c8,start);
	for(;i<=(end*3);i+=3)
		{ 
		  outp(0x03c9,( (intensity * *(palbuf+i))/64) + cp->red);
		  outp(0x03c9,( (intensity * *(palbuf+i+1))/64) + cp->green);
		  outp(0x03c9,( (intensity * *(palbuf+i+2))/64) + cp->blue);
		}
	if(cp->red>0) cp->red--; 
	if(cp->green>0) cp->green--; 
	if(cp->blue>0) cp->blue--; 
}
			  

void shadeline(word x,word y,word x2,word y2,byte *buf11,byte *buf22)
{
	  int deg=255,tmp,nev=0;
	  int i, steep = 0, sx, sy, dx1, dy, e;

	  dx1 = abs(x2 - x);
	  sx = ((x2 - x) > 0) ? 1 : -1;
	  dy = abs(y2 - y);
	  sy = ((y2 - y) > 0) ? 1 : -1;

	  if(dy > dx1)
	  {
			steep = 1;
			x ^= y;  /* swap x and y */
			y ^= x;
			x ^= y;

			dx1 ^= dy; /* swap dx and dy */
			dy ^= dx1;
			dx1 ^= dy;

			sx ^= sy; /* swap sx and sy */
			sy ^= sx;
			sx ^= sy;
	  }

	  e = (dy - dx1)<<1;
	  for(i = 0;i < dx1 && deg>0;i++)
	  {
			if(steep)
			   {
				  tmp=(x<<8)+(x<<6)+y;
				if(!buf11[tmp])
				{
				   if(nev)
				   buf22[tmp]=deg;
				   deg-=light;
				}
				else nev=1;


		   }
		  else
		  {
		  tmp=(y<<8)+(y<<6)+x;
		  if(!buf11[tmp])
				{
				   if(nev)
				   buf22[tmp]=deg;
				   deg-=light;
				}
		  else nev=1;
			}
			while(e >= 0)
			{
				  y += sy;
				  e -=(dx1<<1);
			}
			x += sx;
			e +=(dy<<1);
	  }
}

void map(long x1,long y1,long x2,long y2,long x3,long y3,byte *buf,
			 long tx1,long ty1,long tx2,long ty2,long tx3,long ty3,byte *from)
{
	  long m1,m2,m3,x,xs;
	  long temp,ctemp,xtemp,ytemp;
	  long start,stop;
	  byte *ecran=buf,c;
	  long incly,incs1y,sy,sx;
	  long incs1x,incs2x,ex,ey,incs2y,inclx;
	  
	  long tincx,tincy;
	 long xx,y;

	  
	  int i,j;
	  
	  if(y3<y1)
		  { temp=y3; ctemp=tx3; xtemp=x3; ytemp=ty3;
			y3=y1;   tx3=tx1;  x3=x1;     ty3=ty1;
			y1=temp; tx1=ctemp; x1=xtemp; ty1=ytemp;}
	  if(y3<y2)
		  { temp=y3; ctemp=tx3; xtemp=x3; ytemp=ty3; 
			y3=y2;   tx3=tx2;  x3=x2;     ty3=ty2;
			y2=temp; tx2=ctemp; x2=xtemp; ty2=ytemp;}
	  if(y2<y1)
		  { temp=y2; ctemp=tx2; xtemp=x2; ytemp=ty2;
			y2=y1;   tx2=tx1;  x2=x1;     ty2=ty1;
			y1=temp; tx1=ctemp; x1=xtemp; ty1=ytemp;}
	  
	  if(y1==y2)
		  if(x2<x1)
			  { xtemp=x1;   ctemp=tx1; ytemp=ty1;
				x1=x2;      tx1=tx2;   ty1=ty2;
				x2=xtemp;  tx2=ctemp; ty2=ytemp;  } 
		  
	  if(y2==y3)
		  if(x2<x3)
			  { xtemp=x3;   ctemp=tx3; ytemp=ty3;
				x3=x2;  tx3=tx2; ty3=ty2;
			  x2=xtemp; tx2=ctemp; ty2=ytemp;}
	  if(y1==y3)
		   return;
		   
	  m1=((x3-x1)<<16)/(y3-y1);  
	  incly=((ty3-ty1)<<16)/(y3-y1);
	  inclx=((tx3-tx1)<<16)/(y3-y1);
	  if(y1!=y2)
			  {
				  m2=((x2-x1)<<16)/(y2-y1);
				  incs1y=((ty2-ty1)<<16)/(y2-y1);
				  incs1x=((tx2-tx1)<<16)/(y2-y1);
			  }
	  else 
		   m2=1000000;
		   
	  if(y2!=y3)
			  {
				   m3=((x3-x2)<<16)/(y3-y2);
				   incs2x=((tx3-tx2)<<16)/(y3-y2);
				   incs2y=((ty3-ty2)<<16)/(y3-y2);

			  }
			  
	  if(y3<0)return;
	  if(y1>199)return;
	  if(y3>199)y3=200; // verify color;
	  if(y2>199)y2=200;

			  
	  if(m1<m2)
		{
			x=xs=x1<<16;
			sy=ey=ty1<<16;
			sx=ex=tx1<<16;
			
			if(y1<0)
				{
				x+=(m1*-y1);
				xs+=(m2*-y1);  
				sy+=(incly*-y1);
				sx+=(inclx*-y1);
				ey+=(incs1y*-y1);
				ex+=(incs1x*-y1);
				y1=0;
				} 

				 
			ecran+=(y1*320);

				for(i=y1;i<y2;i++)
					{
						tincx = ((ex-sx)*65536.0)/(xs-x);
						tincy = ((ey-sy)*65536.0)/(xs-x);
						xx=sx;
						y=sy;
						
					
						if(xs>20905984)stop=319;
						else stop=xs>>16;
						if(x<0) { xx+=(tincx*-(x>>16));y+=(tincy*-(x>>16));start=0;}
						else                        
						  start=x>>16;
						for(j=start;j<=stop;j++)
							{   
								c=from[(y>>16)*320+(xx>>16)];
								*(ecran+j)=c;
								xx+=tincx;
								y+=tincy;
							}
					 
						ecran+=320;     
						x+=m1;
						xs+=m2;    
						sy+=incly;
						sx+=inclx;
						ey+=incs1y;
						ex+=incs1x;
					}
				xs=x2<<16;
				ey=ty2<<16;
				ex=tx2<<16;
			if(y2<0)
				{
				xs+=(m3*-y2);  
				ey+=(incs2y*-y2);
				ex+=(incs2x*-y2);
				y2=0;
				} 
				
				for(;i<=y3;i++)
					{
					tincx = ((ex-sx)*65536.0)/(xs-x);
					tincy = ((ey-sy)*65536.0)/(xs-x);
						xx=sx;
						y=sy;
						
						if(xs>20905984)stop=319;
						else stop=xs>>16;
						if(x<0) { xx+=(tincx*-(x>>16));y+=(tincy*-(x>>16));start=0;}
						else                        
						  start=x>>16;

						for(j=start;j<=stop;j++)
							{
								c=from[(y>>16)*320+(xx>>16)];
								*(ecran+j)=c;
								xx+=tincx;
								y+=tincy;
							   
 
							}
						ecran+=320;     
						x+=m1;
						xs+=m3;    
						sy+=incly;
						sx+=inclx;
						ey+=incs2y;
						ex+=incs2x;
					}
		}
	 else
		{
			x=xs=x1<<16;
			sy=ey=ty1<<16;
			sx=ex=tx1<<16;
			if(y1<0)
				{
				x+=(m1*-y1);
				xs+=(m2*-y1);  
				sy+=(incly*-y1);
				sx+=(inclx*-y1);
				ey+=(incs1y*-y1);
				ex+=(incs1x*-y1);
				y1=0;
				} 

			  ecran+=(y1*320);
  
				for(i=y1;i<y2;i++)
					{
						xx=sx;
						y=sy;
						
						tincx = ((ex-sx)*65536.0)/(xs-x);
						tincy = ((ey-sy)*65536.0)/(xs-x);
						
						if(xs<0)start=0;
						else start=xs>>16;
						if(x>20905984){ xx-=(tincx*((x>>16)-319));y-=(tincy*((x>>16)-319));stop=319;}
						else stop=x>>16;
						
						for(j=stop;j>=start;j--)
						{
								
								c=from[(y>>16)*320+(xx>>16)];
								*(ecran+j)=c;
								xx-=tincx;
								y-=tincy;
								
						}
						ecran+=320;     
						x+=m1;
						xs+=m2;
						
						sy+=incly;
						sx+=inclx;
						ey+=incs1y;
						ex+=incs1x;
						
					}
				xs=x2<<16;
				ey=ty2<<16;
				ex=tx2<<16;

				  /* missing somethings */
			if(y2<0)                     
				{
				xs+=(m3*-y2);  
				ey+=(incs2y*-y2);
				ex+=(incs2x*-y2);
				y2=0;
				} 
				
				for(i=y2;i<=y3;i++)  // remove the egual ...
					{
					tincx = ((ex-sx)*65536.0)/(xs-x);
					tincy = ((ey-sy)*65536.0)/(xs-x);
						xx=sx;
						y=sy;
						if(xs<0)start=0;
						else start=xs>>16;
						if(x>20905984){ xx-=(tincx*((x>>16)-319));y-=(tincy*((x>>16)-319));stop=319;}
						else stop=x>>16;
						
						
						for(j=stop;j>=start;j--)
						 {
								c=from[(y>>16)*320+(xx>>16)];
								*(ecran+j)=c;
								xx-=tincx;
								y-=tincy;
						 }
						ecran+=320;     
						x+=m1;
						xs+=m3;    
						sy+=incly;
						sx+=inclx;
						ey+=incs2y;
						ex+=incs2x;
						
					}
		}
}


void scroll13h(dword xstart,word sy,word ey,byte *dest,byte *source)
{
		dword x,k;
		byte *dd=dest;
		byte *ss=source;
		for(dword j=sy;j<ey;j++)
			{
			dword jj=(j<<6)+(j<<8);
			dd=dest+jj;
			ss=source+jj+xstart;
				memcpy(dd,ss,320-xstart);
			ss=source+jj;
			dd+=320-xstart;
				memcpy(dd,ss,xstart);
		}
}

void render(int nbr, objet3d *tab)
{
	 int tot=0;
	 for(int i=1;i<nbr;i++)
	{
	   if((tab[i].icenter.z)>170 && tab[i].icenter.z<11000)
		 {
		   rnd_centroid[tot].z=tab[i].icenter.z;
		   rnd_centroid[tot].noface=i;
		   tot++;
		 }
	}
sort_obj(tot);
	
	 for(i=(tot-1);i>=0;i--)
	   tab[rnd_centroid[i].noface].draw();
	
}

void sort_obj(int tot)
{
   int i,j,c1=0,c0=0;
   long n;

   for(i=0;i<16;i++)
   {
	  c1=c0=0;
	  for(j=0;j<tot;j++)
	 {
	 n=rnd_centroid[j].z;
	 if((n>>i)&1)
		{
		   bufBrn[c1]=rnd_centroid[j];
		   c1++;
		}
		   
	 else
		{
		   bufArn[c0]=rnd_centroid[j];
		   c0++;
		}
		
	 }
	  memcpy((CENTROID *)rnd_centroid,(CENTROID *)bufArn,c0*6);
	  memcpy((CENTROID *)rnd_centroid+c0,(CENTROID *)bufBrn,c1*6);
	  }
}


		   
void gourad(long x1,long y1,long x2,long y2,long x3,long y3,long c1,long c2,
			  long c3,byte *buf)
{
	  long m1,m2,m3,x,xs;
	  long mc1,mc2,mc3,cs,c;
	  long temp,ctemp,xtemp;
	  long color;
	  long incc;
	  long start,stop;
	  byte *ecran=buf;
	  int i,j;
	  if(x1>319 && x2>319 && x3>319) return;
	  if(x1<0 && x2<0 && x3<0) return;
	  
	  
	  
	  
	  if(y3<y1)
		  { temp=y3; ctemp=c3; xtemp=x3;
			y3=y1;   c3=c1;  x3=x1;
			y1=temp; c1=ctemp; x1=xtemp; }
	  if(y3<y2)
		  { temp=y3; ctemp=c3; xtemp=x3;
			y3=y2;   c3=c2;  x3=x2;
			y2=temp; c2=ctemp; x2=xtemp; }
	  if(y2<y1)
		  { temp=y2; ctemp=c2; xtemp=x2;
			y2=y1;   c2=c1;  x2=x1;
			y1=temp; c1=ctemp; x1=xtemp; }
	  
	  if(y1==y2)
		  if(x2<x1)
			  { xtemp=x1;   ctemp=c1;
				x1=x2;  c1=c2;
			  x2=xtemp; c2=ctemp; }
		  
	  if(y2==y3)
		  if(x2<x3)
			  { xtemp=x3;   ctemp=c3;
				x3=x2;  c3=c2;
			  x2=xtemp; c2=ctemp; }
	  if(y1==y3)
		 {
		   if(y1<200 && y1>0 && x1>0 && x1<320)
		   buf[y1*320+x1]=c1;
		   return;
		 }
	  m1=((x3-x1)<<10)/(y3-y1);
	  mc1=((c3-c1)<<10)/(y3-y1);
	  if(y1!=y2)
		  { 
			  m2=((x2-x1)<<10)/(y2-y1);
			  mc2=((c2-c1)<<10)/(y2-y1); 
		  }
	  else m2=1000000;
	  
	  if(y2!=y3)
		  {
			  m3=((x3-x2)<<10)/(y3-y2);
			  mc3=((c3-c2)<<10)/(y3-y2);
		  }
		  
      if((y3-y1)>1000)return;
	  if(abs(x3-x1)>1000)return;
	  if(abs(x2-x1)>1000)return;
	  if(y3<0) return;
	  if(y1>199) return;
	  
	  if(y2>199 && y1<0)return;
	  if(y3>199)y3=200; // verify color;
	  if(y2>199)y2=200;
	  
	  
	  if(m1==m2)return;
	  if(m1<m2)
		{
			x=xs=x1<<10;
			c=cs=c1<<10;
			
			if(y1<0)
				{
						x+=(m1*-y1);
						c+=(mc1*-y1);
						xs+=(m2*-y1);    
						cs+=(mc2*-y1);
						if((xs-x)==0)xs++;
						incc=((cs-c)<<10)/(xs-x); // si lors du gourad ... remettre en hay
						y1=0;

				}
					
			ecran+=(y1*320);  
				for(i=y1;i<y2;i++)
					{
						
						if(xs-x)
						    incc=((cs-c)<<10)/(xs-x); // si lors du gourad ... remettre en hay

						color=c;
						if(xs>326656)stop=319; 
						else stop=xs>>10;
						if(x<0){ color+=(0-(x>>10))*incc; start=0; }
						else start=x>>10; 
						byte *E=ecran+start;
						
						for(j=start;j<=stop;j++)
							{
								*E=color>>10;
								E++;
								color+=incc;
							}       
					 
					ecran+=320;     
						x+=m1;
						c+=mc1;
						xs+=m2;    
						cs+=mc2;
						
						


					}
				xs=x2<<10;
				cs=c2<<10;
				
			if(y2<0)
				{
						xs+=(m3*-y2);    
						cs+=(mc3*-y2);
						if(x==xs)incc=0;
						else
						incc=((cs-c)<<10)/(xs-x); // si lors du gourad ... remettre en hay
						y2=0;

				}

				for(;i<=y3;i++)
					{
						if(xs-x)
						    incc=((cs-c)<<10)/(xs-x); // si lors du gourad ... remettre en hay
						color=c;
						if(xs>326656)stop=319; 
						else stop=xs>>10;
						if(x<0){ color+=(0-(x>>10))*incc; start=0; }
						else start=x>>10; 
						byte *E=ecran+start;
						for(j=start;j<=stop;j++)
							{
							   *E=color>>10;
							   E++;
							   color+=incc;
 
							}
						ecran+=320;       
						x+=m1;
						c+=mc1;
						xs+=m3;
						cs+=mc3;
					}
		  }
	 else
		{
			x=xs=x1<<10;
			c=cs=c1<<10;
			if(y1<0)
				{
						x+=(m1*-y1);
						c+=(mc1*-y1);
						xs+=(m2*-y1);    
						cs+=(mc2*-y1);
						if(x==xs)incc=0;
						else
						incc=((cs-c)<<10)/(xs-x); // si lors du gourad ... remettre en hay
						y1=0;
				}
			
				ecran+=y1*320;
				for(i=y1;i<y2;i++)
					{
						if(xs-x)
						    incc=((cs-c)<<10)/(xs-x); // si lors du gourad ... remettre en hay
						color=c;
						if(x>326656){ color-=((x>>10)-319)*incc; start=319; }
						else start=x>>10;
						if(xs<0)stop=0;
						else stop=xs>>10;
						for(j=start;j>=stop;j--)
						{
								*(ecran+j)=(color>>10);
								//inner();
								color-=incc;
								
						}
						ecran+=320;     
						x+=m1;
						c+=mc1;
						xs+=m2;
						cs+=mc2;

					}
			xs=x2<<10;
			cs=c2<<10;
			if(y2<0)
				{
						xs+=(m3*-y2);    
						cs+=(mc3*-y2);
						if(x==xs)incc=0;
						else
						incc=((c-cs)<<10)/(x-xs);
						y2=0;

				}
			
				for(;i<=y3;i++)  // remove the egual ...
					{
						
						if(xs-x)
						    incc=((cs-c)<<10)/(xs-x); // si lors du gourad ... remettre en hay
						color=c;
						if(x>326656){ color-=((x>>10)-319)*incc; start=319; }
						else start=x>>10;
						if(xs<0)stop=0;
						else stop=xs>>10;
						for(j=start;j>=stop;j--)
						 {
						 
							*(ecran+j)=(color>>10);
							//inner();
							color-=incc;
						 }
						ecran+=320;
						x+=m1;
						c+=mc1;
						xs+=m3;
						cs+=mc3;

					}
		}
// enlever une ligne de moins pas de diff ???
					
}




