;
;
; 32CHN S3M PLAYER FOR GUS V3.94 - BY CYBERDANCER [SHOCK!]
;
;
;
;        SUPPORTED S3M COMMANDS: [26]
;
;        A  - SPEED
;        B  - JUMP
;        C  - BREAK PATTERN
;        D  - VOLUME SLiDE
;        DF - FINE VOLUME SLIDE
;        E  - PORTAMENTO DOWN
;        EF - FINE PORTA DOWN
;        EE - EXTRA FINE PORTA DOWN
;        F  - PORTAMENTO UP
;        FF - FINE PORTA UP
;        FE - EXTRA FINE PORTA UP
;        G  - TONE PORTAMENTO                       
;        H  - ViBRATO
;        J  - ARPEGGIO
;        K  - ViBRATO WiTH VOLUME SLiDE
;        L  - TONE PORTAMENTO WiTH VOLUME SLiDE
;        O  - SAMPLE OFFSET
;        Q  - RETRIGGER NOTE
;        T  - TEMPO
;        V  - SET GLOBAL VOLUME
;        X  - SET DMP PAN
;        S1 - GLISSANDO CONTROL                     
;        S8 - SET PAN
;        SC - NOTE CUT
;        SD - NOTE DELAY
;        SE - PATTERN DELAY
;
;

PUBLiC          S3MPLAY
PUBLiC          REALPATPOiNTER
PUBLiC          PATTERNPOiNTER
PUBLiC          ORDERPOiNTER
PUBLiC          PATTERNNUM
PUBLiC          SONGOFFSET
PUBLiC          U_BASE
PUBLIC          TEMPO
PUBLIC          CURRSPEED
PUBLIC          VOLL
PUBLIC          NUMOFCHANNELS
PUBLIC          COM1
PUBLIC          OPE1
PUBLIC          NOTE
PUBLIC          MASTERVOLUME

CODE            SEGMENT
.386
ASSUME          CS:CODE

S3MPLAY:JMP     SELECTOR

;

COPYRiGHT       DB 10,13,10,13,' ************************************'
                DB '******************************************',10,13
                DB ' ************** S3M/GUS PLAYER DRiVER v3.94 '
                DB 'BY CYBERDANCER/SHOCK! *************',10,13
                DB ' ********************************************'
                DB '**********************************'

REALPATPOINTER  DW 000
ORDERPOiNTER    DW 000
PATTERNNUM      DW 000
SONGOFFSET      DW 000
COUNTER         DB 000
PATTERNPOiNTER  DW 000

NUMOFORDERS     EQU 20H
NUMOFSAMPLES    EQU 22H
NUMOFPATTERNS   EQU 24H
CHANNELCODES    EQU 40H
ORDERLiST       EQU 60H

SC_PAN          DB 32 DUP(0)
SC_VOL          DW 16 DUP(0)
SC_NOTE         DW 16 DUP(0)
SC_MODE         DB 32 DUP(0)
SC_START        DW 16 DUP(0)
SC_START2       DW 16 DUP(0)
SC_LOOPST       DW 16 DUP(0)
SC_LOOPST2      DW 16 DUP(0)
WAVESTART       DW 16 DUP(0)
WAVESTART2      DW 16 DUP(0)
REPLEN          DW 16 DUP(0)
REPLEN2         DW 16 DUP(0)
VOLL            DB 32 DUP(0)
LASTiNST        DW 16 DUP(0)
PERiOD          DW 16 DUP(0)
WAVECONTROL     DB 32 DUP(0)
ViBRATOPOS      DB 32 DUP(0)
COM1            DB 32 DUP(0)
OPE1            DB 32 DUP(0)
OLDPERiOD       DW 16 DUP(0)
TARGETPERiOD    DW 16 DUP(0)
NOTE            DW 16 DUP(0)
SAMPLEOFFSET    DB 32 DUP(0)
LASTVOLSLiDE    DB 32 DUP(0)
LASTPORTA       DB 32 DUP(0)
ViBRATOCMD      DB 32 DUP(0)
GLISSFUNK       DB 32 DUP(0)
TONEPORTSPEED   DW 16 DUP(0)

FILEOFFSET      DD 000
SONGNAMESEG     DW 000
GUSPOS          DD 000
INSSEG          DW 000
PATTERNSiZE     DW 000
PATTDELAYTiME   DB 000
PATTDELAYTiME2  DB 000
U_BASE          DW 000
U_VOiCE         DW 000
U_COMMAND       DW 000
U_DATAHi        DW 000
U_DATALO        DW 000
U_STATUS        DW 000
PBREAKPOSiTiON  DB 000
POSJUMPASSERT   DB 000
PBREAKFLAG      DB 000
SAMPLEiNFOMAP   DW 000
PATTERNSEGMAP   DW 000
NUMOFCHANNELS   DW 000
PLAYiNG         DB 000
OLDiNT8         DW 0,0
PROCESSCHANNEL  DW 000
THiNGSTODO      DB 000
GOTNOTE         DB 000
SMPBEGiN        DW 000
NOTEBYTE        DB 000
TEMPO           DB 125
TEMPODEFA       DB 125
CURRSPEED       DB 006
GLVOLUME        DB 063
ViBFiX          DW 010
MASTERVOLUME    DB 64
BiGNUM          DD 2982950

ViBRATOTABLE    DB 0000,0024,0049,0074,0097,0120,0141,0161
                DB 0180,0197,0212,0224,0235,0244,0250,0253
                DB 0255,0253,0250,0244,0235,0224,0212,0197
                DB 0180,0161,0141,0120,0097,0074,0049,0024
                DB 0000,0000,0000,0000,0000,0000,0000,0000
PERiODTABLE     DW 1712,1712,1712,1712,1712,1712,1712,1712
                DW 1712,1712,1712,1712,1712,1712,1712,1712
                DW 1712,1712,1712,1712,1712,1712,1712,1712
                DW 1712,1712,1712,1712,1712,1712,1712,1712
                DW 1712,1601,1518,1423,1366,1280,1200,1138
                DW 1067,1024,0960,0910,0000,0000,0000,0000
                DW 0856,0808,0762,0720,0678,0640,0604,0570
                DW 0538,0508,0480,0453,0000,0000,0000,0000
                DW 0428,0404,0381,0360,0339,0320,0302,0285
                DW 0269,0254,0240,0226,0000,0000,0000,0000
                DW 0214,0202,0190,0180,0170,0160,0151,0143
                DW 0135,0127,0120,0113,0000,0000,0000,0000
                DW 0106,0100,0095,0089,0085,0080,0075,0071
                DW 0066,0064,0060,0057,0000,0000,0000,0000
                DW 0053,0050,0047,0044,0042,0040,0038,0035
                DW 0033,0032,0030,0028,0000,0000,0000,0000
PERiODTABLE2    DW 0856,0808,0762,0720,0678,0640,0604,0570
                DW 0538,0508,0480,0453,0428,0404,0381,0360
                DW 0339,0320,0302,0285,0269,0254,0240,0226
                DW 0214,0202,0190,0180,0170,0160,0151,0143
                DW 0135,0127,0120,0113,0000,0856,0808,0762
                DW 0720,0678,0640,0604,0570,0538,0508,0480
                DW 0453,0428,0404,0381,0360,0339,0320,0302
                DW 0285,0269,0254,0240,0226,0214,0202,0190
                DW 0180,0170,0160,0151,0143,0135,0127,0120
                DW 0113,0106,0100,0095,0089,0085,0080,0075
                DW 0071,0066,0064,0060,0057,0000,0000,0000
MT_VOLTABLE     DW 01500H,09300h,0A900h,0B400h,0BC00h,0C180h
                DW 0C580h,0C980h,0CD80h,0CF40h,0D240h,0D440h
                DW 0D640h,0D840h,0DA40h,0DC40h,0DE40h,0DEF0h
                DW 0DFA0h,0E1A0h,0E2A0h,0E3A0h,0E4A0h,0E5A0h
                DW 0E6A0h,0E7A0h,0E8A0h,0E9A0h,0EAA0h,0EBA0h
                DW 0ECA0h,0EDA0h,0EEA0h,0EEF0h,0EFE0h,0EF60h
                DW 0F1E0h,0F160h,0F1E0h,0F260h,0F2E0h,0F360h
                DW 0F3E0h,0F460h,0F4E0h,0F560h,0F5E0h,0F660h
                DW 0F6E0h,0F760h,0F7E0h,0F860h,0F8E0h,0F960h
                DW 0F9E0h,0FA60h,0FAF0h,0FB70h,0FBF0h,0FC70h
                DW 0FCF0h,0FD70h,0FD90h,0FDB0h,0FDD0h,00000H
NOTS3M          DB 'THiS iS NOT AN S3M FiLE!$'

;

JUMPTABLE       DW OFFSET iNSTALL_GUS
                DW OFFSET iNSTALLMUZAK
                DW OFFSET TURNONMUZAK
                DW OFFSET TURNOFFMUZAK
                DW OFFSET CHANGEGLVOLUME
                DW OFFSET POLLMUSiC
                DW OFFSET DATAPLACE

;

SELECTOR:
        PUSH    AX
        PUSH    BP
        PUSH    Si
        PUSH    Di
        PUSH    DS
        PUSH    ES
        SHL     BX,1
        CALL    CS:[BX+JUMPTABLE]
        POP     ES
        POP     DS
        POP     Di
        POP     Si
        POP     BP
        POP     AX
        RETF

DATAPLACE:
        MOV     CX,CS
        LEA     DX,PATTERNPOiNTER
        RET

iNSTALL_GUS:
        CALL    DETECTGUS
        MOV     DX,[CS:U_BASE]
        ADD     DX,102H
        MOV     [CS:U_VOiCE],DX
        iNC     DX
        MOV     [CS:U_COMMAND],DX
        iNC     DX
        MOV     [CS:U_DATALO],DX
        iNC     DX
        MOV     [CS:U_DATAHi],DX
        MOV     DX,[CS:U_BASE]
        ADD     DX,6
        MOV     [CS:U_STATUS],DX
        CALL    U_RESET
        ;call    ultrareset
        ;call    ultrareset0
        RET

UDELAY: PUSH    DX AX
        MOV     DX,300H
        iN      AL,DX
        iN      AL,DX
        iN      AL,DX
        iN      AL,DX
        iN      AL,DX
        iN      AL,DX
        iN      AL,DX
        POP     AX DX
        RET

U_RESET:CLi
        MOV     BX,[CS:U_COMMAND]
        MOV     CX,[CS:U_DATAHi]
        MOV     DX,BX
        MOV     AL,4CH
        OUT     DX,AL
        MOV     DX,CX
        MOV     AL,0
        OUT     DX,AL
        CALL    UDELAY
        CALL    UDELAY
        MOV     DX,BX
        MOV     AL,4CH
        OUT     DX,AL
        MOV     DX,CX
        MOV     AL,1
        OUT     DX,AL
        CALL    UDELAY
        CALL    UDELAY
        MOV     DX,[CS:U_VOiCE]
        ADD     DX,100H
        MOV     AL,3
        OUT     DX,AL
        CALL    UDELAY
        MOV     DX,[CS:U_VOiCE]
        ADD     DX,100H
        MOV     AL,0
        OUT     DX,AL
        MOV     DX,BX
        MOV     AL,41H
        OUT     DX,AL
        MOV     DX,CX
        MOV     AL,0
        OUT     DX,AL
        MOV     DX,BX
        MOV     AL,45H
        OUT     DX,AL
        MOV     DX,CX
        MOV     AL,0
        OUT     DX,AL
        MOV     DX,BX
        MOV     AL,49H
        OUT     DX,AL
        MOV     DX,CX
        MOV     AL,0
        OUT     DX,AL
        MOV     DX,BX
        MOV     AL,0EH
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,15
        OR      AL,0C0H
        OUT     DX,AL
        MOV     DX,[CS:U_STATUS]
        iN      AL,DX
        MOV     DX,BX
        MOV     AL,41H
        OUT     DX,AL
        MOV     DX,CX
        iN      AL,DX
        MOV     DX,BX
        MOV     AL,49H
        OUT     DX,AL
        MOV     DX,CX
        iN      AL,DX
        MOV     DX,BX
        MOV     AL,8FH
        OUT     DX,AL
        MOV     DX,CX
        iN      AL,DX
        PUSH    BX CX
        MOV     CX,0
@@VOiCECLEARLOOP:
        MOV     DX,[CS:U_VOiCE]
        MOV     AL,CL
        OUT     DX,AL
        iNC     DX
        MOV     AL,9
        OUT     DX,AL
        iNC     DL
        MOV     AX,0
        OUT     DX,AX
        DEC     DL
        MOV     AL,0
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,3                    ; TURN VOiCE OFF
        OUT     DX,AL
        SUB     DX,2
        MOV     AL,0DH
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,3
        OUT     DX,AL
        SUB     DX,2
        iNC     CX
        CMP     CX,31
        JNZ     @@VOiCECLEARLOOP
        POP     CX BX
        MOV     DX,BX
        MOV     AL,41H
        OUT     DX,AL
        MOV     DX,CX
        iN      AL,DX
        MOV     DX,BX
        MOV     AL,49H
        OUT     DX,AL
        MOV     DX,CX
        iN      AL,DX
        MOV     DX,BX
        MOV     AL,8FH
        OUT     DX,AL
        MOV     DX,CX
        iN      AL,DX
        MOV     DX,BX
        MOV     AL,4CH
        OUT     DX,AL
        MOV     DX,CX
        MOV     AL,7
        OUT     DX,AL
        STi
        RET

TURNONMUZAK:
        CMP     PLAYiNG,0
        JE      GOTOSTART
        RET
GOTOSTART:
        MOV     PLAYiNG,1
        CLi
        XOR     AX,AX
        MOV     ES,AX
        MOV     AX,ES:[20H]
        MOV     BX,ES:[22H]
        MOV     OLDiNT8,AX
        MOV     OLDiNT8+2,BX
        MOV     AX,OFFSET NEWiNT8
        MOV     ES:[20H],AX
        MOV     AX,CS
        MOV     ES:[22H],AX
        MOV     AL,54
        OUT     43H,AL
        MOV     AX,23863        ;1193181/50     ;HZ
        OUT     40H,AL
        MOV     AL,AH
        OUT     40H,AL
        MOV     DX,U_BASE
        MOV     AL,1
        OUT     DX,AL           ;NO LINE IN
        MOV     AL,TEMPODEFA
        CALL    SETTEMPO
        RET

TURNOFFMUZAK:
        CMP     PLAYiNG,1
        JE      GOTOSTOP
        RET
GOTOSTOP:
        MOV     PLAYiNG,0
        CLi
        MOV     AL,54
        OUT     43H,AL
        MOV     AL,0
        OUT     40H,AL
        OUT     40H,AL
        MOV     AX,CS
        MOV     DS,AX
        XOR     AX,AX
        MOV     ES,AX
        MOV     AX,OLDiNT8
        MOV     BX,OLDiNT8+2
        MOV     ES:[20H],AX
        MOV     ES:[22H],BX

        MOV     AL,54
        OUT     43H,AL
        MOV     AX,0    ;18HZ
        OUT     40H,AL
        MOV     AL,AH
        OUT     40H,AL
        MOV     AL,0B6H
        OUT     43H,AL
        MOV     AX,533H
        OUT     42H,AL
        MOV     AL,AH
        OUT     42H,AL
        iN      AL,61H
        AND     AL,0FCH
        OUT     61H,AL
        CALL    GUSKUSS
        MOV     DX,U_BASE
        MOV     AL,2
        OUT     DX,AL           ;LINE IN ENABLED
        RET

iNSTALLMUZAK:
        MOV     CS:[SONGNAMESEG],DS
        MOV     CS:[SONGOFFSET],ES
        PUSHA
        CALL    iNSTALL_GUS
        CALL    RESETDATAS
        POPA
        CMP     AX,1
        JNE     NOLOADS
        JMP     INST2
NOLOADS:MOV     DS,CS:[SONGOFFSET]
        XOR     BX,BX
COUNTCHANS:
        CMP     BYTE PTR DS:[CHANNELCODES+BX],0FFH
        JE      NMCHANNELS
        iNC     BX
        JMP     COUNTCHANS
NMCHANNELS:
        MOV     NUMOFCHANNELS,BX
        MOV     AX,DS:[NUMOFORDERS]
        ADD     AX,60H
        MOV     SAMPLEiNFOMAP,AX
        MOV     BX,DS:[NUMOFSAMPLES]
        ADD     BX,BX
        ADD     AX,BX
        MOV     PATTERNSEGMAP,AX
        MOV     AL,DS:[32H]                     ;iNiTiAL TEMPO
        MOV     CS:TEMPODEFA,AL
        MOV     AL,DS:[31H]                     ;iNiTiAL SPEED
        MOV     CS:CURRSPEED,AL
        MOV     DS,SONGOFFSET
        CALL    COUNTORDERS
        MOV     CX,16
        XOR     Si,Si
        XOR     BP,BP
BALANCESET:
        CMP     BYTE PTR DS:[CHANNELCODES+Si],8
        JB      LEFTCH
        MOV     BYTE PTR CS:[SC_PAN+BP],0FH
        JMP     SRR
LEFTCH: MOV     BYTE PTR CS:[SC_PAN+BP],0
SRR:    iNC     Si
        ADD     BP,2
        LOOP    BALANCESET
        MOV     BX,SAMPLEiNFOMAP
        MOV     CX,DS:[NUMOFSAMPLES]
        MOV     Si,DS:[BX]
        SHL     Si,4
        MOV     DX,DS:[Si+14]
        MOV     SMPBEGiN,DX
LOWNEXT:PUSH    CX
        MOV     Si,DS:[BX]
        SHL     Si,4
        SUB     DS:[Si+14],DX
        ADD     BX,2
        POP     CX
        LOOP    LOWNEXT
        MOV     CX,DS:[NUMOFSAMPLES]
        MOV     BX,SAMPLEiNFOMAP
DMPG:   PUSH    CX
        MOV     Si,DS:[BX]
        SHL     Si,4
        MOV     CX,DS:[Si+16]
        MOV     AX,DS:[Si+14]
        CALL    DUMPTOGUSRAM
        POP     CX
        ADD     BX,2
        LOOP    DMPG
        RET

; DUMP FOR TYPE 1 (ALREADY LOADED SAMPLES) 

DUMPTOGUSRAM:                         ;AX - SEGMENT FROM,   CX - SiZE
        OR      CX,CX
        JE      NODMP
        PUSH    BX BP DX Si
        MOV     BX,AX
        ADD     BX,SMPBEGiN
        ADD     BX,SONGOFFSET
        MOV     ES,BX
        MOV     BX,AX
        XOR     BP,BP
        RCL     BX,1
        RCL     BP,1
        RCL     BX,1
        RCL     BP,1
        RCL     BX,1
        RCL     BP,1
        RCL     BX,1
        RCL     BP,1
        MOV     Si,BP
        MOV     Di,BX
        XOR     BX,BX

LPDMP:  CLi
        PUSH    CX
        MOV     DX,U_COMMAND
        MOV     AL,44H
        OUT     DX,AL
        ADD     DX,2
        PUSH    AX
        MOV     AX,Si
        OUT     DX,AL
        POP     AX
        SUB     DX,2
@@MAiNLOOP:
        MOV     AL,43H
        OUT     DX,AL
        iNC     DX
        PUSH    AX
        MOV     AX,Di
        OUT     DX,AX
        POP     AX
        DEC     DX
@@DUMPBYTE:
        ADD     DX,4
        MOV     AL,ES:[BX]
        ADD     AL,128
        iNC     BX
        OUT     DX,AL
        SUB     DX,4
        ADD     Di,1
        JNC     @@DOLOOP
        iNC     Si
        MOV     AL,44H
        OUT     DX,AL
        ADD     DX,2
        PUSH    AX
        MOV     AX,Si
        OUT     DX,AL
        POP     AX
        SUB     DX,2
@@DOLOOP:
        LOOP    @@MAiNLOOP
        POP     CX
        STi
        POP     Si DX BP BX
NODMP:  RET

RESETDATAS:
        MOV     ORDERPOiNTER,0
        MOV     PATTERNPOiNTER,0
        MOV     REALPATPOINTER,0
        MOV     CURRSPEED,6H
        MOV     AL,TEMPODEFA
        MOV     TEMPO,AL
        RET

; SECOND TYPE: LOAD S3M TOO 

iNST2:  MOV     CS:FILEOFFSET,ECX
        MOV     DS,CS:[SONGNAMESEG]
        MOV     DX,Si
        CALL    OPENFiLE             ; OPEN THE S3M
        MOV     DS,CS:SONGOFFSET
        MOV     DX,0
        MOV     ECX,CS:FILEOFFSET
        CALL    LSEEK
        MOV     ECX,96               ; HEADERSiZE
        CALL    READFiLE             ; LOAD HEADER OF S3M
        CMP     WORD PTR DS:[44],'CS'
        JE      EZS3M                ; OKAY, S3M
        CALL    CLOSEFiLE
        PUSH    CS
        POP     DS
        LEA     DX,NOTS3M            ; PRiNT ERROR MSG
        MOV     AH,9
        iNT     21H
        MOV     AX,4C00H             ; EXiT TO DOS
        iNT     21H
EZS3M:  MOV     CX,WORD PTR DS:[20H]
        MOV     DX,96                ; ENNYIT OLVASTUNK BE EDDIG
        CALL    READFILE             ; READING ORDERS
        ADD     DX,AX                ; INCREASE MEMPOINTER
        MOV     CX,WORD PTR DS:[22H]
        SHL     CX,1
        CALL    READFILE             ; READING INSTRUMENT POINTERS
        MOV     SI,DX
        MOV     CX,WORD PTR DS:[SI]
        MOV     CS:INSSEG,CX
        ADD     DX,AX
        MOV     CX,WORD PTR DS:[24H]
        SHL     CX,1
        CALL    READFILE             ; READING PATTERN POINTERS
        ADD     DX,AX
        MOV     CX,CS:INSSEG
        SHL     CX,4
        SUB     CX,DX
        CALL    READFILE             ; SOME EXTRA SHIT
        ADD     DX,AX
        MOV     CX,WORD PTR DS:[22H]
        MOV     AX,CX
        SHL     CX,6                 ; INSNUM * 80
        SHL     AX,4
        ADD     CX,AX
        CALL    READFILE             ; READING INSTRUMENTS
        MOV     SI,DX
        ADD     DX,AX
INSSEEK:MOVZX   ECX,WORD PTR DS:[SI+14] ; GET 1ST REAL INSTR PLACE
        CMP     ECX,0
        JNE     OKINS1
        ADD     SI,80
        JMP     INSSEEK              ; NOT A REAL INSTRUMENT (0 BYTES LONG!)
OKINS1: SHL     ECX,4
        MOVZX   EDX,DX
        SUB     ECX,EDX
        PUSH    ECX
        CALL    READFILE             ; READ ALL THE PATTERNS
        POP     ECX
        ADD     EDX,ECX
        MOV     AX,DS
        SHR     EDX,4
        ADD     AX,DX
        MOV     DS,AX
        MOV     CS:INSSEG,AX         ; IDE LEHET TOLTENI A HANGSZEREKET
        PUSH    CS
        POP     DS
        CALL    iNSTALL_GUS          ; iNiTiALiZE GUS
        CALL    RESETDATAS           ; AND VARiABLES TOO
        MOV     DS,CS:SONGOFFSET
        XOR     BX,BX
COUNTCHANS_iNST2:
        CMP     BYTE PTR DS:[CHANNELCODES+BX],0FFH
        JE      NMCHANNELS_iNST2
        iNC     BX
        JMP     COUNTCHANS_iNST2
NMCHANNELS_iNST2:
        MOV     CS:[NUMOFCHANNELS],BX
        MOV     AX,DS:[NUMOFORDERS]
        ADD     AX,60H
        MOV     SAMPLEiNFOMAP,AX
        MOV     BX,DS:[NUMOFSAMPLES]
        ADD     BX,BX
        ADD     AX,BX
        MOV     CS:[PATTERNSEGMAP],AX
        MOV     AL,DS:[32H]                     ;iNiTiAL TEMPO
        MOV     CS:TEMPODEFA,AL
        MOV     AL,DS:[31H]                     ;iNiTiAL SPEED
        MOV     CS:[CURRSPEED],AL
        MOV     DS,CS:[SONGOFFSET]
        CALL    COUNTORDERS
        MOV     CX,16
        XOR     Si,Si
        XOR     BP,BP
BALANCESET_iNST2:
        CMP     BYTE PTR DS:[CHANNELCODES+Si],8
        JB      LEFTCH2
        MOV     BYTE PTR CS:[SC_PAN+BP],0FH
        JMP     SRR2
LEFTCH2:MOV     BYTE PTR CS:[SC_PAN+BP],00
SRR2:   iNC     Si
        ADD     BP,2
        LOOP    BALANCESET_iNST2
        MOV     BX,CS:SAMPLEiNFOMAP
        MOV     CX,DS:[NUMOFSAMPLES]
        MOV     Si,DS:[BX]
        SHL     Si,4
        MOV     DX,DS:[Si+14]
        MOV     CS:[SMPBEGiN],DX
        MOV     CX,DS:[NUMOFSAMPLES]
        MOV     BX,CS:[SAMPLEiNFOMAP]
DMPG2:  PUSH    CX
        MOV     Si,DS:[BX]
        SHL     Si,4
        MOVZX   ECX,WORD PTR DS:[Si+14] ; DATAS FOR SEEKiNG
        SHL     ECX,4                   ; CALC OFFSET
        ADD     ECX,CS:FILEOFFSET
        CALL    LSEEK
        MOV     CX,DS:[Si+16]           ; GET LENGTH OF SAMPLE
        PUSH    DS DX CX BX
        MOV     DX,0
        MOV     DS,CS:iNSSEG
        CALL    READFiLE                ; LOAD ONE SAMPLE
        POP     BX CX DX DS
        MOVZX   EAX,WORD PTR DS:[Si+14]
        SHL     EAX,4
        MOV     CS:[GUSPOS],EAX         ; CALC PLACE iN GRAViS TOO
        CALL    LOADSAMPLE              ; LOAD iT
        POP     CX
        ADD     BX,2
        LOOP    DMPG2                   ; NEXT SAMPLE
        CALL    CLOSEFiLE               ; WE DiD iT :-)
        RET

LOADSAMPLE:
        CMP     CX,0
        JE      NOUPLOAD
        PUSHAD
        MOV     ES,CS:[iNSSEG]
        XOR     EDX,EDX
        MOV     EDi,ECX
        MOV     ECX,CS:[GUSPOS]
        MOV     ESi,EDX
        XOR     EBP,EBP
        MOV     DX,CS:[U_BASE]
        ADD     DX,0103H
NBYTE:  MOV     EBX,ECX
        MOV     AL,43H
        OUT     DX,AL
        iNC     DX
        MOV     AX,BX
        OUT     DX,AX
        DEC     DX
        MOV     AL,44H
        OUT     DX,AL
        SHR     EBX,16
        MOV     AL,BL
        iNC     DX
        iNC     DX
        OUT     DX,AL
        iNC     DX
        iNC     DX
        MOV     AL,BYTE PTR ES:[EBP]
        SUB     AL,80H
        OUT     DX,AL
        SUB     DX,4
        iNC     ECX
        iNC     EBP
        CMP     EBP,EDi
        JNE     NBYTE
        POPAD
        PUSHA
        MOV     AH,2
        MOV     DL,254
        iNT     21H
        POPA
NOUPLOAD:
        RET

; THIS ROUTINE WILL BE POLLED 

NEWiNT8:
        PUSHF
        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    BP
        PUSH    Si
        PUSH    Di
        PUSH    DS
        PUSH    ES
        CLD
        CALL    POLLMUSiC
        POP     ES
        POP     DS
        POP     Di
        POP     Si
        POP     BP
        POP     DX
        POP     CX
        POP     BX
        MOV     AL,20H
        OUT     20H,AL
        POP     AX
        POPF
        iRET

;

SETVOiCE MACRO
        MOV     DX,U_VOiCE
        MOV     AX,BP
        SHR     AX,1
        OUT     DX,AL
ENDM    SETVOiCE

PLAYVOL MACRO
        LOCAL   DONE
        MOV     DX,U_COMMAND
        MOV     AL,89H
        OUT     DX,AL
        iNC     DL
        iN      AX,DX
        CMP     AX,[BP+SC_VOL]
        JZ      DONE
        MOV     AX,[BP+SC_VOL]
        CALL    SLiDERAMP
DONE:
ENDM    PLAYVOL

PLAYNOTE MACRO
        LOCAL   DONE
        MOV     DX,U_COMMAND
        ;MOV     AL,81H
        ;OUT     DX,AL
        ;iNC     DL
        ;iN      AX,DX
        ;CMP     AX,[BP+SC_NOTE]
        ;JZ      DONE
        ;DEC     DL
        MOV     AL,1
        OUT     DX,AL
        iNC     DL
        MOV     AX,[BP+SC_NOTE]
        OUT     DX,AX
DONE:
ENDM    PLAYNOTE

RSHiFT: MOV     BX,CX
        SHR     AX,7
        SHR     CX,7
        SHL     BX,9
        OR      AX,BX
        RET
DOiNS:  CMP     SC_START2[BP],0F000H
        JNZ     DOVOiCE
        JMP     NOVOiCE
DOVOiCE:
        MOV     AL,0
        CALL    DORAMP
        MOV     DX,U_COMMAND
        MOV     AL,0
        OUT     DX,AL
        MOV     AL,3
        ADD     DX,2
        OUT     DX,AL
        MOV     DX,U_VOiCE
        MOV     AX,BP
        SHR     AX,1
        OUT     DX,AL
DOBEGiN:
        MOV     DX,U_COMMAND
        MOV     AL,0AH
        OUT     DX,AL
        iNC     DX
        MOV     AX,SC_START[BP]
        MOV     CX,SC_START2[BP]
        CALL    RSHiFT
        OUT     DX,AX
        DEC     DX
        MOV     AL,0BH
        OUT     DX,AL
        iNC     DX
        MOV     AX,SC_START[BP]
        SHL     AX,9
        OUT     DX,AX
        MOV     DX,U_COMMAND
        MOV     AL,2
        OUT     DX,AL
        iNC     DX
        MOV     AX,SC_LOOPST[BP]
        MOV     CX,SC_LOOPST2[BP]
        CALL    RSHiFT
        OUT     DX,AX
        DEC     DX
        MOV     AL,3
        OUT     DX,AL
        iNC     DX
        MOV     AX,SC_LOOPST[BP]
        SHL     AX,9
        OUT     DX,AX
        MOV     DX,U_COMMAND
        MOV     AL,4
        OUT     DX,AL
        iNC     DX
        MOV     AX,REPLEN[BP]
        MOV     CX,REPLEN2[BP]
        CALL    RSHiFT
        OUT     DX,AX
        DEC     DX
        MOV     AL,5
        OUT     DX,AL
        iNC     DX              ; 104H
        MOV     AX,REPLEN[BP]
        SHL     AX,9
        OUT     DX,AX
        DEC     DX              ; 103H
        MOV     AL,0
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,SC_MODE[BP]
        OUT     DX,AL
SETGENERAL:
        CALL    PERNOP
        MOV     DX,U_COMMAND
        MOV     AL,0CH
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,SC_PAN[BP]
        OUT     DX,AL
        JMP     BOTTOM
NOVOiCE:
        MOV     AL,0
        CALL    DORAMP
        MOV     AL,0
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,3
        OUT     DX,AL
BOTTOM: RET

POLLMUSiC:
        PUSH    CS
        POP     DS
        iNC     COUNTER
        MOV     AL,COUNTER
        CMP     AL,CURRSPEED
        JB      DOFX
        JMP     KOVSOR
DOFX:   JMP     COMMANDREL

KOVSOR: MOV     COUNTER,0
        CMP     PATTDELAYTiME2,0
        JE      GETNOTEN
        CALL    DOFX
        JMP     DSKiP
GETNOTEN:
        MOV     ES,SONGOFFSET
        MOV     Si,ORDERPOiNTER
        MOV     BL,ES:[Si+ORDERLiST]
        CMP     BL,254
        JNE     NOPLUSZ
        iNC     ORDERPOiNTER
        JMP     GETNOTEN
NOPLUSZ:CMP     BL,255
        JNE     NOADDiE
        JMP     OVERP
NOADDiE:XOR     BH,BH
        MOV     PATTERNNUM,BX
        SHL     BX,1
        MOV     Di,PATTERNSEGMAP
        MOV     AX,ES:[BX+Di]
        ADD     AX,SONGOFFSET
        MOV     DS,AX
        MOV     Si,PATTERNPOiNTER
        OR      Si,Si
        JNE     NOTFiRSTROW
        LODSW
        MOV     PATTERNSiZE,AX
NOTFiRSTROW:
        CALL    CHANNELPROCi
DSKiP:  MOV     PATTERNPOiNTER,Si
        INC     REALPATPOINTER
        MOV     AL,PATTDELAYTiME
        OR      AL,AL
        JE      NODELY
        MOV     PATTDELAYTiME2,AL
        MOV     PATTDELAYTiME,0
NODELY: CMP     PATTDELAYTiME2,0
        JZ      DSKA
        DEC     PATTDELAYTiME2
        JZ      DSKA
        SUB     PATTERNPOiNTER,16
        SUB     REALPATPOINTER,16
DSKA:   CMP     PBREAKFLAG,0
        JE      NNPYSK
        MOV     PBREAKFLAG,0
        MOV     AL,PBREAKPOSiTiON
        XOR     AH,AH
        SHL     AX,4
CONTBRK:MOV     PATTERNPOiNTER,AX
        MOV     REALPATPOINTER,AX
        MOV     PBREAKPOSiTiON,0
NNPYSK: CMP     Si,PATTERNSiZE
        JAE     NEXTPATTERN
        CMP     POSJUMPASSERT,1
        JE      NEXTPATTERN
        RET
NEXTPATTERN:
        MOV     AL,PBREAKPOSiTiON
        XOR     AH,AH
        SHL     AX,4
        MOV     PATTERNPOiNTER,AX
        MOV     REALPATPOINTER,AX
        MOV     PBREAKPOSiTiON,0
        MOV     POSJUMPASSERT,0
        MOV     ES,SONGOFFSET
        iNC     ORDERPOiNTER
        MOV     AX,ORDERPOiNTER
        CMP     AX,ES:[NUMOFORDERS]
        JB      NEMOVER
OVERP:  CALL    RESETDATAS
        MOV     PATTDELAYTiME,0
        MOV     PATTDELAYTiME2,0
        MOV     AL,TEMPODEFA
        CALL    SETTEMPO
        PUSH    ES CS
        POP     ES
        MOV     AX,0
        MOV     CX,80
        LEA     Di,COM1
        REP     STOSW
        POP     ES
NEMOVER:RET

CHANNELPROCi:
        MOV     CX,NUMOFCHANNELS
        XOR     BX,BX
CLEARR:
        MOV     WORD PTR COM1[BX],0
        MOV     NOTE[BX],0
        SHL     BX,1
        SHR     BX,1
        ADD     BX,2
        LOOP    CLEARR

CHANNELREPEAT:
        LODSB
        OR      AL,AL
        JNE     MOREDATAiN
        RET
MOREDATAiN:
        PUSH    AX
        AND     AX,0FH  ;1F -> UP TO 32 CHANNELS
        SHL     AX,1
        MOV     BP,AX
        MOV     PROCESSCHANNEL,BP
        POP     AX
        SHR     AX,5
        AND     AX,7
        MOV     THiNGSTODO,AL

        MOV     CX,PROCESSCHANNEL
        SHR     CX,1
        SETVOiCE
        TEST    THiNGSTODO,1
        JE      NONOTEANDSAM
        PUSH    DS
        CALL    GETNOTEANDSAM
        POP     DS
NONOTEANDSAM:
        TEST    THiNGSTODO,2
        JE      NOVOLSET
        CALL    GETVOLUMESET
NOVOLSET:
        TEST    THiNGSTODO,4
        JE      NOEFFX
        CALL    GETEFFECT
NOEFFX:
        CALL    PERNOP
        CMP     GOTNOTE,0
        JE      NODU
        CALL    DOiNS
NODU:   MOV     GOTNOTE,0
        PUSH    DS Si
        PLAYNOTE
        PLAYVOL
        POP     Si DS
        JMP     CHANNELREPEAT

GETNOTEANDSAM:
        LODSB
        MOV     NOTEBYTE,AL
        CMP     AL,0FEH
        JNE     GOODNOTE
        iNC     Si              ;READ iNS>NULL
        RET
GOODNOTE:
        LODSB
        XOR     AH,AH
        OR      AL,AL
        JNE     NOLASTSAM
        MOV     AX,LASTiNST[BP]
        MOV     SC_MODE[BP],0
        DEC     AX
        MOV     Di,AX
        SHL     Di,1
        MOV     ES,SONGOFFSET
        MOV     BX,SAMPLEiNFOMAP
        MOV     Di,ES:[BX+Di]
        SHL     Di,4
        MOV     AL,ES:[Di+28]
        CMP     NOTEBYTE,0FFH
        JNE     CONTiSET
        RET
NOLASTSAM:
        MOV     LASTiNST[BP],AX
        MOV     SC_MODE[BP],0
        DEC     AX
        MOV     Di,AX
        SHL     Di,1
        MOV     ES,SONGOFFSET
        MOV     BX,SAMPLEiNFOMAP
        MOV     Di,ES:[BX+Di]
        SHL     Di,4
        MOV     AL,ES:[Di+28]
        MOV     VOLL[BP],AL
        CALL    VOLEQU
        CMP     NOTEBYTE,0FFH
        JNE     CONTiSET
        RET
CONTiSET:
        MOV     AX,ES:[Di+14]
        XOR     DX,DX
        RCL     AX,1
        RCL     DX,1
        CLC
        RCL     AX,1
        RCL     DX,1
        CLC
        RCL     AX,1
        RCL     DX,1
        CLC
        RCL     AX,1
        RCL     DX,1
        MOV     SC_START[BP],AX
        MOV     SC_START2[BP],DX
        TEST    BYTE PTR ES:[Di+31],1   ;LOOP FLAG
        JE      NOLOOP
        OR      SC_MODE[BP],00001000B
        MOV     CX,ES:[Di+20]
        OR      CX,CX
        JE      LOOPNOFiX
        DEC     CX
LOOPNOFiX:
        MOV     AX,SC_START[BP]
        MOV     DX,SC_START2[BP]
        ADD     AX,CX
        ADC     DX,0
        MOV     SC_LOOPST[BP],AX
        MOV     SC_LOOPST2[BP],DX
        MOV     WAVESTART[BP],AX
        MOV     WAVESTART2[BP],DX
        MOV     CX,ES:[Di+24]
        DEC     CX
        MOV     AX,SC_START[BP]
        MOV     DX,SC_START2[BP]
        ADD     AX,CX
        ADC     DX,0
        MOV     REPLEN[BP],AX
        MOV     REPLEN2[BP],DX
        JMP     SETREGS
NOLOOP: MOV     AX,SC_START[BP]
        MOV     DX,SC_START2[BP]
        MOV     SC_LOOPST[BP],AX
        MOV     SC_LOOPST2[BP],DX
        MOV     WAVESTART[BP],AX
        MOV     WAVESTART2[BP],DX
        MOV     CX,ES:[Di+16]
        DEC     CX
        ADD     AX,CX
        ADC     DX,0
        MOV     REPLEN[BP],AX
        MOV     REPLEN2[BP],DX
SETREGS:
        MOV     BL,NOTEBYTE
        XOR     BH,BH
        SHL     BX,1
        MOV     AX,PERiODTABLE[BX]
        MOV     BX,8200
        MUL     BX
        DiV     WORD PTR ES:[Di+32]
        MOV     BX,PERiOD[BP]
        MOV     OLDPERiOD[BP],BX
        MOV     NOTE[BP],AX
        MOV     PERiOD[BP],AX
        CALL    PERNOP
        MOV     GOTNOTE,1
        RET

GETVOLUMESET:
        LODSB
        MOV     VOLL[BP],AL
        CALL    VOLEQU
        RET

GETEFFECT:
        LODSB
        MOV     COM1[BP],AL
        MOV     AH,AL
        LODSB
        MOV     OPE1[BP],AL
        OR      AH,AH
        JNE     CHKCOM3
        RET
CHKCOM3:
        CMP     AH,1
        JE      SPDCH
        CMP     AH,2
        JE      POSJUMP
        CMP     AH,3
        JE      PATTBR
        CMP     AH,7
        JE      SETTONEPORTA
        CMP     AH,12
        JE      SETTONEPORTA
        CMP     AH,15
        JE      SAMOFFS
        CMP     AH,20
        JE      SETTEMPO
        RET

; COMMAND 1: CHANGE SPEED 

SPDCH:  AND     AL,0FFH
        JE      SPEEDNULL
        CMP     AL,32
        JB      NORMSPD
        RET
NORMSPD:
        MOV     CURRSPEED,AL
        MOV     COUNTER,0
SPEEDNULL:
        RET

; COMMAND 2: JUMP ORDER 

POSJUMP:
        DEC     AL
        XOR     AH,AH
        MOV     ORDERPOiNTER,AX
        MOV     POSJUMPASSERT,1
        RET

; COMMAND 3: PATTERN BREAK 

PATTBR: MOV     POSJUMPASSERT,1
        RET

; COMMAND 7: PORTA TO NOTE 

SETTONEPORTA:
        MOV     GOTNOTE,0
        CMP     NOTE[BP],0
        JE      REMG1
        MOV     BX,PERiOD[BP]
        MOV     TARGETPERiOD[BP],BX
        MOV     AX,OLDPERiOD[BP]
        MOV     PERiOD[BP],AX
        MOV     NOTE[BP],0
REMG1:  RET

; COMMAND 15: SAMPLE OFFSET 

SAMOFFS:XOR     AH,AH
        OR      AL,AL
        JZ      SONONEW
        MOV     SAMPLEOFFSET[BP],AL
SONONEW:MOV     EAX,0
        MOV     AH,SAMPLEOFFSET[BP]
        PUSH    BX DI ES AX
        MOV     AX,LASTiNST[BP]
        DEC     AX
        MOV     Di,AX
        SHL     Di,1
        MOV     ES,CS:[SONGOFFSET]
        MOV     BX,SAMPLEiNFOMAP
        MOV     Di,ES:[BX+Di]
        SHL     Di,4
        MOV     DX,ES:[Di+16]
        POP     AX ES DI BX
        CMP     DX,AX
        JA      SUCKOFF
        MOV     AX,DX
SUCKOFF:CMP     NOTE[BP],0
        JE      NOUJOFF
        ADD     SC_START[BP],AX
        ADC     SC_START2[BP],0
NOUJOFF:MOV     GOTNOTE,1
        RET

; COMMAND 20: SET TEMPO 

SETTEMPO:
        PUSH    AX BX DX
        CMP     AL,46
        JAE     OKTEMPO
        MOV     AL,125
OKTEMPO:MOV     TEMPO,AL
        MOV     AH,0
        MOV     BX,AX
        MOV     DX,WORD PTR CS:BiGNUM+2
        MOV     AX,WORD PTR CS:BiGNUM
        DiV     BX
        MOV     BX,AX
        CLi
        MOV     AL,00110100B
        OUT     43H,AL
        MOV     AL,BL
        OUT     40H,AL
        MOV     AL,BH
        OUT     40H,AL
        STi
        POP     DX BX AX
        RET

COMMANDREL:
        MOV     CX,NUMOFCHANNELS
        XOR     BP,BP
COMLOOP_:
        PUSH    CX
        SETVOiCE
        CALL    QUESTCOM
        PLAYNOTE
        PLAYVOL
deLYP:  POP     CX
        ADD     BP,2
        LOOP    COMLOOP_
        RET
JUMPS

QUESTCOM:                               ; HERE iS THE HEART OF THE PLAYER
        MOV     AL,COM1[BP]
        OR      AL,AL
        JNE     GHH2
        RET
GHH2:   CMP     AL,4
        JE      VOLSLiDE
        CMP     AL,5
        JE      PORTADOWN
        CMP     AL,6
        JE      PORTAUP
        CMP     AL,7
        JE      TONEPORTAMENTO
        CMP     AL,8
        JE      ViBRATO
        CMP     AL,10
        JE      ARPEGGiO
        CMP     AL,11
        JE      VOLSLiDEANDViBRATO
        CMP     AL,12
        JE      VOLSLiDEANDTONE
        CMP     AL,17
        JE      RETRIGGERNOTE
        CMP     AL,19
        JE      EXTRACOMMANDS
        CMP     AL,22
        JE      CHANGEGLVOLUME
        CMP     AL,24
        JE      DMPPAN
        RET

; COMMAND 4: VOLUME SLIDE 

VOLSLiDE:
        MOV     AL,OPE1[BP]
        OR      AL,AL
        JNE     NEWVLS
        MOV     AL,LASTVOLSLiDE[BP]
NEWVLS: MOV     LASTVOLSLiDE[BP],AL
        CMP     AL,0F0H
        JE      VOLSLIDEUP
        SHR     AL,4
        OR      AL,AL
        JE      VOLSLiDEDOWN
        CMP     AL,0FH
        JE      FINEVOLDOWN
VOLSLiDEUP:
        MOV     AL,LASTVOLSLiDE[BP]
        TEST    AL,0FH
        JNE     FiNEVOLUP
VOLSLiDEUP2:
        SHR     AL,4
        ADD     VOLL[BP],AL
        CMP     VOLL[BP],40H
        JB      VSUSKiP
        MOV     VOLL[BP],40H
VSUSKiP:MOV     AL,VOLL[BP]
        CALL    VOLEQU
        RET
VOLSLiDEDOWN:
        MOV     AL,LASTVOLSLiDE[BP]
        AND     AL,0FH
        SUB     VOLL[BP],AL
        CMP     VOLL[BP],0FFH
        JG      VSDSKiP
        MOV     VOLL[BP],0
VSDSKiP:MOV     AL,VOLL[BP]
        CALL    VOLEQU
        RET

FiNEVOLDOWN:
        MOV     COM1[BP],0
        JMP     VOLSLiDEDOWN
FiNEVOLUP:
        MOV     COM1[BP],0
        JMP     VOLSLiDEUP2

; COMMAND 5: PORTAMENTO DOWN 

PORTADOWN:
        MOV     AL,OPE1[BP]
        MOV     BL,AL
        SHR     BL,4
        CMP     BL,0FH
        JE      FINEPD
        CMP     BL,0EH
        JE      EFINEPD
        OR      AL,AL
        JNE     PD
        MOV     AL,LASTPORTA[BP]
PD:     MOV     LASTPORTA[BP],AL
FDOWN:  XOR     AH,AH
        ADD     PERiOD[BP],AX
        MOV     CX,PERiOD[BP]
        JMP     PERNOP2
FINEPD: AND     AL,0FH
        MOV     LASTPORTA[BP],0
        MOV     COM1[BP],0
        JMP     FDOWN
EFINEPD:AND     AL,0FH
        SHR     AL,2
        MOV     LASTPORTA[BP],0
        MOV     COM1[BP],0
        JMP     FDOWN

; COMMAND 6: PORTAMENTO UP 

PORTAUP:
        MOV     AL,OPE1[BP]
        MOV     BL,AL
        SHR     BL,4
        CMP     BL,0FH
        JE      FINEPU
        CMP     BL,0EH
        JE      EFINEPU
        OR      AL,AL
        JNE     PU
        MOV     AL,LASTPORTA[BP]
PU:     MOV     LASTPORTA[BP],AL
FUP:    XOR     AH,AH
        SUB     PERiOD[BP],AX
        MOV     CX,PERiOD[BP]
        JMP     PERNOP2
FINEPU: AND     AL,0FH
        MOV     LASTPORTA[BP],0
        MOV     COM1[BP],0
        JMP     FUP
EFINEPU:AND     AL,0FH
        SHR     AL,2
        MOV     LASTPORTA[BP],0
        MOV     COM1[BP],0
        JMP     FUP

; COMMAND 7: TONE PORTAMENTO 

TONEPORTAMENTO:
        MOV     AL,OPE1[BP]
        XOR     AH,AH
        OR      AL,AL
        JE      TONEPORTNOCHANGE
        MOV     TONEPORTSPEED[BP],AX
        MOV     OPE1[BP],0
TONEPORTNOCHANGE:
        CMP     TARGETPERiOD[BP],0
        JNE     TPER
        RET
TPER:   MOV     BX,TONEPORTSPEED[BP]
        MOV     AX,PERiOD[BP]
        CMP     AX,TARGETPERiOD[BP]
        JNE     NMORG1
        RET
NMORG1: CMP     AX,TARGETPERiOD[BP]
        JA      DWNG1
        ADD     AX,BX
        CMP     AX,TARGETPERiOD[BP]
        JBE     NMG1
        MOV     AX,TARGETPERiOD[BP]
NMG1:   MOV     PERiOD[BP],AX
        JMP     PERNOP
DWNG1:  CMP     AX,BX
        JBE     DOG1
        SUB     AX,BX
        CMP     AX,TARGETPERiOD[BP]
        JNB     NMGG1
DOG1:   MOV     AX,TARGETPERiOD[BP]
NMGG1:  MOV     PERiOD[BP],AX
        JMP     PERNOP

; COMMAND 8: VIBRATO 

ViBRATO:
        MOV     AL,OPE1[BP]
        OR      AL,AL
        JE      ViBRATO2
        MOV     BL,ViBRATOCMD[BP]
        AND     AL,0FH
        JE      ViBSKiP
        AND     BL,0F0H
        OR      BL,AL
ViBSKiP:
        MOV     AL,OPE1[BP]
        AND     AL,0F0H
        JE      ViBSKiP2
        AND     BL,0FH
        OR      BL,AL
ViBSKiP2:
        MOV     ViBRATOCMD[BP],BL
ViBRATO2:
        MOV     AL,ViBRATOPOS[BP]
        SHR     AL,2
        AND     AX,1FH
        MOV     BL,WAVECONTROL[BP]
        AND     BL,3
        JE      ViBSiNE
        SHL     AL,3
        CMP     BL,1
        JE      ViBRAMPDOWN
        MOV     BL,255
        JMP     ViBSET
ViBRAMPDOWN:
        CMP     BYTE PTR ViBRATOPOS[BP],0
        JNB     ViBRAMPDOWN2
        MOV     BL,255
        SUB     BL,AL
        JMP     ViBSET
ViBRAMPDOWN2:
        MOV     BL,AL
        JMP     ViBSET

ViBSiNE:MOV     BL,AL
        XOR     BH,BH
        MOV     BL,ViBRATOTABLE[BX]

ViBSET: MOV     AL,ViBRATOCMD[BP]
        AND     AL,0FH
        MUL     BL
        SHR     AX,7
        MOV     BX,AX
        MOV     AX,PERiOD[BP]
        CMP     BYTE PTR ViBRATOPOS[BP],0
        JB      ViBRATONEG
        ADD     AX,BX
        JMP     ViBRATO3
ViBRATONEG:
        SUB     AX,BX
ViBRATO3:
        MOV     CX,AX
        CALL    PERNOP2
        MOV     AL,ViBRATOCMD[BP]
        XOR     AH,AH
        SHR     AX,2
        AND     AX,3CH
        ADD     ViBRATOPOS[BP],AL
        RET
                         
; COMMAND 10: ARPEGGIO 

ARPEGGIO:
        mov     cx,cx
	CMP	OPE1[BP],0
	JNE	GOARP
	RET
GOARP:
        MOV     AL,COUNTER
        XOR     AH,AH
        MOV     BL,3
        DIV     BL
        CMP     AH,1
        JE      ARPEGGIO1
        CMP     AH,2
        JE      ARPEGGIO2
ARPEGGIO0:
        MOV     AX,PERIOD[BP]
        JMP     ARPEGGIOSET
ARPEGGIO1:
        XOR     AH,AH
        MOV     AL,OPE1[BP]
        SHR     AL,4
        JMP     ARPEGGIOFIND
ARPEGGIO2:
        XOR     AH,AH
        MOV     AL,OPE1[BP]
        AND     AL,15
ARPEGGIOFIND:
        CBW
        SAL     AX,1
        MOV     BX,AX
        MOV     DX,PERIOD[BP]
        LEA     DI,PERIODTABLE2
        MOV     CX,35
ARPLOOP:
        MOV     AX,CS:[BX+DI]
        push    bx
        mov     bx,ax
        shr     bx,4
        add     ax,bx
        shr     bx,3
        add     ax,bx
        pop     bx
        CMP     DX,CS:[DI]
        JAE     ARPEGGIOSET
        ADD     DI,2
        LOOP    ARPLOOP
        RET
ARPEGGIOSET:
        MOV     CX,AX
        JMP     PERNOP2

; COMMAND 11: VOLSLD+VIBRATO 

VOLSLiDEANDViBRATO:
        CALL    VOLSLiDE
        JMP     ViBRATO2

; COMMAND 12: VOLSLD+TONEPORTA 

VOLSLiDEANDTONE:
        CALL    VOLSLiDE
        JMP     TONEPORTNOCHANGE

; COMMAND 17: RETRIGGER NOTE 

RETRIGGERNOTE:
        ret
        MOV     BL,OPE1[BP]
        AND     BL,0FH
        JZ      RTNEND       
        MOV     AL,COUNTER
        XOR     AH,AH
        OR      AL,AL
        JNZ     RTNSKP
        MOV     CX,NOTE[BP]
        AND     CX,0FFFH
        JNZ     RTNSKP
        MOV     COUNTER,0
RTNSKP: DIV     BL
        XCHG    AL,AH
        OR      AL,AL
        JNZ     RTNEND
DORETRIG:
        MOV     SC_START[BP],0
        MOV     SC_START2[BP],0
        CALL    DOINS
RTNEND: RET

; COMMAND 22: CHANGE GLOBAL VOLUME 

CHANGEGLVOLUME:
        MOV     AL,OPE1[BP]
        MOV     MASTERVOLUME,AL
        RET

; COMMAND 24: SET DMP PAN 

DMPPAN: MOV     AL,OPE1[BP]
        SHR     AL,4
        MOV     SC_PAN[BP],AL
        RET

;

DORAMP: PUSH    BX Si
        MOV     AH,0
        CMP     MASTERVOLUME,0
        JZ      @@ZEROVOL
        MUL     MASTERVOLUME
        iNC     AH
@@ZEROVOL:
        MOV     BL,AH
        XOR     BH,BH
        SHL     BX,1
        MOV     AX,[BX+MT_VOLTABLE]
        JMP     SLiDERAMP2
SLiDERAMP:
        PUSH    BX Si
SLiDERAMP2:
        MOV     Si,AX
        MOV     DX,[CS:U_COMMAND]
        MOV     AL,0DH
        OUT     DX,AL
        ADD     DL,2
        MOV     AL,3
        OUT     DX,AL
        SUB     DL,2
        MOV     AL,89H
        OUT     DX,AL
        iNC     DX
        iN      AX,DX
        PUSH    Si
        PUSH    AX
        SHR     AX,8
        SHR     Si,8
        CMP     AX,Si
        JZ      @@DONE2
        JB      @@OK
        XCHG    Si,AX
@@OK:   PUSH    AX
        MOV     DX,[CS:U_COMMAND]
        MOV     AL,7
        OUT     DX,AL
        ADD     DX,2
        POP     AX
        OUT     DX,AL
        MOV     DX,[CS:U_COMMAND]
        MOV     AL,8
        OUT     DX,AL
        ADD     DX,2
        MOV     AX,Si
        OUT     DX,AL
        MOV     DX,[CS:U_COMMAND]
        MOV     AL,6
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,00111111B
        OUT     DX,AL
        MOV     BL,00000000B
        POP     AX
        POP     Si
        CMP     AX,Si
        JB      @@OK2
        OR      BL,01000000B
@@OK2:  MOV     DX,[CS:U_COMMAND]
        MOV     AL,0DH
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,BL
        OUT     DX,AL
        JMP     @@DONE
@@DONE2:POP     AX AX
@@DONE: POP     Si BX
        RET

VOLEQU: PUSH    BX
        MOV     AH,0
        CMP     MASTERVOLUME,0
        JZ      @@ZEROVOL2
        MUL     MASTERVOLUME
@@ZEROVOL2:
        MOV     BL,AH
        XOR     BH,BH
        SHL     BX,1
        MOV     AX,[BX+MT_VOLTABLE]
@@SKiP: MOV     [BP+SC_VOL],AX
        POP     BX
        RET
DiViT:
        OR      BX,BX
        STC
        JZ      DiV1
        MOV     CX,AX
        MOV     AX,DX
        XOR     DX,DX
        DiV     BX
        XCHG    CX,AX
        DiV     BX
        XCHG    DX,CX
        CLC
DiV1:   RET

PERNOP: MOV     CX,[BP+PERiOD]    ; GET PERiOD VALUE
PERNOP2:MOV     AX,CX
        AND     AX,0FFFH
        OR      AX,AX
        JZ      @@OUTiT
        PUSH    DX BX AX
        MOV     BX,20
        MOV     DX,28
        MOV     AX,9E9AH
        CALL    DiViT
        POP     BX
        CALL    DiViT
        POP     BX DX
@@OUTiT:MOV     [BP+SC_NOTE],AX
        RET

GUSKUSS:
        MOV     CX,0
GK2:    CALL    GUSCHNK
        iNC     CX
        CMP     CX,31
        JNE     GK2
        RET

GUSCHNK:MOV     DX,CS:[U_BASE]       ;EGY CSATORNA KUSSOLTATASA
        ADD     DX,102H
        MOV     AL,CL
        OUT     DX,AL
        iNC     DX
        MOV     AL,80H
        OUT     DX,AL
        ADD     DX,2
        iN      AL,DX
        AND     AL,0DFH
        OR      AL,3
        MOV     AH,AL
        MOV     AL,0
        SUB     DX,2
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,AH
        CALL    UDELAY
        SUB     DX,2
        MOV     AL,0
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,AH
        OUT     DX,AL
        RET

; EXTRA COMMANDS 

EXTRACOMMANDS:
        MOV     BL,OPE1[BP]
        MOV     AL,OPE1[BP]
        AND     AL,15
        SHR     BL,4
        CMP     BL,0
        JE      XFILTERONOFF
        CMP     BL,1
        JE      XSETGLISSCTRL
        CMP     BL,2
        JE      XFINETUNE
        CMP     BL,3
        JE      XSETVIBRATOCTRL
        CMP     BL,4
        JE      XSETTREMCTRL
        CMP     BL,8
        JE      XSETPAN
        CMP     BL,0AH
        JE      XOLDSTEREO
        CMP     BL,0BH
        JE      XJUMPLOOP
        CMP     BL,0CH
        JE      XNOTECUT
        CMP     BL,0DH
        JE      XNOTEDELAY
        CMP     BL,0EH
        JE      XPATTERNDELAY
        CMP     BL,0FH
        JE      XFUNKIT
        RET

XFILTERONOFF:   JMP     FILTERONOFF
XFINETUNE:      JMP     FINETUNE
XSETPAN:        JMP     SETPAN
XOLDSTEREO:     JMP     OLDSTEREO
XNOTECUT:       JMP     NOTECUT
XNOTEDELAY:     JMP     NOTEDELAY
XPATTERNDELAY:  JMP     PATTERNDELAY
XJUMPLOOP:      JMP     PATTERNLOOP
XSETGLISSCTRL:  JMP     SETGLISSCONTROL
XSETVIBRATOCTRL:JMP     SETVIBRATOCONTROL
XSETTREMCTRL:   JMP     SETTREMOLOCONTROL
XFUNKIT:        JMP     FUNKIT

; SPECIAL COMMAND 0: SET FILTER 

FILTERONOFF:
        RET

; SPECIAL COMMAND 1: GLISSANDO CONTROL 

SETGLISSCONTROL:
        MOV     AL,OPE1[BP]
        AND     AL,0FH
        AND     GLISSFUNK[BP],0F0H
        OR      GLISSFUNK[BP],AL
        RET

; SPECIAL COMMAND 2: SET FINETUNE 

FINETUNE:
        RET

; SPECIAL COMMAND 3: SET VIBRATO CONTROL 

SETVIBRATOCONTROL:
        MOV     AL,OPE1[BP]
        AND     AL,0FH
        AND     WAVECONTROL[BP],0F0H
        OR      WAVECONTROL[BP],AL
        RET

; SPECIAL COMMAND 4: SET TREMOLO CONTROL 

SETTREMOLOCONTROL:
        MOV     AL,OPE1[BP]
        AND     AL,0FH
        SHL     AL,4
        AND     WAVECONTROL[BP],0FH
        OR      WAVECONTROL[BP],AL
        RET

; SPECIAL COMMAND 8: SET PAN 

SETPAN: MOV     AL,OPE1[BP]
        AND     AL,15
        MOV     SC_PAN[BP],AL
        RET

; SPECIAL COMMAND 10: OLD STEREO EFFECT 

OLDSTEREO:
        RET

; SPECIAL COMMAND 11: PATTERN LOOP 

PATTERNLOOP:
        RET

; SPECIAL COMMAND 12: NOTE CUT 

NOTECUT:MOV     AL,OPE1[BP]
        AND     AL,15
        CMP     AL,COUNTER
        JNZ     RETNC
        MOV     AX,0
        MOV     VOLL[BP],AL
        CALL    VOLEQU
RETNC:  RET

; SPECIAL COMMAND 13: NOTE DELAY 

;OLDSCN  DW      16 DUP (0)
;FIRST   DB      1
;
NOTEDELAY:ret
;        CMP     FIRST,0
;        JE      NOSAVE
;        MOV     AX,SC_NOTE[BP]
;        MOV     OLDSCN[BP],AX
;NOSAVE: MOV     AL,OPE1[BP]
;        AND     AL,0FH
;        CMP     AL,COUNTER
;        JNZ     RETND
;        MOV     AX,NOTE[BP]
;        OR      AX,AX
;        JZ      RETND
;        MOV     AX,OLDSCN[BP]
;        MOV     SC_NOTE[BP],AX
;        PLAYNOTE
;        MOV     FIRST,1
;DONE3:  RET
;RETND:  MOV     DX,U_COMMAND
;        MOV     AL,81H
;        OUT     DX,AL
;        iNC     DL
;        iN      AX,DX
;        CMP     AX,0
;        JZ      DONE4
;        DEC     DL
;        MOV     AL,1
;        OUT     DX,AL
;        iNC     DL
;        MOV     AX,0
;        OUT     DX,AX
;DONE4:  POP     AX
;        JMP     DELYP
;        RET

; SPECIAL COMMAND 14: PATTERN DELAY 

PATTERNDELAY:
        CMP     COUNTER,0
        JNE     RETPD
        MOV     AL,OPE1[BP]
        AND     AL,0FH
        CMP     PATTDELAYTIME2,0
        JNE     RETPD
        INC     AL
        MOV     PATTDELAYTIME,AL
RETPD:  RET

; SPECIAL COMMAND 15: FUNK REPEAT 

FUNKIT: RET

; GUSPORT DETECT 

; NO CARRY  - GUS AT U_BASE

DETECTGUS:
        MOV     CS:[U_BASE],210H
TESTPRT:CALL    GUSPROBE
        JNB     FOUNDP
        ADD     CS:[U_BASE],10H
        CMP     CS:[U_BASE],270H
        JB      TESTPRT
        STC
        RET
FOUNDP: CLC
        RET

DETECTGUS2:
        MOV     DI,210H
        MOV     CX,7
DEGUS2: MOV     DX,DI
        ADD     DI,10H
        ADD     DX,100H
        IN      AL,DX
        CMP     AL,2
        JE      DEGUS3
        LOOP    DEGUS2
        MOV     AX,0
        RET
DEGUS3: MOV     AX,DI
        SUB     AX,10H
        MOV     CS:[U_BASE],AX
        RET

GUSPEEK:PUSH    DX
        MOV     DX,CS:[U_BASE]
        ADD     DX,103H
        MOV     AL,43H
        OUT     DX,AL
        iNC     DX
        MOV     AX,CX
        OUT     DX,AX
        DEC     DX
        MOV     AL,44H
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,BL
        OUT     DX,AL
        ADD     DX,2
        iN      AL,DX
        POP     DX
        RET

GUSPOKE:PUSH    DX AX
        MOV     DX,CS:[U_BASE]
        ADD     DX,103H
        MOV     AL,43H
        OUT     DX,AL
        iNC     DX
        MOV     AX,CX
        OUT     DX,AX
        DEC     DX
        MOV     AL,44H
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,BL
        OUT     DX,AL
        ADD     DX,2
        POP     AX
        OUT     DX,AL
        POP     DX
        RET

GUSPROBE:
        MOV     DX,CS:[U_BASE]
        ADD     DX,0103H
        MOV     AL,4CH
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,0
        OUT     DX,AL
        CALL    UDELAY
        CALL    UDELAY
        SUB     DX,2
        MOV     AL,4CH
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,1
        OUT     DX,AL
        MOV     AX,0AAH
        MOV     BX,0
        MOV     CX,0
        CALL    GUSPOKE
        MOV     AX,055H
        MOV     BX,1
        CALL    GUSPOKE
        MOV     BX,0
        CALL    GUSPEEK
        PUSH    AX
        MOV     AX,0
        CALL    GUSPOKE
        SUB     DX,2
        MOV     AL,4CH
        OUT     DX,AL
        ADD     DX,2
        MOV     AL,0
        OUT     DX,AL
        POP     AX
        CMP     AL,0AAH
        JNZ     NOFOUND
        CLC
        RET
NOFOUND:STC
        RET

COUNTORDERS:
        MOV     CX,CX
        PUSHA
        MOV     CX,0
        MOV     SI,60H
CNTOR1: LODSB
        CMP     AL,255
        JE      CNTOR2
        INC     CX
        JMP     CNTOR1
CNTOR2: MOV     DS:[20H],CX     ; STORE THE CORRECT NUM. OF ORDERS
        POPA
        RET
; LOADER ROUTiNES 

OPENFiLE:                       ; DS:DX FiLENAME
        PUSH    CX
        MOV     AL,0            ; READ/WRiTE FLAG
        MOV     AH,3DH
        iNT     21H
        JNC     NOERROR
        JMP     FiLEERROR
NOERROR:MOV     CS:HANDLE,AX
        POP     CX
        RET

CLOSEFiLE:
        MOV     BX,CS:HANDLE
        MOV     AH,3EH
        iNT     21H
        JNC     NCERROR
        JMP     FiLEERROR
NCERROR:RET

READFiLE:                       ; DS:DX = PUFFER
        PUSH    DS
        MOV     EAX,0
        MOV     BX,CS:HANDLE
        MOV     BP,CX
        SHR     ECX,16
        JZ      NINCS64K
REREAD: PUSH    CX
        MOV     CX,0FFF0H
        MOV     AX,3F00H        ; ECX - MENNYiT
        iNT     21H
        MOV     AX,DS
        ADD     AX,0FFFH
        MOV     DS,AX
        POP     CX
        LOOP    REREAD
NINCS64K:
        MOV     CX,BP
        MOV     AX,3F00H
        iNT     21H  
        POP     DS
        RET

LSEEK:  PUSHA                          ; ECX = OFFSET TO SEEK
        MOVZX   EDX,CX
        SHR     ECX,16
        MOV     AX,4200H
        MOV     BX,CS:HANDLE
        iNT     21H
        JNC     NSERROR
        JMP     FILEERROR
NSERROR:POPA
        RET

FiLEERROR:
        PUSH    AX
        MOV     AX,CS
        MOV     DS,AX
        POP     AX
        CALL    WHiCHERROR
        MOV     AH,9
        iNT     21H
        MOV     AX,4C00H
        iNT     21H
WHiCHERROR:
        CMP     AX,1
        JNE     FER2
        LEA     DX,FERR1
        RET
FER2:   CMP     AX,2
        JNE     FER3
        LEA     DX,FERR2
        RET
FER3:   CMP     AX,3
        JNE     FER4
        LEA     DX,FERR3
        RET
FER4:   CMP     AX,4
        JNE     FER5
        LEA     DX,FERR4
        RET
FER5:   CMP     AX,5
        JNE     FER6
        LEA     DX,FERR5
        RET
FER6:   CMP     AX,6
        JNE     FER7
        LEA     DX,FERR6
        RET
FER7:   CMP     AX,7
        JNE     FER8
        LEA     DX,FERR7
        RET
FER8:   CMP     AX,8
        JNE     FER9
        LEA     DX,FERR8
        RET
FER9:   LEA     DX,FERR9
        RET

; DATAS & MSGS 

HANDLE  DW      0

FERR1   DB      'FUNCTiON NUMBER iNVALiD$'
FERR2   DB      'INVALID FILENAME SPECIFIED$'
FERR3   DB      'PATH NOT FOUND$'
FERR4   DB      'TOO MANY OPEN FiLES$'
FERR5   DB      'ACCES DENiED$'
FERR6   DB      'iNVALiD HANDLE$'
FERR7   DB      'MEMORY CONTROL BLOCK DESTROYED$'
FERR8   DB      'iNSUFFiCiENT MEMORY$'
FERR9   DB      'HULYE EGY HiBA$'

CODE    ENDS
        END
