/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLConstants;
import codeanticode.glgraphics.GLFramebufferObject;
import codeanticode.glgraphics.GLModel;
import codeanticode.glgraphics.GLSLShader;
import codeanticode.glgraphics.GLSLTextureFilterParameter;
import codeanticode.glgraphics.GLShader;
import codeanticode.glgraphics.GLShaderVariable;
import codeanticode.glgraphics.GLState;
import codeanticode.glgraphics.GLTexture;
import codeanticode.glgraphics.GLTextureFilterParameter;
import codeanticode.glgraphics.GLTextureGrid;
import codeanticode.glgraphics.GLTextureGridCompiled;
import codeanticode.glgraphics.GLTextureGridDirect;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.opengl.PGraphicsOpenGL;
import processing.xml.XMLElement;

public class GLTextureFilter
implements GLConstants,
PConstants {
    protected PApplet parent;
    protected GL gl;
    int polyMode;
    protected PGraphicsOpenGL pgl;
    protected GLState glstate;
    protected GLFramebufferObject destFBO;
    protected GLTextureGrid grid;
    protected HashMap<String, GLTextureFilterParameter> paramsHashMap;
    protected GLTextureFilterParameter[] paramsArray;
    protected String filterName;
    protected String description;
    protected boolean blend;
    protected int blendMode;
    protected GLShader shader;
    protected int numInputTex;
    protected int numOutputTex;
    protected String[] srcTexNames;
    protected String[] srcTexOffsetNames;
    protected String clockDataName;
    protected String destColorName;
    protected String destTexSizeName;
    protected GLTextureFilterParameter[] srcTexUnitParams;
    protected GLTextureFilterParameter[] srcTexOffsetParams;
    protected GLTextureFilterParameter clockDataParam;
    protected GLTextureFilterParameter destColorParam;
    protected GLTextureFilterParameter destTexSizeParam;
    protected String vertexFN;
    protected String geometryFN;
    protected String fragmentFN;
    protected String inGeoPrim;
    protected String outGeoPrim;
    protected int maxNumOutVert;
    protected boolean crop;
    protected int cropX0;
    protected int cropX1;
    protected int cropY0;
    protected int cropY1;
    protected float destR;
    protected float destG;
    protected float destB;
    protected float destA;

    public GLTextureFilter() {
        this.parent = null;
    }

    public GLTextureFilter(PApplet pApplet, String string) {
        this.parent = pApplet;
        this.initFilter(string);
    }

    public void delete() {
        this.destFBO.delete();
        this.grid.delete();
        this.shader.delete();
    }

    public GLTextureFilter(PApplet pApplet, URL uRL) {
        this.parent = pApplet;
        this.initFilter(uRL);
    }

    public String getName() {
        return this.filterName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumInputTextures() {
        return this.numInputTex;
    }

    public int getNumOutputTextures() {
        return this.numOutputTex;
    }

    public void apply(GLTexture gLTexture, GLTexture gLTexture2) {
        this.apply(new GLTexture[]{gLTexture}, new GLTexture[]{gLTexture2}, null);
    }

    public void apply(GLTexture gLTexture, GLTexture gLTexture2, GLModel gLModel) {
        this.apply(new GLTexture[]{gLTexture}, new GLTexture[]{gLTexture2}, gLModel);
    }

    public void apply(GLTexture[] gLTextureArray, GLTexture gLTexture) {
        this.apply(gLTextureArray, new GLTexture[]{gLTexture}, null);
    }

    public void apply(GLTexture[] gLTextureArray, GLTexture[] gLTextureArray2) {
        this.apply(gLTextureArray, gLTextureArray2, null);
    }

    public void apply(GLTexture gLTexture) {
        this.apply(new GLTexture[0], new GLTexture[]{gLTexture}, null);
    }

    public void apply(GLTexture[] gLTextureArray) {
        this.apply(new GLTexture[0], gLTextureArray, null);
    }

    public void apply(GLTexture[] gLTextureArray, GLTexture[] gLTextureArray2, GLModel gLModel) {
        int n;
        int n2;
        if (0 < gLTextureArray.length) {
            n2 = gLTextureArray[0].width;
            n = gLTextureArray[0].height;
        } else {
            n2 = gLTextureArray2[0].width;
            n = gLTextureArray2[0].height;
        }
        int n3 = gLTextureArray2[0].width;
        int n4 = gLTextureArray2[0].height;
        this.checkDestTex(gLTextureArray2, n2, n);
        this.setGLConf(n3, n4);
        this.bindDestFBO();
        this.bindDestTexToFBO(gLTextureArray2);
        this.shader.start();
        this.setupShader(gLTextureArray, n3, n4, this.destR, this.destG, this.destB, this.destA);
        if (0 < gLTextureArray.length) {
            this.bindSrcTex(gLTextureArray);
        } else {
            this.gl.glEnable(gLTextureArray2[0].getTextureTarget());
        }
        if (this.grid.isUsingSrcTexRes() && 0 < gLTextureArray.length) {
            n2 = gLTextureArray[this.grid.srcTexInUse()].width;
            n = gLTextureArray[this.grid.srcTexInUse()].height;
        }
        if (this.crop) {
            this.grid.render(n2, n, n3, n4, gLTextureArray.length, this.cropX0, this.cropY0, this.cropX1, this.cropY1);
        } else {
            this.grid.render(n2, n, n3, n4, gLTextureArray.length, 0, 0, n2, n);
        }
        if (0 < gLTextureArray.length) {
            this.unbindSrcTex(gLTextureArray);
        } else {
            this.gl.glDisable(gLTextureArray2[0].getTextureTarget());
        }
        this.shader.stop();
        if (gLModel != null) {
            this.copyToModel(0, gLTextureArray2[0], gLModel);
        }
        this.unbindDestFBO();
        this.restoreGLConf();
    }

    public void noTint() {
        this.destA = 1.0f;
        this.destB = 1.0f;
        this.destG = 1.0f;
        this.destR = 1.0f;
    }

    public void setTint(float f) {
        int n = this.parent.color(f);
        this.setTintColor(n);
    }

    public void setTint(int n, int n2) {
        int n3 = this.parent.color(n, n2);
        this.setTintColor(n3);
    }

    public void setTint(int n, float f) {
        int n2 = this.parent.color((float)n, f);
        this.setTintColor(n2);
    }

    public void setTint(float f, float f2) {
        int n = this.parent.color(f, f2);
        this.setTintColor(n);
    }

    public void setTint(int n, int n2, int n3) {
        int n4 = this.parent.color(n, n2, n3);
        this.setTintColor(n4);
    }

    public void setTint(float f, float f2, float f3) {
        int n = this.parent.color(f, f2, f3);
        this.setTintColor(n);
    }

    public void setTint(int n, int n2, int n3, int n4) {
        int n5 = this.parent.color(n, n2, n3, n4);
        this.setTintColor(n5);
    }

    public void setTint(float f, float f2, float f3, float f4) {
        int n = this.parent.color(f, f2, f3, f4);
        this.setTintColor(n);
    }

    protected void setTintColor(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        this.destA = (float)n2 / 255.0f;
        this.destR = (float)n3 / 255.0f;
        this.destG = (float)n4 / 255.0f;
        this.destB = (float)n5 / 255.0f;
    }

    public void noCrop() {
        this.crop = false;
    }

    public void setCrop(int n, int n2, int n3, int n4) {
        this.crop = true;
        this.cropX0 = n;
        this.cropY0 = n2;
        this.cropX1 = n + n3;
        this.cropY1 = n2 + n4;
    }

    public void noBlend() {
        this.blend = false;
    }

    public void setBlendMode(int n) {
        this.blend = true;
        this.blendMode = n;
    }

    public boolean hasParameter(String string) {
        return this.paramsHashMap.containsKey(string);
    }

    public void setParameterValue(String string, int n) {
        if (this.paramsHashMap.containsKey(string)) {
            GLTextureFilterParameter gLTextureFilterParameter = this.paramsHashMap.get(string);
            gLTextureFilterParameter.setValue(n);
        }
    }

    public void setParameterValue(String string, float f) {
        if (this.paramsHashMap.containsKey(string)) {
            GLTextureFilterParameter gLTextureFilterParameter = this.paramsHashMap.get(string);
            gLTextureFilterParameter.setValue(f);
        }
    }

    public void setParameterValue(String string, float[] fArray) {
        if (this.paramsHashMap.containsKey(string)) {
            GLTextureFilterParameter gLTextureFilterParameter = this.paramsHashMap.get(string);
            gLTextureFilterParameter.setValue(fArray);
        }
    }

    public void setParameterValue(String string, int n, float f) {
        if (this.paramsHashMap.containsKey(string)) {
            GLTextureFilterParameter gLTextureFilterParameter = this.paramsHashMap.get(string);
            gLTextureFilterParameter.setValue(n, f);
        }
    }

    public void setParameterValue(String string, int n, int n2, float f) {
        if (this.paramsHashMap.containsKey(string)) {
            GLTextureFilterParameter gLTextureFilterParameter = this.paramsHashMap.get(string);
            gLTextureFilterParameter.setValue(n, n2, f);
        }
    }

    public void setParameterValues(float[] ... fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            this.paramsArray[i].setValue(fArray2);
        }
    }

    public int getParameterCount() {
        return this.paramsArray.length;
    }

    public int getParameterType(int n) {
        return this.paramsArray[n].getType();
    }

    public String getParameterName(int n) {
        return this.paramsArray[n].getName();
    }

    public String getParameterLabel(int n) {
        return this.paramsArray[n].getLabel();
    }

    public GLTextureFilterParameter getParameter(int n) {
        return this.paramsArray[n];
    }

    public void setParameterValue(int n, int n2) {
        this.paramsArray[n].setValue(n2);
    }

    public void setParameterValue(int n, float f) {
        this.paramsArray[n].setValue(f);
    }

    public void setParameterValue(int n, float[] fArray) {
        this.paramsArray[n].setValue(fArray);
    }

    public void setParameterValue(int n, int n2, float f) {
        this.paramsArray[n].setValue(n2, f);
    }

    public void setParameterValue(int n, int n2, int n3, float f) {
        this.paramsArray[n].setValue(n2, n3, f);
    }

    public GLTextureFilterParameter getParameter(String string) {
        if (this.paramsHashMap.containsKey(string)) {
            GLTextureFilterParameter gLTextureFilterParameter = this.paramsHashMap.get(string);
            return gLTextureFilterParameter;
        }
        return null;
    }

    public void beginIterativeMode() {
        this.bindDestFBO();
        GLState.disablePushFramebuffer();
        GLState.disablePopFramebuffer();
        GLState.setFramebufferFixed(true);
    }

    public void endIterativeMode() {
        GLState.enablePushFramebuffer();
        GLState.enablePopFramebuffer();
        GLState.setFramebufferFixed(false);
        this.unbindDestFBO();
    }

    protected void setGLConf(int n, int n2) {
        int[] nArray = new int[1];
        this.gl.glGetIntegerv(2880, nArray, 0);
        this.polyMode = nArray[0];
        this.glstate.saveBlendConfig();
        if (this.blend) {
            this.glstate.enableBlend();
            this.glstate.setupBlending(this.blendMode);
        } else {
            this.glstate.disableBlend();
        }
        this.gl.glPolygonMode(1028, 6914);
        this.glstate.saveView();
        this.glstate.setOrthographicView(n, n2);
    }

    protected void restoreGLConf() {
        this.glstate.restoreView();
        this.glstate.restoreBlendConfig();
        this.gl.glPolygonMode(1028, this.polyMode);
    }

    protected void copyToModel(int n, GLTexture gLTexture, GLModel gLModel) {
        this.gl.glReadBuffer(36064 + n);
        this.gl.glBindBuffer(35051, gLModel.getCoordsVBO());
        this.gl.glReadPixels(0, 0, gLTexture.width, gLTexture.height, 6408, 5126, 0L);
        this.gl.glBindBuffer(35051, 0);
    }

    protected void bindSrcTex(GLTexture[] gLTextureArray) {
        this.gl.glEnable(gLTextureArray[0].getTextureTarget());
        for (int i = 0; i < gLTextureArray.length; ++i) {
            gLTextureArray[i].bind(i);
        }
    }

    protected void unbindSrcTex(GLTexture[] gLTextureArray) {
        for (int i = 0; i < gLTextureArray.length; ++i) {
            gLTextureArray[i].unbind();
        }
        this.gl.glDisable(gLTextureArray[0].getTextureTarget());
    }

    protected void bindDestFBO() {
        this.glstate.pushFramebuffer();
        this.glstate.setFramebuffer(this.destFBO);
    }

    protected void unbindDestFBO() {
        this.glstate.popFramebuffer();
    }

    protected void bindDestTexToFBO(GLTexture[] gLTextureArray) {
        if (GLState.isFramebufferFixed()) {
            this.glstate.setDestTextures(gLTextureArray, this.numOutputTex);
        } else {
            this.destFBO.setDrawBuffers(gLTextureArray, this.numOutputTex);
        }
    }

    protected void initFBO() {
        this.destFBO = new GLFramebufferObject(this.gl);
    }

    protected void initFilter(String string) {
        this.initFilterCommon();
        string = string.replace('\\', '/');
        XMLElement xMLElement = new XMLElement(this.parent, string);
        this.loadXML(xMLElement);
        this.initShader(string, false);
    }

    protected void initFilter(URL uRL) {
        this.initFilterCommon();
        try {
            String string = PApplet.join((String[])PApplet.loadStrings((InputStream)uRL.openStream()), (String)"\n");
            XMLElement xMLElement = new XMLElement(string);
            this.loadXML(xMLElement);
        }
        catch (IOException iOException) {
            System.err.println("Error loading filter: " + iOException.getMessage());
        }
        this.initShader(uRL.toString(), true);
    }

    private void initFilterCommon() {
        this.pgl = (PGraphicsOpenGL)this.parent.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.initFBO();
        this.blend = false;
        this.blendMode = 1;
        this.crop = false;
        this.cropY1 = 0;
        this.cropY0 = 0;
        this.cropX1 = 0;
        this.cropX0 = 0;
        this.destA = 1.0f;
        this.destB = 1.0f;
        this.destG = 1.0f;
        this.destR = 1.0f;
        this.numInputTex = 1;
        this.numOutputTex = 1;
        this.grid = null;
        this.srcTexNames = null;
        this.srcTexOffsetNames = null;
        this.clockDataName = "clock_data";
        this.destColorName = "dest_color";
        this.destTexSizeName = "dest_tex_size";
        this.paramsHashMap = new HashMap();
        this.paramsArray = new GLTextureFilterParameter[0];
    }

    protected void loadXML(XMLElement xMLElement) {
        int n = xMLElement.getChildCount();
        this.fragmentFN = "";
        this.geometryFN = "";
        this.vertexFN = "";
        this.filterName = xMLElement.getString("name");
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (string.equals("description")) {
                this.description = xMLElement2.getContent();
                continue;
            }
            if (string.equals("vertex")) {
                this.vertexFN = xMLElement2.getContent();
                continue;
            }
            if (string.equals("geometry")) {
                this.geometryFN = xMLElement2.getContent();
                this.inGeoPrim = xMLElement2.getString("input");
                this.outGeoPrim = xMLElement2.getString("output");
                this.maxNumOutVert = xMLElement2.getInt("vertcount");
                continue;
            }
            if (string.equals("fragment")) {
                this.fragmentFN = xMLElement2.getContent();
                continue;
            }
            if (string.equals("textures")) {
                this.numInputTex = xMLElement2.getInt("input");
                this.numOutputTex = xMLElement2.getInt("output");
                this.srcTexNames = new String[this.numInputTex];
                this.srcTexOffsetNames = new String[this.numInputTex];
                for (int j = 0; j < this.numInputTex; ++j) {
                    this.srcTexNames[j] = "src_tex_unit" + j;
                    this.srcTexOffsetNames[j] = "src_tex_offset" + j;
                }
                this.loadInputTextures(xMLElement2);
                continue;
            }
            if (string.equals("specialpars")) {
                this.loadSpecialParameters(xMLElement2);
                continue;
            }
            if (string.equals("parameters")) {
                this.loadParameters(xMLElement2);
                continue;
            }
            if (string.equals("parameter")) {
                this.addParameter(xMLElement2);
                continue;
            }
            if (string.equals("grid")) {
                String string2 = xMLElement2.getString("mode");
                if (string2 == null) {
                    string2 = "direct";
                }
                if (string2.equals("direct")) {
                    this.grid = new GLTextureGridDirect(this.gl, xMLElement2);
                    continue;
                }
                if (string2.equals("compiled")) {
                    this.grid = new GLTextureGridCompiled(this.gl, xMLElement2);
                    continue;
                }
                System.err.println("Unrecognized grid mode!");
                continue;
            }
            System.err.println("Unrecognized element in filter config file!");
        }
    }

    protected void loadInputTextures(XMLElement xMLElement) {
        int n = xMLElement.getChildCount();
        if (n == 0) {
            return;
        }
        if (n != this.numInputTex) {
            System.err.println("Wrong number of textures in config file!");
            return;
        }
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (!string.equals("intexture")) continue;
            String string2 = xMLElement2.getString("name");
            String string3 = xMLElement2.getString("offset");
            String string4 = xMLElement2.getContent();
            int n2 = PApplet.parseInt((String[])PApplet.split((String)string4, (char)' '))[0];
            if (0 <= n2 && n2 < n) {
                this.srcTexNames[n2] = string2;
                if (string3 == null) continue;
                this.srcTexOffsetNames[n2] = string3;
                continue;
            }
            System.err.println("Wrong texture unit!");
        }
    }

    protected void loadSpecialParameters(XMLElement xMLElement) {
        int n = xMLElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (!string.equals("specialpar")) continue;
            String string2 = xMLElement2.getString("type");
            String string3 = xMLElement2.getString("name");
            if (string2.equals("clock")) {
                this.clockDataName = string3;
                continue;
            }
            if (string2.equals("tint")) {
                this.destColorName = string3;
                continue;
            }
            if (!string2.equals("size")) continue;
            this.destTexSizeName = string3;
        }
    }

    protected void loadParameters(XMLElement xMLElement) {
        int n = xMLElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (!string.equals("parameter")) continue;
            this.addParameter(xMLElement2);
        }
    }

    protected void addParameter(XMLElement xMLElement) {
        String string = xMLElement.getString("name");
        String string2 = xMLElement.getString("type");
        String string3 = xMLElement.getString("label");
        if (string2.equals("clock")) {
            this.clockDataName = string;
        } else if (string2.equals("tint")) {
            this.destColorName = string;
        } else if (string2.equals("size")) {
            this.destTexSizeName = string;
        } else {
            int n = GLShaderVariable.getType(string2);
            String string4 = xMLElement.getContent();
            float[] fArray = PApplet.parseFloat((String[])PApplet.split((String)string4, (char)' '));
            if (-1 < n && !this.paramsHashMap.containsKey(string)) {
                GLSLTextureFilterParameter gLSLTextureFilterParameter = new GLSLTextureFilterParameter(this.parent, string, string3, n, fArray.length);
                ((GLTextureFilterParameter)gLSLTextureFilterParameter).setValue(fArray);
                this.paramsHashMap.put(string, gLSLTextureFilterParameter);
                this.paramsArray = (GLTextureFilterParameter[])PApplet.append((Object)this.paramsArray, (Object)gLSLTextureFilterParameter);
            }
        }
    }

    String fixShaderFilename(String string, String string2) {
        String string3 = string.replace('\\', '/');
        if (!string2.equals("") && string3.indexOf(string2) != 0) {
            string3 = string2 + string3;
        }
        return string3;
    }

    protected void initShader(String string, boolean bl) {
        int n;
        String string2 = "";
        int n2 = string.lastIndexOf(47);
        if (-1 < n2) {
            string2 = string.substring(0, n2 + 1);
        }
        if (this.grid == null) {
            this.grid = new GLTextureGridDirect(this.gl);
        }
        this.shader = new GLSLShader(this.parent);
        if (!this.vertexFN.equals("")) {
            this.vertexFN = this.fixShaderFilename(this.vertexFN, string2);
            if (bl) {
                try {
                    this.shader.loadVertexShader(new URL(this.vertexFN));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(malformedURLException.getMessage());
                }
            } else {
                this.shader.loadVertexShader(this.vertexFN);
            }
        }
        if (!this.geometryFN.equals("")) {
            this.geometryFN = this.fixShaderFilename(this.geometryFN, string2);
            if (bl) {
                try {
                    this.shader.loadGeometryShader(new URL(this.geometryFN));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(malformedURLException.getMessage());
                }
            } else {
                this.shader.loadGeometryShader(this.geometryFN);
            }
            ((GLSLShader)this.shader).setupGeometryShader(this.inGeoPrim, this.outGeoPrim, this.maxNumOutVert);
        }
        if (!this.fragmentFN.equals("")) {
            this.fragmentFN = this.fixShaderFilename(this.fragmentFN, string2);
            if (bl) {
                try {
                    this.shader.loadFragmentShader(new URL(this.fragmentFN));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(malformedURLException.getMessage());
                }
            } else {
                this.shader.loadFragmentShader(this.fragmentFN);
            }
        }
        this.shader.setup();
        this.srcTexUnitParams = new GLSLTextureFilterParameter[this.numInputTex];
        this.srcTexOffsetParams = new GLSLTextureFilterParameter[this.numInputTex];
        for (n = 0; n < this.numInputTex; ++n) {
            this.srcTexUnitParams[n] = new GLSLTextureFilterParameter(this.parent, this.srcTexNames[n], "Texture unit " + n, 0, 1);
            this.srcTexUnitParams[n].setShader(this.shader);
            this.srcTexUnitParams[n].init();
            this.srcTexOffsetParams[n] = new GLSLTextureFilterParameter(this.parent, this.srcTexOffsetNames[n], "Texture offset " + n, 2, 1);
            this.srcTexOffsetParams[n].setShader(this.shader);
            this.srcTexOffsetParams[n].init();
        }
        this.clockDataParam = new GLSLTextureFilterParameter(this.parent, this.clockDataName, "Clock data", 2, 1);
        this.destColorParam = new GLSLTextureFilterParameter(this.parent, this.destColorName, "Destination color", 4, 1);
        this.destTexSizeParam = new GLSLTextureFilterParameter(this.parent, this.destTexSizeName, "Destination size", 2, 1);
        this.clockDataParam.setShader(this.shader);
        this.clockDataParam.init();
        this.destColorParam.setShader(this.shader);
        this.destColorParam.init();
        this.destTexSizeParam.setShader(this.shader);
        this.destTexSizeParam.init();
        for (n = 0; n < this.paramsArray.length; ++n) {
            this.paramsArray[n].setShader(this.shader);
            this.paramsArray[n].init();
        }
    }

    void setupShader(GLTexture[] gLTextureArray, int n, int n2, float f, float f2, float f3, float f4) {
        int n3;
        int n4 = PApplet.min((int)this.numInputTex, (int)gLTextureArray.length);
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.srcTexUnitParams[n3].available()) {
                this.srcTexUnitParams[n3].setValue(n3);
                this.srcTexUnitParams[n3].copyToShader();
            }
            if (!this.srcTexOffsetParams[n3].available()) continue;
            this.srcTexOffsetParams[n3].setValue(0, 1.0f / (float)gLTextureArray[n3].width);
            this.srcTexOffsetParams[n3].setValue(1, 1.0f / (float)gLTextureArray[n3].height);
            this.srcTexOffsetParams[n3].copyToShader();
        }
        if (this.clockDataParam.available()) {
            n3 = this.parent.frameCount;
            int n5 = this.parent.millis();
            this.clockDataParam.setValue(0, n3);
            this.clockDataParam.setValue(1, n5);
            this.clockDataParam.copyToShader();
        }
        if (this.destColorParam.available()) {
            this.destColorParam.setValue(0, f);
            this.destColorParam.setValue(1, f2);
            this.destColorParam.setValue(2, f3);
            this.destColorParam.setValue(3, f4);
            this.destColorParam.copyToShader();
        }
        if (this.destTexSizeParam.available()) {
            this.destTexSizeParam.setValue(0, n);
            this.destTexSizeParam.setValue(1, n2);
            this.destTexSizeParam.copyToShader();
        }
        for (n3 = 0; n3 < this.paramsArray.length; ++n3) {
            this.paramsArray[n3].copyToShader();
        }
    }

    protected void checkDestTex(GLTexture[] gLTextureArray, int n, int n2) {
        for (int i = 0; i < gLTextureArray.length; ++i) {
            if (gLTextureArray[i].available()) continue;
            gLTextureArray[i].init(n, n2);
        }
    }
}

