///////////////////////////////////////////////////////////////////////////////
// TJC ChipDisk #2 header file
// Author: Pontus (pikzel) Palmens    050530
///////////////////////////////////////////////////////////////////////////////

#ifndef _CHIPDISK_H
#define _CHIPDISK_H

#include "allegro.h"
#ifdef WIN32
	#include <FMOD/fmod.h>
#endif
#ifdef unix
	#include <fmod.h>
#endif
using namespace std;

///////////////////////////////////////////////////////////////////////////////
// Konstanter
///////////////////////////////////////////////////////////////////////////////
#define MODE GFX_AUTODETECT_WINDOWED
#define WIDTH 640
#define HEIGHT 480
#define WINDOW_TITLE "TJC ChipDisk #2"
#define WHITE makecol(255,255,255)
#define BLACK makecol(0,0,0)
#define GREY makecol(155,155,155)
#define FLOWER_SPEED 0.1
#define N_SONGS 14 // antal ltar
#define N_NOTES 25 // antal animerade noter


///////////////////////////////////////////////////////////////////////////////
// Strukturer
///////////////////////////////////////////////////////////////////////////////
struct song {
  FMUSIC_MODULE* mod;
  const char* title;
  const char* msg;
} songs[N_SONGS];

struct note {
  int type;
  int x;
  int y;
  int speed;
} notes[N_NOTES];


///////////////////////////////////////////////////////////////////////////////
// Globala variabler
///////////////////////////////////////////////////////////////////////////////

// timers
volatile int counter;
volatile int ticks;
volatile int framerate;
volatile int resting, rested;

// instllningar
int current = 0;
int volume = 255;
bool esc = false;
bool shuffle = false;

// bitmaps
BITMAP *buff;
BITMAP *backg;
BITMAP *flower;
BITMAP *note1;
BITMAP *note2;

// positioner och vinklar
int center_x = 0, center_y = 0;
fixed flower_angle = 0;
fixed note_angle = 0;
int msg_x = WIDTH;

// lite fulkod att lgga allt i arrayer, ska fixa det (sen)
const char* files[] = {"data/zik/jal-bjornen.xm", "data/zik/algar-cbx.xm",
                      "data/zik/algar-rejv.xm", "data/zik/pxl-flubb.xm",
                      "data/zik/algar-dagos.xm", "data/zik/algar-coffeefuck.xm",
                      "data/zik/pxl-algars_chipfabrik.xm", "data/zik/algar-ment.xm",
                      "data/zik/pxl-verksamhet.xm", "data/zik/algar-oronmuff.xm",
                      "data/zik/venom-doom.xm", "data/zik/pxl-trampbil.xm",
                      "data/zik/jal-svard.xm", "data/zik/algar-wepp.xm"};
const char* titles[] = {"1. Jallabert - vahva kuin karhu", "2. algar - Come to beatbox!",
                       "3. algar - algars raveparty!", "4. pikzel - flubb",
                       "5. algar - Dagos flykt", "6. algar - Coffeefuck",
                       "7. pikzel - algars chipfabrik", "8. algar - Cement",
                       "9. pikzel - verksamhet", "10. algar - Ear muffs",
                       "11. venom - doom", "12. pikzel - trampbil",
                       "13. Jallabert - freundliche neger", "14. algar - depression, but why?"};
const char* msgs[] = {"This is the song about the bear. Venom took his legs away :(",
                     "Hi! We invite you to Beatbox 8-10 July. Please visit http://beatbox.tjc.se",
                     "Rave, yuck... Never mind...",
                     "ha ha ha :/            jAnZoN, you should know this one!",
                     "The escape of Dago",
                     "This song is about Coffeefuck, or so it seems.",
                     "Welcome to algars chip factory. Chips are always welcome here!",
                     "Cement? Cement!",
                     "This is some sort of chip. Should be trance, I think. Silexz, woo.",
                     "Ear muffs, baby!",
                     "Tribute to the greatest series of games of all time!",
                     "This one is just for fun. Really! It is the theme of www.trampbil.org - also called Angie.",
                     "There are friendly negros too",
                     "Why do I have this anxiety?"};


///////////////////////////////////////////////////////////////////////////////
// Funktionsprototyper
///////////////////////////////////////////////////////////////////////////////
void init();
void deinit();
void setupMusic();
void setupScene();
void updateScene();
void drawScene();
void getInput();
void next();
void prev();
void customTimer();
void hold();
void volume_up();
void volume_down();
void change_gfxmode();

#endif
