/*
--------------------------------------------------------------------------

NOMBRE ........ ESTADO.C
AUTOR  ........ Fernando Gonzlez Ruano
VERSION ....... 1.0
COMPILADOR .... BC++ v2.0

TORTUGA soft. 1996

DESCRIPCION:

	Visualiza el estado de lnea y modem de un puerto COM utilizando
	la BIOS.

SINTAXIS:

	ESTADO x

	x -> nmero de puerto (de 1 a 4)

--------------------------------------------------------------------------
*/

#include<stdio.h>
#include<stdlib.h>
#include<dos.h>
/* ----- Datos sobre el programa
*/
#define PROG_VER    01
#define PROG_REV    00
#define PROG_DATE   "Marzo de 1.996"

/* ----- Crditos
*/
void creditos(void)
{
	printf("\n\n");
	printf("ESTADO v");
	printf( "%02d", PROG_VER );
	printf( ".r" );
	printf( "%02d", PROG_REV);
	printf("  [");
	printf( "%s", PROG_DATE );
	printf("]  ");
	printf("\nAutor: Fernando Gonzlez Ruano\n");
	printf("Copyright (c) TORTUGA soft.\n");
	printf("Fidonet  2:345/801.15                       \n");
	printf("Internet fernan@p15.atlantis.encomix.com    \n\n");
}

int main(int narg,char **larg)
{
	char estado[2][3] = {"NO","SI"};
	char linea, modem;
	int  com;

	creditos();		// crditos del programa

	// comprobaciones

        if(narg<2)
	{
		printf("\nTienes que darme el nmero de puerto.");
		exit(1);
	}

	com = atoi(larg[1]);

	if(com<1 && com>4)
	{
		printf("\nEl nmero de puerto es de 1 a 4.");
		exit(1);
	}

	// servicio de lectura del estado del puerto

	_AH = 3;
	_DX = com-1;
	geninterrupt(0x14);
	linea = _AL;
	modem = _AH;

	printf("COM = %d\n",com);
	printf("\n      Estado del modem     \t\t");
	printf("    Estado de la lnea     ");
	printf("\n---------------------------\t\t");
	printf("---------------------------");
	printf("\nCTS secundario ......... %s\t\t",estado[(linea&1)]);
	printf("DTR .................... %s",estado[(modem&1)]);
	printf("\nDSR secundario ......... %s\t\t",estado[(linea&2)>>1]);
	printf("Error de alcance ....... %s",estado[(modem&2)>>1]);
	printf("\nRING secundaria ........ %s\t\t",estado[(linea&4)>>2]);
	printf("Error de paridad ....... %s",estado[(modem&4)>>2]);
	printf("\nDCD secundaria ......... %s\t\t",estado[(linea&8)>>3]);
	printf("Error de trama ......... %s",estado[(modem&8)>>3]);
	printf("\nCTS .................... %s\t\t",estado[(linea&16)>>4]);
	printf("Error en portadora ..... %s",estado[(modem&16)>>4]);
	printf("\nDSR .................... %s\t\t",estado[(linea&32)>>5]);
	printf("Buffer de transmisin .. %s",estado[(modem&32)>>5]);
	printf("\nRING ................... %s\t\t",estado[(linea&64)>>6]);
	printf("Reg. de desplz. vaco .. %s",estado[(modem&64)>>6]);
	printf("\nDCD .................... %s\t\t",estado[(linea&128)>>7]);
	printf("Time out ............... %s",estado[(modem&128)>>7]);
	printf("\n");
	return 0;
}

