#include <dos.h>
#include "modo_x.h"


#define TS_inx   0x3c4
#define TS_dat   0x3c5

#define CRTC_inx 0x3d4
#define CRTC_dat 0x3d5

void far modo_13x (void) {

	asm {
		xor ah,ah
		mov al,0x13
		int 0x10      //Primero cambiamos al modo 13h normal.
	}

	outportb(TS_inx,4); //Desconexin del modo Chain 4 y del par/impar ...
					   //Necesitamos en el TS 4 el bit 3=0 y bit 2=1.
	outportb(TS_dat , (inportb(TS_dat) &  (unsigned char) (~0x08)) | (unsigned char) 4);

	outportb(CRTC_inx, 0x14);  //CRTC registro 14h, bit 6=0 -> desconexin del
							  //direccionamiento double-word
	outportb(CRTC_dat , inportb(CRTC_dat) &  (unsigned char) (~0x40));

	outportb(CRTC_inx, 0x17);  //CRTC registro 17h, bit 6=1 -> modo byte
	outportb(CRTC_dat , inportb(CRTC_dat) | (unsigned char) 0x40);


}


void far modo_texto (void) {

	asm {
		xor ah,ah
		mov al,0x3
		int 0x10
	}
}

void far cls_4x (void) {

	asm {
		mov ah,0x0f  //Activar los 4 planos para escribir
		mov dx,TS_inx
		mov al,2
		out dx,ax

		mov ax,0xa000
		mov es,ax
		xor ax,ax
		mov di,ax
		mov cx,32000
		rep stosw
	}

}

void far lPCX_modoX (unsigned char huge* RAMbuf, unsigned int inicio_pag, unsigned int size) {

	unsigned int segmento, desplaza;  //SEG:OFF del buffer donde hay un dibujo PCX descomprimido
	unsigned char plano_n; //N de plano en el que escribimos.
	unsigned int plane_pos;

	segmento=FP_SEG(RAMbuf);
	desplaza=FP_OFF(RAMbuf);

	asm {
		mov byte ptr plano_n,1  //Empezamos con el primer plano
		push ds
		mov ds,segmento
		mov ax,desplaza
		mov si,ax  //DS:SI apunta al buffer del grafico PCX
		mov word ptr plane_pos,si
		mov ax,0xa000
		mov es,ax
		mov di, inicio_pag  //di=inicio de la pagina elegida del modo x
		mov cx,size      //tamao de la pagina del modo x (suele ser /4)
	}
cambiar_plano:
	asm {
		mov al,2        //TS registro 2 (write plane Mask)
		mov ah,plano_n  //n de plano a activar
		mov dx,TS_inx
		out dx,ax
	}
copiar_cuarta_parte:
	asm {
		movsb
		add si,3 //Al siguiente byte (tenemos que copiar cada 4 -> 1,4,8,...)
		dec cx
		jnz copiar_cuarta_parte
		mov di, inicio_pag  //De nuevo la posicin destino
		inc word ptr plane_pos  //Esta vez el origen es el anterior +1
		mov si,word ptr plane_pos
		mov cx,size
		shl byte ptr plano_n,1 //Enmascarar siguiente plano
		cmp byte ptr plano_n,0x10 //Copiados los 4 planos?
		jne cambiar_plano

		pop ds
	}
}

void far linear_start_address (unsigned int direc) {

		asm {
			mov ax,direc
			mov dx,CRTC_inx
			push ax
			mov al,0xc  //en este regirstro el valor alto de la direccin
			out dx,al
			inc dx
			mov al,ah
			out dx,al  //enviamos el valor alto
			dec dx
			mov al,0xd
			out dx,al   //En este otro registro el valor bajo (low byte)
			inc dx
			pop ax
			out dx,al
		}
}

void far WaitRetrace(void)
{ // Evita el efecto nieve en la pantalla
	asm {
	mov   dx,0x3DA
	}
bucle1:
	asm {
	in    al,dx
	and   al,8
	jnz   bucle1
	}
bucle2:
	asm {
	in    al,dx
	and   al,8
	jz    bucle2
	}
}

