#include <dos.h>

// ******************** RUTINAS DEL FUNDIDO ************************
// ******************ESTE ES PARA MODO GRAFICO**********************
//******************************************************************

#define TAMA_DAC 256  //En modo grafico DAC tiene 256 registros
		      //En modo texto slo 64 registros

typedef unsigned char Byte;

typedef struct {
	Byte R,G,B;
	} regRGB;


regRGB DAC256[TAMA_DAC];

void Pal(regRGB DAC, Byte reg)
{ // Cambia el color actual del texto
   Byte R, G, B;

   R=DAC.R;
   G=DAC.G;
   B=DAC.B;

   asm {
      mov   dx,0x3c8
      mov   al, reg
      out   dx, al
      inc   dx
      mov   al, [R]
      out   dx, al
      mov   al, [G]
      out   dx, al
      mov   al, [B]
      out   dx, al
    }
}

void GetPal(regRGB *DAC, Byte reg)
{ //Obtiene el color actual del texto

   Byte Rt, Gt, Bt;

   asm {
      mov   dx,0x3c7
      mov   al, reg
      out   dx, al
      inc   dx
      inc   dx
      in    al, dx
      mov   [Rt],al
      in    al, dx
      mov   [Gt],al
      in    al, dx
      mov   [Bt],al
   }
 DAC->R = Rt;
 DAC->G = Gt;
 DAC->B = Bt;
}

static void WaitRetrace(void)
{ // Evita el efecto nieve en la pantalla

    asm {
	mov   dx,0x3DA
    }

bucle1:

    asm {
	in    al,dx
	and   al,8
	jnz   bucle1
    }

bucle2:

    asm {
	in    al,dx
	and   al,8
	jz    bucle2
    }
}

void FadeIn256 (regRGB DAC256[TAMA_DAC])
{ 	//Realiza un fundido a negro y devuelve el color inicial

   register int Loop;
   regRGB AUX[TAMA_DAC];
   register int reg;

   for (reg=0; reg<TAMA_DAC; reg++)
      GetPal(&DAC256[reg], reg);
   for (reg=0; reg<TAMA_DAC; reg++)
	AUX[reg]=DAC256[reg];

   for (Loop=0; Loop<TAMA_DAC; Loop++) {
     WaitRetrace();
   //  WaitRetrace();
     for(reg=0; reg<TAMA_DAC; reg++) {
	Pal( AUX[reg], reg);
	if (AUX[reg].R) (AUX[reg].R)--;
	if (AUX[reg].G) (AUX[reg].G)--;
	if (AUX[reg].B) (AUX[reg].B)--;

     }
   }
}



void FadeOut256 (regRGB DAC256[TAMA_DAC] )
{ 	//Pasa del negro al color especificado

   register int Loop;
   regRGB AUX[TAMA_DAC];
   register int reg;

   for (reg=0; reg<TAMA_DAC; reg++)
	   AUX[reg].R=AUX[reg].G=AUX[reg].B=0;

 for (Loop=0; Loop<TAMA_DAC; Loop++) {
	WaitRetrace();
     //	WaitRetrace();
   for (reg=0; reg<TAMA_DAC; reg++) {
      Pal( AUX[reg], reg);
      if (AUX[reg].R < DAC256[reg].R) (AUX[reg].R)++;
      if (AUX[reg].G < DAC256[reg].G) (AUX[reg].G)++;
      if (AUX[reg].B < DAC256[reg].B) (AUX[reg].B)++;
   }
 }
}

//******************** FIN DE RUTINAS DEL FUNDIDO ************************
//************************************************************************

//************************************************************************
//***************** RUTINAS DE ACCESO POR BLOQUES AL DAC *****************
//************************************************************************
//************************************************************************

//************************************************************************
//*leeDAC256(bufDAC) --> Lee los 256*3 bytes del DAC y los guarda en bufDAC
//************************************************************************

void leeDAC256 (unsigned char far *bufDAC) {

	       _ES=FP_SEG(bufDAC);
	       _DX=FP_OFF(bufDAC);
	asm {

		mov bx,0	// registro de paleta de inicio
		mov cx,256      // n registros de paleta a leer
		mov ax,0x1017
		int 0x10	//Funciones de video
	}
}

//************************************************************************
//*escribeDAC256 (bufDAC) -> escribe en el DAC el cont. del buffer bufDAC
//************************************************************************

void escribeDAC256 (unsigned char far *bufDAC) {

	 _ES=FP_SEG(bufDAC);
	 _DX=FP_OFF(bufDAC);

	asm {

		mov bx,0	// registro de paleta de inicio
		mov cx,256      // n registros de paleta a escribir
		mov ax,0x1012
		int 0x10	//Funciones de video
	}
}


//************************************************************************
//*************** FIN RUTINAS DE ACCESO POR BLOQUES AL DAC ***************
//************************************************************************
//************************************************************************
