unit u_accion; { Ir a, Usar, ... }
INTERFACE


type

  cad80=string [80];

  pacciones=^acciones;

  acciones=record

        accion:cad80; { Nombre de la accin }
        px1,py1,px2,py2:integer; { Coordenadas }
        ptrsiguiente:pacciones;
  end;


  t_acciones=object
       ptractual:pacciones; { Y aqu tenemos la ltima accion que hemos pillado }
       ptrprimero:pacciones; { Aqu tenemos la direccin de la primera accin }
       accion_anterior:cad80;
       cuantos:byte; { ... Nmero de acciones que hay }

   { //-- Aqu van las definiciones de los mtodos }
       constructor INICIA; { Ejecutar este proc. antes de aadir la primera accin }
       procedure add_accion (cadena:cad80;vpx1,vpy1,vpx2,vpy2:integer); { Aade una accin }
       procedure listar; { ... Hace un listado de las acciones, cosas del programador ... }

       function  leer_accion (vx,vy:integer):cad80;
       function anterior:cad80; { //--> Nos da la accin actual, si no se }
       { ha escogido otra..., muy til }
       destructor destruye; { Destruye la lista de acciones, liberando la memoria }
  end; { //---- Fin de la declaracin del objeto t_acciones }
{ ------------------------------------------------------------------------- }
IMPLEMENTATION
{ ------------------------------------------------------------------------- }
{ ------------ Ahora meto la implementacin de los mtodos ---------------- }
{ ------------------------------------------------------------------------- }
  constructor t_acciones.inicia; { Inicializa la lista }
    begin
      ptractual:=NIL;
      ptrprimero:=NIL;
      cuantos:=0;
      accion_anterior:='';
    end; { //-- Fin de t_acciones.inicia }

{ ------------------------------------------------------------------------- }

  procedure t_acciones.add_accion (cadena:cad80;vpx1,vpy1,vpx2,vpy2:integer);
    var   { ... Para aadir una nueva accin }
      ptrtrabajo:pacciones;

      begin
      new (ptrtrabajo);
      inc (cuantos);
      with ptrtrabajo^ do
           begin
           ptrsiguiente:=nil;
           accion:=cadena;
           px1:=vpx1;
           px2:=vpx2;
           py1:=vpy1;
           py2:=vpy2;
           end;

      if ( ptrprimero <> nil) and ( ptrprimero^.ptrsiguiente=nil) then { Segundo elemento }
         begin
         ptrprimero^.ptrsiguiente:=ptractual;
         end;

      if ptrprimero=nil then { ... Primer elemento }
         begin
         ptrprimero:=ptrtrabajo;
         accion_anterior:=ptrprimero^.accion;
         ptractual:=ptrtrabajo;
         end
      else
         begin
         ptractual^.ptrsiguiente:=ptrtrabajo;
         ptractual:=ptrtrabajo;
         end;
      end;
{ ------------------------------------------------------------------------- }
  procedure t_acciones.listar;
    var
    ptrcurrele:pacciones;

    begin
     ptrcurrele:=ptrprimero;

     repeat
        writeln (ptrcurrele^.accion);
        ptrcurrele:=ptrcurrele^.ptrsiguiente;
     until ptrcurrele=nil;
    end;
{ ------------------------------------------------------------------------- }
  function  t_acciones.leer_accion (vx,vy:integer):cad80; { Comprueba si hemos seleccionado }
    var
    ptrcurrele:pacciones;
    currelo:cad80;

    begin
      currelo:='';
      ptrcurrele:=ptrprimero;

      repeat
        if (vx>=ptrcurrele^.px1) and (vx<=ptrcurrele^.px2)
          and (vy>=ptrcurrele^.py1) and (vy<=ptrcurrele^.py2) then
           begin
           currelo:=ptrcurrele^.accion;
           accion_anterior:=ptrcurrele^.accion;
           end;
         ptrcurrele:=ptrcurrele^.ptrsiguiente;
      until (ptrcurrele=nil) or (currelo<>'');
    leer_accion:=currelo;
    end;

{ ------------------------------------------------------------------------- }
function t_acciones.anterior:cad80; { //--> Nos da la accin actual, si no hay una }
  begin                  { recien escogida... }
  anterior:=accion_anterior;
  end;
{ ------------------------------------------------------------------------- }
  destructor t_acciones.destruye;
    var
    ptrdestruye:pacciones;

    begin
    ptractual:=ptrprimero;
    repeat
       ptrdestruye:=ptractual;
       ptractual:=ptractual^.ptrsiguiente;
       dispose (ptrdestruye);
    until ptractual^.ptrsiguiente=nil;
    end;

{ ------------------------------------------------------------------------- }
end.



