/***************************************************************************/
/* Ŀ */
/*  NOMBRE DEL FICHERO: PANTALLA.H                                       */
/*  DESCRIPCION:        Conjunto de clases para la representacin de     */
/*                      pantallas grficas virtuales.                    */
/*  CONTENIDO:          .class pantalla320200256                         */
/*                      .class pantalla640400256                         */
/*                      .class pantalla640480256                         */
/*                                                                       */
/*  LLAMADO POR:        PANTALLA.CPP: Implementacin de los mtodos.     */
/*  LLAMA A:      (PRJ) IMAGEN.H: Representacin de imgenes.            */
/*                      MATH.H: Funciones matemticas.                   */
/*                                                                       */
/*  PROGRAMADO POR:     Juan Manuel Snchez Cervantes.                   */
/*  FECHA:              07/03/1995                                       */
/*  ACTUALIZACIONES:    ---                                              */
/*  NOTAS:  Pantalla grfica virtual: se puede enterder como una zona de */
/*          memoria que simula a la pantalla real del monitor, donde se  */
/*          puede almacenar toda la informacin sobre la imagen total    */
/*          que forma a sta. Sobre la pantalla virtual se puede dibujar */
/*          mediante los mtodos contruidos para esta funcin, y cuando  */
/*          sea necesario su contenido se vuelca a la RAM de video con   */
/*          lo que se har visible en el monitor.                        */
/*  */
/***************************************************************************/
#ifndef PANTALLA        //Evitar recompilado.

#define PANTALLA 1      //PANTALLA == 1  -->  Mdulo ya compilado.
#include "imagen.h"
#include <math.h>

class pantalla320200256{
/***************************************************************************/
/* DESCRIPCION:   Clase para la instanciacin de objetos para el control de*/
/*                pantallas grficas virtuales de 640x400 puntos y 256 co- */
/*                lores.                                                   */
/* HERENCIA:      ---                                                      */
/* MIEMBROS PRIV: .char far *B: Puntero a un buffer (array) de memoria,    */
/*                              necesario para el mantenimiento de la      */
/*                              pantalla virtual.                          */
/* MIEMBROS PUBL: .pantalla320200256(void).                                */
/*                .char inicializar(void).                                 */
/*                .void cls(char color).                                   */
/*                .void dImagen(int, int, int, int, imagen256 *).          */
/*                .void cImagen(int ,int, int, int, imagen256 *).          */
/*                .void dImagenMasc(int, int, int, int, imagen256 *).      */
/*                .void dPunto(int, int, char).                            */
/*                .void cPunto(int, int, *char).                           */
/*                .void dLinea(int, int, int, int, char).                  */
/*                .void dRectangulo(int, int, int, int, char, char).       */
/*                .void volcar(void).                                      */
/*                .void liberarRAM(void).                                  */
/*                .~pantalla320200256(void).                               */
/*                                                                         */
/***************************************************************************/
    char far* B;

 public:
    pantalla320200256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Constructor del objeto. Inicializa 'B' a nulo.            */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    char inicializar(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   0 si la inicializacin del objeto no ha sido correcta.    */
    /*             Falta memoria.                                          */
    /*           1 si el objeto se ha inicializado de forma correcta.      */
    /* EFECTO:   Se reserva la memoria necesaria para el mantenimiento de  */
    /*           la pantalla virtual.                                      */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    Ver notas en cabecera de la clase.                        */
    /***********************************************************************/

    void cls(char color);
    /***********************************************************************/
    /* ENTRADA:  Un dato tipo char que especifica el color para cubrir.    */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La pantalla toma el color 'color' en todos sus pixels.    */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    void dImagen(int x, int y, int tx, int ty, imagen256 *imag);
    /***********************************************************************/
    /* ENTRADA:  2 enteros que especifican la coordenada en la pantalla,   */
    /*           2 enteros que determinan dimensiones en la imagen, y un   */
    /*           puntero al buffer del objeto imagen.                      */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La porcin rectangular de imagen que determinan los puntos*/
    /*           (0,0) y (tx,ty) se copia en la coordenada (x,y) de la     */
    /*           pantalla.                                                 */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas (x  y) es negativa se actua-*/
    /*           liza a 0. Si la porcin de imagen a dibujar rebasa los    */
    /*           lmites superiores de la pantalla (320,200), se recorta.  */
    /***********************************************************************/

    void cImagen(int x, int y, int tx, int ty, imagen256 *imag);
    /***********************************************************************/
    /* ENTRADA:  2 enteros que especifican la coordenada en la pantalla,   */
    /*           2 enteros que determinan dimensiones en la imagen, y un   */
    /*           puntero al buffer del objeto imagen.                      */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La porcin rectangular de pantalla que determinan los pun-*/
    /*           tos (0,0) y (tx,ty) se copia en la imagen a partir de su  */
    /*           coordenada (0,0).                                         */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas (x  y) es negativa se actua-*/
    /*           liza a 0. Si la porcin de imagen a dibujar rebasa los    */
    /*           lmites superiores de la pantalla (320,200), se recorta.  */
    /***********************************************************************/

    void dImagenMasc(int x, int y, int tx, int ty, imagen256 *imag);
    /***********************************************************************/
    /* ENTRADA:  2 enteros que especifican la coordenada en la pantalla,   */
    /*           2 enteros que determinan dimensiones en la imagen, y un   */
    /*           puntero al buffer del objeto imagen.                      */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La porcin rectangular de imagen que determinan los puntos*/
    /*           (0,0) y (tx,ty) se copia en la coordenada (x,y) de la     */
    /*           pantalla tratando el color 0 de la paleta como transpa-   */
    /*           rente, es decir, los puntos con color 0 no se copian.     */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas (x  y) es negativa se actua-*/
    /*           liza a 0. Si la porcin de imagen a dibujar rebasa los    */
    /*           lmites superiores de la pantalla (320,200), se recorta.  */
    /***********************************************************************/

    void dPunto(int x, int y, char color);
    /***********************************************************************/
    /* ENTRADA:  Dos enteros positivos que especifican una coordenada en la*/
    /*           pantalla, y un dato tipo char que determina un color.     */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   El punto de pantalla (x,y) toma el color 'color'.         */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si la coordenada especificada no corresponde a la pantalla*/
    /*           no se dibuja nada.                                        */
    /***********************************************************************/

    void cPunto(int x, int y, char *color);
    /***********************************************************************/
    /* ENTRADA:  Dos enteros positivos que especifican una coordenada en la*/
    /*           pantalla, y un puntero a un char que determina un color.  */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La variable apuntada por 'color' toma el valor del color  */
    /*           del punto (x,y) de la pantalla.                           */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si la coordenada especificada no corresponde a la pantalla*/
    /*           no se devuelve nada.                                      */
    /***********************************************************************/

    void dLinea(int x1, int y1, int x2, int y2, char color);
    /***********************************************************************/
    /* ENTRADA:  Cuatro enteros que especifican 2 coordenadas en pantalla, */
    /*           y un dato tipo char que determina un color de la paleta.  */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Dibuja un segmento de linea recta entre las coordenadas   */
    /*           (x1,y1) (x2,y2)  de la pantalla (inclusives).             */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas especificadas no corresponde */
    /*           a la pantalla no se dibuja nada.                          */
    /***********************************************************************/

    void dRectangulo(int x1, int y1, int x2, int y2, char color, char solido);
    /***********************************************************************/
    /* ENTRADA:  Cuatro enteros que especifican 2 coordenadas en pantalla, */
    /*           un dato tipo char que determina un color de la paleta, y  */
    /*           otro char que de forma booleana determina una caracteris- */
    /*           tica del objeto a dibuar.                                 */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Dibuja un rectangulo determinado por las 2 coordenadas y  */
    /*           con el color especificado (inclusives).                   */
    /*           Si 'solido'==0 solo se dibujar el contorno del mismo.    */
    /*           Si 'solido'>0 se dibujar relleno del color especificado. */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas especificadas no corresponde */
    /*           a la pantalla no se dibuja nada.                          */
    /*           Se trata de una funcin relativamente rpida, y en el caso*/
    /*           de dibujo de lineas totalmente horizontales o verticales  */
    /*           es ms eficiente que 'dLinea'.                            */
    /***********************************************************************/

    void volcar(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Se vuelca el contenido de la pantalla virtual a memoria   */
    /*           de video, con lo que se hace visible en el monitor.       */
    /* REQUIERE: El modo de video actual debe ser 320x200 y 256 colores.   */
    /* NOTAS:    Si el objeto no se ha inicializado correctamente el resul-*/
    /*           tado en pantalla no ser el deseado, pues se estar visua-*/
    /*           lizando el contenido de zonas de memoria apuntadas por el */
    /*           puntero 'B', el cuales contendr datos no relativos a la  */
    /*           imagen de la pantalla.                                    */
    /***********************************************************************/

    void liberarRAM(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Se libera la memoria retenida por el array de punteros 'B'*/
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    ~pantalla320200256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Destructor del objeto. Se libera la memoria retenida.     */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/
};



class pantalla640400256{
/***************************************************************************/
/* DESCRIPCION:   Clase para la instanciacin de objetos para el control de*/
/*                pantallas grficas virtuales de 640x400 puntos y 256 co- */
/*                lores.                                                   */
/* HERENCIA:      ---                                                      */
/* MIEMBROS PRIV: .char far* far *B: Puntero a un array de punteros, cada  */
/*                                   uno de los cuales apuntar a un buffer*/
/*                                   de memoria. La suma de todos estos bu-*/
/*                                   ffers har el total de la memoria ne- */
/*                                   cesaria para el mantenimiento de la   */
/*                                   pantalla virtual.                     */
/* MIEMBROS PUBL: .pantalla640400256(void).                                */
/*                .char inicializar(void).                                 */
/*                .void cls(char color).                                   */
/*                .void dImagen(int, int, int, int, imagen256 *).          */
/*                .void cImagen(int ,int, int, int, imagen256 *).          */
/*                .void dImagenMasc(int, int, int, int, imagen256 *).      */
/*                .void dPunto(int, int, char).                            */
/*                .void cPunto(int, int, *char).                           */
/*                .void dLinea(int, int, int, int, char).                  */
/*                .void dRectangulo(int, int, int, int, char, char).       */
/*                .void volcar(void).                                      */
/*                .void liberarRAM(void).                                  */
/*                .~pantalla640400256(void).                               */
/*                                                                         */
/* NOTAS: La razn por la que se manejan varios buffers para el manteni-   */
/*        miento de la pantalla virtual es que el compilador slo permite  */
/*        reservar 64 KBytes para un puntero, y la pantalla en cuestin    */
/*        (640x400 a 256 colores) necesita 250 KB. Se usarn, por tanto,   */
/*        4 buffers de 62.5 KB cada uno.                                   */
/***************************************************************************/
    char far* far *B;

 public:
    pantalla640400256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Constructor del objeto. Inicializa 'B' a nulo.            */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    char inicializar(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   0 si la inicializacin del objeto no ha sido correcta.    */
    /*             Falta memoria.                                          */
    /*           1 si el objeto se ha inicializado de forma correcta.      */
    /* EFECTO:   Se reserva la memoria necesaria para el mantenimiento de  */
    /*           la pantalla virtual. La estructura formada por el array de*/
    /*           punteros 'B' se inicializa a 4 celdas, cada una de ellas  */
    /*           puntero a un buffer de 62.5 KB.                           */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    Ver notas en cabecera de la clase.                        */
    /***********************************************************************/

    void cls(char color);
    /***********************************************************************/
    /* ENTRADA:  Un dato tipo char que especifica el color para cubrir.    */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La pantalla toma el color 'color' en todos sus pixels.    */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    void dImagen(int x, int y, int tx, int ty, imagen256 *imag);
    /***********************************************************************/
    /* ENTRADA:  2 enteros que especifican la coordenada en la pantalla,   */
    /*           2 enteros que determinan dimensiones en la imagen, y un   */
    /*           puntero al buffer del objeto imagen.                      */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La porcin rectangular de imagen que determinan los puntos*/
    /*           (0,0) y (tx,ty) se copia en la coordenada (x,y) de la     */
    /*           pantalla.                                                 */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas (x  y) es negativa se actua-*/
    /*           liza a 0. Si la porcin de imagen a dibujar rebasa los    */
    /*           lmites superiores de la pantalla (640,400), se recorta.  */
    /***********************************************************************/

    void cImagen(int x, int y, int tx, int ty, imagen256 *imag);
    /***********************************************************************/
    /* ENTRADA:  2 enteros que especifican la coordenada en la pantalla,   */
    /*           2 enteros que determinan dimensiones en la imagen, y un   */
    /*           puntero al buffer del objeto imagen.                      */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La porcin rectangular de pantalla que determinan los pun-*/
    /*           tos (0,0) y (tx,ty) se copia en la imagen a partir de su  */
    /*           coordenada (0,0).                                         */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas (x  y) es negativa se actua-*/
    /*           liza a 0. Si la porcin de imagen a dibujar rebasa los    */
    /*           lmites superiores de la pantalla (640,400), se recorta.  */
    /***********************************************************************/

    void dImagenMasc(int x, int y, int tx, int ty, imagen256 *imag);
    /***********************************************************************/
    /* ENTRADA:  2 enteros que especifican la coordenada en la pantalla,   */
    /*           2 enteros que determinan dimensiones en la imagen, y un   */
    /*           puntero al buffer del objeto imagen.                      */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La porcin rectangular de imagen que determinan los puntos*/
    /*           (0,0) y (tx,ty) se copia en la coordenada (x,y) de la     */
    /*           pantalla tratando el color 0 de la paleta como transpa-   */
    /*           rente, es decir, los puntos con color 0 no se copian.     */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas (x  y) es negativa se actua-*/
    /*           liza a 0. Si la porcin de imagen a dibujar rebasa los    */
    /*           lmites superiores de la pantalla (640,400), se recorta.  */
    /***********************************************************************/

    void dPunto(int x, int y, char color);
    /***********************************************************************/
    /* ENTRADA:  Dos enteros positivos que especifican una coordenada en la*/
    /*           pantalla, y un dato tipo char que determina un color.     */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   El punto de pantalla (x,y) toma el color 'color'.         */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si la coordenada especificada no corresponde a la pantalla*/
    /*           no se dibuja nada.                                        */
    /***********************************************************************/

    void cPunto(int x, int y, char *color);
    /***********************************************************************/
    /* ENTRADA:  Dos enteros positivos que especifican una coordenada en la*/
    /*           pantalla, y un puntero a un char que determina un color.  */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La variable apuntada por 'color' toma el valor del color  */
    /*           del punto (x,y) de la pantalla.                           */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si la coordenada especificada no corresponde a la pantalla*/
    /*           no se devuelve nada.                                      */
    /***********************************************************************/

    void dLinea(int x1, int y1, int x2, int y2, char color);
    /***********************************************************************/
    /* ENTRADA:  Cuatro enteros que especifican 2 coordenadas en pantalla, */
    /*           y un dato tipo char que determina un color de la paleta.  */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Dibuja un segmento de linea recta entre las coordenadas   */
    /*           (x1,y1) (x2,y2)  de la pantalla (inclusives).             */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas especificadas no corresponde */
    /*           a la pantalla no se dibuja nada.                          */
    /***********************************************************************/

    void dRectangulo(int x1, int y1, int x2, int y2, char color, char solido);
    /***********************************************************************/
    /* ENTRADA:  Cuatro enteros que especifican 2 coordenadas en pantalla, */
    /*           un dato tipo char que determina un color de la paleta, y  */
    /*           otro char que de forma booleana determina una caracteris- */
    /*           tica del objeto a dibuar.                                 */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Dibuja un rectangulo determinado por las 2 coordenadas y  */
    /*           con el color especificado (inclusives).                   */
    /*           Si 'solido'==0 solo se dibujar el contorno del mismo.    */
    /*           Si 'solido'>0 se dibujar relleno del color especificado. */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas especificadas no corresponde */
    /*           a la pantalla no se dibuja nada.                          */
    /*           Se trata de una funcin relativamente rpida, y en el caso*/
    /*           de dibujo de lineas rectas es ms eficiente que 'dLinea'. */
    /***********************************************************************/

    void volcar(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Se vuelca el contenido de la pantalla virtual a memoria   */
    /*           de video, con lo que se hace visible en el monitor.       */
    /* REQUIERE: El modo de video actual debe ser 640x400 y 256 colores.   */
    /* NOTAS:    Como la pantalla virtual rebasa la memoria de video (64K) */
    /*           se hace uso del desplazamiento de la ventana de acceso.   */
    /*           Si el objeto no se ha inicializado correctamente el resul-*/
    /*           tado en pantalla no ser el deseado, pues se estar visua-*/
    /*           lizando el contenido de zonas de memoria apuntadas por la */
    /*           estructura de punteros interna 'B', las cuales contendrn */
    /*           datos no relativos a la imagen de la pantalla.            */
    /***********************************************************************/

    void liberarRAM(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Se libera la memoria retenida por el array de punteros 'B'*/
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    ~pantalla640400256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Destructor del objeto. Se libera la memoria retenida.     */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/
};


class pantalla640480256{
/***************************************************************************/
/* DESCRIPCION:   Clase para la instanciacin de objetos para el control de*/
/*                pantallas grficas virtuales de 640x480 puntos y 256 co- */
/*                lores.                                                   */
/* HERENCIA:      ---                                                      */
/* MIEMBROS PRIV: .char far* far *B: Puntero a un array de punteros, cada  */
/*                                   uno de los cuales apuntar a un buffer*/
/*                                   de memoria. La suma de todos estos bu-*/
/*                                   ffers har el total de la memoria ne- */
/*                                   cesaria para el mantenimiento de la   */
/*                                   pantalla virtual.                     */
/* MIEMBROS PUBL: .pantalla640480256(void).                                */
/*                .char inicializar(void).                                 */
/*                .void cls(char color).                                   */
/*                .void dImagen(int, int, int, int, imagen256 *).          */
/*                .void cImagen(int ,int, int, int, imagen256 *).          */
/*                .void dImagenMasc(int, int, int, int, imagen256 *).      */
/*                .void dPunto(int, int, char).                            */
/*                .void cPunto(int, int, *char).                           */
/*                .void dLinea(int, int, int, int, char).                  */
/*                .void dRectangulo(int, int, int, int, char, char).       */
/*                .void volcar(void).                                      */
/*                .void liberarRAM(void).                                  */
/*                .~pantalla640480256(void).                               */
/*                                                                         */
/* NOTAS: La razn por la que se manejan varios buffers para el manteni-   */
/*        miento de la pantalla virtual es que el compilador slo permite  */
/*        reservar 64 KBytes para un puntero, y la pantalla en cuestin    */
/*        (640x480 a 256 colores) necesita 300 KB. Se usarn, por tanto,   */
/*        6 buffers de 50 KB cada uno                                      */
/***************************************************************************/
    char far* far *B;

 public:
    pantalla640480256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Constructor del objeto. Inicializa 'B' a nulo.            */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    char inicializar(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   0 si la inicializacin del objeto no ha sido correcta.    */
    /*             Falta memoria.                                          */
    /*           1 si el objeto se ha inicializado de forma correcta.      */
    /* EFECTO:   Se reserva la memoria necesaria para el mantenimiento de  */
    /*           la pantalla virtual. La estructura formada por el array de*/
    /*           punteros 'B' se inicializa a 6 celdas, cada una de ellas  */
    /*           puntero a un buffer de 50 KB.                             */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    Ver notas en cabecera de la clase.                        */
    /***********************************************************************/

    void cls(char color);
    /***********************************************************************/
    /* ENTRADA:  Un dato tipo char que especifica el color para cubrir.    */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La pantalla toma el color 'color' en todos sus pixels.    */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    void dImagen(int x, int y, int tx, int ty, imagen256 *imag);
    /***********************************************************************/
    /* ENTRADA:  2 enteros que especifican la coordenada en la pantalla,   */
    /*           2 enteros que determinan dimensiones en la imagen, y un   */
    /*           puntero al buffer del objeto imagen.                      */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La porcin rectangular de imagen que determinan los puntos*/
    /*           (0,0) y (tx,ty) se copia en la coordenada (x,y) de la     */
    /*           pantalla.                                                 */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas (x  y) es negativa se actua-*/
    /*           liza a 0. Si la porcin de imagen a dibujar rebasa los    */
    /*           lmites superiores de la pantalla (640,480), se recorta.  */
    /***********************************************************************/

    void cImagen(int x, int y, int tx, int ty, imagen256 *imag);
    /***********************************************************************/
    /* ENTRADA:  2 enteros que especifican la coordenada en la pantalla,   */
    /*           2 enteros que determinan dimensiones en la imagen, y un   */
    /*           puntero al buffer del objeto imagen.                      */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La porcin rectangular de pantalla que determinan los pun-*/
    /*           tos (0,0) y (tx,ty) se copia en la imagen a partir de su  */
    /*           coordenada (0,0).                                         */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas (x  y) es negativa se actua-*/
    /*           liza a 0. Si la porcin de imagen a dibujar rebasa los    */
    /*           lmites superiores de la pantalla (640,480), se recorta.  */
    /***********************************************************************/

    void dImagenMasc(int x, int y, int tx, int ty, imagen256 *imag);
    /***********************************************************************/
    /* ENTRADA:  2 enteros que especifican la coordenada en la pantalla,   */
    /*           2 enteros que determinan dimensiones en la imagen, y un   */
    /*           puntero al buffer del objeto imagen.                      */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La porcin rectangular de imagen que determinan los puntos*/
    /*           (0,0) y (tx,ty) se copia en la coordenada (x,y) de la     */
    /*           pantalla tratando el color 0 de la paleta como transpa-   */
    /*           rente, es decir, los puntos con color 0 no se copian.     */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas (x  y) es negativa se actua-*/
    /*           liza a 0. Si la porcin de imagen a dibujar rebasa los    */
    /*           lmites superiores de la pantalla (640,480), se recorta.  */
    /***********************************************************************/

    void dPunto(int x, int y, char color);
    /***********************************************************************/
    /* ENTRADA:  Dos enteros positivos que especifican una coordenada en la*/
    /*           pantalla, y un dato tipo char que determina un color.     */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   El punto de pantalla (x,y) toma el color 'color'.         */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si la coordenada especificada no corresponde a la pantalla*/
    /*           no se dibuja nada.                                        */
    /***********************************************************************/

    void cPunto(int x, int y, char *color);
    /***********************************************************************/
    /* ENTRADA:  Dos enteros positivos que especifican una coordenada en la*/
    /*           pantalla, y un puntero a un char que determina un color.  */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   La variable apuntada por 'color' toma el valor del color  */
    /*           del punto (x,y) de la pantalla.                           */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si la coordenada especificada no corresponde a la pantalla*/
    /*           no se devuelve nada.                                      */
    /***********************************************************************/

    void dLinea(int x1, int y1, int x2, int y2, char color);
    /***********************************************************************/
    /* ENTRADA:  Cuatro enteros que especifican 2 coordenadas en pantalla, */
    /*           y un dato tipo char que determina un color de la paleta.  */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Dibuja un segmento de linea recta entre las coordenadas   */
    /*           (x1,y1) (x2,y2)  de la pantalla (inclusives).             */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas especificadas no corresponde */
    /*           a la pantalla no se dibuja nada.                          */
    /***********************************************************************/

    void dRectangulo(int x1, int y1, int x2, int y2, char color, char solido);
    /***********************************************************************/
    /* ENTRADA:  Cuatro enteros que especifican 2 coordenadas en pantalla, */
    /*           un dato tipo char que determina un color de la paleta, y  */
    /*           otro char que de forma booleana determina una caracteris- */
    /*           tica del objeto a dibuar.                                 */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Dibuja un rectangulo determinado por las 2 coordenadas y  */
    /*           con el color especificado (inclusives).                   */
    /*           Si 'solido'==0 solo se dibujar el contorno del mismo.    */
    /*           Si 'solido'>0 se dibujar relleno del color especificado. */
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* NOTAS:    Si alguna de las coordenadas especificadas no corresponde */
    /*           a la pantalla no se dibuja nada.                          */
    /*           Se trata de una funcin relativamente rpida, y en el caso*/
    /*           de dibujo de lineas rectas es ms eficiente que 'dLinea'. */
    /***********************************************************************/

    void volcar(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Se vuelca el contenido de la pantalla virtual a memoria   */
    /*           de video, con lo que se hace visible en el monitor.       */
    /* REQUIERE: El modo de video actual debe ser 640x480 y 256 colores.   */
    /* NOTAS:    Como la pantalla virtual rebasa la memoria de video (64K) */
    /*           se hace uso del desplazamiento de la ventana de acceso.   */
    /*           Si el objeto no se ha inicializado correctamente el resul-*/
    /*           tado en pantalla no ser el deseado, pues se estar visua-*/
    /*           lizando el contenido de zonas de memoria apuntadas por la */
    /*           estructura de punteros interna 'B', las cuales contendrn */
    /*           datos no relativos a la imagen de la pantalla.            */
    /***********************************************************************/

    void liberarRAM(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Se libera la memoria retenida por el array de punteros 'B'*/
    /* REQUIERE: Que el mtodo 'inicializar' se haya ejecutado con exito.  */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/

    ~pantalla640480256(void);
    /***********************************************************************/
    /* ENTRADA:  ---                                                       */
    /* SALIDA:   ---                                                       */
    /* EFECTO:   Destructor del objeto. Se libera la memoria retenida.     */
    /* REQUIERE: ---                                                       */
    /* NOTAS:    ---                                                       */
    /***********************************************************************/
};

#endif;