/* Analizador de frecuencias de aparicin de caracteres en textos. V 1.0

		Programador: Antonio Javier Garca Martnez.
		Alias: G|N.
		Fundador del Club Virtual Zone.

		(c) Club Virtual Zone. 	GRANADA 1995. */

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

#define MAX(A,B) ( (A>B) ? A : B)

void main (void)
{
	unsigned int ASCII[256];
	unsigned int masfrecuencia[10],  max, letra;
	unsigned char caracteres[10];


	char file[80];
	FILE *in, *out;
	unsigned char ch,i,j;
	long int nchar;       // guarda el n total de caracteres

	clrscr();
	printf("\n   Analizador de frecuencias de aparicin de caracteres en textos. V 1.0\n");
	printf("\n\nNombre de archivo a analizar: ");
	scanf("%s",file);


	if ((in=fopen( file, "rb"))==NULL) {
		printf("\n\aError al abrir archivo.");
		exit(1);
	}

	for (i=0; i<255; i++)       //Limpiar
		ASCII[i]=0;

	nchar=0;

	if (!feof(in))
		while(1) {
			ch=fgetc(in);
			nchar++;
			if (!feof(in))
				ASCII[ch]++;
			else
				break;
		}

	fclose(in);


	for (j=0; j<10; j++)
	{
		max=0;
		for (i=0; i<255; i++) {
			masfrecuencia[j]=MAX(ASCII[i],max);
			if (max<ASCII[i]) {
				letra=i;
				max=ASCII[i];
			}
		}

		ASCII[letra]=0;
		caracteres[j]=letra;

	}

	printf("\n\nLos 10 caracteres ms frecuentes son:\n");

	for (j=0; j<10; j++)
		printf("\nCARACTER: %c    ASCII: %3dd | %.3xh    VECES:  %5d    FRECUENCIA: %5.2f %%."
		   ,(caracteres[j]>31) ? caracteres[j] : '.' ,caracteres[j], caracteres[j],masfrecuencia[j]
		   ,(float) ((double) masfrecuencia[j]/(double) nchar)*100);

	printf("\n\n\t\tAntonio Javier Garca Martnez. (G|N).\n\t\t\t   Club Virtual Zone.\n\t\t\t     GRANADA 1995.\n");


}

