;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;    M A D f f   -->   Multi-Archive Designation File Format   ;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MADFFHeader     STRUC
  Pertenencia   DB  32 DUP (0)
  EOF           DB      0
  MADTamanyo    DD      0
  Identificador DB   4 DUP (0)
  MADVersion    DB      0
                ENDS

VariableHeader  STRUC
  MADTipo       DB      0
  MADHandle     DW      0
  MADCompresion DB      0
  SubTipo       DW      0
 Desplazamiento DD      0
  MADLongitud   DD      0
                ENDS

CabeceraMAD     MADFFHeader <0>
CabeceraArchivo VariableHeader <0>
HandleFile      DW      0
MadFile         DB  14 DUP (0)
Error           DB      'ERROR de fichero$'

;;  Se le pasa en DS:SI un puntero al nombre del fichero.
NuevoArchivo    PROC
                PUSHA
                PUSH    ES
                MOV     CX, 12/4
                MOV     DI, Offset MADfile
                PUSH    CS
                POP     ES
                REP  MOVSD              ;  Movemos DWords.
                POP     ES
                POPA
                RET
NuevoArchivo    ENDP

;;  A esta funcin se le pasa en AX el nmero de campo total y en ES:DI el
;; lugar donde se copiar lo del disco.
LeeEntrada      PROC
                PUSHAD
                PUSH    DS
                PUSH    AX
                MOV     DX, Offset MADfile
                PUSH    CS
                POP     DS
                MOV     AX, 3D00h
                INT     21h             ;  Abrimos el fichero.
                JC    ErrorDisk
                MOV     CS:[HandleFile], AX
                MOV     BX, AX
                PUSH    CS
                MOV     AH, 3Fh
                MOV     CX, 42          ;  El tamao de la cabecera.
                POP     DS
                MOV     DX, Offset CabeceraMAD
                INT     21h             ;  Leemos la cabecera.
                JC    ErrorDisk
                CMP     DWORD PTR CS:[CabeceraMAD.Identificador], 'XSGI'
                POP     AX
                JNE   ErrorMAD
                MOV     DX, 14
                MUL     DX              ;   n * 14
                ADD     AX, 42          ;  (n * 14) + 42
                ADC     DX, 0
                MOV     CX, DX
                MOV     DX, AX          ;  Colocamos todo en su stio...
                MOV     BX, CS:[HandleFile]
                MOV     AX, 4200h
                INT     21h             ; ...y nos resituamos.
                JC    ErrorMAD
                MOV     BX, CS:[HandleFile]
                PUSH    CS
                MOV     AH, 3Fh
                MOV     CX, 14          ;  El tamao de la cabecera.
                POP     DS
                MOV     DX, Offset CabeceraArchivo
                INT     21h             ;  Leemos la cabecera variable.
                JC    ErrorMAD
                CMP     CS:[CabeceraArchivo.MADCompresion], 1
                JNE   ErrorMAD          ;  No se acepta ningn tipo de cmpres.

                MOV     DX, WORD PTR CS:[CabeceraArchivo.Desplazamiento]
                MOV     CX, WORD PTR CS:[CabeceraArchivo.Desplazamiento+2]
                MOV     AX, 4200h
                MOV     BX, CS:[HandleFile]
                INT     21h
                MOV     CX, WORD PTR CS:[CabeceraArchivo.MADLongitud]
                PUSH    ES              ;  ATENCIN: tamao mximo 1 segmento.
                POP     DS
                MOV     DX, DI
                MOV     BX, CS:[HandleFile]
                MOV     AH, 3Fh
                INT     21h             ;  Leemos el fichero.
                MOV     AH, 3Eh
                MOV     BX, CS:[HandleFile]
                INT     21h             ;  Cerramos el fichero.
                POP     DS
                POPAD
                RET
LeeEntrada      ENDP

;;  A esta funcin se le pasa en AX el nmero de campo total y en ES:DI el
;; lugar donde se copiar lo del disco. Adicionalmente, en EBP se le pasar
;; la longitud del trozo a leer y en ESI el inicio dentro del archivo.
LeeTrozo        PROC
                PUSHAD
                PUSH    DS
                PUSH    AX
                MOV     DX, Offset MADfile
                PUSH    CS
                POP     DS
                MOV     AX, 3D00h
                INT     21h             ;  Abrimos el fichero.
                JC    ErrorMAD
                MOV     CS:[HandleFile], AX
                MOV     BX, AX
                PUSH    CS
                MOV     AH, 3Fh
                MOV     CX, 42          ;  El tamao de la cabecera.
                POP     DS
                MOV     DX, Offset CabeceraMAD
                INT     21h             ;  Leemos la cabecera.
                JC    ErrorMAD
                CMP     DWORD PTR CS:[CabeceraMAD.Identificador], 'XSGI'
                POP     AX
                JNE   ErrorMAD
                MOV     DX, 14
                MUL     DX              ;   n * 14
                ADD     AX, 42          ;  (n * 14) + 42
                ADC     DX, 0
                MOV     CX, DX
                MOV     DX, AX          ;  Colocamos todo en su stio...
                MOV     BX, CS:[HandleFile]
                MOV     AX, 4200h
                INT     21h             ; ...y nos resituamos.
                JC    ErrorMAD
                MOV     BX, CS:[HandleFile]
                PUSH    CS
                MOV     AH, 3Fh
                MOV     CX, 14          ;  El tamao de la cabecera.
                POP     DS
                MOV     DX, Offset CabeceraArchivo
                INT     21h             ;  Leemos la cabecera variable.
                JC    ErrorMAD
                CMP     CS:[CabeceraArchivo.MADCompresion], 1
                JNE   ErrorMAD          ;  No se acepta ningn tipo de cmpres.

                MOV     DX, WORD PTR CS:[CabeceraArchivo.Desplazamiento+2]
                SHL     EDX, 16
                MOV     DX, WORD PTR CS:[CabeceraArchivo.Desplazamiento]
                ADD     EDX, ESI
                MOV     CX, DX
                SHR     EDX, 16
                XCHG    CX, DX
                MOV     AX, 4200h
                MOV     BX, CS:[HandleFile]
                INT     21h
                MOV     CX, BP
                PUSH    ES              ;  ATENCIN: tamao mximo 1 segmento.
                POP     DS
                MOV     DX, DI
                MOV     BX, CS:[HandleFile]
                MOV     AH, 3Fh
                INT     21h             ;  Leemos el fichero.
                MOV     AH, 3Eh
                MOV     BX, CS:[HandleFile]
                INT     21h             ;  Cerramos el fichero.
                POP     DS
                POPAD
                RET
LeeTrozo        ENDP

;;  Esta funcin devuelve en EBP la longitud del fichero cuyo nmero de campo
;; total est especificado en AX.
LongitudFile    PROC
                PUSHAD
                PUSH    DS
                PUSH    AX
                MOV     DX, Offset MADfile
                PUSH    CS
                POP     DS
                MOV     AX, 3D00h
                INT     21h             ;  Abrimos el fichero.
                JC    ErrorMAD
                MOV     CS:[HandleFile], AX
                MOV     BX, AX
                PUSH    CS
                MOV     AH, 3Fh
                MOV     CX, 42          ;  El tamao de la cabecera.
                POP     DS
                MOV     DX, Offset CabeceraMAD
                INT     21h             ;  Leemos la cabecera.
                JC    ErrorMAD
                CMP     DWORD PTR CS:[CabeceraMAD.Identificador], 'XSGI'
                POP     AX
                JNE   ErrorMAD
  @@LeeArchivo: MOV     DX, 14
                MUL     DX              ;   n * 14
                ADD     AX, 42          ;  (n * 14) + 42
                ADC     DX, 0
                MOV     CX, DX
                MOV     DX, AX          ;  Colocamos todo en su stio...
                MOV     BX, CS:[HandleFile]
                MOV     AX, 4200h
                INT     21h             ; ...y nos resituamos.
                JC    ErrorMAD
                MOV     BX, CS:[HandleFile]
                PUSH    CS
                MOV     AH, 3Fh
                MOV     CX, 14          ;  El tamao de la cabecera.
                POP     DS
                MOV     DX, Offset CabeceraArchivo
                INT     21h             ;  Leemos la cabecera variable.
                JC    ErrorMAD
                MOV     BX, CS:[HandleFile]
                MOV     AH, 3Eh
                INT     21h
                POP     DS              ;  Pillamos la longitud despus de
                POPAD                   ; desapilar.
                MOV     EBP, CS:[CabeceraArchivo.MADLongitud]
                RET
LongitudFile    ENDP

ErrorDisk       LABEL   PROC
ErrorMAD        LABEL   PROC
                MOV     AH, 9
                PUSH    CS
                POP     DS
                MOV     DX, Offset Error
                INT     21h
                MOV     AX, 4C00h
                INT     21h
                END
