.MODEL TINY
.CODE

                ORG     100h
Inicio:         JMP    Horizontales

PonPixel        PROC                    ;  Coordenadas del punto en (BX,DX).
                PUSH    AX              ;  Siempre debemos guardar todos los
                PUSH    BX              ; registros usados por la funcin para
                PUSH    DX              ; no llevarnos sorpresas.
                PUSH    ES
                MOV     AX, 320         ;  Cargamos AX para la multiplicacin.
                MUL     DX              ;  Hacemos la multiplicacin por Y*320
                ADD     BX, AX          ;  Sumamos la coordenada X.
                MOV     AX, 0A000h
                MOV     ES, AX          ;  Cargamos en ES el segmento de video.
                MOV     ES:[BX], CL     ;  Escribimos el byte (color) deseado.
                POP     ES
                POP     DX              ;  Debemos acordarnos de recoger todo
                POP     BX              ; lo que empujamos en la pila o el
                POP     AX              ; programa se colgar (la direccin
                RET                     ; de retorno tambien se guarda en la
PonPixel        ENDP                    ; pila).

Horizontales    PROC
                MOV     AX, 0013h
                INT     10h             ;  Entramos en el modo grfico 13h.

                XOR     DX, DX          ;  Coordenada Y inicializada a 0.
          @@BucleY:                     ;  Bucle principal.
                XOR     BX, BX          ;  Coordenada X inicializada a 0.
            @@BucleX:
                MOV     CL, DL          ;  Dibujamos un punto en (BX,DX) con
                CALL    PonPixel        ; el color en CL.
                INC     BX              ;  Un pixel ms a la derecha.
                CMP     BX, 320         ;  Hasta que lleguemos al final
                JB    @@BucleX          ; de la columna (320).
                INC     DX              ;  Siguiente lnea.
                CMP     DX, 200         ;  Hasta que lleguemos a la ltima
                JB    @@BucleY          ; lnea de pantalla (200).

                XOR     AH, AH          ;  Esperamos la pulsacin de una tecla
                INT     16h             ; (funcin 0 de la INT 16h de la BIOS).
                MOV     AX, 3
                INT     10h             ;  Modo texto predeterminado.
                MOV     AX, 4C00h
                INT     21h             ;  Salimos al DOS.
Horizontales    ENDP
                END     Inicio
