
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
#include "CHARS.INC"
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"
#include "GLASS.INC"
#include "ATMOS.INC"
#include "FINISH.INC"
#include "GOLDS.INC"
#include "STARS.INC"
#include "STONEOLD.INC"

/************************************************/

camera
{
  location
  			<.5, 1.6, 0.2>
  			//<2, 1, -2>

  look_at   <.5, 0, 1>
}

// LUZ DE AMBIENTE
light_source
{ 0*x     // posicion inicial
  color rgb 1.0
  area_light
  <8, 0, 0> <0, 0, 8> //  Se forma una matriz de luces
  4, 4                // de tamao 4x4
  adaptive 0
  jitter
  translate <400, 800, -400>  // La ponemos aqui.
}

// Al fondo un cielo envolvente azulado
//sky_sphere { pigment { SkyBlue } }

// MOLA--->  normal{bumps 1 scale 5}
/***********************************************************/
light_source{ <100,100,-100> color White}

height_field {
   tga "prueva_k.tga"
   water_level 0.0
	smooth
   pigment { 
        image_map { tga "prueva_k1.tga" }
   		rotate 90*x
   }

}
