
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"
/************************************************/


// set viewer's position in the scene
camera
{
  location  <0, .75, -1.35>
  look_at   <1.5, 0.0,  1.0>
}


// create a point "spotlight" (conical directed) light source
light_source
{
  <0, 20, -10>
  color White
}

light_source
{
  <1, 1, -1.5>
  color OrangeRed
}
#declare letrero=height_field
{
   tga "pueva_kk.tga"
   water_level 0.0

}
union {
	box { <0, 0, -.5> <1.5, 1.5, -0.01>
		translate <-.2, -.2, 0>}
	
	object { letrero
			rotate -90*x
	}
	
    pigment { color BrightGold } 
	finish { reflection 0.3 }
}

sky_sphere {
	pigment { SkyBlue }
}
