
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "Metals.inc"
/************************************************/

camera
{
  location	//<-3, 15, -7> //Perspectiva
  			//<30, 5, 0> //Frente
			//< 4, 0,-7> //Lateral
			<12, 21, 0> //Arriba
  look_at   <12, 0, 0>
}

// LUZ DE AMBIENTE
light_source
{ 0*x     // posicion inicial
  color rgb 1.0
  area_light
  <8, 0, 0> <0, 0, 8> //  Se forma una matriz de luces
  4, 4                // de tamao 4x4
  adaptive 0
  jitter
  translate <40, 80, -40>  // La ponemos aqui.
}

// Al fondo un cielo envolvente azulado
sky_sphere { pigment { SkyBlue } }

// MOLA--->  normal{bumps 1 scale 5}
/***********************************************************/


		/*****************************************************
		 ****************  MANGO DE LA ESPADA ****************
		 *****************************************************/
#declare Largo=12    // define la longitud del mango,
#declare ancho=0.7   //  el grosor y la robustez..
#declare gordo=0.3
#declare Toro=torus	{
			  	ancho,
				gordo
				rotate 90*z

			}
#declare Distancia=Largo*0.4
#declare Mango=union {
	#declare KK=Largo
	#declare K=0
	#while ( KK>=1 )
		#declare KK=KK-1
		object { Toro  translate K*x }
		#declare K=0.4*KK
	#end
	sphere { <-0.45, 0, 0> ancho+gordo }

	//scale <1,1,1.3>
}

// Medio toro
#declare Medio_toro=intersection {
	torus	{
		ancho+gordo,
		(ancho+gordo)/2 //0.5
	}
	plane{ -.25*z 0 }
}


#declare Empun=union{
	#declare Mov=Distancia+1
	object { Mango
	}
	sphere {
		0
		(ancho+gordo)*1.5

		translate Mov*x
	}
	#declare largo=Largo/2
	#declare Centro=largo/2
	cylinder {
		0*z,
		largo*z,
		(ancho+gordo)/2
		translate <Mov, 0, -Centro>
	}
	#declare H_toro=Mov+ancho+gordo
	#declare H_toro2=H_toro+ancho+gordo
	object { Medio_toro
		translate<H_toro, 0, Centro>
	}
	object { Medio_toro
		rotate 180*x
		translate<H_toro, 0, -Centro>
	}
	#declare bolita=sphere{	0 (ancho+gordo)/2
	}
	object { bolita
		translate <H_toro2, 0, Centro>
	}
	object { bolita
		translate <H_toro2, 0, -Centro>
	}
	
	scale <1,1,1.3>
}

   /***************************************************
	**************** FILO DE LA ESPADA ****************
	***************************************************/
		 //    (define tus propias medidas)
/*
( poner el filo a una distancia *Mov*, del origen de coordenadas )
*/
#declare F_alto  = 10       // Largaria del filo
#declare F_grueso= 1		// Grosor del filo
#declare F_ancho =2			// Anchura del filo
#declare H_alto  =4			// Altura de la punta

#declare Alt=H_alto/3
#declare Gro=F_grueso/2
#declare Anch=F_ancho/2
#declare Anchk=Anch-0.75
#declare punta=union {
		triangle { <0, 0, -Anch>,      <-Gro, 0, -Anchk>,   <0, H_alto, 0> }
     	triangle { <-Gro, 0, -Anchk>,   <-Gro, 0, Anchk >, <-Gro, Alt, 0>}
	 	triangle { <-Gro, 0, -Anchk>,   <-Gro, Alt, 0>, <0, H_alto, 0>    }
		triangle { <-Gro, 0, Anchk>, <-Gro, Alt, 0>, <0, H_alto, 0>    }
      	triangle { <-Gro, 0, Anchk>,  <0, 0, Anch>,      <0, H_alto, 0>    }
      	triangle { <  0, 0, Anch>,    <Gro, 0, Anchk>,  <0, H_alto, 0>    }
	  	triangle { <+Gro, 0, Anchk>,  <Gro, Alt, 0>,  <0, H_alto, 0>    }
	  	triangle { <+Gro, 0, -Anchk>,   <Gro, Alt, 0>,  <0, H_alto, 0>    }
	  	triangle { <+Gro, 0, Anchk >, <Gro, 0, -Anchk>,   <Gro, Alt, 0> }
	  	triangle { <+Gro, 0, -Anchk>,   <0, 0, -Anch>, <0, H_alto, 0>    }
	}
#declare Hoja=union {
	prism {
		linear_sweep // or conic_sweep for tapering to a point
  		linear_spline // linear_spline | quadratic_spline | cubic_spline
		0,        // height 1
   		F_alto,        // height 2
  		7,          // numero de puntos
  		// puntos
  		<0,-Anch>,<-Gro,-Anchk>,<-Gro,Anchk>,<0,Anch>,<Gro,Anchk>,
		<Gro,-Anchk>,<0,-Anch>

	}
	object { punta  translate <0, F_alto, 0> }

}
#declare Tex=texture{ 
		pigment { Red }
		finish {
			roughness 0.7
		}
}
# declare Espada=union{
	object { Empun
		texture { pigment { red 1 blue .6 green .7 } }
	}
	object { Hoja
		texture { T_Chrome_5D  }
		rotate -90*z
		translate Mov*x
	}
}


object { Espada
	rotate 30*x
}
