//  Implementacin de la clase habitacin.

#include "room.hpp"

Room :: Room(char *text)	//  Constructor de la clase "room".
{
 num_obj=0;			//  Inicialmente 0 objetos.
 norte=sur=este=oeste=NULL;	//  No apuntan a ningun sitio.
 texto=text;			//  Copiamos el puntero simplemente.
 }

void Room :: describe(void)	//  Funcin para escribir la descripcin.
{
 cout << texto << endl;         //  Escribimos la descripcin.
 if(num_obj>0) {
   cout << "Puedo ver: ";
   for(int i=0; i<num_obj; i++) {
     cosa[i]->es_nombre();	//  Dice todo lo que hay.
     if(i!=num_obj-1)
       cout << ", ";		//  No debe aparecer la ltima coma.
      else
       cout << endl;
     }
   }
 }

objeto *Room :: coge_obj(Texto &que)
{				//  Funcin para coger objetos de la sala.
 int num=num_obj+1;		//  Ms all del ltimo.
 for(int i=0; i<num_obj; i++)
   if(cosa[i] -> es_un(que))	//  Comprobamos 1 por 1 a ver si est.
     num=i;
 if(num>num_obj) return NULL;	//  Si no estaba el objeto.
 else {
   objeto *aux=cosa[num];	//  Guardamos en aux el objeto.
   for(int i=num+1; i<num_obj; i++)
     cosa[i-1]=cosa[i];		//  Reponemos el array de objetos.
   --num_obj;			//  Ahora hay un objeto menos.
   return aux;			//  Devolvemos el puntero al objeto.
   }
 }

void Room :: deja_obj(objeto *cual)
{
 if(num_obj<MAX_OBJ)		//  Hay que tener cuidado en no pasarse.
   cosa[num_obj++]=cual;	//  Lo dejamos por ah...
 }

void Room :: conecta(Room *h1, int direc)
{
 switch(direc)
  {
   case R_NORTE:
     if(norte==NULL) {
       norte=h1;		     //  Guardamos la direccin de la sala.
       h1 -> conecta(this, R_SUR);   //  Conectamos la otra habitacin por el sur.
       }
     break;
   case R_ESTE:
     if(este==NULL) {
       este=h1;			     //  Guardamos la direccin de la sala.
       h1 -> conecta(this, R_OESTE); //  Conectamos la otra habitacin por el oeste.
       }
     break;
   case R_SUR:
     if(sur==NULL) {
       sur=h1;			     //  Guardamos la direccin de la sala.
       h1 -> conecta(this, R_NORTE); //  Conectamos la otra habitacin por el norte.
       }
     break;
   case R_OESTE:
     if(oeste==NULL) {
       oeste=h1;		     //  Guardamos la direccin de la sala.
       h1 -> conecta(this, R_ESTE);  //  Conectamos la otra habitacin por el sur.
       }
     break;
   }
 }

void Room :: salidas(void)
{				//  Escribe todas las salidas posibles.
 cout << "Salidas: ";
 if(norte!=NULL)
   cout << "norte ";
 if(este!=NULL)
   cout << "este ";
 if(sur!=NULL)
   cout << "sur ";
 if(oeste!=NULL)
   cout << "oeste ";
 cout << endl;
 }

Room *Room :: ir_a(int direc)	//  Funcin para transladarse por las
{				// habitaciones contiguas.
 switch(direc)
  {
   case R_NORTE:
     if(norte!=NULL)		//  Si se puede salir por ah...
       return norte;
     break;
   case R_ESTE:
     if(este!=NULL)		//  Si se puede salir por ah...
       return este;
     break;
   case R_SUR:
     if(sur!=NULL)		//  Si se puede salir por ah...
       return sur;
     break;
   case R_OESTE:
     if(oeste!=NULL)		//  Si se puede salir por ah...
       return oeste;
     break;
   }
 return NULL;			//  Si no est devuelve NULL.
 }

objeto *Room :: info_objeto(int index)  //  Devuelve el objeto i-simo.
{
 if(index<num_obj)
   return cosa[index];
  else
   return NULL;
 }
