//  Ejemplo de aventuras conversacionales    --->  Navi/PhyMosys
//  Mdulo principal

extern "C" {
  #include <string.h>
  #include <stdio.h>
  }
#include <iostream.h>
#include "objects.hpp"		//  Inclusin de las clases objetos y
#include "room.hpp"		// habitaciones.
#include "texto.hpp"		//  Para usar las cadenas.

char *des1="Estas en una gran sala llena de polvo y... telaraas.";
char *des2="Esto es una habitacin muy oscura y llena de polvo.";
char *des3="Estas en una pequea sala con un gran ventanal.";

char *obj1="Es un sable muy pesado. Debe ser una buena arma.";
char *obj2="Es una botella llena de agua, puede ser util.";
char *obj3="Se trata de una bolsa llena de polvo.";
char *obj4="Con estos prismaticos puedo ver muy lejos.";

char *palabras[] = { "norte", "este", "sur", "oeste", "i", "describe",
		     "coger", "dejar", "help", "quit", "mirar" };
#define _NUM_COMM_ 10

int main(void)
{
 Room h1(des1);			//  Definimos las salas.
 Room h2(des2);
 Room h3(des3);
 h1.conecta(&h2, R_SUR);	//  Conectamos las salas.
 h1.conecta(&h3, R_NORTE);

 objeto o1("Sable", obj1);	//  Cargamos los objetos.
 objeto o2("Botella", obj2);
 objeto o3("Bolsa", obj3);
 objeto o4("Prismaticos", obj4);

 h1.deja_obj(&o1);		//  Dejamos los objetos donde corresponde.
 h1.deja_obj(&o2);
 h2.deja_obj(&o3);
 h3.deja_obj(&o4);

 Texto comando, param,		//  Cadena donde cogemos los comandos.
       p1, p2;			//  Para sub-dividir los comandos.
 Room *sala=&h1;		//  Apunta a la sala actual.
 Room *aux;
 objeto *aux_o;			//  Objetos auxiliares.

 objeto *obj[20];		//  Array con los objetos que lleva el
 int num=0;			// personaje y nmero de estos.
 int i, j;			//  Variables auxiliars per a bucles.
 int valor_com;			//  Un valor que s'asigna al comando.

 for(int fin=0==1; !fin;) {	//  Bucle "sin fin".
   if(aux!=sala) {
     sala->describe();
     sala->salidas();		//  Muestra la descripcin y las salidas.
     }
   cout << endl << ">";
   cin >> comando;		//  Leemos el comando.
   comando.minusculas();	//  Convertimos a minusculas.

   aux=sala;			//  Guardar temporalmente la sala.
   p1.copia(comando.palabra(1));
   if(comando.num_palabras()==2)
     p2.copia(comando.palabra(2));

   for(valor_com=0; palabras[valor_com] && valor_com<_NUM_COMM_+1; valor_com++)
     if(p1.igual(palabras[valor_com]))
       break;

   switch(valor_com) {
     case 0:
     case 1:
     case 2:
     case 3:			//  Nos movemos por el mundo.
       sala=sala->ir_a(valor_com+1);	//  Ya se que no es una buena forma,
       if(sala==NULL) {			// pero es la ms corta.
	 sala=aux;		//  Comprobacin de que el moviento es correcto.
	 cout << "No puedes ir en esa direccin." << endl;
	 }
       break;

     case 4:			//  Hacer un inventario.
       if(num==0)
	 cout << "No tengo nada :(" << endl;
	else {
	 cout << "Tengo: ";
	 for(i=0; i<num; i++) {
	   obj[i]->es_nombre();	//  Escribimos todo lo que hay.
	   if(i!=num-1)
	     cout << ", ";	//  No debe aparecer la ltima coma.
	    else
	     cout << endl;
	   }
	 }
       break;

     case 5:                    //  Describir un objeto.
       i=0;
       aux_o=&o1;	//  Si lo ponemos a NULL parar el while enseguida :)
       while(aux_o!=NULL) {
	 aux_o=sala->info_objeto(i++);
	 if(aux_o->es_un(p2)) {
	   cout << aux_o->describe() << endl;
	   break;
	   }
	 }
       if(aux_o==NULL)
	 for(j=0; j<num; j++)
	   if(obj[j]->es_un(p2)) {
	     cout << obj[j]->describe() << endl;
	     break;
	     }
       break;

     case 6:                    //  Coger un objeto.
       if((aux_o=sala->coge_obj(p2))==NULL)
	 cout << "No puedo ver eso..." << endl;
	else
	 obj[num++]=aux_o;	//  Aadimos a la lista.
       break;

     case 7:               	//  Dejar un objeto.
       for(i=0; i<num; i++)
         if(obj[i]->es_un(p2)) {
	   sala->deja_obj(obj[i]);
	   for(int j=i; j<num-1; j++)
	     obj[j]=obj[j+1];
	   --num;
	   break;
	   }
       break;

     case 8:			//  Mostra un messatge d'ajuda.
       cout << " Puedes usar los siguientes comandos:" << endl\
	    << "  norte, sur, este, oeste -> Te mueves por el mundo" << endl\
	    << "  i -> Inventario de objetos" << endl\
	    << "  describe -> Da una descripcion de un objeto" << endl\
	    << "  coger, dejar -> Te permite coger o dejar objetos" << endl\
	    << "  mirar -> Repite la descripcin de la sala" << endl\
	    << "  quit -> Termina la ejecucin del juego" << endl;
       break;

     case 9:                    //  Comando quit.
       fin=1==1;
       break;			//  Si el usuario se quiere ir...

     case 10:			//  Comando mirar.
       sala->describe();
       sala->salidas();		//  Muestra la descripcin y las salidas.
       break;

     default:			//  Si no se entiende.
       cout << "Comorl??? Reptemelo con otras palabras" << endl;
       break;
     }
   }

 return 0;		//  Fin de la partida.
 }
