//  Funciones para controlar la SOUND BLASTER desde Turbo-C.
//       en el modo directo.     Por Navi Dj.

void interrupt SBDirect();

long ticks, contador;
word long_onda;
byte SBON=0, veces=0, ONCE=0;
char *inic_wave;
void interrupt (*oldfunc)();

void InicSB(void)
{
 while((inportb(0x22c) & 0x80)!=0);     //  Espera
 outp(0x22c,0xd1);                      //  Speaker ON
 }

void EndSB(void)
{
 while((inportb(0x22c) & 0x80)!=0);     //  Espera
 outp(0x22c,0xd3);                      //  Speaker OFF
 }

void PLAY(word velocidad, word longitud, char *inicio)
{
 SBON=1;
 long_onda=longitud;
 inic_wave=inicio;
 contador=0x1234DD/velocidad;
 ticks=0;

 outp(0x43,0x34);
 outp(0x40,contador % 256);
 outp(0x40,contador/256);

 oldfunc=getvect(8);
 setvect(8,SBDirect);
 }

void STOP(void)
{
 setvect(8,oldfunc);
 SBON=0;

 outp(0x43,0x34);
 outp(0x40,0);
 outp(0x40,0);
 }

void PLAY_Once(word velocidad, word longitud, char *inicio)
{
 veces=0; ONCE=1;
 PLAY(velocidad,longitud,inicio);
 }

void interrupt SBDirect(void)
{
 while((inportb(0x22c) & 0x80)!=0);   // Espera
 outp(0x22c,0x10);
 while((inportb(0x22c) & 0x80)!=0);   // Espera
 outp(0x22c,*(inic_wave+ticks));

 if(++ticks>=long_onda) { ticks=0; veces++; }
 oldfunc();
 }
