;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;                                                      ;;
;;;;;;;;;;;;;;;;;;;;;;;        MAPEDIT                    NAVI Dj.           ;;
;;;;;;;;;;;;;;;;;;;;;;;                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;                Usando  GRAPH v1.2                    ;;
;;;;;;;;;;;;;;;;;;;;;;;                                                      ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.MODEL SMALL
.STACK
.386

.DATA
FilePCX         DB  13 DUP (0)          ;  Nombre del fichero PCX.
MapName         DB  13 DUP (0)          ;  Nombre del fichero de mapas.
PVirtual        DB      0               ;  PV del PCX.
Color           DB      0               ;  Color del rectngulo.
CoorX1          DW      0
CoorY1          DW      0
CoorX2          DW      0
CoorY2          DW      0               ;  Coordenadas del rectangulo.
SizeX           DW      0
SizeY           DW      0               ;  Tamao X e Y del sprite.
Sprite          DB      0               ;  Handle de sprite.
Handle          DW      0               ;  Handle del fichero.
ERROR           DB  ' ERROR: Debes indicar en la lnea de comandos lo siguiente:',0Dh,0Ah
                DB  '     MAPEDIT  /Pnombre_pcx  /Snombre_blk  /Xtamao  /Ytamao  [/Ccolor]$'

.CODE
INCLUDE GRFLIB2.INC

InicMouse       PROC                    ;  Resetea el ratn.
                XOR     AX, AX
                INT     33h
                MOV     AX, 1
                INT     33h
                MOV     AX, 0Fh
                MOV     CX, 8
                MOV     DX, 16
                INT     33h
                XOR     CX, CX
                MOV     DX, 319         ;  Tamao X
                MOV     AX, 7
                INT     33h
                XOR     CX, CX
                MOV     DX, 199         ;  Tamao Y
                MOV     AX, 8
                INT     33h
                RET
InicMouse       ENDP

ShowMouse       PROC                    ;  Muestra el puntero del mouse.
                MOV     AX, 1
                INT     33h
                RET
ShowMouse       ENDP

HideMouse       PROC                    ;  Quita el puntero del mouse.
                MOV     AX, 2
                INT     33h
                RET
HideMouse       ENDP

AskMouse        PROC
                MOV     AX, 3           ;  Devuelve en BX los botones y en 
                INT     33h             ; CX,DX la posicin X e Y.
                SHR     CX, 1
                RET
AskMouse        ENDP

LineaCmds       PROC
                MOV     DI, 80h         ;  Apunta a la lnea de comandos.
                XOR     CH, CH
                MOV     CL, ES:[DI]     ;  Cogemos la longitud.
                INC     DI
                MOV     [Color], 15     ;  Color predeterminado.

        @@BuscaCaracter:
                MOV     AL, ES:[DI]
                INC     DI
                CMP     AL, '/'
                JNE   @@BuscaCaracter
                CMP     DI, 0FFh
                JA    @@Final
        @@Comando:
                MOV     AL, ES:[DI]
                INC     DI
                CMP     AL, 'P'         ;  Nombre del PCX.
                JE    @@PCXName
                CMP     AL, 'S'
                JE    @@SPRName
                CMP     AL, 'X'
                JE    @@SizeX
                CMP     AL, 'Y'
                JE    @@SizeY
                CMP     AL, 'C'
                JNE   @@BuscaCaracter
          @@Color:
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                MOV     [Color], AL
                JMP   @@BuscaCaracter
          @@SPRName:
                MOV     SI, Offset MapName
              @@BucleSPR:
                MOV     AL, ES:[DI]
                INC     DI
                CMP     AL, ' '
                JE    @@FinSPR
                PUSH    DI
                SUB     DI, CX
                SUB     DI, 2
                CMP     DI, 80h
                POP     DI
                JNB   @@FinSPR
                MOV     DS:[SI], AL
                INC     SI
                JMP   @@BucleSPR
              @@FinSPR:
                MOV     BYTE PTR DS:[SI], 0
                JMP   @@BuscaCaracter
          @@PCXName:
                MOV     SI, Offset FilePCX
                JMP   @@BucleSPR                ;  Es lo mismo.
          @@SizeX:
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                MOV     AH, 100
                MUL     AH                      ;  La primera cifra por 100.
                MOV     [SizeX], AX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                MOV     AH, 10
                MUL     AH
                ADD     [SizeX], AX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                ADD     [SizeX], AX
                JMP   @@BuscaCaracter
          @@SizeY:
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                MOV     AH, 100
                MUL     AH                      ;  La primera cifra por 100.
                MOV     [SizeY], AX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                MOV     AH, 10
                MUL     AH
                ADD     [SizeY], AX
                MOV     AL, ES:[DI]
                INC     DI
                SUB     AL, 30h
                JS    @@BuscaCaracter
                CMP     AL, 9
                JA    @@BuscaCaracter
                XOR     AH, AH
                ADD     [SizeY], AX
                JMP   @@BuscaCaracter
        @@Final:RET
LineaCmds       ENDP

;;;  F U N C I  N    P R I N C I P A L .

MapEdit         PROC
                MOV     AX, @DATA
                MOV     DS, AX
                CALL    LiberaMEM
                CALL    ModoGrafico     ;  Encendemos GRAPH.
                CALL    TrataError

                CALL    CreaVirtual     ;  Pedimos una PV.
                CALL    TrataError
                MOV     [PVirtual], AL
                CALL    LineaCmds       ;  Se lee la lnea de comandos.
                PUSH    DS
                MOV     DX, Offset FilePCX
                MOV     AL, [PVirtual]
                CALL    LeePCX          ;  Leemos el fichero.
                CALL    TrataError
                POP     DS
                JC    @@Sacabou
                PUSH    AX
                MOV     AH, AL
                XOR     AL, AL
                XOR     BL, BL
                CALL    PonPaleta       ;  Inserta la paleta.
                CALL    TrataError
                POP     AX
                CALL    DestPaleta      ;  Libera memoria no utilizada.
                CALL    TrataError
                XOR     CX, CX
                MOV     DX, Offset MapName
                MOV     AX, 3D02h
                INT     21h             ;  Abre el fichero.
                JC    @@Sacabou
                MOV     [Handle], AX    ;  Guarda el handle.
                MOV     BX, AX
                XOR     DX, DX
                XOR     CX, CX
                MOV     AX, 4202h       ;  Nos movemos hasta el final del
                INT     21h             ; fichero para introducir informacin.

                MOV     AL, [PVirtual]
                XOR     AH, AH          ;  VGA
                CALL    CopiaPantalla   ;  Copiamos la pantalla a la VGA
                CALL    TrataError
                CALL    InicMouse
        @@BuclePPal:
                CALL    AskMouse        ;  Pregunta a ver que esta pasando.
                PUSH    BX              ;  Guardamos el resultado.
                CALL  @@PintaCuadro     ;  Dibuja el cuadro.
                POP     BX
                OR      BX, BX
                JZ    @@BuclePPal       ;  Vuelve...
                CMP     BX, 1
                JE    @@SalvaSprite     ;  Graba el sprite.
                CMP     BX, 2
                JNE   @@BuclePPal       ;  Vuelve...

          @@Finalizar:
                MOV     BX, [handle]
                MOV     AH, 3Eh
                INT     21h             ;  Cerramos el fichero.
                CALL    HideMouse
                MOV     AL, [PVirtual]
                CALL    DestVirtual     ;  Devuelve la memria.
                XOR     DX, DX
                MOV     CX, 8000h
                CALL    FadeDown        ;  Hace un fade.
                CALL    ModoTexto
                MOV     AX, 4C00h
                INT     21h             ;  Salir al DOS.

  @@Sacabou:    CALL    ModoTexto
                MOV     AH, 9
                MOV     DX, Offset ERROR
                INT     21h
                MOV     AX, 4C01h
                INT     21h

          @@SalvaSprite:
                MOV     BX, [CoorX1]
                MOV     SI, [CoorY1]
                MOV     DX, [CoorX2]
                MOV     DI, [CoorY2]
                MOV     AL, [PVirtual]
                CALL    GetImagen       ;  Coge el sprite.
                MOV     [Sprite], AL
                CALL    SegmentoSprite  ;  Nos devuelve el handle de sprite.
                MOV     AL, [Sprite]
                CALL    DestSprite      ;  Deja memoria libre.
                MOV     AX, [CoorX2]
                SUB     AX, [CoorX1]    ;  Calculamos la base del rectngulo.
                JNS   @@SignoOK1
                NEG     AX
            @@SignoOK1:
                MOV     CX, [CoorY2]
                SUB     CX, [CoorY1]    ;  Calculamos la altura del rectngulo.
                JNS   @@SignoOK2
                NEG     CX
            @@SignoOK2:
                PUSH    DS
                MOV     BX, [Handle]    ;  Cogemos el handle antes de cargar-
                PUSH    BX              ; nos BX.
                PUSH    ES
                POP     DS
                XOR     DX, DX          ;  S = b * h
                MUL     CX              ;  El resultado en AX, porque nunca
                POP     BX              ; puede en una pantalla de 320x200
                MOV     CX, AX          ; cogerse un sprite de ms de un
                MOV     AH, 40h         ; segmento.
                INT     21h
                POP     DS
                MOV     AX, 21h
                INT     33h             ;  Reset de software.
                JMP   @@BuclePPal       ;  Tal vez haya ms bloques.

          @@PintaCuadro:
                CMP     CX, [CoorX1]    ;  Compruebo si se ha movido el ratn.
                JNE   @@Continua
                CMP     DX, [CoorY1]
                JE    @@Regresa
          @@Continua:
                MOV     [CoorX1], CX
                MOV     [CoorY1], DX    ;  Guarda las coordenadas iniciales.
                ADD     CX, [SizeX]
                ADD     DX, [SizeY]     ;  Suma los valores de tamao...
                MOV     [CoorX2], CX
                MOV     [CoorY2], DX    ; ..y los guarda.
                CALL    HideMouse
;                WaitVR
                MOV     AL, [PVirtual]
                XOR     AH, AH
                CALL    CopiaPantalla   ;  Cpia la pantalla virtual.
                MOV     DI, [CoorY2]
                MOV     DX, [CoorX2]
                MOV     BX, [CoorX1]
                MOV     SI, [CoorY1]
                MOV     CL, [Color]
                XOR     AL, AL
;                WaitVR
                CALL    Rectangulo      ;  Dibuja el rectngulo.
        @@Regresa:
                RET
MapEdit         ENDP
                END     MapEdit
