//   Fichero de inclusin para compatibilizar la libreria GRAPH
//  con Turbo C (no sera difcil adaptarla para otros compiladores)
//      Por   N A V I   D.j.

#include <dos.h>
#include <alloc.h>

typedef unsigned char  byte;
typedef unsigned int   word;
typedef unsigned long dword;

word Ssegmento;
word Soffset;
 word dvuelta;
 word wvuelta;
 byte bvuelta;

extern void *DBORRAPANTALLA;
extern void *DPONPIXEL;
extern void *DCOGEPIXEL;
extern void *DLINEA;
extern void *DCREAVIRTUAL;
extern void *DDESTVIRTUAL;
extern void *DCOPIAPANTALLA;
extern void *DTRATAERROR;
extern void *DCARGASPRITE;
extern void *DDIBUJASPRITE;
extern void *DDESTSPRITE;
extern void *DVACIAMEM;
extern void *DFDIBUJASPRITE;
extern void *DFLINEA;
extern void *DFPONPIXEL;
extern void *DFCOGEPIXEL;
extern void *DFBORRAPANTALLA;
extern void *DCOGECOLOR;
extern void *DPONCOLOR;
extern void *DCOGEPALETA;
extern void *DPONPALETA;
extern void *DFADEDOWN;
extern void *DCARGAPALETA;
extern void *DFADEUP;
extern void *DFADETO;
extern void *DBLACKOUT;
extern void *DCARGACEL;
extern void *DCARGAANIMA;
extern void *DPONFRAMEANIMA;
extern void *DFPONFRAMEANIMA;
extern void *DDESTANIMA;
extern void *DINSERTADIRSPRITE;
extern void *DINSERTADIRANIMA;
extern void *DSEGMENTOSPRITE;
extern void *DSEGMENTOANIMA;
extern void *DSEGMENTOPAL;
extern void *DSEGMENTOPV;
extern void *DINSERTADIRPV;
extern void *DINSERTADIRPAL;
extern void *DDESCOMPPUNTOS;
extern void *DDESCOMPWORM;
extern void *DFCAJA;
extern void *DCAJA;
extern void *DFRECTANGULO;
extern void *DRECTANGULO;
extern void *DPOLIGONO;
extern void *DFPOLIGONO;
extern void *DCREASPRITE;
extern void *DCAMBIASPRITES;
extern void *DGETIMAGEN;
extern void *DFGETIMAGEN;
extern void *DCIRCULO;
extern void *DFCIRCULO;
extern void *DLEEPCX;
extern void *DDESTPALETA;
extern void *DLEEBMP;
extern void *DPLAYFLI;
extern void *DINICGRAPH;
extern void *DENDGRAPH;
extern void *DCARGAFUENTE;
extern void *DCAMBIATIPO;
extern void *DQUETIPO;
extern void *DESCLETRA;
extern void *DCOGEFUENTEDOS;
extern void *DSETCURSOR;
extern void *DGETCURSOR;
extern void *DESCRIBE;
extern void *DLEELETRA;
extern void *DLEELETRAECHO;
extern void *DLEEBYTE;
extern void *DLEECADENA;
extern void *DLEEWORD;
extern void *DESCBYTE;
extern void *DESCWORD;
extern void *DWRITE;
extern void *DNUEVOARCHIVO;
extern void *DLEEENTRADA;
extern void *DLEETROZO;
extern void *DLONGITUDFILE;
extern void *DFLIPCOPY;
extern void *DFLIP;
extern void *DSEGMENTOFUENTE;
extern void *DSETSTART;
extern void *DDOBLALINEAS;
extern void *DSETVSPIXELS;
extern void *DPIDEXMS;
extern void *DLIBERAXMS;
extern void *DGETADDRESS;
extern void *DMAXIMAXMS;
extern void *DGUARDAFLAT;
extern void *DCARGAFLAT;
extern void *DCARGABLOQUE;
extern void *DCARGAMAPA;
extern void *DDESTBLOQUE;
extern void *DDESTMAPA;
extern void *DDIBUJAMAPA;
extern void *DPOSMAPA;
extern void *DINSERTADIRBLOQUE;
extern void *DINSERTADIRMAPA;
extern void *DSEGMENTOBLOQUE;
extern void *DSEGMENTOMAPA;
extern void *DRESETGRAPH;
extern void *DMODOGRAFICO;
extern void *DMODOTEXTO;
extern void *DCREAMAPA;
extern void *DCREABLOQUE;
extern void *DDESTFUENTE;
extern void *DINSERTADIRFUENTE;

extern word LERROR;                     //  La variable de errores.
extern word REGISTRO;                   //  El n de campo total.

word PideMEM(word canti)                //  Pide "canti" prrafos de memoria.
{
 word p;
 int stat;

 asm push es;
 asm push ds;
 stat=allocmem(canti, &p);
 asm pop ds;
 asm pop es;

 return p;
 }

void LiberaMEM(word puntero)		//  Libera un bloque de memoria.
{
 freemem(puntero);
 }

void WaitVR(void)                       //  Espera el retrazo vertical.
 {
   asm  .386
   asm  MOV   DX,03DAh;
 St1:
   asm  IN    AL,DX;
   asm  TEST  AL,08h;
   asm  JZ    St1;
 St2:
   asm  IN    AL,DX;
   asm  TEST  AL,08h;
   asm  JNZ   St2;
   }

byte CargaAnima(char *nombre,word longX,word longY,word NSprites){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
        asm  push es;
        asm  pusha;
	asm  push ds;
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
	asm  mov ax, NSprites;
	asm  mov bx, longX;
	asm  mov cx, longY;
        asm  call dword ptr DCARGAANIMA;
	asm  pop ds;
        asm  mov bvuelta,al;
        asm  popa;
        asm  pop es;
        return bvuelta;}

void PonFrameAnima(byte hdl,byte pv,word x,word y,word frame){
        asm  push es;
        asm  push ds;
        asm  pusha;
	asm  mov al,pv;
	asm  mov ah,hdl
	asm  mov bx,y;
	asm  mov cx,frame;
	asm  mov bp,x;
        asm  call dword ptr DPONFRAMEANIMA;
        asm  popa;
        asm  pop ds;
        asm  pop es;}

void fPonFrameAnima(byte hdl,byte pv,word x,word y,word frame){
        asm  push es;
        asm  push ds;
        asm  pusha;
	asm  mov al,pv;
	asm  mov ah,hdl
	asm  mov bx,y;
	asm  mov cx,frame;
	asm  mov bp,x;
        asm  call dword ptr DFPONFRAMEANIMA;
        asm  popa;
        asm  pop ds;
        asm  pop es;}

void DestAnima(byte hdl){
        asm  push es;
        asm  pusha;
	asm  mov al,hdl;
        asm  call dword ptr DDESTANIMA;
        asm  popa;
        asm  pop es;}
/*
void CogeColor(byte registro, byte &crojo, byte &cverde, byte &cazul) {
        asm  al, registro;
        asm  call dword ptr DCOGECOLOR;
        asm  crojo, cl;
        asm  cverde, bl;
        asm  cazul, al;}
*/
void PonColor(byte NReg,byte R,byte G,byte B){
	asm  mov cl,R;
	asm  mov bl,G;
	asm  mov al,B;
	asm  mov ah,NReg;
        asm  call dword ptr DPONCOLOR;}

byte CogePaleta(void) {
        asm  push es;
        asm  pusha;
        asm  call dword ptr DCOGEPALETA;
        asm  popa
        asm  pop es
	asm  mov bvuelta,al;
	return bvuelta;}

void PonPaleta(byte Hdl,byte FCol,byte LCol){
        asm  push es
        asm  pusha
	asm  mov bl,LCol;
	asm  mov al,FCol;
	asm  mov ah,Hdl;
        asm  call dword ptr DPONPALETA;
        asm  popa;
        asm  pop es;}

byte CargaPaleta(char *nombre){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
        asm  push es;
	asm  push ds;
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
        asm  call dword ptr DCARGAPALETA;
	asm  pop ds;
        asm  mov bvuelta,al
        asm  pop es;
        return bvuelta;}

void FadeDown(word Retar,byte FCol,byte LCol){
        asm  pusha;
	asm  mov dh,LCol;
	asm  mov dl,FCol;
	asm  mov cx,Retar;
        asm  call dword ptr DFADEDOWN;
        asm  popa;}

void FadeUp(word Retar,byte FCol,byte LCol){
        asm  pusha;
	asm  mov dh,LCol;
	asm  mov dl,FCol;
	asm  mov cx,Retar;
        asm  call dword ptr DFADEUP;
        asm  popa;}

void FadeTo(byte Hdl,word Retar,byte FCol,byte LCol){
        asm  push es;
        asm  pusha;
	asm  mov dh,LCol;
	asm  mov dl,FCol;
	asm  mov cx,Retar;
	asm  mov al,Hdl;
        asm  call dword ptr DFADETO;
        asm  popa;
        asm  pop es;}

void BlackOut(byte FCol,byte LCol){
	asm  mov bl,LCol;
	asm  mov al,FCol;
        asm  call dword ptr DBLACKOUT;}

void DestPaleta(byte hdl){
        asm  push es;
	asm  mov al,hdl;
        asm  call dword ptr DDESTPALETA;
        asm  pop es;}

void PonPixel(word x,word y,byte color,byte pv){
        asm  push es;
        asm  pusha
        asm  mov bx,x;
	asm  mov dx,y;
	asm  mov cl,color;
	asm  mov al,pv;
        asm  call dword ptr DPONPIXEL;
        asm  popa
        asm  pop es;}

void fPonPixel(word x,word y,byte color,byte pv){
        asm  push es;
        asm  pusha
        asm  mov bx,x;
	asm  mov dx,y;
	asm  mov cl,color;
	asm  mov al,pv;
        asm  call dword ptr DFPONPIXEL;
        asm  popa
        asm  pop es;}

void BorraPantalla(byte color,byte pv){
        asm  push es;
        asm  pushad
        asm  mov cl,color;
	asm  mov al,pv;
        asm  call dword ptr DBORRAPANTALLA;
        asm  popad
        asm  pop es;}

void fBorraPantalla(byte color,byte pv){
        asm  push es;
        asm  pushad
        asm  mov cl,color;
	asm  mov al,pv;
        asm  call dword ptr DFBORRAPANTALLA;
        asm  popad
        asm  pop es;}

byte CogePixel(word x,word y,byte pv){
        asm  push es;
        asm  pusha
	asm  mov al,pv;
	asm  mov bx,x;
	asm  mov dx,y;
        asm  call dword ptr DCOGEPIXEL;
	asm  mov bvuelta,cl;
        asm  popa
        asm  pop es;
	return bvuelta;}

byte fCogePixel(word x,word y,byte pv){
        asm  push es;
        asm  pusha
	asm  mov al,pv;
	asm  mov bx,x;
	asm  mov dx,y;
        asm  call dword ptr DFCOGEPIXEL;
	asm  mov bvuelta,cl;
        asm  popa
        asm  pop es;
	return bvuelta;}

void Rectangulo(word x1,word y1,word x2,word y2,byte col,byte hdl){
        asm  pusha;
	asm  mov al,hdl;
	asm  mov cl,col;
	asm  mov bx,x1;
	asm  mov si,y1;
	asm  mov dx,x2;
	asm  mov di,y2;
        asm  call dword ptr DRECTANGULO;
        asm  popa;}

void fRectangulo(word x1,word y1,word x2,word y2,byte col,byte hdl){
        asm  pusha;
	asm  mov al, hdl;
	asm  mov cl, col;
	asm  mov bx,x1;
	asm  mov si,y1;
	asm  mov dx,x2;
	asm  mov di,y2;
        asm  call dword ptr DFRECTANGULO;
        asm  popa;}

void Circulo(word Xcen,word Ycen,word radio,byte hdl,byte col){
        asm  pusha;
        asm  mov ch,hdl;
	asm  mov bx,Xcen;
	asm  mov dx,Ycen;
	asm  mov ax,radio;
	asm  mov cl,col;
        asm  call dword ptr DCIRCULO;
        asm  popa;}

void fCirculo(word Xcen,word Ycen,word radio,byte hdl,byte col){
        asm  pusha;
	asm  mov ch,hdl;
	asm  mov bx,Xcen;
	asm  mov dx,Ycen;
	asm  mov ax,radio;
	asm  mov cl,col;
        asm  call dword ptr DFCIRCULO;
        asm  popa;}

void ModoGrafico(void){
        asm  push es;
        asm  push ds;
        asm  pushad
        asm  call dword ptr DMODOGRAFICO;
        asm  popad
        asm  pop ds;
        asm  pop es;}

void ModoTexto(void){
        asm  push es;
        asm  push ds;
        asm  pushad
        asm  call dword ptr DMODOTEXTO;
        asm  popad
        asm  pop ds;
        asm  pop es;}

void Linea(word Xi,word Yi,word Xf,word Yf,byte color,byte pv){
        asm  pusha;
        asm  push es;
	asm  mov bx,Xi;
	asm  mov dx,Xf;
	asm  mov si,Yi;
	asm  mov di,Yf;
	asm  mov ch,color;
	asm  mov al,pv;
        asm  call dword ptr DLINEA;
        asm  pop es;
        asm  popa;}

void fLinea(word Xi,word Yi,word Xf,word Yf,byte color,byte pv){
        asm  pusha;
        asm  push es;
	asm  mov bx,Xi;
	asm  mov dx,Xf;
	asm  mov si,Yi;
	asm  mov di,Yf;
	asm  mov ch,color;
	asm  mov al,pv;
        asm  call dword ptr DFLINEA;
        asm  pop es;
        asm  popa;}

void Caja(word x1,word y1,word x2,word y2,byte col,byte hdl){
        asm  pusha;
        asm  push es;
	asm  mov al,hdl;
	asm  mov cl,col;
	asm  mov bx,x1;
	asm  mov si,y1;
	asm  mov dx,x2;
	asm  mov di,y2;
        asm  call dword ptr DCAJA;
        asm  pop es;
        asm  popa;}

void fCaja(word x1,word y1,word x2,word y2,byte col,byte hdl){
        asm  pusha;
        asm  push es;
	asm  mov al,hdl;
	asm  mov cl,col;
	asm  mov bx,x1;
	asm  mov si,y1;
	asm  mov dx,x2;
	asm  mov di,y2;
        asm  call dword ptr DFCAJA;
        asm  pop es;
        asm  popa;}

// Para definir los vertices de un poligono hacerlo as:
//  CHAR *Vertices = {32, 54, 132, 54}

void Poligono(char *PTRVertices,byte NVertices,byte col,byte hdl){
	Ssegmento=FP_SEG(PTRVertices);
	Soffset=FP_OFF(PTRVertices);
	asm  push ds;
        asm  pusha
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
	asm  mov cl,col;
	asm  mov al,hdl;
	asm  mov ch,NVertices;
        asm  call dword ptr DPOLIGONO;
        asm  popa
	asm  pop ds;}

void fPoligono(char *PTRVertices,byte NVertices,byte col,byte hdl){
	Ssegmento=FP_SEG(PTRVertices);
	Soffset=FP_OFF(PTRVertices);
	asm  push ds;
        asm  pusha
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
	asm  mov cl,col;
	asm  mov al,hdl;
	asm  mov ch,NVertices;
        asm  call dword ptr DFPOLIGONO;
        asm  popa
	asm  pop ds;}

byte CreaVirtual(void) {
        asm  call dword ptr DCREAVIRTUAL;
	asm  mov bvuelta,al;
	return bvuelta;}

void CopiaPantalla(byte Opv,byte Dpv){
        asm  push es;
        asm  push ds;
        asm  pusha
        asm  mov al,Opv;
	asm  mov ah,Dpv;
        asm  call dword ptr DCOPIAPANTALLA;
        asm  popa
        asm  pop ds;
        asm  pop es;}

void DestVirtual(byte pv){
        asm  push es;
        asm  pusha
        asm  mov al,pv;
        asm  call dword ptr DDESTVIRTUAL;
        asm  popa
        asm  pop es;}

word SegmentoPV(byte pv){
	asm  push es;
	asm  mov al,pv;
        asm  call dword ptr DSEGMENTOPV;
	asm  mov wvuelta,es;
	asm  pop es;
	return wvuelta;}

word SegmentoPal(byte Hdl){
	asm  push es;
	asm  mov al,Hdl;
        asm  call dword ptr DSEGMENTOPAL;
	asm  mov wvuelta,es;
	asm  pop es;
	return wvuelta;}

word SegmentoSprite(byte Hdl){
	asm  push es;
	asm  mov al,Hdl;
        asm  call dword ptr DSEGMENTOSPRITE;
	asm  mov wvuelta,es;
	asm  pop es;
	return wvuelta;}

word SegmentoAnima(byte Hdl){
	asm  push es;
	asm  mov al,Hdl;
        asm  call dword ptr DSEGMENTOANIMA;
	asm  mov wvuelta,es;
	asm  pop es; 
	return wvuelta;}

void VaciaMEM(void) { asm  call dword ptr DVACIAMEM; }

void TrataError(void) { asm  call dword ptr DTRATAERROR; }

byte InsertaDirPV(word seg){
	asm  push es;
	asm  mov ax,seg;
	asm  mov es,ax;
        asm  call dword ptr DINSERTADIRPV;
	asm  mov bvuelta,al;
	asm  pop es;
	return bvuelta;}

void InsertaDirPal(word seg){
	asm  push es;
	asm  mov ax,seg;
	asm  mov es,ax;
        asm  call dword ptr DINSERTADIRPAL;
	asm  pop es;}

void InsertaDirSprite(word seg, word lx, word ly){
	asm  push es;
	asm  mov ax,seg;
	asm  mov es,ax;
        asm  mov ax,lx;
        asm  mov cx,ly;
        asm  call dword ptr DINSERTADIRSPRITE;
	asm  pop es;}

void InsertaDirAnima(word seg, word lx, word ly, word num){
	asm  push es;
	asm  mov ax,seg;
	asm  mov es,ax;
        asm  mov ax,lx;
        asm  mov cx,ly;
        asm  mov si,num;
        asm  call dword ptr DINSERTADIRANIMA;
	asm  pop es;}

byte CargaSprite(char *nombre,word lonx,word lony){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
        asm  pusha;
        asm  push es;
	asm  push ds;
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
	asm  mov bx,lonx;
	asm  mov cx,lony;
        asm  call dword ptr DCARGASPRITE;
	asm  pop ds;
        asm  mov bvuelta,al;
        asm  pop es;
        asm  popa;
        return bvuelta;}

void DestSprite(byte hdl){
        asm  push es;
        asm  pusha
	asm  mov al,hdl;
        asm  call dword ptr DDESTSPRITE;
        asm  popa
        asm  pop es;}

void CambiaSprites(byte hdl1,byte hdl2){
        asm  pusha;
	asm  mov al,hdl1;
	asm  mov dl,hdl2;
        asm  call dword ptr DCAMBIASPRITES;
        asm  popa;}

byte CreaSprite(word lx,word ly){
	asm  mov bx,lx;
	asm  mov cx,ly;
        asm  call dword ptr DCREASPRITE;
        asm  mov bvuelta, al
	return bvuelta;}

void DibujaSprite(byte hdl,byte pv,word x,word y){
        asm  pusha;
        asm  push ds;
        asm  push es;
	asm  mov al,pv;
	asm  mov ah,hdl
	asm  mov bx,y;
	asm  mov bp,x;
        asm  call dword ptr DDIBUJASPRITE;
        asm  pop es;
        asm  pop ds;
        asm  popa;}

void fDibujaSprite(byte hdl,byte pv,word x,word y){
        asm  pusha;
        asm  push ds;
        asm  push es;
	asm  mov al,pv;
	asm  mov ah,hdl
	asm  mov bx,y;
	asm  mov bp,x;
        asm  call dword ptr DFDIBUJASPRITE;
        asm  pop es;
        asm  pop ds;
        asm  popa;}

void CargaCEL(char *nombre,byte pv){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
        asm  push es;
        asm  pusha
	asm  push ds;
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
	asm  mov al, pv;
        asm  call dword ptr DCARGACEL;
        asm  pop ds;
        asm  popa
        asm  pop es;}

byte GetImagen(word x1,word y1,word x2,word y2,byte hdl){
        asm  pusha;
        asm  push es;
        asm  push ds;
	asm  mov al,hdl;
	asm  mov bx,x1;
	asm  mov si,y1;
	asm  mov dx,x2;
	asm  mov di,y2;
        asm  call dword ptr DGETIMAGEN;
        asm  pop ds;
        asm  mov bvuelta,al;
        asm  pop es;
        asm  popa;
        return bvuelta;}

byte fGetImagen(word x1,word y1,word x2,word y2,byte hdl){
        asm  pusha;
        asm  push es;
        asm  push ds;
	asm  mov al,hdl;
	asm  mov bx,x1;
	asm  mov si,y1;
	asm  mov dx,x2;
	asm  mov di,y2;
        asm  call dword ptr DFGETIMAGEN;
        asm  mov bvuelta,al;
        asm  pop ds;
        asm  pop es;
        asm  popa;
        return bvuelta;}

void DescompPuntos(byte color,word semilla){
        asm  pushad
	asm  mov ax,semilla;
	asm  mov cl,color;
        asm  call dword ptr DDESCOMPPUNTOS;
        asm  popad;}

void DescompWorm(byte color,word semilla){
        asm  push es;
        asm  pusha
	asm  mov ax,semilla;
	asm  mov cl,color;
        asm  call dword ptr DDESCOMPWORM;
        asm  popa
        asm  pop es;}

byte LeePCX(char *nombre,byte hdl){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
	asm  push ds;
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
	asm  mov al,hdl;
        asm  call dword ptr DLEEPCX;
	asm  pop ds;
        asm  mov bvuelta,ah
        return bvuelta;}

//  Nuevas en GRAPH 2.0

byte LeeBMP(char *nombre,byte hdl){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
	asm  push ds;
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
	asm  mov al,hdl;
        asm  call dword ptr DLEEBMP;
	asm  pop ds;
        asm  mov bvuelta,al
        return bvuelta;}

void InicGRAPH(word modo, dword flags){
        asm  push ds;
        asm  push es;
        asm  pushad
        asm  mov bx,modo;
        asm  mov eax,flags;
        asm  call dword ptr DINICGRAPH;
        asm  popad
        asm  pop es;
        asm  pop ds;}

void EndGRAPH(void){
        asm  push ds;
        asm  push es;
        asm  pushad
        asm  call dword ptr DENDGRAPH;
        asm  popad
        asm  pop es;
        asm  pop ds;}

void CambiaTipo(byte new){
        asm  mov al,new;
        asm  call dword ptr DCAMBIATIPO;}

byte QueTipo(void){
        asm  call dword ptr DCAMBIATIPO;
        asm  mov bvuelta,al;
        return bvuelta;}

void SetCursor(word posx, word posy){
        asm  mov bx,posx;
        asm  mov dx,posy;
        asm  call dword ptr DSETCURSOR;}
/*
void GetCursor(word &posx, word &posy){
        asm  call dword ptr DGETCURSOR;
        asm  mov posx,bx;
        asm  mov posy,dx;}
*/
byte CargaFuente(char *nombre,byte lonx,byte lony,byte prime,byte ulti){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
        asm  push es;
        asm  pusha
	asm  push ds;
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
        asm  mov bl,lonx;
        asm  mov bh,lony;
        asm  mov ah,prime;
        asm  mov al,ulti;
        asm  call dword ptr DCARGAFUENTE;
	asm  pop ds;
        asm  mov bvuelta,al;
        asm  popa
        asm  pop es;
        return bvuelta;}

byte CogeFuenteDOS(void){
        asm  pusha;
        asm  push ds;
        asm  push es;
        asm  call dword ptr DCOGEFUENTEDOS;
        asm  mov bvuelta,al;
        asm  pop es;
        asm  pop ds;
        asm  popa;
        return bvuelta;}

void EscLetra(byte hdl, byte letra, byte pv, byte color){
        asm  pusha;
        asm  push ds;
        asm  push es;
        asm  mov al,hdl
        asm  mov ah,letra
        asm  mov bl,pv
        asm  mov bh,color
        asm  call dword ptr DESCLETRA;
        asm  pop es;
        asm  pop ds;
        asm  popa;}

void Escribe(byte hdl, char *cadena, byte pv, byte color, byte distx, byte disty){
        Ssegmento=FP_SEG(cadena);
        Soffset=FP_OFF(cadena);
        asm  pusha;
        asm  push ds;
        asm  push es;
        asm  mov ax,Ssegmento
        asm  mov ds,ax
        asm  mov si,Soffset
        asm  mov al,hdl
        asm  mov bl,pv
        asm  mov bh,color
        asm  mov cl,distx
        asm  mov dl,disty
        asm  call dword ptr DESCRIBE;
        asm  pop es;
        asm  pop ds;
        asm  popa;}

byte LeeLetra(void){
        asm  call dword ptr DLEELETRA;
        asm  mov bvuelta,al;
        return bvuelta;}

byte LeeLetraEcho(byte hdl, byte pv, byte color){
        asm  mov al,hdl
        asm  mov bl,pv
        asm  mov bh,color
        asm  call dword ptr DLEELETRAECHO;
        asm  mov bvuelta,al;
        return bvuelta;}

void LeeCadena(byte hdl, char *buffer, byte pv, byte color, byte distx, word longi){
        Ssegmento=FP_SEG(buffer);
        Soffset=FP_OFF(buffer);
        asm  push es
        asm  mov dx,Soffset
        asm  mov al,hdl
        asm  mov bl,pv
        asm  mov bh,color
        asm  mov ah,distx
        asm  mov cx,longi
        asm  push ds
        asm  pop es
        asm  mov ax,Ssegmento
        asm  mov ds,ax
        asm  call dword ptr es:DLEECADENA
        asm  pop es; }

void Write(byte hdl, char *cadena, byte pv, byte color, byte distx, byte disty){
        Ssegmento=FP_SEG(cadena);
        Soffset=FP_OFF(cadena);
        asm  pusha;
        asm  push ds;
        asm  push es;
        asm  mov ax,Ssegmento
        asm  mov ds,ax
        asm  mov si,Soffset
        asm  mov al,hdl
        asm  mov bl,pv
        asm  mov bh,color
        asm  mov cl,distx
        asm  mov dl,disty
        asm  call dword ptr DWRITE;
        asm  pop es;
        asm  pop ds;
        asm  popa;}

void NuevoArchivo(char *nombre){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
        asm  push ds;
        asm  push es;
        asm  pusha
        asm  mov ax,Ssegmento;
        asm  mov ds,ax;
        asm  mov si,Soffset;
        asm  call dword ptr DNUEVOARCHIVO;
        asm  popa
        asm  pop es;
        asm  pop ds;}

void LeeEntrada(char *buffer, word campo){
        Ssegmento=FP_SEG(buffer);
        Soffset=FP_OFF(buffer);
        asm  push ds;
        asm  push es;
        asm  pusha
        asm  mov ax,Ssegmento;
        asm  mov es,ax;
        asm  mov di,Soffset;
        asm  mov ax,campo;
        asm  call dword ptr DLEEENTRADA;
        asm  popa
        asm  pop es;
        asm  pop ds;}

void LeeTrozo(char *buffer, word campo, dword longi, dword inicio){
        Ssegmento=FP_SEG(buffer);
        Soffset=FP_OFF(buffer);
        asm  push ds;
        asm  push es;
        asm  pusha
        asm  mov ax,Ssegmento;
        asm  mov es,ax;
        asm  mov di,Soffset;
        asm  mov ax,campo;
        asm  mov esi,inicio;
        asm  mov ebp,longi;
        asm  call dword ptr DLEETROZO;
        asm  popa
        asm  pop es;
        asm  pop ds;}

long LongitudFile(word campo){
        asm  push ds;
        asm  pushad;
        asm  mov ax,campo;
        asm  call dword ptr DLONGITUDFILE;
        asm  mov dvuelta, bp
        asm  shr ebp, 16
        asm  mov wvuelta, bp
        asm  popad;
        asm  pop ds;
        asm  mov dx, wvuelta
        asm  mov ax, dvuelta;}

void FlipCopy(byte Opv,byte Dpv){
        asm  push es;
        asm  push ds;
        asm  pusha
        asm  mov al,Opv;
	asm  mov ah,Dpv;
        asm  call dword ptr DFLIPCOPY;
        asm  popa
        asm  pop ds;
        asm  pop es;}

void Flip(byte Opv){
        asm  push es;
        asm  push ds;
        asm  pusha
        asm  mov al,Opv;
        asm  call dword ptr DFLIP;
        asm  popa
        asm  pop ds;
        asm  pop es;}

word SegmentoFuente(byte Hdl){
	asm  push es;
	asm  mov al,Hdl;
        asm  call dword ptr DSEGMENTOFUENTE;
	asm  mov wvuelta,es;
        asm  pop es;
	return wvuelta;}

void DoblaLineas(void){
        asm  call dword ptr DDOBLALINEAS;}

void SetStart(word direc){
        asm  mov bx,direc;
	asm  call dword ptr DSETSTART;}

void SetVSPixels(byte lineas){
        asm  mov ah,lineas;
        asm  call dword ptr DSETVSPIXELS;}

word PideXMS(word memo){
        asm  pusha
        asm  mov dx,memo;
        asm  call dword ptr DPIDEXMS;
        asm  mov wvuelta,dx
        asm  popa
        return wvuelta;}

void LiberaXMS(word memo){
        asm  pusha
        asm  mov dx,memo;
        asm  call dword ptr DLIBERAXMS;
        asm  popa;}

long GetAddress(word hdl){
        asm  mov dx,hdl;
        asm  call dword ptr DGETADDRESS;
        asm  mov ax, dx
        asm  shr edx, 16;}

word MaximaXMS(void){
        asm  call dword ptr DMAXIMAXMS;
        asm  mov wvuelta,dx;
        return wvuelta;}

word GuardaFlat(byte hdl, byte tipo){
        asm  push ds;
        asm  push gs;
        asm  push es;
        asm  pusha
        asm  mov al,hdl;
        asm  mov ah,tipo;
        asm  call dword ptr DGUARDAFLAT;
        asm  mov wvuelta,dx;
        asm  popa
        asm  pop es;
        asm  pop gs;
        asm  pop ds;
        return wvuelta;}

void CargaFlat(byte hdl, byte tipo, word hdlxms){
        asm  push ds;
        asm  push gs;
        asm  pusha
        asm  mov al,hdl;
        asm  mov ah,tipo;
        asm  mov dx,hdlxms;
        asm  call dword ptr DCARGAFLAT;
        asm  popa
        asm  pop gs;
        asm  pop ds;}

byte CargaBloque(char *nombre){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
        asm  push es;
        asm  pusha
	asm  push ds;
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
        asm  call dword ptr DCARGABLOQUE;
	asm  pop ds;
        asm  mov bvuelta,al;
        asm  popa
        asm  pop es;
        return bvuelta;}

byte CargaMapa(char *nombre){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
        asm  push es;
        asm  pusha
	asm  push ds;
	asm  mov ax,Ssegmento;
	asm  mov ds,ax;
	asm  mov dx,Soffset;
        asm  call dword ptr DCARGAMAPA;
	asm  pop ds;
        asm  mov bvuelta,al;
        asm  popa
        asm  pop es;
        return bvuelta;}

void DestBloque(byte hdl){
        asm  push es;
        asm  pusha
        asm  mov al,hdl;
        asm  call dword ptr DDESTBLOQUE;
        asm  popa
        asm  pop es;}

void DestMapa(byte hdl){
        asm  push es;
        asm  pusha
        asm  mov al,hdl;
        asm  call dword ptr DDESTMAPA;
        asm  popa
        asm  pop es;}

void DibujaMapa(byte pv, byte hmapa, byte hblk, dword posx, dword posy){
        asm  push es;
        asm  push ds;
        asm  push gs;
        asm  push fs;
        asm  pusha;
        asm  mov al,pv;
        asm  mov bl,hmapa;
        asm  mov bh,hblk;
        asm  mov ecx,posx;
        asm  mov edx,posy;
        asm  call dword ptr DDIBUJAMAPA;
        asm  popa;
        asm  pop fs;
        asm  pop gs;
        asm  pop ds;
        asm  pop es;}

word PosMapa(byte hdl, word posx, word posy){
        asm  push ds;
        asm  pusha;
        asm  mov al,hdl;
        asm  mov cx,posx;
        asm  mov dx,posy;
        asm  call dword ptr DPOSMAPA;
        asm  mov wvuelta,ax;
        asm  popa;
        asm  pop ds;
        return wvuelta;}

void InsertaDirBloque(word seg, byte longx, byte longy, word numero){
	asm  push es;
	asm  mov ax,seg;
	asm  mov es,ax;
        asm  mov cl,longy;
        asm  mov dh,longx;
        asm  mov dx,numero;
        asm  call dword ptr DINSERTADIRBLOQUE;
	asm  pop es;}

void InsertaDirMapa(word seg, word longx, word longy){
	asm  push es;
	asm  mov ax,seg;
	asm  mov es,ax;
        asm  mov cx,longy;
        asm  mov dx,longx;
        asm  call dword ptr DINSERTADIRMAPA;
	asm  pop es;}

void ResetGRAPH(word modo, dword flags){
        asm  push es;
        asm  push ds;
        asm  pushad
        asm  mov bx,modo;
        asm  mov eax,flags;
        asm  call dword ptr DRESETGRAPH;
        asm  popad
        asm  pop ds;
        asm  pop es;}

word SegmentoBloque(byte Hdl){
	asm  push es;
	asm  mov al,Hdl;
        asm  call dword ptr DSEGMENTOBLOQUE;
	asm  mov wvuelta,es;
        asm  pop es;
	return wvuelta;}

word SegmentoMapa(byte Hdl){
	asm  push es;
	asm  mov al,Hdl;
        asm  call dword ptr DSEGMENTOMAPA;
	asm  mov wvuelta,es;
        asm  pop es;
	return wvuelta;}

void PlayFLI(char *nombre, word pausa){
	Ssegmento=FP_SEG(nombre);
	Soffset=FP_OFF(nombre);
        asm  push es;
        asm  push ds;
        asm  pusha;
        asm  mov ax,Ssegmento;
        asm  mov ds,ax;
        asm  mov dx,Soffset;
        asm  mov ax,pausa;
        asm  call dword ptr DPLAYFLI;
        asm  popa;
        asm  pop ds;
        asm  pop es;}

byte CreaMapa(word longx, word longy){
        asm  pusha
        asm  mov ax,longx;
        asm  mov cx,longy;
        asm  call dword ptr DCREAMAPA;
        asm  mov bvuelta,al;
        asm  popa
        return bvuelta;}

byte CreaBloque(byte longx, byte longy, word numero){
        asm  pusha
        asm  mov al,longx;
        asm  mov ah,longy;
        asm  mov cx,numero;
        asm  call dword ptr DCREABLOQUE;
        asm  mov bvuelta,al;
        asm  popa
        return bvuelta;}

void DestFuente(byte hdl){
        asm  push es;
        asm  pusha
        asm  mov al,hdl;
        asm  call dword ptr DDESTFUENTE;
        asm  popa
        asm  pop es;}

void InsertaDirFuente(word seg, byte longx, byte longy, byte prim, byte ult){
	asm  push es;
	asm  mov ax,seg;
	asm  mov es,ax;
        asm  mov cl,longy;
        asm  mov ch,longx;
        asm  mov al,prim;
        asm  mov ah,ult;
        asm  call dword ptr DINSERTADIRFUENTE;
	asm  pop es;}


