/* 
   Rutinas                          [ GargonScene n4 ]   
  para el                 Programa ejemplo sobre programacin
                     del joystick.
                     
                  
	      code by eXcalibur
*/

#include <stdio.h>
#include <conio.h>


#define MENOS     0
#define MEDIO     1
#define MAS       2

#define JABoton1  0x10          /* Joystick 1 */
#define JABoton2  0x20
#define JAEjeX    0x01
#define JAEjeY    0x02

#define JBBoton1  0x40          /* Joystick 2 */
#define JBBoton2  0x80
#define JBEjeX    0x04
#define JBEjeY    0x08

int JMinX=0, JMedX=0, JMaxX=0;	/* Medias de los ejes */
int JMinY=0, JMedY=0, JMaxY=0;


/*************************************************************************\
** Leer botones del joystick.                                            **
**                                                                       **
** Devuelve:  0=boton pulsado                                            **
**            1=botn soltado                                            **
\*************************************************************************/
char JBoton(unsigned char buttonnum)
{
 asm mov dx, 201h                       /* Puerto 201h del teclado       */
 asm in  al, dx                         /* Leemos byte                   */
 asm and al, [buttonnum]                /* Le hacemos un and lgico para */
					/* saber en que estado se encuen-*/
 return _AL;                            /* tra el bit del boton          */
}

/*************************************************************************\
** Leer posicin joystick. Aqu sabemos el valor mximo que alcanza el   **
** joystick en nuestro ordenador.                                        **
**                                                                       **
**   Devuelve:                                                           **
**   - 16 Bits (int)-> Si FFFFh NO HAY JOYSTICK CONECTADO                **
**   -  " "         -> Si no FFFFh Si joystick, valor del eje.           **
\*************************************************************************/
int JPos(unsigned char axisnum)
{
 asm xor cx, cx
 asm cli
 asm mov dx, 201h
 asm out dx, al
Jloop:
 asm inc cx
 asm cmp cx, 0xFFFF
 asm je done
 asm in al, dx
 asm and al, [axisnum]
 asm jne Jloop
done:
 asm sti
 return _CX;
}


char JPosX()
{
 asm xor cx, cx
 asm cli         
 asm mov dx, 201h
 asm out dx, al
Jloop:
 asm inc cx            
 asm cmp cx, 0xFFFF
 asm je done
 asm in al, dx
 asm and al, JAEjeX
 asm jne Jloop
done:
 asm sti              
 
 if(_CX>JMinX-10 && _CX<JMinX+120)
			     return MENOS;
 if(_CX>JMaxX-120 && _CX<JMaxX+100)
			     return MAS;
 return MEDIO;
}

char JPosY()
{
 asm xor cx, cx
 asm cli         
 asm mov dx, 201h
 asm out dx, al
Jloop:
 asm inc cx            
 asm cmp cx, 0xFFFF
 asm je done
 asm in al, dx
 asm and al, JAEjeY
 asm jne Jloop
done:
 asm sti              
 
 if(_CX>JMinY-10 && _CX<JMinY+120)
			    return MENOS;
 if(_CX>JMaxY-120 && _CX<JMaxY+100)
			     return MAS;
 return MEDIO;
}


/* Ejemplo -----------------------------------------------------------------*/

void main()
{
 int Aux;

 clrscr();

 if(JPos(JAEjeX)==0xFFFF) /* Miramos si hay joystick conectado (si devuelve 0ffffh no es que no hay) */
	    {
	     printf("\a\n Epss!... no tienes el joystick conectado. :~(\n\n\n");
	     asm mov ax, 4c01h
	     asm int 21h
	    }


 JMedX=JPos(JAEjeX);
 JMedY=JPos(JAEjeY);

 printf("Ahora se te pedir que calibres el joystick para que el programa");
 printf("\n\rpueda coger los valores mnimos y mximos para saber as la media");
 printf("\n\rde los ejes.\n\n\r");
 printf("Pulsa arriba-izquierda + botn A.");
 while(JBoton(JABoton1))
	{
	 JMinX=JPos(JAEjeX);
	 JMinY=JPos(JAEjeY);
	}

 printf("Ahora pulsa abajo-derecha + botn B.");
 while(JBoton(JABoton2))
	{
	 Aux=JPos(JAEjeX); 	/* Si el ltimo valor leido es mayor que */
	 if(Aux>JMaxX)		/* que el anterior, entonces actualizamos. */
		JMaxX=Aux;
	 Aux=JPos(JAEjeY);
	 if(Aux>JMaxY)
		JMaxY=Aux;
	}

 JMedX=(JMaxX-JMinX)/2;		/* La Media es del valor eje central */
 JMedY=(JMaxY-JMinY)/2;

 clrscr();

 printf("Joystick Info - Eje X: Min. %d   Med. %d   Max. %d  ", JMinX, JMedX, JMaxX);
 printf("\n\r                EJE Y: Min. %d   Med. %d   Max. %d  ", JMinY, JMedY, JMaxY);
 while(!kbhit())
	{
	 gotoxy(1,4);

	 printf("\rPosiscin actual eje X=%d  ",JPos(JAEjeX));
	 printf("\n\rPosicin actual eje Y=%d  ",JPos(JAEjeY));

	 if(JPosX()==MENOS)
		  printf("\n\n\rIZQUIERDA");

	 else if(JPosX()==MAS)
		  printf("\n\n\rDERECHA  ");

	 else     printf("\n\n\rCENTRO   ");


	 if(JPosY()==MENOS)
		printf("\n\rARRIBA");

	 else if(JPosY()==MAS)
		printf("\n\rABAJO ");

	 else     printf("\n\rCENTRO");


	 if(JBoton(JABoton1)==0)
			printf("\n\n\rPULSADO    ");
	 else
	   printf("\n\n\rSIN PULSAR");

	 if(JBoton(JABoton2)==0)
			printf("\n\rPULSADO     ");
	 else
	   printf("\n\rSIN PULSAR");
	}
 clrscr();
 printf("GargonScene n4 - Uso joystick -\n\n\r");
}
