/*
  
  GargonScene n3                                                    
  ModInfo - Visualiza el contenido de un fichero MOD                 
  
*/
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <alloc.h>


struct CabezeraMod
	{
	 int NumInstrumentos;
	 char Titulo[20];

	 struct Instrumentos
		{
		 char Name[22];
		 unsigned int Tamano;
		 unsigned char Finetune;
		 char Volumen;
		 unsigned int OffsRep;
		 unsigned int LongRep;
		}Inst[31];
	 char Patterns;
	 char Nada;
	 char TPat[128];
	 char Iden[4];
	} Mod;

char *Samples[31];

char *Magic1="M.K.";
char *Magic2="FLT4";
char *Magic3="FLT8";
char *Magic4="6CHN";
char *Magic5="8CHN";


char GetInfo(char *fichero);

void main(int argc, char **argv)
{
 int i=0;
 if(argc>2 || argc<2)
	{
	 printf("GargonScene n3. - MOD INFO -\n\rParametros incorrectos.\n\n\rUSO: MODINO <FICHERO>.<MOD>\n\n\a");
	 exit(0);
	}

 GetInfo(argv[1]);

 clrscr();
 printf("MODINFO - GargonScene n3\n\n\r");

 printf(" Archivo MOD: %s\n\r Ttulo de la cancin: %s\n\r", argv[1], Mod.Titulo);
 printf(" Nmero de canales: ");

 if(memcmp(Magic1,Mod.Iden,4)==0)
				printf("4 canales (M.K.)\n\r");
 else if(memcmp(Magic1,Mod.Iden,4)==0)
				printf("4 canales (FLT4)\n\r");
 else if(memcmp(Magic1,Mod.Iden,4)==0)
				printf("8 canales (FLT8)\n\r");
 else if(memcmp(Magic1,Mod.Iden,4)==0)
				printf("6 canales (6CHN)\n\r");
 else if(memcmp(Magic1,Mod.Iden,4)==0)
				printf("8 canales (8CHN)\n\r");

 printf(" Nmero de instrumentos: %d", Mod.NumInstrumentos);

 gotoxy(1,25);
 printf("Opciones: ESC=SALIR  O=Instrumento anterior P=Siguiente instrumento");

 do {
     gotoxy(1,15);
     printf(" Instrumento nmero %d  ", i+1);
     printf("\n\r  -----------------------");
     if(Mod.Inst[i].Tamano!=0)
		printf("\n\r                      \n\r");
     else printf("\n\rInstrumento sin uso.\n\r");
     printf("  Nombre instrumento: %s                           \n\r", Mod.Inst[i].Name);
     printf("  Tamao sample: %d bytes          ", Mod.Inst[i].Tamano);
     switch(getch())
	{
	 case 'O':
	 case 'o': if(i>0) i--;
		   break;

	 case 'P':
	 case 'p': if(i<30) i++;
		   break;

	 case 27 : i=32;
	}
    }while(i!=32);

 getch();
 clrscr();
 printf("MODINFO .-[ GARGONSCENE n3 ]-.\n\n\r");
}

char GetInfo(char *fichero)
{
 FILE *fp;
 int i, convert;
 Mod.NumInstrumentos=0;

 if((fp=fopen(fichero,"rb"))==NULL)
		{
		 clrscr();
		 printf("GargonScene n3. - MOD INFO -\n\rNo se pudo abrir el fichero %s.\n\n\r\a", fichero);
		 exit(1);
		}

 fread(&Mod.Titulo, 20, 1, fp);

 for(i=0;i<31;i++)
	{
	 fread(&Mod.Inst[i].Name,22,1,fp);
	 fread(&Mod.Inst[i].Tamano,2,1,fp);
	 fread(&Mod.Inst[i].Finetune,1,1,fp);
	 fread(&Mod.Inst[i].Volumen,1,1,fp);
	 fread(&Mod.Inst[i].OffsRep,2,1,fp);
	 fread(&Mod.Inst[i].LongRep,2,1,fp);

	 _AX=Mod.Inst[i].Tamano;  asm xchg ah, al; Mod.Inst[i].Tamano =_AX<<1;
	 _AX=Mod.Inst[i].OffsRep; asm xchg ah, al; Mod.Inst[i].OffsRep=_AX<<1;
	 _AX=Mod.Inst[i].LongRep; asm xchg ah, al; Mod.Inst[i].LongRep=_AX<<1;

	 if(Mod.Inst[i].Tamano>0)
			 Mod.NumInstrumentos++;
	}

 fread(&Mod.Patterns, 1, 1, fp);
 fread(&Mod.Nada, 1, 1, fp);
 fread(&Mod.TPat, 128, 1, fp);
 fread(&Mod.Iden, 4, 1, fp);

 for(i=0;i<31;i++)
      if(Mod.Inst[i].Tamano>0)
		{
		 if((Samples[i]=(char *)malloc(Mod.Inst[i].Tamano))==NULL)
						{
						 clrscr();
						 printf("GargonScene n3. - MOD INFO -\n\rInsuficiente memoria para cargar samples.\n\n\r\a");
						 exit(1);
						}

		 fread(Samples[i],Mod.Inst[i].Tamano,1,fp);
		}
 fclose(fp);

 if(memcmp(Magic1,Mod.Iden,4)!=0)
     if(memcmp(Magic2,Mod.Iden,4)!=0)
	 if(memcmp(Magic3,Mod.Iden,4)!=0)
	   if(memcmp(Magic4,Mod.Iden,4)!=0)
	       if(memcmp(Magic5,Mod.Iden,4)!=0)
				{
				 clrscr();
				 printf("GargonScene n3. - MOD INFO -\n\rFormato no desconocido.\n\n\r\a");
				 exit(1);
				}
}
