/* 
  ޳
  ޳ Gargon Software / Code by eXcalibur  gargonsoft@hotmail.com         ޳
  ޳                                                                     ޳
  ޳ Gargonscene n1. Efecto 'Campo de estrellas horizontal'.            ޳
  ޳ 1997, Gargon Soft.                                                  ޳
  ޳
*/
/*-.-.-.-.-.-.-.-.-.-.-.-... Librerias a incluir ...-.-.-.-.-.-.-.-.-.-.-.-.*/
#include <dos.h>                        /* pokeb()...                       */
#include <conio.h>                      /* kbhit()...                       */
#include <stdlib.h>                     /* randomize(), random()...         */

/*-.-.-.-.-.-.-.-.-.-.-.-... Constantes numricas ...-.-.-.-.-.-.-.-.-.-.-.-*/
#define GRAFICO         19              /* Modos grficos. (13h & 03h)      */
#define TEXTO           3                                                      

#define DistObs             256         /* Distancia del observador a la    
				   pantalla. (en el artculo se ex-
				   plica esto.
				*/    
#define CentroY     100             /* Centro 'y' de la pantalla (200/2)*/
#define CentroX     160         /* Centro 'x' de la   " "    (320/2)*/

#define MAXSTARS        350             /* Maximo nmero de estrellas. Si   */
				/* quereis podes cambiarlas con    */
				/* cualquier otro nmero (no s'us   */
				/* paseis) ;)                       */

/*-.-.-.-.-.-.-.-.-.-... Declaracin de las funciones ...-.-.-.-.-.-.-.-.-.-*/
void WRetrace();
void CambiaStar(int NumStars);
void IniMode(char mode);
void PutPixel(int x, int y, char Color);
void CambiaColor(char Color, char R, char G, char B);

/*-.-.-.-.-.-.-.-.-.-.-.-.-... Varibles Globales ...-.-.-.-.-.-.-.-.-.-.-.-.*/
struct Stars {                    /* Estructura que guarda la posicin*/
	     int x[MAXSTARS];   /* de las estrellas, su velocidad y */
	     int y[MAXSTARS];   /* color.                           */
	     int z[MAXSTARS];                                             
	   }Stars;

int xp,yp;                  /* Posicin de las estrellas en 2D

/*
  
   Inicio (main())                                                       
  
*/
void main()

{
 int i, j=2;                            /* Indices para los bucles for      */

 IniMode(GRAFICO);                      /* Iniciamos Modo 13h (320x200x256c)*/
 randomize();                           /* Para que los nmeros aleatorios
				   no sean siempre los mismos ;)
				*/
 for(i=0;i<MAXSTARS;i++)                /* Creamos con random posiciones a- */
	{                             /* leatorias para las estrellas     */
	  Stars.x[i]=random(320)-CentroX; /* 160 es el centro x de la pantalla*/
	  Stars.y[i]=random(200)-CentroY;
	  Stars.z[i]=-(random(100)+156);
	}


 for(i=0;i<255;i++)                     /* Creamos paleta                   */
	{
	 if(!(i%8))
		j+=2;
	 CambiaColor(i,j,j,j);

	}

 do    { 
	WRetrace();             /* Esperamos el retrace...            */        
	for(i=1;i<MAXSTARS;i++)
		  { PutPixel( (DistObs*Stars.x[i]) / Stars.z[i]+CentroX,
			    (DistObs*Stars.y[i]) / Stars.z[i]+CentroY, 0);

		    Stars.z[i] = Stars.z[i]+2; /* Aumentamos z en 2     */
			      
		    xp=(DistObs*Stars.x[i])/Stars.z[i];
		    yp=(DistObs*Stars.y[i])/Stars.z[i];

		    if(xp<-CentroX || yp<-CentroY || xp>CentroX || yp>CentroY)
							CambiaStar(i);

		    PutPixel(xp+CentroX,yp+CentroY,Stars.z[i]);
		  }
       }while(!kbhit());
 
 IniMode(TEXTO);

 asm mov ax, 4c00h
 asm int 10h
}


/*
  
   Funcin void CambiaStar(int NumStar);                                 
  
   Esta funcin nos cambia la estrella pasada como parametro en NumStar  
   y nos la actualiza en 2D (xp,yp)                                      
                                                                         
  
*/
void CambiaStar(int NumStars)
 {
  Stars.x[NumStars]=random(320)-CentroX;         
  Stars.y[NumStars]=random(200)-CentroY; 
  Stars.z[NumStars]=-(random(100)+156);
  xp=(DistObs*Stars.x[NumStars])/Stars.z[NumStars];  /* X2D=DisObs*X3D/Z   */
  yp=(DistObs*Stars.y[NumStars])/Stars.z[NumStars];  /* Y2D=DisObs*Y3D/Z   */
 }


/*
  
   Funcin void PutPixel(int x, int y, char Color);                      
  
   Rutina para poner un pixel en pantalla en modo 13h.                   
                                                                         
   x..... Pos. vertical pixel      Color...... Nm. de color (0-255)     
   y..... Pos. horizontal pixel                                          
  
*/
void PutPixel(int x, int y, char Color)
 {
  pokeb(0xA000, y*320+x, Color);      /* SEGMENTO:OFFSET (A000:Y*320+X) */
 }


/*
  
   Funcin void IniMode(char Mode);                                      
  
   Funcin que inicia un modo grfico.                                   
                                                           
   Entrada: GRAFICO...Mode 13h        TEXTO...Modo texto (80x25)         
  
*/
void IniMode(char mode)  
 {                          
  asm xor ax, ax
  asm mov al, mode
  asm int 10h
 }                            


/*
  
   Funcin void WRetrace(void);                                          
  
   Rutina que espera al retrazado vertical de la VGA.                    
                                                                         
   Esto lo conseguimos mediante el registro de la VGA Input Status Regis-
   ter 1, en la direccin del puerto 3DAh, que nos informa en su bit 3 la
   seal del retrazado vertical, de modo que podemos detectar si se  est
   efectuando en qualquier momento este. La rutina se espera a que el re-
   trace finalize, entonces continua.                                    
  
*/
void WRetrace()
 {

 asm  {
	 mov dx, 3DAh           /* Input Status Register 1          */
      }   
et1:
 asm  {
	 in  al,dx      
	 and al,8h     
	 jnz et1        
      } 
et2:
 asm  {
	 in  al,dx      
	 and al,8h     
	 jz  et2
				/* Finalizado retrazado vertical    */
      }
  /*
    Nota: Si queres emplear 'C puro', lo anterior se puede hacer de la sigui-
	ente manera empleando la intruccin inport() del ANSI C :

	while(!(inport(0x3da) & 8));            // Espera retrace 
  */
 }


/*
  
   Funcin void CambiaColor(char Color, char R, char G, char B);         
  
   Rutina para cambiar el valor de un color para obtener otro.           
                                                                         
   Utiliza primero el puerto 3C8h, poniedo en este el valor del color que
   queremos cambiar, todo seguido nos dipondremos a meter  los nuevos va-
   lores en el orden RGB (Rojo, Verde y Azul) en el puerto 3C9h.         
  
*/
void CambiaColor(char Color, char R, char G, char B)
 {                                    
  outportb(0x3c8,Color);                /* Color a cambiar                  */

  outportb(0x3c9,R);            /* Los cambiamos todo en el orden   */
  outportb(0x3c9,G);            /* R (Rojo), G (Verde), B (Azul)    */
  outportb(0x3c9,B);
 }

