;--------------------------------------------------------------
;some C callable functions by Juergen Ludyga
;--------------------------------------------------------------

.model large
EXTRN _HscPlayer:PROC
.code

PUBLIC _PlayMode, _PollFMM, _FadeFMM, _StopFMM

;
;byte1:
;	0 = irq
;	1 = polling
;byte2:
; 	0 = calling old int 1ch
;	1 = don't call old int 1ch
;Module:
;       pointer to sounddata

_PlayMode	PROC
ARG  byte1:BYTE,byte2:BYTE,Module:DWORD
                push    bp
                mov     bp,sp
                push    ax bx es si
                mov     ah,0
                mov     bl,byte1
                mov     bh,byte2
                les     si,Module
		call 	_HscPlayer
                pop     si es bx ax
                pop     bp
		ret
_PlayMode	ENDP

_PollFMM	PROC
		push	ax
                mov     ah,1
		call    _HscPlayer
                pop     ax
		ret
_PollFMM	ENDP

_FadeFMM	PROC
		push	ax
                mov     ah,3
		call    _HscPlayer
                pop     ax
		ret
_FadeFMM	ENDP

_StopFMM	PROC
		push	ax
                mov     ah,2
		call    _HscPlayer
                pop     ax
		ret
_StopFMM	ENDP
end
