;****************************************************************************
; Filename: ULTOA.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.02.09
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: PSZ @ultoa(LONG value,PSZ string,LONG radix);
;    Input: Eax, value - value to convert to ASCII
;           Edx, string - string pointer
;           Ecx, radix - radix to convert too, 2 to 36
;   Output: string pointer
;  Comment: Converts a unsigned value to a string. The radix must be between
;           2 and 36 or ultoa will return NULL. The string output can be
;           up to 33 characters (including the '\0').
;****************************************************************************

	Include	STDDEF.INC

	Codeseg

Extrn NumberConvert:Byte

Proc	ultoa   ,3
		Cmp	Ecx,2
		Jb	@@Exit
		Cmp	Ecx,36
		Ja	@@Exit
		TestZ	Edx
		Jz	@@Exit
		Push	Ebx
		Sub	Esp,36
		Push	Edx
		Lea	Ebx,[Esp+4+35]
		Mov	[Byte Ebx],0
	Align	4
@@Loop:		Clear	Edx
		Div	Ecx
		Dec	Ebx
		Mov	Dl,[NumberConvert+Edx]
		TestZ	Eax
		Mov	[Ebx],Dl
		Jnz	@@Loop
		Mov	Edx,Ebx
		Mov	Eax,[Esp]
		Call	@stpcpy
		Mov	Edx,Eax
		Pop	Eax,+36,Ebx
		Ret
	Align	4
@@Exit:		Clear	Eax
		Ret
Endp

	End
