
// Logo routines

// Handle of logo window. 0 means: not open.
HWND hlogo=0;

static int logow=499,logoh=429,logox=0,logoy=0;
static HBRUSH yellowbrush;

// Register logo class
void RegisterLogo(HINSTANCE hi)
{
	LRESULT CALLBACK LogoWndProc(HWND hw,UINT msg,WPARAM wp,LPARAM lp);
	WNDCLASS wc;
    memset(&wc,0,sizeof(wc));
	wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc   = LogoWndProc;
	wc.hInstance     = hi;
    yellowbrush=CreateSolidBrush(RGB(255,255,0));
	wc.hbrBackground = yellowbrush;
    wc.lpszClassName = wc.lpszMenuName = "DIDOLOGO";
	RegisterClass(&wc);
}

// Toggle logo window
void ToggleLogo(void)
{
	if (hlogo) {
		DestroyWindow(hlogo);
		return;
		}
    if (!logox) {
        logox=GetSystemMetrics(SM_CXSCREEN)/2-logow/2;
        logoy=GetSystemMetrics(SM_CYSCREEN)/2-logoh/2;
    	}
	hlogo=CreateWindow("DIDOLOGO","Digital Domain Logo",
			WS_POPUP|WS_BORDER|WS_VISIBLE,
			logox,logoy,logow,logoh,0,0,hinst,0);
}

// Windowprocedure for logo window
#pragma argsused
LRESULT CALLBACK LogoWndProc(HWND hw,UINT msg,WPARAM wp,LPARAM lp)
{
	HDC dc;
	PAINTSTRUCT ps;
    static HBITMAP phb,hb;
    static HDC mdc;

	switch(msg) {
        case WM_CREATE:
        	break;
        case WM_LBUTTONDOWN:
            PostMessage(hw,WM_CLOSE,0,0);
        	break;
        case WM_PAINT:
            dc=BeginPaint(hw,&ps);
    	    mdc=CreateCompatibleDC(dc);
    	    hb=LoadBitmap(hinst,"DidoLogo");
    	    if (!hb) MessageBox(0,"Logo bitmap load","Error",0);
	        phb=SelectObject(mdc,hb);
	        SelectObject(dc,GetStockObject(BLACK_BRUSH));
    	    BitBlt(dc,0,0,logow,logoh, mdc,0,0, 0xB8074AL);
	        SelectObject(mdc,phb); DeleteDC(mdc); DeleteObject(hb);
			EndPaint(hw,&ps);
			break;
        case WM_CLOSE:
        	DestroyWindow(hw);
			break;
		case WM_DESTROY:
        	DeleteObject(yellowbrush);
        	hlogo=0; // fallthru...
		default:
			return DefWindowProc(hw,msg,wp,lp);
    	}
	return 0;
}
