;***************************************************************************
;*	Driver pour la Sound Blaster 16 sortie 16 bits stereo
;*
;* Programm par Sbastien Granjoux
;* Commenc le 02/07/95
;* Modification le 02/07/95

IDEAL
P386N


INCLUDE "CRYSERR.INC"
INCLUDE "CRYSDEV.INC"

PUBLIC	USES16

SEGMENT CODE PARA PUBLIC USE16 'CODE'

ASSUME cs:CODE,ds:CODE

NO_FILTER	EQU	3600
LOW_FILTER	EQU	1800

;*************************************************************************
;*	Fonction de detection du driver

PROC	USES16

	call	USEDEVICE
	DEVICE <07h,'BLASTERs=ApIiDdHhTt58$',OFFSET sets16,OFFSET inits16,OFFSET starts16,OFFSET stops16,OFFSET makes16,OFFSET defbpms16,OFFSET peekdef,0,0,0,1,5>

ENDP

Stereo	DB	80h	; 00 Stereo activ 80h Stereo dactiv
SbLen	DW ?
OldInt	DD	0
DspVer   DW 	0
Count	DW	0
DmaPage	DB	8Fh,8Bh,89h,8Ah

;***************************************************************************
;*	Reset de la Soundblaster (recupre l'adresse de port)
;*
;* Entre:
;*	DS:SI	adresse de la structure device
;*
;* Sortie:
;*	DX	adresse de port du reset 2X6

PROC	resetsb

	mov	dx,[(DEVICE ptr ds:si).port]
	add	dx,6
	mov	al,1
	out	dx,al
	mov	cx,256	;compte des moutons pendant au moins 3s
@@compte:
	loop	@@compte
	dec	al
	out	dx,al
	ret
ENDP

;***************************************************************************
;*	Attente d'une lecture sur un port de la SB
;*
;* Entre:
;*	DX	adresse de port du status en lecture 2XE
;*
;* Sortie:
;*	AL	rsultat de la lecture
;*	DX	adresse de port de lecture 2XA

PROC	readsb

@@wait:
	in	al,dx
	or	al,al
	jns	@@wait
	sub	dx,4
	in	al,dx

	ret
ENDP

;***************************************************************************
;*	Attente d'une autorisation d'criture
;*
;* Entre:
;*	DX	port d'criture 2XC
;*
;* Sortie:
;*	DX	port d'criture 2XC

PROC	waitsb

@@wait:
	in	al,dx
	or	al,al
	js	@@wait

	ret
ENDP

;***************************************************************************
;*	routine permettant d'initialiser le son sur la soundblaster

PROC	sets16

	call	resetsb

	add	dx,8
	mov	cx,1024
@@wait:
	in	al,dx
	or	al,al
	js	@@test
	loop	@@wait
@@no_sb:

       stc
       mov	ax,SB_NOT_FOUND
       ret

@@test:
	sub	dx,4
	in	al,dx
	cmp	al,0aah
	jne	@@no_sb

	add	dx,2
	call	waitsb
	mov	al,0E1h
	out	dx,al

	add	dx,2
	call	readsb
	mov	ah,al
	add	dx,4
	call	readsb

	cmp	ax,400h		; Numero de version
	jae	@@sb_16

	stc
	mov	ax,SB_NOT_FOUND
	ret

@@sb_16:
	mov	[DspVer],ax

	add	dx,5
	mov	[cs:OFFSET port_sb+1],dx
	sub	dx,0fh
	mov	[(DEVICE ptr ds:si).port],dx

	mov	al,20h
	cmp	[(DEVICE ptr ds:si).irq],8
	jb	@@first_pic
	mov	al,0A0h
@@first_pic:
	mov	[cs:OFFSET port_irq+1],al

	xor	al,al 		;efface la bascule interne
	out	0d8h,al
	mov	dx,030h
	mov	al,[(DEVICE PTR ds:si).hdma]
	add	dl,al
	shl	dx,2
	or	al,4  		;masque le canal DMA
	out	0d4h,al
	and 	al,0FBh
	or	al,58h
	out	0d6h,al		;choix du mode autoinitialis

	mov	ax,cs
	mov     cx,ax
	shr	ch,4
	shl	ax,4
	add	ax,OFFSET SoundBuf
	adc	ch,0
	mov	cl,ch
	shr	cl,1
	rcr	ax,1
	cmp	ax,65536-BUF_LEN/2
	jb	@@ok1
	add	ax,BUF_LEN/2
	adc	cl,0
	mov	ch,cl
	mov	cl,ah
	shl	cl,1
	rcl	ch,1
	mov	bx,OFFSET SoundBuf
	mov	[word ptr cs:OFFSET soundbuf3b0+3],bx
	mov	[word ptr cs:OFFSET soundbuf8b0+2],bx
	mov	[word ptr cs:OFFSET soundbuf16b0+2],bx
	inc	bx
	inc	bx
	mov	[word ptr cs:OFFSET soundbuf12b1+2],bx
	mov	[word ptr cs:OFFSET soundbuf22b1+2],bx
	inc	bx
	inc	bx
	mov	[word ptr cs:OFFSET soundbuf6b2+3],bx
	mov	[word ptr cs:OFFSET soundbuf10b2+2],bx
	mov	[word ptr cs:OFFSET soundbuf19b2+2],bx
	inc	bx
	inc	bx
	mov	[word ptr cs:OFFSET soundbuf14b3+2],bx
	mov	[word ptr cs:OFFSET soundbuf25b3+2],bx
	add	bx,BUF_LEN
	mov	[word ptr cs:OFFSET soundbuf5a3+2],bx
	mov	[word ptr cs:OFFSET soundbuf13a3+2],bx
	mov	[word ptr cs:OFFSET soundbuf24a3+2],bx
	mov	[word ptr cs:OFFSET soundbuf26a3+2],bx
	dec	bx
	dec	bx
	mov	[word ptr cs:OFFSET soundbuf2a2+2],bx
	mov	[word ptr cs:OFFSET soundbuf9a2+2],bx
	mov	[word ptr cs:OFFSET soundbuf18a2+2],bx
	mov	[word ptr cs:OFFSET soundbuf20a2+2],bx
	dec	bx
	dec	bx
	mov	[word ptr cs:OFFSET soundbuf4a1+2],bx
	mov	[word ptr cs:OFFSET soundbuf11a1+2],bx
	mov	[word ptr cs:OFFSET soundbuf21a1+2],bx
	mov	[word ptr cs:OFFSET soundbuf23a1+2],bx
	dec	bx
	dec	bx
	mov    	[word ptr cs:OFFSET soundbuf1a0+2],bx
	mov	[word ptr cs:OFFSET soundbuf7a0+2],bx
	mov	[word ptr cs:OFFSET soundbuf15a0+2],bx
	mov	[word ptr cs:OFFSET soundbuf17a0+2],bx
@@ok1:

	out	dx,al		; place l'adresse de base
	mov	al,ah
	out	dx,al
	mov	ax,BUF_LEN/2
	dec	ax
	add	dx,2
	out	dx,al		; place la longueur du bloc
	mov	al,ah
	out	dx,al
	mov    	bx,OFFSET DmaPage
	mov	al,[(DEVICE PTR ds:si).hdma]
	xlat
	mov	dl,al
	mov	al,ch
	out	dx,al


	mov  [Stereo],80h

	clc
	ret

ENDP

;***************************************************************************
;*	Routine d'initialisation d'une SB16 (suite)
;*

PROC	inits16

	mov     cl,[NbVoice]
	inc	cl
	shr     cl,1
	mov     al,cl
	mov     ah,-1
@@find_msbit:
	inc     ah
	shr     al,1
	jne     @@find_msbit
	mov     [cs:OFFSET nbvoicediv1+3],ah
	mov     [cs:OFFSET nbvoicediv2+3],ah
	mov     [cs:OFFSET nbvoicediv1b+3],ah
	mov     [cs:OFFSET nbvoicediv2b+3],ah
	call    caloptvoltab16
	jc	@@error

	clc

	ret

@@error:
	stc
	ret

ENDP

;***************************************************************************
;*	routine permettant de dmarrer l'envoit du son sur la soundblaster

PROC	starts16

	mov	ax,[VoicesLen]
	xor	cl,cl
@@search_msb:
	inc	cl
	shr	ax,1
	jne	@@search_msb
	sub    	cl,2
	mov	ax,1
	shl	ax,cl
	mov	[SbLen],ax

	mov	dx,cs
	mov	ax,OFFSET sounds16
	mov	bl,[(DEVICE PTR ds:si).irq]
	call	setirq

	mov	al,[(DEVICE PTR ds:si).hdma]
	out	0d4h,al		; autorise le canal

	mov	dx,[(DEVICE PTR ds:si).port]

	add	dx,04        	; mixer en mode stereo
	mov	al,0Eh
	out	dx,al
	inc	dx
	in	al,dx
	or	al,2
	out	dx,al

	dec	dx
	mov	al,3Ch
	out	dx,al
	inc	dx
	in	al,dx
	or	al,18h
	out	dx,al

	add	dx,7
	call	waitsb
	mov	al,0d1h
	out	dx,al			; allume le haut parleur

	call	waitsb
	mov	al,41h
	out	dx,al
	call	waitsb
	mov	ax,[ds:MixRate]
	xchg	al,ah
	out	dx,al
	call	waitsb
	mov	al,ah
	out	dx,al

	call	waitsb
	mov	al,0B6h
	out	dx,al

	call	waitsb
	mov     al,20h
	out	dx,al

	call	waitsb
	mov	ax,[cs:SbLen]
	shr	ax,1
	dec	ax
	out 	dx,al
	call	waitsb
	mov	al,ah
	out	dx,al
	call	waitsb

	ret
ENDP

;**************************************************************************
;*	cette procdure est en fait un bloc que l'on doit mettre 
;*	l'adresse Voices

PROC	makes16

	mov	cl,[NbVoice]
	sub	cl,4
	push	cx

	mov	di,OFFSET Voice1
	MAKEVOICE16

	mov	di,[ds:OFFSET SoundPage]

	push	ebp
@@voix1:
	add	ch,cl
	adc     esi,edx
	movzx	ax,[byte ptr es:esi]
	mov     ax,[fs:ebx+eax*2]
soundbuf1a0:
	mov	[ds:di+OFFSET SoundBuf],ax


	add	ch,cl
	adc	esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf2a2:
	mov	[ds:di+OFFSET SoundBuf+4],ax
soundbuf3b0:
	mov	[dword ptr ds:di+OFFSET SoundBuf+BUF_LEN],0
	add	di,8

	cmp	di,bp
	jne	@@voix1
	rol	ebp,16
	xor	di,di
	cmp	bp,BUF_LEN
	jne	@@voix1
	pop	ebp

	mov	di,OFFSET Voice1
	SAVEVOICE

	add	di,SIZE VOICE
	MAKEVOICE16

	push	di
	mov	di,[ds:OFFSET SoundPage]
	push	ebp
@@voix1b:
	add	ch,cl
	adc     esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf4a1:
	mov	[ds:di+OFFSET SoundBuf+2],ax

	add	ch,cl
	adc	esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf5a3:
	mov	[ds:di+OFFSET SoundBuf+6],ax
soundbuf6b2:
	mov	[dword ptr ds:di+OFFSET SoundBuf+BUF_LEN+4],0
	add	di,8

	cmp	di,bp
	jne	@@voix1b
	rol	ebp,16
	xor	di,di
	cmp	bp,BUF_LEN
	jne	@@voix1b
	pop	ebp
	pop	di

	SAVEVOICE

	pop	cx
	add	di,SIZE VOICE
	inc	cl
	shr	cl,1
	je	@@end_voice
@@next_voice:
	push	cx
	MAKEVOICE16

	push	di

	push	ebp
	mov	di,[ds:OFFSET SoundPage]
@@voix2:
	add	ch,cl
	adc     esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf7a0:
	add	[ds:di+OFFSET SoundBuf],ax
soundbuf8b0:
	adc	[word ptr ds:di+OFFSET SoundBuf+BUF_LEN],0


	add	ch,cl
	adc	esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf9a2:
	add	[ds:di+OFFSET SoundBuf+4],ax
soundbuf10b2:
	adc	[byte ptr ds:di+OFFSET SoundBuf+BUF_LEN+4],0
	add	di,8

	cmp	di,bp
	jne	@@voix2
	rol	ebp,16
	xor	di,di
	cmp	bp,BUF_LEN
	jne	@@voix2
	pop	ebp


	pop	di
	SAVEVOICE
	add	di,SIZE VOICE

	MAKEVOICE16

	push	di

	push	ebp
	mov	di,[ds:OFFSET SoundPage]
@@voix2b:
	add	ch,cl
	adc     esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf11a1:
	add	[ds:di+OFFSET SoundBuf+2],ax
soundbuf12b1:
	adc	[word ptr ds:di+OFFSET SoundBuf+BUF_LEN+2],0


	add	ch,cl
	adc	esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf13a3:
	add	[ds:di+OFFSET SoundBuf+6],ax
soundbuf14b3:
	adc	[word ptr ds:di+OFFSET SoundBuf+BUF_LEN+6],0
	add	di,8

	cmp	di,bp
	jne	@@voix2b
	rol	ebp,16
	xor	di,di
	cmp	bp,BUF_LEN
	jne	@@voix2b
	pop	ebp


	pop	di
	SAVEVOICE
	add	di,SIZE VOICE

	pop	cx
	dec	cl
	jne	@@next_voice

@@end_voice:
	MAKEVOICE16

	push	di
	mov	di,[ds:OFFSET SoundPage]
	push	ebp
@@voix4b:
	add	ch,cl
	adc     esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf15a0:
	add	ax,[ds:di+OFFSET SoundBuf]
	rcl	eax,1
	rol	eax,15
	rol	ax,1
soundbuf16b0:
	add	ax,[ds:di+OFFSET SoundBuf+BUF_LEN]
	rol	eax,16
nbvoicediv1b:
	shr	eax,2
soundbuf17a0:
	mov	[ds:di+OFFSET SoundBuf],ax

	add	ch,cl
	adc	esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf18a2:
	add	ax,[ds:di+OFFSET SoundBuf+4]
	rcl	eax,1
	rol	eax,15
	rol	ax,1
soundbuf19b2:
	add	ax,[ds:di+OFFSET SoundBuf+BUF_LEN+4]
	rol	eax,16
nbvoicediv2b:
	shr	eax,2
soundbuf20a2:
	mov	[ds:di+OFFSET SoundBuf+4],ax
	add	di,8

	cmp	di,bp
	jne	@@voix4b
	rol	ebp,16
	xor	di,di
	cmp	bp,BUF_LEN
	jne	@@voix4b
	pop	ebp

	pop	di
	SAVEVOICE

	add	di,SIZE VOICE
	MAKEVOICE16

	push	di
	mov	di,[ds:OFFSET SoundPage]
@@voix4:
	add	ch,cl
	adc     esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf21a1:
	add	ax,[ds:di+OFFSET SoundBuf+2]
	rcl	eax,1
	rol	eax,15
	rol	ax,1
soundbuf22b1:
	add	ax,[ds:di+OFFSET SoundBuf+BUF_LEN+2]
	rol	eax,16
nbvoicediv1:
	shr	eax,2

soundbuf23a1:
	mov	[ds:di+OFFSET SoundBuf+2],ax

	add	ch,cl
	adc	esi,edx
	movzx	ax,[byte ptr es:esi]
	mov	ax,[fs:ebx+eax*2]
soundbuf24a3:
	add	ax,[ds:di+OFFSET SoundBuf+6]
	rcl	eax,1
	rol	eax,15
	rol	ax,1
soundbuf25b3:
	add	ax,[ds:di+OFFSET SoundBuf+BUF_LEN+6]
	rol	eax,16
nbvoicediv2:
	shr	eax,2

soundbuf26a3:
	mov	[ds:di+OFFSET SoundBuf+6],ax
	add	di,8

	cmp	di,bp
	jne	@@voix4
	rol	ebp,16
	xor	di,di
	cmp	bp,BUF_LEN
	jne	@@voix4

	pop	di
	SAVEVOICE

@@fin4voice:

	shr	ebp,16
	and	bp,65535-BUF_LEN
	mov	[word ptr ds:OFFSET SoundPage],bp

	ret



ENDP

;***************************************************************************
;*	Cette routine remplace d'interruption 5

PROC	sounds16

	push	ax
	push	dx

port_sb:
	mov	dx,22fh
	in	al,dx

	mov	ax,[cs:SbLen]
	add	[cs:SoundPtr],ax
	and     [cs:SoundPtr],65535-BUF_LEN

	mov	al,20h
	out	20h,al
port_irq:
	out	20h,al
	pop	dx

	mov	ax,[cs:SbLen]
	sub	[cs:Count],ax
	jle	@@imakemod

	pop	ax

	iret

@@imakemod:
	mov	ax,[cs:VoicesLen]
	add	[cs:Count],ax

	pop	ax
	jmp	IMAKEMOD

ENDP

;***************************************************************************
;*	Cette routine permet d'arreter l'envoit du son sur une soundblaster

PROC	stops16

	call	resetsb

	mov	al,[(DEVICE PTR ds:si).hdma]
	or	al,08
	out	0d6h,al
	and	al,03h
	or	al,4
	out	0d4h,al            ; masque le canal DMA

	add	dx,6
	call	waitsb
	mov	al,0d3h
	out	dx,al		; teint le haut parleur

	sub	dx,08		; enleve le mode stereo
	mov	al,0Eh
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0FDh
	out	dx,al

	dec	dx
	mov	al,3Ch
	out	dx,al
	inc	dx
	in	al,dx
	or	al,0E7h
	out	dx,al

	dec	dx
	mov	al,0Eh		; remet le filtre
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0DFh
	out	dx,al

	dec	dx    		; remet le filtre  3.2Khz
	mov	al,0Ch
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0F7h
	out	dx,al

	ret

ENDP

;***************************************************************************
;*	Change la vitesse en BPM
;*
;* Entre:
;*	AL	nouvelle vitesse

PROC	defbpms16

	movzx	cx,al
	lea	cx,[ecx*4+ecx]
	add	cx,cx
	mov	ax,[MixRate]
	mov	dx,25
	mul	dx
	div	cx
	inc	ax
	and	ax,0fffch
	shl	ax,2
	mov	[VoicesLen],ax
	ret

ENDP

;*************************************************************************
;*	Calcul la table multiplication 16 bits optimal pour le volume
;*
;* Entre:
;*	CL	nombre de voix utilis

PROC	caloptvoltab16

	mov	ah,48h
	mov	bx,65*32
	int	21h
	jc	@@error
	mov	[ds:VolumeSeg],ax
	mov	es,ax

	mov	ch,cl
	mov	cl,-1
	mov	al,ch
@@find_msbit:
	inc	cl
	shr	al,1
	jne	@@find_msbit
	mov	ax,100h
	shl	ah,cl
	xor	dx,dx
	shr	cx,8
	div	cx
	mov	cx,ax

	xor	di,di		;remplit la table de multiplication
	xor	bl,bl
@@fill_tab:
	xor	bh,bh
@@fill_line:
	mov	al,bl
	imul	bh
	sar	ax,6
	xor	ah,ah
	add	al,128
	mul	cx
	mov	[es:di],ax
	add	di,2
	inc	bh
	jne	@@fill_line
	inc     bl
	cmp	bl,64
	jbe	@@fill_tab

	clc
	ret

@@error:
	stc
	ret

ENDP


ENDS

END
