PROCEDURE Set_vga; ASSEMBLER;
ASM
   mov ax,13h
   int 10h
END;

PROCEDURE Set_text; ASSEMBLER;
ASM
   mov ax,3h
   int 10h
END;

PROCEDURE WaitRetrace; ASSEMBLER;
ASM
    mov dx,3DAh
@l1:
    in al,dx
    and al,08h
    jnz @l1
@l2:
    in al,dx
    and al,08h
    jz  @l2
END;

PROCEDURE Putpixel (X,Y : Integer; Col : Byte; where:word);ASSEMBLER;
ASM
    mov      ax,where
    mov      es,ax
    mov      bx,[X]
    mov      dx,[Y]
    mov      di,bx
    mov      bx, dx
    shl      dx, 8
    shl      bx, 6
    add      dx, bx
    add      di, dx
    mov      al, [Col]
    mov es:[di],al
END;

Procedure Poligono (x1,y1,x2,y2,x3,y3,col:integer;donde:word);
var
  inc_ent,inc_par : longint;
  pos_ent,pos_par : longint;
  temp            : integer;
  cont,cont2      : integer;
  xmin,xmax       : integer;

BEGIN
     if Y1>Y3 then      {Antes de nada, se tienen que ordenar los vrtices}
        begin           {segn la Y. Al haber solo 3 vrtices, se pueden}
             temp:=X3;  {ordenar con relativa facilidad, con muy pocas}
             X3:=X1;    {comparaciones, y sin tener que recurrir a complicados}
             X1:=temp;  {algoritmos de ordenacin.}
             temp:=Y3;
             Y3:=Y1;    {El orden de las comparaciones es muy importante:}
             Y1:=temp;  {si no se hacen en este orden, los vrtices no quedarn}
        end;            {bien ordenados}

     if Y1>Y2 then
        begin
             temp:=X2;
             X2:=X1;
             X1:=temp;
             temp:=Y2;
             Y2:=Y1;
             Y1:=temp;
        end;

     if Y2>Y3 then
        begin
             temp:=X3;
             X3:=X2;
             X2:=temp;
             temp:=Y3;
             Y3:=Y2;
             Y2:=temp;
        end;

                        {Calculamos la posicin y el incremento para el lado}
                        {largo (el que va de Y1 a Y3}
    pos_ent:=65536*X1;
    if (Y3-Y1)>0 then inc_ent:=65536*(X3-X1) div (Y3-Y1);

                        {lo mismo para el lado corto (de Y1 a Y2)}
    pos_par:=65536*X1;
    if (Y2-Y1)>0 then inc_par:=65536*(X2-X1) div (Y2-Y1);

    for cont:=Y1 to Y2-1 do
        begin
             xmin:=pos_ent div 65536;  {cogemos la parte entera de la x del}
             xmax:=pos_par div 65536;  {lado corto y el lado largo}
             if xmax<xmin then
                begin                  {si XMAX<XMIN, los intercambia}
                     temp:=xmax;
                     xmax:=xmin;
                     xmin:=temp;
                end;
                               {dibuja una linea horizontal entre xmax y ymax}

             for cont2:=xmin to xmax-1 do putpixel(cont2,cont,col,donde);
             pos_ent:=pos_ent+inc_ent;
             pos_par:=pos_par+inc_par;
        end;

                        {el lado largo es el mismo, pero el corto ahora}
                        {es el que va de Y2 a Y3}

    pos_par:=65536*X2;
    if (Y3-Y2)>0 then inc_par:=65536*(X3-X2) div (Y3-Y2);

    for cont:=Y2 to Y3-1 do
        begin
             xmin:=pos_ent div 65536;
             xmax:=pos_par div 65536;
             if xmax<xmin then
                begin
                     temp:=xmax;
                     xmax:=xmin;
                     xmin:=temp;
                end;
             for cont2:=xmin to xmax-1 do putpixel(cont2,cont,col,donde);
             pos_ent:=pos_ent+inc_ent;
             pos_par:=pos_par+inc_par;
        end;
end;

var
   cont: word;

begin
     set_vga;
     poligono(0,0,300,100,100,199,8,$a000);
     readln;
     randomize;
     for cont:=0 to 1000 do
         poligono(random(320),random(200),random(320),random(200),
                  random(320),random(200),random(256),$a000);
     set_text;
end.