#*      MWC32LIB.MAK
#*
#* Make script for MIDAS Sound System Watcom C32 library
#*
#* Copyright 1996 Petteri Kangaslampi and Jarno Paananen
#*
#* This file is part of the MIDAS Sound System, and may only be
#* used, modified and distributed under the terms of the MIDAS
#* Sound System license, LICENSE.TXT. By continuing to use,
#* modify or distribute this file you indicate that you have
#* read the license and understand and accept it fully.
#*


# If CUTDOWN is defined (wmake -u CUTDOWN=1), the library file name will
# be "mcutwc32.lib" and all Module Players will be compiled without loading
# routines. Also other routines, not necessary for small programs such
# as demos, will be removed.
# In addition, if GUSONLY is defined (wmake -u GUSONLY=1 CUTDOWN=1), only
# Gravis UltraSound support is installed and configuration is removed.
# The library name is "mguswc32.lib".


# Compilers and options:

#__16__ = 1

!ifdef __16__

CC = wcc
CCOPTS = -ml -zdp -zu -w3 -d2 -d__WC16__ -2 -5 -dDEBUG
ASM = tasm
ASMOPTS = -UT310 -ml -m9 -zi -d__WC16__ -dDEBUG

EMSINC = ems.inc
EMSH = ems.h
EMSOBJ = ems.obj
DPMIH =
DPMIINC =
DPMIOBJ =
LINKCMD = midp16.wlk

!else

CC = wcc386
#CCOPTS = -w3 -zdp -zu -d__WC32__ -oneatx -s
CCOPTS = -w3 -zdp -zu -oneatx -s -bt=dos -d__WC32__ #-dNOTIMER
#CCOPTS = -w3 -d__WC32__ -dDEBUG -oneatx -s
ASM = tasm
#ASMOPTS = -UT310 -p -ml -m9 -zi -d__WC32__ -dDEBUG
ASMOPTS = -UT310 -p -m9 -d__WC32__

EMSINC =
EMSH =
EMSOBJ=
DPMIH = dpmi.h
DPMIINC = dpmi.inc
DPMIOBJ = dpmi.obj
LINKCMD = midp.wlk

!endif

LIBNAME = mdsswc32.lib
LIBCMDS = mdsswc32.

!ifdef CUTDOWN
ASMOPTS += -dNOLOADERS -dNOCMDNAMES -dNOEMS -dCUTDOWN
CCOPTS += -dNOLOADERS -dNOCMDNAMES -dNOEMS -dCUTDOWN
LIBNAME = mcutwc32.lib
LIBCMDS = mcutwc32.
!endif

!ifdef GUSONLY
ASMOPTS += -dNOCONFIG -dGUSONLY
CCOPTS += -dNOCONFIG -dGUSONLY
LIBNAME = mguswc32.lib
LIBCMDS = mguswc32.
!endif


TOUCH = wtouch
LIBCMD = wlib -c -n $(LIBNAME) @$(LIBCMDS)



$(LIBNAME) : midas.obj dsm.obj dsmmix.obj mmem.obj errors.obj \
        mutils.obj dma.obj mixsd.obj postproc.obj pas.obj mglobals.obj \
        sb.obj gmplayer.obj gmpcmds.obj file.obj rawfile.obj loadmod.obj \
        wss.obj timer.obj vgatext.obj gus.obj loadxm.obj loads3m.obj vu.obj \
        nosound.obj mconfig.obj gusdac.obj $(EMSOBJ) $(DPMIOBJ)
        $(LIBCMD)

!include MIDAS.MAK