;ModeX 80x50

dosseg
.model small
.stack 100h

GLOBAL  flames:PROC

.data

colors  label byte
include av.inc

screen  dw 80*50
timeout dw 0

.286
.code

proc    main
        mov     ax,@data
        mov     ds,ax

        call    flames

        mov     ax,0003h
        int     10h
                   
        mov     ax,4c00h
        int     21h
endp    main


proc    flames
        mov     ax,@data
        mov     ds,ax
        mov     ax,0012h
        int     10h
        mov     ax,0013h
        int     10h
        mov     ax,0a000h
        mov     es,ax

        mov     cx,30
wait_:
        call    vertical
        loop    wait_

        mov     dx,3c4h
        mov     ax,0604h
        out     dx,ax
        mov     dx,3d4h
        mov     ax,0014h
        out     dx,ax
        mov     ax,0e317h
        out     dx,ax
        mov     ax,709h
        out     dx,ax
        mov     dx,3c4h
        mov     ax,0f02h
        out     dx,ax

        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,768
        lea     si,colors
load_pal:
        mov     al,[si]
        out     dx,al
        inc     si
        loop    load_pal

        xor     di,di
        mov     cx,80*25
        mov     ax,0101h
        rep     stosw

fire_loop:
        call    draw_flame
        call    vertical
        call    vertical
        cmp     timeout,300
        jb      no_fade_out
        sub     screen,80
no_fade_out:
        cmp     timeout,300+50
        jz      dos
        inc     timeout
        jmp     fire_loop
dos:
        ret
endp    flames

proc    draw_flame
        pusha
        xor     di,di
screen_loop:
        mov     cx,80
        xor     bh,bh
fireloop:
        push    cx
        xor     ax,ax
        add     al,es:[di-1]
        adc     ah,bh
        add     al,es:[di+1]
        adc     ah,bh
        add     al,es:[di-79]
        adc     ah,bh
        add     al,es:[di+81]
        adc     ah,bh
        ror     ax,2
        or      ax,ax
        jz      cool
        dec     al
cool:
        mov     es:[di],al
        inc     di
        pop     cx
        loop    fireloop

        cmp     di,screen
        jb      screen_loop

        xor     ax,ax
        mov     cx,40*2
        rep     stosw

        popa
        ret
endp    draw_flame

proc    vertical
        push    dx ax
        mov     dx,3dah
wait_not_vrt:
        in      al,dx
        test    al,8
        jnz     wait_not_vrt
wait_end_vrt:
        in      al,dx
        test    al,8
        jz      wait_end_vrt
        pop     ax dx
        ret
endp    vertical

end     main


