.386
.MODEL TPASCAL
.DATA
  EXTRN VidSeg: WORD
  EXTRN MinY: Byte
  EXTRN LastY: Byte
; EXTRN LastY: Byte
; EXTRN ActX: WORD
; EXTRN ActCol: WORD
; EXTRN ActY: WORD
; EXTRN mpc: WORD

   ScrWidthInBytes = 320
   LINEARIZE = 1
;  DOUBLE = 1
.CODE
  ; Declaracin de rutinas pblicas de la unidad
  PUBLIC Panavision
  PUBLIC ClearBuffer
  PUBLIC DumpBuffer
  PUBLIC VGouLine
  PUBLIC WaitRetrace
  PUBLIC WaitNonRetrace
  PUBLIC ClearMinY

  ; Constantes
  FillColor EQU 01010101H

  Panavision PROC NEAR
    ; Sets de VGA video mode into a cinema like mode with 200 lines height
    ; but 400 real lines
    ; MODIFIES: DX, AL
    mov dx,03cch   ; Port to read video miscellaneous status register
    in  al,dx      ; Let's read it.
    mov dx,03c2h   ; Port to write video status miscellaneous register
    or  al,0C0h    ; VGA reserved mode for the two highest bits
    and al,03Fh
    out dx,al      ; Back to da port
    ret
  Panavision ENDP

  ClearMinY PROC NEAR
    mov ax,[VidSeg]
    mov es,ax
    mov si,ScrWidthInBytes-1
    mov ax, 0101h

    DoEraseLine:
      xor cx,cx
      mov cl,MinY[si]
      mov di,si
      IFDEF DOUBLE
        shl di,1
      ENDIF
      DoVLine:
        mov byte PTR es:[di],al
        add di,320
        dec cx
      jg DoVLine
      dec si
    jge DoEraseLine
    ret
  ClearMinY ENDP

  ClearBuffer PROC NEAR
    xor eax,eax
    mov edi,eax
    mov ax,[VidSeg]
    mov es,ax
    mov eax,FillColor
    xor di,di
    mov di,16000
    DoClear:
      mov DWORD ptr es:[di], eax
      sub di,4
    jnz DoClear
    ret
  ClearBuffer ENDP

  DumpBuffer PROC NEAR
    ; Vuelca el bffer de VidSeg a $A000 y borra el bffer de VidSeg
    mov bx,ds                     ; guardamos ds en bx

    mov ax,[VidSeg]               ; Tomamos el bfer
    mov ds,ax                     ; ponemos VidSeg en ds
    xor si,si                     ; borramos si
    mov ax,0A000h                 ; Ponemos el segmento de vdeo en
    mov es,ax                     ; es
    mov ecx,FillColor             ; Tomamos el color de llenado
    DoDump:
      mov eax,ds:[si]             ; Tomamos el pxel Vidseg
      mov es:[si],eax             ; Copiamos el pxel a Vdeo
      mov DWORD ptr ds:[si],ecx   ; Borramos el pxel de VidSeg
      add si,4                    ; Incrementamos el ndice
    jnz DoDump                    ; Hasta que si vuelva a valer 0

    mov ds,bx                     ; Recuperamos el segmento de datos
    ret
  DumpBuffer ENDP

  VGouLine PROC NEAR x:WORD, y0:WORD, y1:WORD, c0:WORD, c1:WORD, Min:Word
  ; Traza una lnea vertical interpolando colores siempre que:
  ;   y1 > y0
  ;   0 < c0,c1 < 255
  ;   0 < x < 320
  ; Este procedimiento es una variacin y debug del aparecido en el
  ; MAG Imphobia '10

    ; Calculamos el nmero de pxels a poner
    xor ecx,ecx   ; Borramos los registros
    mov eax,ecx
    mov ebx,ecx
    mov cx,y1
    mov ax,y0     ; ax contiene y0
    mov si,cx     ; si salvaguarda y1
    sub cx,ax     ; cx contiene el nmero de pxels a poner

    inc cx        ; Por construccin del bucle y para que no d overflow
                  ; el idiv

    ; Calculamos el offset del primer byte a dibujar
    ; No vale la pena hacerlo por tablas ??
    xchg ah,al  ; Hacemos (ax shl 8)+((ax shl 8) shr 2) == ax * (256+(256 shl 2))
    mov di,ax   ; == ax * (256 + 16) == ax * 320
    shr ax,2
    add di,ax
    add di,x
    mov ax,[VidSeg] ; Tomamos el segmento del bffer
    mov es,ax       ; @es:[di] == primer pix a variar

    ; Convertimos c1 a 8.24
    mov ax,c1
    ror eax,8
    ; Convertimos c0 a 8.24
    mov bx,c0
    ror ebx,8

    ; Miramos c1-c0
    sub eax,ebx

    ; Extendemos el signo de c2-c1 a edx
;    rcr eax,1
    cdq
;    rcl eax,1

    ; Calculamos el incremento en 8.24
    cmp cx,2
    je  EndDiv
        idiv ecx
    EndDiv:

    add cx,Min ; Tenemos en cuenta la Y mnima
    sub cx,si

    ; Ponemos las partes altas en las bajas para poder acceder con ms faci-
    ; lidad a la parte entera ('Code _Diamond_' de Imphobia 10)
    rol eax,8
    rol ebx,8
;    xchg ebx,eax   ; ebx contiene el incremento y eax (al) el primer color

    ; Aparentemente el 'linearizing' no mejora la velocidad, sino que la
    ; empeora (supongo que tiene algo que ver que las lneas trazadas sean
    ; cortas y con la cache del 486) => Bucle en vez de linearizing.

    DoGouraud:
	mov byte ptr es:[di],bl
      IFDEF DOUBLE
        mov byte ptr es:[di+1],bl        ; Movemos el pxel
      ENDIF
      add di,ScrWidthInBytes           ; Siguiente posicin
;      add eax,ebx                      ; Suma de nmeros en 8.24
       add ebx,eax
       adc bl,0                        ; Aadimos el carry
      dec cx                           ; Decrementamos el Contador
    jnz DoGouraud

    ret
  VGouLine ENDP

  WaitRetrace PROC NEAR
    mov dx,03dah
    WaitVR0:
      in al,dx
      test al,8
    jz WaitVr0
    WaitNVR0:
      in al,dx
      test al,8
    jnz WaitNVR0
    ret
  WaitRetrace ENDP

  WaitNonRetrace PROC NEAR
    mov dx,03dah
    WaitNVR1:
      in al,dx
      test al,8
    jnz WaitNVR1
    WaitVR1:
      in al,dx
      test al,8
    jz WaitVr1
    ret
  WaitNonRetrace ENDP

;  FillChar PROC NEAR x:WORD, y:WORD
;    cmp ActCol,256
;    jng EndFill
;    cmp ActX,ScrWidthInBytes
;    jge EndFill

;    xor ecx,ecx
;    mov ebx,ecx
    ; Calculamos el incremento de y por cada incremento de x
;    mov cx,x
;    sub cx,ActX      ; cx == x-ActX > 0 siempre
;    mov ax,y
;    sub ax,ActY      ; y-ActY
;    shl eax,16       ; en 16.16
    ; Extendemos el signo de y-ActY a edx
;    rcr eax,1
;    cdq
;    rcl eax,1
;    idiv ecx        ;
 ;   rol eax,16      ; Pasamos la parte entera a la parte baja
  ;  mov edi,eax     ; edi es el incremento de y por cada x


    ; Calculamos el incremento de color por cada incremento de x
;    mov ax,mpc
;    sub ax,actCol
;    shl eax,16 ; 16.16
;    ; Extendemos el signo de mpc-ActCol a edx
;    rcr eax,1
;    cdq
;    rcl eax,1
;    idiv ecx
;    rol eax,16      ; Pasamos la parte entera a la parte baja
;    mov esi,eax     ; esi es el incremento de color por cada inc. de x

    ; Puntos origen
;    mov eax,ebx
;    mov bx,ActY     ; Y origen
;    mov ax,ActCol   ; Color origen

;    DoFill:
;      cmp dx,ScrWidthInBytes
;      jge DoNothing:
;      pushad
;      push dx
;      push bx
;      push LastY[dx]
;      push ax
;      push LastCol[dx]
;      call VGouLine
;      popad
;      add ebx, edi      ; Sumamos el incremento de Y
;      adc ebx,0
;      add eax, esi      ; Sumamos el incremento de color
;      adc eax,0
;      DoNothing
;      dec dx
;    jl DoFill







;    EndFill:
;    ret
;  FillChar ENDP

END