unit vector;

INTERFACE

uses global;

const
	CIRCUNFERENCIA=360;
	COSENO=90;
	ESCALA=1 shl 16;

	Grad2Rad=0.01745329252;	{Constante para pasar de grados a radianes = PI/180}

	distancia:LongInt=1024;

	ColorMalla:byte=15;

type
	Tvertices=record
		x,y,z:LongInt;
	end;

	Tcaras=record
		color:word;
		Vertice1,Vertice2,Vertice3:word;
	end;

	Tnormal=record
		sx,sy:word;
		luz:word;
		nada:word;
	end;

	Tvector=record
		sx,sy:integer;    {Coordenadas 2D despus de la rotacin}
		x,y,z:LongInt;		{Coordenadas 3D del objeto antes de la rotacin}
		mx,my,mz:LongInt; {Punto de vista}

		SenoDeriva,CosenoDeriva:LongInt;
		SenoBalanza,CosenoBalanza:LongInt;
		SenoCaida,CosenoCaida:LongInt;

		AnguloDeriva,AnguloBalanza,AnguloCaida:0..360;

		shade:array[0..255] of byte;

		vertices,caras:word;
		PunteroVertices:^Tvertices;
		PunteroCaras:^Tcaras;
		PunteroNormales:^Tnormal;
	end;

	Tpinta=(MALLA,NORMAL,GOURAUD,PHONG);

var
	seno:array[0..CIRCUNFERENCIA+COSENO] of LongInt;
	FocoX,FocoY,FocoZ:LongInt;	{Vector de luz}

procedure rotacion(var o:Tvector);
{Guarda los valores de seno y coseno de caida, balanza y deriva del vector O}

function Calculos3D(var o:Tvector):boolean;
{Devuelve en SX y SY del tipo Tvector, las coordenadas rotadas del vector O
y la funcin devuelve FALSE si Z<=0}

procedure BorrarObjeto(var o:Tvector);
function CargaObjeto(var o:Tvector;nombre:string):boolean;
procedure VerObjeto(var o:Tvector;modo:Tpinta;l,v:boolean);

IMPLEMENTATION

uses ModeX,Mode13,
{$IFDEF _megafich_}
	megafich;
{$ELSE}
	files;
{$ENDIF}

var
	_ES:LongInt;
	GuardaCoordenadasXY:Tpoligono;
	DivBy3:array[0..255*3] of word;

procedure rotacion(var o:Tvector);ASSEMBLER;
ASM
	MOV		DI,WORD(o)
	MOV		AX,WORD(o+2)
	DB		$8E,$E8     {MOV GS,AX}

	DB 		GS;MOV			BX,Tvector[DI].AnguloDeriva
	SHL		BX,2

	DB		_386;MOV		AX,WORD(seno[BX])
	DW		GS_386;MOV	WORD(Tvector[DI].SenoDeriva),AX

	DB		_386;MOV		AX,WORD(seno[BX+90*4])
	DW		GS_386;MOV	WORD(Tvector[DI].CosenoDeriva),AX


	DB		GS;MOV			BX,Tvector[DI].AnguloBalanza
	SHL		BX,2

	DB		_386;MOV		AX,WORD(seno[BX])
	DW		GS_386;MOV	WORD(Tvector[DI].SenoBalanza),AX

	DB		_386;MOV		AX,WORD(seno[BX+90*4])
	DW		GS_386;MOV	WORD(Tvector[DI].CosenoBalanza),AX


	DB		GS;MOV			BX,Tvector[DI].AnguloCaida
	SHL		BX,2

	DB		_386;MOV		AX,WORD(seno[BX])
	DW		GS_386;MOV	WORD(Tvector[DI].SenoCaida),AX

	DB		_386;MOV		AX,WORD(seno[BX+90*4])
	DW		GS_386;MOV	WORD(Tvector[DI].CosenoCaida),AX
END;

{begin
	o.SenoDeriva:=seno[o.AnguloDeriva];
	o.CosenoDeriva:=seno[COSENO+o.AnguloDeriva];

	o.SenoBalanza:=seno[o.AnguloBalanza];
	o.CosenoBalanza:=seno[COSENO+o.AnguloBalanza];

	o.SenoCaida:=seno[o.AnguloCaida];
	o.CosenoCaida:=seno[COSENO+o.AnguloCaida];
end;}

function Calculos3D(var o:Tvector):boolean;ASSEMBLER;
ASM
	PUSH		DS
	PUSH		BP

	MOV			AX,DS
	DB			$8E,$E8			{MOV GS,AX}

	LDS     BX,o

	DB			_386;MOV		CX,WORD(Tvector[BX].z)
	DB			_386;MOV		BP,WORD(Tvector[BX].x)
	DB			_386;MOV		DI,WORD(Tvector[BX].CosenoDeriva)
	DB			_386;MOV		SI,WORD(Tvector[BX].SenoDeriva)

	DB			_386;MOV			AX,BP
	DB			_386;IMUL			DI   	{x*CosenoDeriva}
	DB			_386;PUSH			AX
	DB			_386;MOV			AX,CX
	DB			_386;IMUL			SI   	{z*SenoDeriva}
	DB			_386;POP			DX
	DB			_386;SUB			DX,AX
	DB			_386;SAR			DX,16
	DB			_386;MOV			AX,BP {AX=x}
	DB			_386;MOV			BP,DX {BP=xa:=(CosenoDeriva*x-SenoDeriva*z) div ESCALA;}

	DB			_386;IMUL			SI    {x*SenoDeriva}
	DB			_386;PUSH			AX
	DB			_386;MOV			AX,CX
	DB			_386;IMUL			DI    {z*CosenoDeriva}
	DB			_386;POP			DX
	DB			_386;ADD			AX,DX
	DB			_386;SAR			AX,16
	DW			GS_386;MOV		WORD(_ES),AX	{ES=za:=(SenoDeriva*x+CosenoDeriva*z) div ESCALA;}

	DB			_386;MOV		CX,WORD(Tvector[BX].y)  {CX=y}
	DB			_386;MOV		DI,WORD(Tvector[BX].CosenoBalanza)
	DB			_386;MOV		SI,WORD(Tvector[BX].SenoBalanza)

	DB			_386;MOV      AX,BP
	DB			_386;IMUL			DI
	DB			_386;PUSH			AX
	DB			_386;MOV			AX,CX
	DB			_386;IMUL			SI
	DB			_386;POP			DX
	DB			_386;ADD			AX,DX
	DB			_386;SAR			AX,16
	DB			_386;MOV			DX,AX		{DX=x:=(CosenoBalanza*xa+SenoBalanza*y) div ESCALA;}
	DB			_386;MOV			WORD(Tvector[BX].x),DX

	DB			_386;MOV			AX,CX     			{AX=y}
	DW			GS_386;MOV		CX,WORD(_ES)    {CX=ES=za}
	DW			GS_386;MOV		WORD(_ES),DX    {ES=x}
	DB			_386;IMUL			DI
	DB			_386;PUSH			AX
	DB			_386;MOV			AX,BP
	DB			_386;IMUL			SI
	DB			_386;POP			BP
	DB			_386;SUB			BP,AX
	DB			_386;SAR			BP,16			{BP=ya:=(CosenoBalanza*y-SenoBalanza*xa) div ESCALA;}

	DB			_386;MOV			DI,WORD(Tvector[BX].CosenoCaida)
	DB			_386;MOV			SI,WORD(Tvector[BX].SenoCaida)

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			DI
	DB			_386;PUSH			AX
	DB			_386;MOV			AX,BP
	DB			_386;IMUL			SI
	DB			_386;POP			DX
	DB			_386;SUB			DX,AX
	DB			_386;SAR			DX,16
	DB			_386;PUSH			DX            {BX=z:=(CosenoCaida*za-SenoCaida*ya) div ESCALA;}
	DB			_386;MOV			WORD(Tvector[BX].z),DX

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			SI
	DB			_386;MOV			CX,AX
	DB			_386;MOV			AX,BP
	DB			_386;IMUL			DI
	DB			_386;ADD			AX,CX
	DB			_386;SAR			AX,16					{AX=y:=(SenoCaida*za+CosenoCaida*ya) div ESCALA;}
	DB			_386;MOV			WORD(Tvector[BX].y),AX
	DB			_386;POP			DI

	DW			GS_386;MOV		SI,WORD(_ES)								{Recupero x}
	DB			_386;ADD			SI,WORD(Tvector[BX].mx)			{SI=inc(x,mx);}

	DB			_386;ADD			AX,WORD(Tvector[BX].my)			{AX=inc(y,my);}

	DB			_386;ADD			DI,WORD(Tvector[BX].mz)   	{DI=inc(z,mz);}
	DB			$0F,$9F,$C1		{SETLE CL}
	JZ			@SALIR				{if z=0 then goto salir}

	DB			_386;SHL			AX,9		{*DISTANCIA}
	DB 			_386;CWD
	DB			_386;IDIV			DI
	ADD			AX,CENTER_Y
	MOV			Tvector[BX].sy,AX		{sy:=100+(y*DISTANCIA) div z;}

	DB			_386;MOV			AX,SI
	DB			_386;SHL			AX,9    {*DISTANCIA}
	DB 			_386;CWD
	DB			_386;IDIV			DI
	ADD			AX,CENTER_X
	MOV			Tvector[BX].sx,AX  	{sx:=160+(x*DISTANCIA) div z;}

@SALIR:
	MOV			AL,CL

	POP			BP
	POP			DS
END;

{var
	xa,ya,za:LongInt;

begin
	xa:=(o.CosenoDeriva*o.x-o.SenoDeriva*o.z) div ESCALA;
	za:=(o.SenoDeriva*o.x+o.CosenoDeriva*o.z) div ESCALA;

	o.x:=(o.CosenoBalanza*xa+o.SenoBalanza*o.y) div ESCALA;
	ya:=(o.CosenoBalanza*o.y-o.SenoBalanza*xa) div ESCALA;

	o.z:=(o.CosenoCaida*za-o.SenoCaida*ya) div ESCALA;
	o.y:=(o.SenoCaida*za+o.CosenoCaida*ya) div ESCALA;

	inc(o.y,o.my);
	inc(o.z,o.mz);
	inc(o.x,o.mx);

	if o.z=0 then exit;

	o.sy:=100+(o.y*DISTANCIA) div o.z;
	o.sx:=160+(o.x*DISTANCIA) div o.z;
end;}

procedure BorrarObjeto(var o:Tvector);
begin
	FreeMem(o.PunteroNormales,(o.vertices*SizeOf(Tnormal)*2));	{*2?}
	FreeMem(o.PunteroVertices,o.vertices*SizeOf(Tvertices));
	FreeMem(o.PunteroCaras,o.caras*SizeOf(Tcaras));
end;

procedure VerObjeto(var o:Tvector;modo:Tpinta;l,v:boolean);

	function EsVisible:boolean;NEAR;ASSEMBLER;
ASM
	LEA     SI,GuardaCoordenadasXY		{SI=OFFSET[GuardaCoordenadasXY]}

	MOV			DX,[SI+14]    {GuardaCoordenadasXY[3].y-GuardaCoordenadasXY[2].y*}
	SUB			DX,[SI+10]

	MOV			AX,[SI+4]    	{GuardaCoordenadasXY[1].x-GuardaCoordenadasXY[2].x}
	SUB			AX,[SI+8]

	IMUL		DX
	DD			MOVSX_ECX_AX

	MOV			DX,[SI+12]    {GuardaCoordenadasXY[3].x-GuardaCoordenadasXY[2].x*}
	SUB			DX,[SI+8]

	MOV			AX,[SI+6]     {GuardaCoordenadasXY[1].y-GuardaCoordenadasXY[2].y}
	SUB			AX,[SI+10]

	IMUL		DX
	DD			MOVSX_EAX_AX

	DB			_386;CMP			CX,AX {EsVisible:=ECX>=EAX;}
	DB			$0F,$9D,$C0					{SETGE AL}
END;

	function CalculaLuz(d:pointer):word;NEAR;ASSEMBLER;
ASM
	LES		SI,d

	DB		_386;MOV		AX,WORD(ES:Tvector[SI].x)
	DB		_386;IMUL   WORD(FocoX)
	DB		_386;MOV		CX,AX

	DB		_386;MOV		AX,WORD(ES:Tvector[SI].y)
	DB		_386;IMUL		WORD(FocoY)
	DB		_386;ADD		CX,AX

	DB		_386;MOV		AX,WORD(ES:Tvector[SI].z)
	DB		_386;IMUL		WORD(FocoZ)
	DB		_386;ADD		AX,CX

	DB		_386;SHL 		AX,5
	DB		_386;SAR		AX,18
	ADD		AX,32
END;

var
	luz:word;
	color1,color2:byte;
	i,j:integer;
	m,q:^integer;
	p:pointer;
	x1,y1,x2,y2,x3,y3:integer;

begin
	p:=@o;
	rotacion(o);

	m:=pointer(o.PunteroVertices);
	q:=pointer(o.PunteroNormales);
	for j:=o.vertices DownTo 1 do
		begin
			ASM
{			Vertices2Coordenadas3D(m,p);}
				PUSH		DS

				LES			DI,o
				LDS			SI,m
				ADD			DI,4

				DW			MOVSD	{x:=m^;inc(m,2);}
				DW			MOVSD	{y:=m^;inc(m,2);}
				DW			MOVSD	{z:=m^;inc(m,2);}

				POP			DS
				MOV			WORD(m),SI
			END;

			Calculos3D(o);
			if l then luz:=CalculaLuz(p) else luz:=0;

			ASM
{			Coordenadas2D2Normales(p,q);}
				PUSH		DS
				LES			DI,q
				LDS			SI,p

				MOV			BX,DS
				MOV			CX,SI

				DW			MOVSD				{q^[j].sx:=o.sx;q^[j].sy:=o.sy}
				POP			DS

				MOV			AX,luz
				MOV			ES:[DI],AX  {q^[j].luz:=luz}
				ADD			DI,4

				MOV			WORD(q),DI
			END;
		end;

	m:=pointer(o.PunteroNormales);
	q:=pointer(o.PunteroCaras);
	for j:=o.caras DownTo 1 do
		begin
			ASM
				PUSH		BP
				PUSH		DS

				MOV			AX,WORD(m+2)
				DW			MOV_GS_AX
				MOV			BX,WORD(m)  {GS:BX=PunteroNormales}
				MOV			DX,BX       {DX=offset(PunteroNormales)}

				MOV			AX,DS
				MOV     ES,AX
				LEA			DI,GuardaCoordenadasXY+4	{ES:DI=GuardaCoordenadasXY[1]}

				LDS			SI,q				{DS:SI=PunteroCaras}

				LODSW               {Color}
				MOV			color1,AL

{				MOV			AX,[SI+6]
				MOV			color2,AX{}

				XOR			BP,BP       {luz:=0;}

				MOV			CX,3      	{Siempre tringulos}

@BUCLE:
				LODSW               {Nmero de vertice}
				SHL			AX,3				{*8}

				MOV			BX,DX       {BX=offset(PunteroNormales)}
				ADD			BX,AX

				DB			GS;MOV	AX,Tnormal[BX].sx
				STOSW	{GuardaCoordenadasXY[j].x:=o.PunteroNormales^[o.PunteroCaras^[i]].sx;}
				DB			GS;MOV	AX,Tnormal[BX].sy
				STOSW	{GuardaCoordenadasXY[j].y:=o.PunteroNormales^[o.PunteroCaras^[i]].sy;}
				DB			GS;ADD	BP,Tnormal[BX].luz
							{inc(luz,o.PunteroNormales^[o.PunteroCaras^[i]].luz;}
				DEC			CX
				JNZ			@BUCLE

				POP			DS

				ADD			BP,BP
				MOV			AX,WORD(DS:DivBy3[BP])
				POP			BP
				ADD			AL,color1
				MOV			color1,AL		{color1:=(luz div 3)+ColorBase}

				MOV			WORD(q),SI
			END;

			if (EsVisible) or (not v) then
				case mv of
					MO13:
						case modo of
							GOURAUD:Mode13.PoligonoGouraud(3,GuardaCoordenadasXY,
															o.shade[color1],o.shade[color2+luz]);

							NORMAL:Mode13.poligono(3,GuardaCoordenadasXY,color1);

							MALLA:
								begin
									if not l then color1:=15;

									with GuardaCoordenadasXY[1] do
										begin
											x1:=x;
											y1:=y;
										end;
									with GuardaCoordenadasXY[2] do
										begin
											x2:=x;
											y2:=y;
										end;
									if Mode13.clip(x1,y1,x2,y2) then Mode13.draw(x1,y1,x2,y2,color1);
									x3:=x1;y3:=y1;

									x1:=x2;y1:=y2;
									with GuardaCoordenadasXY[3] do
										begin
											x2:=x;
											y2:=y;
										end;
									if Mode13.clip(x1,y1,x2,y2) then Mode13.draw(x1,y1,x2,y2,color1);

									x1:=x2;y1:=y2;
									x2:=x3;y2:=y3;
									if Mode13.clip(x1,y1,x2,y2) then Mode13.draw(x1,y1,x2,y2,color1);
								end;
						end;

					MOX:
						case modo of
							NORMAL:ModeX.poligono(3,GuardaCoordenadasXY,color1);
							MALLA:
								begin
									if not l then color1:=15;

									ModeX.draw(x1,y1,x2,y2,color1);
									ModeX.draw(x2,y2,x3,y3,color1);
									ModeX.draw(x3,y3,x1,y1,color1);
								end;
						end;
				end;
		end;
end;

function CargaObjeto(var o:Tvector;nombre:string):boolean;
const
	PROFUNDIDAD=256 div 256;

var
	f:Tfile;
	a,l:word;
	p:^LongInt;
	p1:^word;

	vertices,caras,color:word;
	x,y,z:LongInt;

begin
	CargaObjeto:=FALSE;
	if open(f,nombre,RO)>0 then
		begin
			close(f);
			exit;
		end;

	read(f,vertices,2,l);
	o.vertices:=vertices;

	read(f,caras,2,l);
	o.caras:=caras;

	GetMem(o.PunteroNormales,(vertices*SizeOf(Tnormal)*2));	{*2?}

	GetMem(o.PunteroVertices,vertices*SizeOf(Tvertices));
	p:=pointer(o.PunteroVertices);
	read(f,p^,vertices*SizeOf(Tvertices),l);
(*	for a:=1 to vertices do
		begin
			read(f,p^,4,l);inc(p);	{X}
			read(f,p^,4,l);inc(p);	{Y}
			read(f,p^,4,l);inc(p);	{Z}
		end;*)

	GetMem(o.PunteroCaras,caras*SizeOf(Tcaras));
	p1:=pointer(o.PunteroCaras);
	read(f,p1^,caras*SizeOf(Tcaras),l);
(*	for a:=1 to caras do
		begin
			read(f,p1^,2,l);inc(p1);	{COLOR}

			read(f,p1^,2,l);inc(p1);	{V1}
			read(f,p1^,2,l);inc(p1);	{V2}
			read(f,p1^,2,l);inc(p1);	{V3}
		end;*)

	o.mx:=0;o.my:=0;o.mz:=3000;

{	o.shade[0]:=1;
	l:=1;
	for a:=1 to 255 do
		begin
			o.shade[a]:=l;
			if a mod PROFUNDIDAD=0 then inc(l);
		end;{}

	CargaObjeto:=TRUE;
end;

var
	a:integer;

begin
	FocoX:=0;FocoY:=0;FocoZ:=-10;

	for a:=0 to high(seno) do	seno[a]:=round(sin(a*Grad2Rad)*ESCALA);

	for a:=0 to high(DivBy3) do DivBy3[a]:=a div 3;
end.