unit UMB;

{----------------------------------------------------------------------------}

INTERFACE

procedure init;
procedure done;
															{ the Turbo Pascal 6.0 heap.  This procedure }
															{ should be called as soon as possible in    }
															{ your code.                                 }
var
	UMBHeapDebug:boolean; 		{ If TRUE, releases UMBs immediately to make }
														{ sure they're available for the next run    }
														{ without rebooting.  Used when debugging in }
														{ the IDE.  If not used then, the UMBs may   }
														{ not get freed between executions.          }

{----------------------------------------------------------------------------}

IMPLEMENTATION

const
	MAX_BLOCKS=4;              { It's not likely more than 4 UMBs are needed }

type
	PFreeRec=^TFreeRec;      {  From pg. 216 of the TP6 programmer's guide.  }
	TFreeRec=record          {  It's used for traversing the free blocks of  }
		Next:PFreeRec;         {  the heap.                                    }
		Size:Pointer;
	end;

var
	XMSDriver:pointer;      {  Pointer to the XMS driver.  }
	NumBlocks:word;
	BlockAddress,BlockSize:Array[0..MAX_BLOCKS+1] of pointer;

{  Swap to pointers.  Needed when sorting the UMB addresses.  }
procedure PointerSwap(var a,b:pointer);
var
	temp:pointer;

begin
	temp:=A;
	A:=B;
	B:=Temp;
end;

Function XMSDriverPresent:Boolean;  { XMS software present? }
var
	result:boolean;

begin
	result:=FALSE;      { Assume no XMS driver }

	asm
		@begin:
			mov ax,4300h
			int 2Fh
			cmp al,80h
			jne @Fail
			mov ax,4310h
			int 2Fh
			mov word ptr XMSDriver+2,es       { Get the XMS driver entry point }
			mov word ptr XMSDriver,bx
			mov Result,TRUE
			jmp @end
		@Fail:
			mov Result,FALSE
		@end:
	end;

	XMSDriverPresent:=Result;
end;

{----------------------------------------------------------------------------}

procedure AllocateUMBHeap;         { Add the four largest UMBs to the heap }
var
	i,j:word;
	UMBStrategy,DosStrategy,Segment,Size:word;
	GetDirect:boolean;   { Get UMB direct from XMS if TRUE, else from DOS }

begin
	NumBlocks:=0;

	for i:=1 to MAX_BLOCKS do
		begin
			BlockAddress[i]:=nil;
			BlockSize[i]:=nil;
		end;

	asm
		mov ax,5800h
		int 21h                     { Get and save the DOS allocation strategy }
		mov [DosStrategy],ax
		mov ax,5802h
		int 21h                     { Get and save the UMB allocation strategy }
		mov [UMBStrategy],ax
		mov ax,5801h
		mov bx,0000h
		int 21h                      { Set the DOS allocation strategy so that }
		mov ax,5803h                 { it uses only high memory                }

																 { DON'T TRUST THIS FUNCTION.  DOS WILL GO }
																 { AHEAD AND TRY TO ALLOCATE LOWER MEMORY  }
																 { EVEN AFTER YOU TELL IT NOT TO!          }
		mov bx,0001h
		int 21h                      { Set the UMB allocation strategy so that }
	end;                           { UMBs are added to the DOS mem chain     }

	GetDirect:=TRUE;            { Try to get UMBs directly from the XMS   }
																 { if possible.                            }
	for i:=1 to MAX_BLOCKS do
		begin
			Segment:=0;
			Size:=0;

			if GetDirect then         { Get a UMB direct from the XMS driver.   }
				begin
					asm
						@begin:
							mov ax,01000h
							mov dx,0FFFFh         { Ask for the impossible to ...        }
							push ds               { Get the size of the next largest UMB }
							mov cx,ds
							mov es,cx
							call es:[XMSDriver]
							cmp dx,100h           { Don't bother with anything < 1K      }
							jl @end
							mov ax,01000h
							call es:[XMSDriver]  { Get the next largest UMB }
							cmp ax,1
							jne @end
							cmp bx,0A000h         { It better be above 640K }
							jl @end               { We can't trust DOS 5.00 }
							mov [Segment],bx
							mov [Size],dx
						@end:
							pop ds
					end;
					if ((i = 1) and (Size = 0)) then  { if we couldn't get the UMB  }
						GetDirect:=FALSE;            		{ from the XMS driver, don't  }
				end;                                { try again the next time.    }

			if (not GetDirect) then   { Get a UMB via DOS }
				begin
					asm
						@begin:
							mov ax,4800h
							mov bx,0FFFFh         { Ask for the impossible to ...        }
							int 21h               { Get the size of the next largest UMB }
							cmp bx,100h           { Don't bother with anything < 1K      }
							jl @end
							mov ax,4800h
							int 21h               { Get the next largest UMB }
							jc @end
							cmp ax,0A000h         { It better be above 640K }
							jl @end               { We can't trust DOS 5.00 }
							mov [Segment],ax
							mov [Size],bx
						@end:
					end;
				end;

			if (Segment > 0) then                      { Did it work? }
				begin
					BlockAddress[i]:=Ptr(Segment,0);
					Inc(NumBlocks);
				end;
			BlockSize[i]:=Ptr(Size,0);
		end;
	if (NumBlocks > 0) then               { Sort the UMB addrs in ASC order }
		for i:=1 to NumBlocks-1 do for j:=i+1 to NumBlocks do
			if (Seg(BlockAddress[i]^)>Seg(BlockAddress[j]^)) then
				begin
					PointerSwap(BlockAddress[i],BlockAddress[j]);
					PointerSwap(BlockSize[i],BlockSize[j]);
				end;

	asm
		mov ax,5803h
		mov bx,[UMBStrategy]
		int 21h                          { Restore the UMB allocation strategy }
		mov ax,5801h
		mov bx,[DosStrategy]
		int 21h                          { Restore the DOS allocation strategy }
	end;
end;

{----------------------------------------------------------------------------}

procedure done;             { Exit procedure to release UMBs }
var
	i:word;
	segment:word;

begin
	if (NumBlocks > 0) then
		begin
			asm
				mov ax,5803h
				mov bx,0000h
				int 21h                       { Set the UMB status to release UMBs }
			end;
			for i:=1 to NumBlocks do
				begin
					Segment:=Seg(BlockAddress[i]^);
					if (Segment > 0) then
						asm
							mov ax,$4901
							mov bx,[Segment]
							mov es,bx
							int 21h                                    { Release the UMB }
						end;
				end;
		end;
end;

{----------------------------------------------------------------------------}

procedure init;
var
	i:word;
	Temp:PFreeRec;

begin
	if XMSDriverPresent then
		begin
			AllocateUMBHeap;
			if UMBHeapDebug then done;
			if (NumBlocks > 0) then
				begin                             { Attach UMBs to the FreeList    }
					for i:=1 to NumBlocks do
						PFreeRec(BlockAddress[i])^.Size:=BlockSize[i];
					for i:=1 to NumBlocks do
						PFreeRec(BlockAddress[i])^.Next:=BlockAddress[i+1];

					PFreeRec(BlockAddress[NumBlocks])^.Next:=nil;

					if (FreeList = HeapPtr) then with PFreeRec(FreeList)^ do
						begin
							next:=BlockAddress[1];
							size:=Ptr(Seg(Heapend^)-Seg(HeapPtr^),0);
						end else with PFreeRec(HeapPtr)^ do
							begin
								Next:=BlockAddress[1];
								Size:=Ptr(Seg(Heapend^)-Seg(HeapPtr^),0);
							end;

					{ HEAPPTR MUST BE IN THE LAST FREE BLOCK SO
						THAT TP6 DOESN'T TRY TO USE ANY MEMORY BETWEEN
						640K AND HEAPPTR }

					HeapPtr:=BlockAddress[NumBlocks];
					Heapend:=Ptr(Seg(BlockAddress[NumBlocks]^)+
											 Seg(BlockSize[NumBlocks]^),0);
				end;
		end;
 end;

{----------------------------------------------------------------------------}

begin
	UMBHeapDebug:=FALSE;
	NumBlocks:=0;
end.
