unit MyDOS;

INTERFACE

const
	ErrorPrinter:byte=0;

	DIRECTORIO_EXISTE=5;
	DIRECTORIO_NO_EXISTE=3;

	FICHERO_NO_EXISTE=2;
	PATH_NO_ENCONTRADO=3;
	DEMASIADOS_FICHEROS_ABIERTOS=4;
	ACCESO_DENEGADO=5;
	HANDLE_INVALIDO=6;
	MEMORIA_INSUFICIENTE=8;
	DISCO_PROTEGIDO=9;

type
	unidad=(A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z);
	lpt=(LPT1,LPT2,LPT3);
	Tletra=(MINI,PROPORCIONAL,ESTRECHA,ALTA_CALIDAD,SUB_INDICES,SUPER_INDICES,
					DOBLE_IMPRESION,CURSIVA,NEGRITA,SUBRAYADO,DOBLE_ANCHURA,NORMAL);

procedure dir(opciones:string);
{igual que en el DOS}

procedure del(opciones:string);
{igual que en el DOS}

procedure copia(opciones:string);
{igual que el COPY del DOS}

function sgn(valor:integer):integer;
{devuelve -1 si VALOR<0, 0 si VALOR=0 y 1 si VALOR>0}

function TestBit(var conta;num:integer):boolean;
{devuelve TRUE si el bit NUM de conta est a 1,
CONTA puede ser cualquier tipo ENTERO}

procedure SetBit(var conta;num:integer);
{pone a 1 el bit NUM de CONTA,
CONTA puede ser cualquier tipo ENTERO}

procedure ClearBit(var conta;num:integer);
{pone a 0 el bit NUM de CONTA,
CONTA puede ser cualquier tipo ENTERO}

procedure ToggleBit(var conta;num:integer);
{pone a 0 el bit NUM de CONTA si est a 1 y si no a 0,
CONTA puede ser cualquier tipo ENTERO}

function aleatorio(inferior,superior:integer):integer;
{devuelve un nmero aleatorio entre SUPERIOR e INFERIOR y con signo}

procedure drive(disco:unidad);
{cambia la unidad de disco activa}

function GetDrive:byte;
{devuelve la unidad de disco activa}

function ImpresoraOn(cual:lpt):boolean;
{devuelve TRUE si la impresora esta ON, cual=LPT1, LPT2 o LPT3}

procedure TipoLetra(tipo:Tletra);
{cambia el tipo de letra para la impresora}

procedure ImprimeTexto(texto:string);
{imprime una cadena}

procedure ImprimeNumero(numero:LongInt);
{imprime una cifra}

procedure reboot;
{resetea el ordenador}

procedure AlarmaON(h,m:byte;dir:pointer);
{activa la alarma, a las H:M,s ir a las rutina DIR}

procedure AlarmaOFF;
{desactiva la alarma}

procedure EveryInit(mil:word;dir:pointer);
{rutina de interrupcin de cada MIL milisegundos ir a DIR, el
procedimiento a de ser FAR}

procedure EveryDone;
{Deshabilita el procedimiento Every}

procedure after(mil:word;dir:pointer);
{rutina de interrupcin dedpus DE MIL milisegundos ir a DIR, el
procedimiento a de ser FAR}

procedure NumLockON;
{Enciende la luz del NUM LOCK}

procedure NumLockOFF;
{Apagala luz del NUM LOCK}

function PorCiento(num:LongInt;tanto:byte):integer;
{Calcula el tanto TANTO por ciento de NUM}

procedure EnableIrq(i:byte);
{Habilita la int I}

procedure DisableIrq(i:byte);
{Deshabilita la int I}

procedure EOI;
{Hace un End Of Interrupt hard}

procedure CLI;

procedure STI;

procedure IncPuntero(p:pointer;num:LongInt);
{incrementa el puntero p en NUM unidades,
pero al salir de segmento va al siguiente}

procedure DecPuntero(p:pointer;num:LongInt);
{decrementa el puntero p en NUM unidades,
pero al salir de segmento va al anterior}

procedure EscribePuntero(p:pointer;o:word;dato:byte);
{Escribe en el puntero P, +offset O, el dato DATO, como en C *(p+xx)=a}

function LeePuntero(p:pointer;o:word):byte;
{Lee el dato del puntero P, +offset O, como en C a=*(p+xx)}

function GetCdrom(var unidad:char):boolean;
{Devuelve TRUE si hay CD y UNIDAD es la letra del CD}

function md(var dir:string):byte;
{Crea mltiples subdirectorios y devuelve >0 si error}

procedure SetTimer(n:word);
{Reprograma el timer, para que genere N interrupciones por segundo}

procedure TimerTicks(n:word);

procedure NormalTimer;
{Pone el timer a la velocidad normal}

function GetTimer:word;
{Devuelve la velocidad del timer}

function PtrToLinear(p:pointer):LongInt;
{Devuelve la direccin linear del puntero P}

procedure delay(decimas:word);
{Espera decimas de segundos}

function rnd(n:word):word;
{Devuelve un nmero aleatorio entre 0 y n-1}

IMPLEMENTATION

uses
	printer,dos;

const
	MiliSegundos:real=0.0182;
	PuedoAfter:boolean=TRUE;

	INT_TIEMPO=8;

var
	TiempoEvery,TiempoAfter:real;
	GuardaAlarma:pointer;
	AnteriorEvery,AnteriorAfter,RutinaEvery,RutinaAfter:procedure;
	n1,n2:word;
	random:word;

procedure RutinaIntEvery;INTERRUPT;
begin
	ASM PUSHF END;
	AnteriorEvery;

	inc(n1);
	if n1>TiempoEvery then
		begin
			RutinaEvery;
			n1:=0;
		end;
end;

procedure RutinaIntAfter;INTERRUPT;
begin
	ASM PUSHF END;
	AnteriorAfter;

	inc(n2);
	if n2>TiempoAfter then
		begin
			RutinaAfter;
			SetIntVec(INT_TIEMPO,@AnteriorAfter);
			PuedoAfter:=TRUE;
		end;
end;

procedure dir(opciones:string);
begin
	SwapVectors;
	exec(GetEnv('COMSPEC'),'/c dir '+opciones);
	SwapVectors;
end;

procedure del(opciones:string);
begin
	SwapVectors;
	exec(GetEnv('COMSPEC'),'/c del '+opciones);
	SwapVectors;
end;

procedure copia(opciones:string);
begin
	SwapVectors;
	exec(GetEnv('COMSPEC'),'/c copy '+opciones);
	SwapVectors;
end;

function sgn(valor:integer):integer;
begin
	if valor<0 then sgn:=-1 else if valor=0 then sgn:=0 else sgn:=1;
end;

{$L BITS.OBJ}
{$F+}
function TestBit(var conta;num:integer):boolean;EXTERNAL;
procedure SetBit(var conta;num:integer);EXTERNAL;
procedure ClearBit(var conta;num:integer);EXTERNAL;
procedure ToggleBit(var conta;num:integer);EXTERNAL;
{$F-}

function aleatorio(inferior,superior:integer):integer;
begin
	aleatorio:=system.random(superior-inferior)+inferior;
end;

procedure drive(disco:unidad);ASSEMBLER;
ASM
	MOV			AH,$E
	MOV			DL,disco
	INT			$21
END;

function GetDrive:byte;ASSEMBLER;
ASM
	MOV			AH,$19
	INT			$21
END;

function ImpresoraOn(cual:lpt):boolean;
var
	r:byte;

begin
	ErrorPrinter:=0;
	ImpresoraOn:=FALSE;

	ASM
		MOV			AH,2
		XOR			DH,DH
		MOV			DL,cual
		INT			$17
		MOV			r,AH
	END;

	case r of
		2,$4a:ErrorPrinter:=1;
		0,$10,8,$18,$58:ErrorPrinter:=2;
		$28,$38:ErrorPrinter:=3;
		$88,$c8:ErrorPrinter:=4;
		$90:ImpresoraOn:=TRUE;
		else ErrorPrinter:=5;
	end;
end;

procedure TipoLetra(tipo:Tletra);
begin
	case tipo of
		MINI:ImprimeTexto(#27+'P');
		PROPORCIONAL:ImprimeTexto(#27+'p'+#1);
		ESTRECHA:ImprimeTexto(#15);
		ALTA_CALIDAD:ImprimeTexto(#27+'x'+#1);
		SUB_INDICES:ImprimeTexto(#27+'S'+#1);
		SUPER_INDICES:ImprimeTexto(#27+'S'+#0);
		DOBLE_IMPRESION:ImprimeTexto(#27+'G');
		CURSIVA:ImprimeTexto(#27+'4');
		NEGRITA:ImprimeTexto(#27+'E');
		SUBRAYADO:ImprimeTexto(#27+'-'+#1);
		DOBLE_ANCHURA:ImprimeTexto(#14);
		NORMAL:ImprimeTexto(#27+'@');
	end;
end;

procedure ImprimeTexto(texto:string);
begin
	write(lst,texto);
end;

procedure ImprimeNumero(numero:LongInt);
begin
	write(lst,numero);
end;

procedure reboot;ASSEMBLER;
ASM
	MOV			AL,$FE
	OUT			$64,AL
END;

procedure AlarmaON(h,m:byte;dir:pointer);
begin
	GetIntVec($4a,GuardaAlarma);
	SetIntVec($4a,dir);

	h:=(h div 10)*16+h mod 10;
	m:=(m div 10)*16+m mod 10;

	ASM
		MOV			AH,6
		MOV			CH,h
		MOV			CL,m
		XOR			DH,DH
		INT			$1A
	END;
end;

procedure AlarmaOFF;
begin
	SetIntVec($4a,GuardaAlarma);

	ASM
		MOV				AH,7
		INT				$1A
	END;
end;

procedure EveryInit(mil:word;dir:pointer);
begin
	TiempoEvery:=mil*MiliSegundos;
	@RutinaEvery:=dir;

	GetIntVec(INT_TIEMPO,@AnteriorEvery);
	SetIntVec(INT_TIEMPO,@RutinaIntEvery);
end;

procedure EveryDone;
begin
	SetIntVec(INT_TIEMPO,@AnteriorEvery);
end;

procedure after(mil:word;dir:pointer);
begin
	if not PuedoAfter then exit;

	PuedoAfter:=FALSE;
	TiempoAfter:=mil*milisegundos;
	@RutinaAfter:=dir;

	GetIntVec(INT_TIEMPO,@AnteriorAfter);
	SetIntVec(INT_TIEMPO,@RutinaIntAfter);
end;

procedure NumLockON;ASSEMBLER;
ASM
	MOV			AX,$40
	MOV			ES,AX
	OR			BYTE(ES:[$17]),$20
END;

procedure NumLockOFF;ASSEMBLER;
ASM
	MOV			AX,$40
	MOV			ES,AX
	AND			BYTE(ES:[$17]),$DF
END;

function PorCiento(num:LongInt;tanto:byte):integer;
begin
	PorCiento:=(tanto*num) div 100;
end;

procedure EnableIRQ(i:byte);
begin
	if i<8 then port[$21]:=port[$21] and (not (1 shl i)) else
		begin
			port[$a1]:=port[$a1] and (not (1 shl (i-8)));
			port[$21]:=port[$21] and (not (1 shl 2));
		end;
end;

procedure DisableIRQ(i:byte);
begin
	if i<8 then port[$21]:=port[$21] or (1 shl i) else
		port[$a1]:=port[$a1] or (1 shl (i-8));
end;

procedure EOI;ASSEMBLER;
ASM
	MOV			AL,$20
	OUT			$20,AL
END;

procedure CLI;ASSEMBLER;
ASM
	CLI
END;

procedure STI;ASSEMBLER;
ASM
	STI
END;

procedure IncPuntero(p:pointer;num:LongInt);ASSEMBLER;
ASM
	PUSH		DS
	LDS			SI,p

	MOV			AX,WORD(num)
	ADD			[SI],AX
	JNC			@SIGUE
	ADD			WORD([SI+2]),$1000

@SIGUE:
	MOV			AX,WORD(num+2)
	SHL			AX,12   {*$1000}
	ADD			[SI+2],AX

	POP			DS
END;

procedure DecPuntero(p:pointer;num:LongInt);ASSEMBLER;
ASM
	PUSH		DS

	LDS			SI,p
	MOV			AX,WORD(num)
	SUB			[DI],AX
	JNC			@SIGUE
	SUB			WORD([DI+2]),$1000

@SIGUE:
	MOV			AX,WORD(num+2)
	SHL			AX,12  {*$1000}
	SUB			[SI+2],AX

	POP			DS
END;

procedure EscribePuntero(p:pointer;o:word;dato:byte);ASSEMBLER;
ASM
	LES			DI,p
	MOV			AL,dato
	MOV			BX,o
	MOV			ES:[DI+BX],AL
END;

function LeePuntero(p:pointer;o:word):byte;ASSEMBLER;
ASM
	LES			DI,p
	MOV			BX,o
	MOV			AL,ES:[DI+BX]
END;

function GetCdROM(var unidad:char):boolean;ASSEMBLER;
var
	err:boolean;

ASM
	MOV			AX,$1500
	XOR			BX,BX
	INT			$2F

	MOV			err,FALSE
	XOR			AL,AL
	OR			BX,BX
	JZ			@ERROR

	MOV			AX,$150D
	LES			BX,unidad
	INT			$2F
	MOV			err,TRUE

@ERROR:
	MOV			AL,'A'
	ADD			ES:[BX],AL
	MOV			AL,err
END;

function md(var dir:string):byte;
var
	a,b,n,m:integer;

begin
	if dir[length(dir)]='\' then dec(dir[0]);
	md:=0;
	m:=0;

	for n:=1 to length(dir) do if dir[n]='\' then
		begin
			inc(m);
			if m=2 then a:=n;
		end;

	if m>1 then
		begin
			repeat
				MkDir(copy(dir,1,a-1));
				b:=IOResult;
				md:=b;
				if (b>0) and (b<>DIRECTORIO_EXISTE) then exit;
				repeat
					inc(a);
				until (dir[a]='\') or (a>length(dir));
			until a>length(dir);

			if dir[a-1]='\' then dec(dir[0]);
			Mkdir(copy(dir,1,a-1));
			b:=IOResult;
			md:=b;
			if (b>0) and (b<>DIRECTORIO_EXISTE) then exit else md:=0;
		end else
			begin
				MkDir(dir);
				b:=IOResult;
				md:=b;
				if (b>0) and (b<>DIRECTORIO_EXISTE) then exit else md:=0;
			end;
end;

procedure SetTimer(n:word);ASSEMBLER;
ASM
	MOV			AX,n

	DB			$66;SHL			AX,8
	MOV			AL,$34
	OUT			$43,AL

	DB			$66;SHR			AX,8
	OUT			$40,AL

	DB			$66;SHR			AX,8
	OUT			$40,AL
END;

procedure TimerTicks(n:word);
var
	divisor:LongInt;

begin
	divisor:=1193180 div n;
	SetTimer(divisor);
end;

procedure NormalTimer;ASSEMBLER;
ASM
	MOV			AL,$34
	OUT			$43,AL

	XOR			AL,AL
	OUT			$40,AL
	OUT			$40,AL
END;

function GetTimer:word;ASSEMBLER;
ASM
	XOR			AL,AL
	OUT			$43,AL

	IN			AL,$40
	MOV			AH,AL
	IN			AL,$40
	XCHG		AH,AL

	NEG			AX
END;

function PtrToLinear(p:pointer):LongInt;
begin
	 PtrToLinear:=LongInt(seg(p^)) shl 4+ofs(p^);
end;

procedure delay(decimas:word);ASSEMBLER;
ASM
	MOV		CX,decimas
	ADD		CX,CX

@BUCLE:
	HLT
	LOOP	@BUCLE
END;

function rnd(n:word):word;ASSEMBLER;
ASM
	MOV			AX,random
	XOR			AX,$AA55
	ADD			AX,AX
	ADC			AX,$118
	MOV			random,AX

	CMP			AX,n
	JB			@SIGUE
	AND			AX,n

@SIGUE:
END;

begin
	randomize;
	random:=system.random(65535);
end.