unit MegaFich;

INTERFACE

uses files,global;

type
	TFile=record
		nombre:array[0..12] of char;
		offset,size,pos:LongInt;
		EOF:boolean;
	end;

	ModoLectura=(RO,WO,RW);

procedure init(nombre:string);
function open(var f:TFile;nombre:string;a:MegaFich.ModoLectura):integer;
function close(var f:TFile):integer;
function read(var f:TFile;var buffer;bytes:word;var leidos:word):integer;
function seek(var f:TFile;desplazamiento:LongInt):integer;
function FilePos(f:TFile):LongInt;
function FileSize(f:TFile):LongInt;
function EOF(f:TFile):boolean;

IMPLEMENTATION

uses strings;

var
	GlobalFile:files.Tfile;
	GuardaNombre:array[0..20] of char;
	name:array[0..12] of char;

procedure init(nombre:string);
begin
	StrPCopy(GuardaNombre,nombre);
end;

function open(var f:TFile;nombre:string;a:ModoLectura):integer;
var
	i:integer;
	l:word;

begin
	open:=1;

	StrPCopy(name,nombre);
	if files.open(GlobalFile,GuardaNombre,files.RO)>0 then exit;
	files.read(GlobalFile,i,2,l);
	if i=0 then exit;

	repeat
		files.read(GlobalFile,f,SizeOf(TFile),l);
	until StrComp(name,f.nombre)=0;

	files.seek(GlobalFile,f.offset);
	f.EOF:=FALSE;
	f.pos:=0;

	open:=0;
end;

function close(var f:TFile):integer;
begin
	f.EOF:=TRUE;
	f.pos:=0;
	close:=files.close(GlobalFile);
end;

function read(var f:TFile;var buffer;bytes:word;var leidos:word):integer;
var
	i,j:LongInt;

begin
	if f.pos+bytes>f.size then
		begin
			bytes:=f.size-f.pos;
			f.EOF:=TRUE;
		end;

	f.pos:=f.pos+bytes;
	if bytes>0 then read:=files.read(GlobalFile,buffer,bytes,leidos) else leidos:=0;
end;

function seek(var f:TFile;desplazamiento:LongInt):integer;
begin
	if desplazamiento<=f.size then
	 begin
			seek:=files.seek(GlobalFile,desplazamiento+f.offset);
			f.pos:=desplazamiento;
	 end else seek:=0;
end;

function FilePos(f:TFile):LongInt;
begin
	FilePos:=f.pos;
end;

function FileSize(f:TFile):LongInt;
begin
	FileSize:=f.size;
end;

function EOF(f:TFile):boolean;
begin
	EOF:=f.eof;
end;

end.