{$I ANIM1.RGB}

const
	LENS_DIAMETER=64;		{160}
	DIR=48000;					{48000}

type
	Tlens=array[0..LENS_DIAMETER*LENS_DIAMETER] of word;

var
	lens:^Tlens;
	yy,PositionX,PositionY:integer;
	guarda:word;
	AnteriorLente:pointer;
	y:array[0..6] of integer;
	ss:integer;

procedure FetchBuffer;ASSEMBLER;
ASM              			{Copiamos de la pantalla al buffer}
	PUSH		DS

	MOV			SI,WORD(vRAM)
	MOV			BX,PositionY
	ADD			BX,BX
	ADD			SI,WORD(MultBy80[BX])

	MOV			BX,PositionX
	MOV			CX,BX
	SHR			BX,2
	ADD			SI,BX
	MOV			guarda,SI {Guardamos la coordenadas para volverlas a usar despus}

	MOV			AX,$A000
	MOV			DS,AX
	MOV			ES,AX
	MOV			DI,DIR

	MOV			BH,LENS_DIAMETER

@Y:
	MOV			CX,LENS_DIAMETER/8
	REP			MOVSW

	ADD			DI,80-(LENS_DIAMETER/4)
	ADD			SI,80-(LENS_DIAMETER/4)
	DEC			BH
	JNZ			@Y

	POP			DS
END;

procedure MorphBuffer;ASSEMBLER;
ASM                 {Le aplicamos la lente y la ponemos en pantalla}
	PUSH		DS

	MOV			CX,PositionX
	AND			CL,3                    {Recupero x}
	MOV			CH,$11
	SHL			CH,CL         					{CH=plano actual}

	MOV			DX,SC_INDEX
	MOV			AL,GC_READ_MAP
	MOV			AH,CH
	OUT			DX,AL
	INC			DX

	MOV			DI,guarda
	LES			BX,lens
	MOV			AX,$A000
	MOV			DS,AX

	MOV			AH,LENS_DIAMETER

@Y:
	PUSH		AX
	MOV			CL,LENS_DIAMETER

@X:
	MOV			AL,CH
	OUT			DX,AL

	MOV			SI,ES:[BX]   			 {Leemos el incremento sobre X}
	MOV			AL,[SI]

	CMP			AL,127
	JA			@NO
	ADD			AL,16
	MOV			[DI],AL

@NO:
	ROL			CH,1
	ADC			DI,0

	INC			BX
	INC			BX
	DEC			CL
	JNZ			@X

	ADD			DI,80-(LENS_DIAMETER/4)

	POP			AX
	DEC			AH
	JNZ			@Y

	POP			DS
END;

procedure LensInit;

	function FindSqrt(numero:LongInt):word;ASSEMBLER;
ASM
	DB		_386;MOV		AX,WORD(numero)
	DB		_386;XOR		DX,DX
	DB		$66,$B9,$01,0,0,0	{MOV ECX,1}

@BUCLE:
	DB		_386;SUB    AX,CX
	JB      @EXIT
	INC			DX
	INC			CX
	INC			CX
	JMP			@BUCLE

@EXIT:
	MOV			AX,DX
END;

const
	AUMENTO=LENS_DIAMETER div 8;		{+=Menos aumento, -=+ms aumento}
	R=LENS_DIAMETER div 2;
	RR=R*R;
	RRR=RR-(AUMENTO*AUMENTO);

var
	xx,yy,a,b,x,y,pos,s,z:integer;
	d,e,f,g:word;

begin
	new(lens);

	pos:=0;
	s:=sqr(FindSqrt(RRR));       {Genero la lente}

	for y:=-R to R-1 do for x:=-R to R-1 do
		begin
			xx:=sqr(x);
			yy:=sqr(y);

			if xx+yy>s then
				begin
					a:=x;
					b:=y;
				end else
					begin    {NORMAL--, otro camino,-+, +-, ++}
						z:=FindSqrt(RR-xx-yy);
						a:=(x*AUMENTO) div z;
						b:=(y*AUMENTO) div z;
					end;

			d:=(b+R)*LENS_DIAMETER+a+R;
			e:=d div LENS_DIAMETER;	{y}
			f:=d mod LENS_DIAMETER; {x}
			d:=(e*80)+(f div 4);
			lens^[pos]:=d+DIR;
			inc(pos);
		end;
end;

procedure MueveLente;INTERRUPT;
begin
	ASM
		PUSHF
		CALL		AnteriorLente
	END;

	ss:=GetSemaphore(3);
END;

procedure _lente;
var
	n,m:integer;
	s:Tsprite;

begin
	ModeX.init(COPIA,X320x200);
	SetScreenSyncro(sync[X200]);
	LensInit;

	for n:=SPRITE_ANIM1 to SPRITE_ANIM1+(TOTAL_ANIM1-1) do LoadSprite(n);

	LoadPCX('LENTE.PCX',PAGINA_FONDO,c);
	move(ColorLetras[0],c[0],32*3);
	move(ColorAnim1[33],c[33],64*3);

	for n:=1 to high(y) do y[n]:=-(dim[1].alto+20)*n;
	PositionX:=CENTERX-(LENS_DIAMETER div 2);
	PositionY:=CENTERY-(LENS_DIAMETER div 2);

	yy:=300;
	m:=SPRITE_ANIM1;

	InkAllRGB(0,255,c);

	GetIntVec(8,AnteriorLente);
	SetIntVec(8,@MueveLente);

	ss:=0;
	while ss<>4 do;

	repeat
		s.x:=CENTERX-(dim[1].ancho div 2);
		for n:=1 to high(y) do
			begin
				s.n:=n;
				s.y:=y[n];
				PintaSpriteMask(s);

				inc(y[n]);
			end;

		if yy>155 then dec(yy);
		s.x:=260;s.y:=yy;
		s.n:=m;
		PintaSpriteMask(s);
		inc(m);
		if m=SPRITE_ANIM1+(TOTAL_ANIM1-1) then m:=SPRITE_ANIM1;

		SetPlanes(ALL_PLANES);
		FetchBuffer;
		MorphBuffer;

		if ss=1 then SetColors(0,255,PaletaBlanca) else SetColors(0,255,c);

		anima;
	until ss=2;
	StopColors;

	for n:=SPRITE_ANIM1 to SPRITE_ANIM1+(TOTAL_ANIM1-1) do DisposeSprite(n);
	for n:=SPRITE_LETRAS to SPRITE_LETRAS+(TOTAL_LETRAS-1) do DisposeSprite(n);

	dispose(lens);

	SetIntVec(8,AnteriorLente);
end;